' Copyright (C) 1997-2001 Agilent Technologies
' VXIplug&play Instrument Driver for the Agilent E1476

'/*=============================*/
'/*           HPE1476           */
'/*=============================*/
'/* Framework Revision: WIN95 4.0 */
'/*                     WINNT 4.0 */
'/* Driver Revision:    A.02.06 */
'/* Firmware Revision:  A.09.00 */
'/*=============================*/

'/*=============================*/
'/* Source Files:               */
'/*=============================*/
'/*   hpe1476.c                 */
'/*   hpe1476.h                 */
'/*=============================*/

'/*=============================*/
'/* WIN Framework Files         */
'/*=============================*/
'/*   hpe1476.def               */
'/*   hpe1476.rc                */
'/*   hpe1476.bas               */
'/*=============================*/

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Common Error numbers start at BFFC0D00

Global Const hpe1476_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1476_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1476_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1476_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1476_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1476_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1476_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Used by Status System Functions
Global Const hpe1476_USER_ERROR_HANDLER                       = -1

Global Const hpe1476_ESR_OPC                                  = 601
Global Const hpe1476_ESR_QUERY_ERROR                          = 603
Global Const hpe1476_ESR_DEVICE_DEPENDENT_ERROR               = 604
Global Const hpe1476_ESR_EXECUTION_ERROR                      = 605
Global Const hpe1476_ESR_COMMAND_ERROR                        = 606

Global Const hpe1476_OPER_SCAN_DONE                           = 809

' Used by Function hpe1476_timeOut
Global Const hpe1476_TIMEOUT_MAX                              = 2147483647&
Global Const hpe1476_TIMEOUT_MIN                              = 0&


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1476_init Lib "hpe1476_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1476_close Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_reset Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_self_test Lib "hpe1476_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1476_error_query Lib "hpe1476_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1476_error_message Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1476_revision_query Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' other standard functions 

Declare Function hpe1476_dcl Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_errorQueryDetect Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function hpe1476_errorQueryDetect_Q Lib "hpe1476_32.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function hpe1476_opc Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_opc_Q Lib "hpe1476_32.dll" (ByVal vi As Long, opc As Integer) As Long

Declare Function hpe1476_readStatusByte_Q Lib "hpe1476_32.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function hpe1476_statCond_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal happening As Long, pCondition As Integer) As Long

Declare Function hpe1476_statEvenClr Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_statEven_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal happening As Long, pEvent As Integer) As Long

Declare Function hpe1476_timeOut Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function hpe1476_timeOut_Q Lib "hpe1476_32.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function hpe1476_trg Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_wai Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1476_armCoun
Global Const hpe1476_ARM_COUN_MAX                         = 32767
Global Const hpe1476_ARM_COUN_MIN                         = 1

' Used by Function hpe1476_closCardChan
Global Const hpe1476_CARD_MAX                             = 99
Global Const hpe1476_CARD_MIN                             = 1
Global Const hpe1476_CHANNEL_NUMBER_MAX                   = 94
Global Const hpe1476_CHANNEL_NUMBER_MIN                   = 0

' Used by Function hpe1476_openCardChan
'    hpe1476_CARD_MAX
'    hpe1476_CARD_MIN
'    hpe1476_CHANNEL_NUMBER_MAX
'    hpe1476_CHANNEL_NUMBER_MIN

' Used by Function hpe1476_outpEcltStat_M
Global Const hpe1476_ECLTNUM_MAX                          = 1
Global Const hpe1476_ECLTNUM_MIN                          = 0

' Used by Function hpe1476_outpEcltStat_M_Q
'    hpe1476_ECLTNUM_MAX
'    hpe1476_ECLTNUM_MIN

' Used by Function hpe1476_outpTtltStat_M
Global Const hpe1476_TTLTNUM_MAX                          = 7
Global Const hpe1476_TTLTNUM_MIN                          = 0

' Used by Function hpe1476_outpTtltStat_M_Q
'    hpe1476_TTLTNUM_MAX
'    hpe1476_TTLTNUM_MIN

' Used by Function hpe1476_routClos
Global Const hpe1476_CHANNEL_MAX                          = 999999
Global Const hpe1476_CHANNEL_MIN                          = 100

' Used by Function hpe1476_routClos_Q
'    hpe1476_CHANNEL_MAX
'    hpe1476_CHANNEL_MIN

' Used by Function hpe1476_routOpen
'    hpe1476_CHANNEL_MAX
'    hpe1476_CHANNEL_MIN

' Used by Function hpe1476_routOpen_Q
'    hpe1476_CHANNEL_MAX
'    hpe1476_CHANNEL_MIN

' Used by Function hpe1476_routScanMode
Global Const hpe1476_ROUT_SCAN_MODE_NONE                  = 0
Global Const hpe1476_ROUT_SCAN_MODE_FRES                  = 1
Global Const hpe1476_ROUT_SCAN_MODE_RES                   = 2
Global Const hpe1476_ROUT_SCAN_MODE_VOLT                  = 3

' Used by Function hpe1476_routScanMode_Q
'    hpe1476_ROUT_SCAN_MODE_NONE
'    hpe1476_ROUT_SCAN_MODE_FRES
'    hpe1476_ROUT_SCAN_MODE_RES
'    hpe1476_ROUT_SCAN_MODE_VOLT

' Used by Function hpe1476_routScanPort
Global Const hpe1476_ROUT_SCAN_PORT_NONE                  = 0
Global Const hpe1476_ROUT_SCAN_PORT_ABUS                  = 1

' Used by Function hpe1476_routScanPort_Q
'    hpe1476_ROUT_SCAN_PORT_NONE
'    hpe1476_ROUT_SCAN_PORT_ABUS

' Used by Function hpe1476_systCdes_Q
'    hpe1476_CARD_MAX
'    hpe1476_CARD_MIN

' Used by Function hpe1476_systCpon
'    hpe1476_CARD_MAX
'    hpe1476_CARD_MIN

' Used by Function hpe1476_systCtyp_Q
'    hpe1476_CARD_MAX
'    hpe1476_CARD_MIN

' Used by Function hpe1476_trigSour
Global Const hpe1476_TRIG_SOUR_BUS                        = 0
Global Const hpe1476_TRIG_SOUR_ECLT0                      = 1
Global Const hpe1476_TRIG_SOUR_ECLT1                      = 2
Global Const hpe1476_TRIG_SOUR_HOLD                       = 3
Global Const hpe1476_TRIG_SOUR_IMM                        = 4
Global Const hpe1476_TRIG_SOUR_TTLT0                      = 5
Global Const hpe1476_TRIG_SOUR_TTLT1                      = 6
Global Const hpe1476_TRIG_SOUR_TTLT2                      = 7
Global Const hpe1476_TRIG_SOUR_TTLT3                      = 8
Global Const hpe1476_TRIG_SOUR_TTLT4                      = 9
Global Const hpe1476_TRIG_SOUR_TTLT5                      = 10
Global Const hpe1476_TRIG_SOUR_TTLT6                      = 11
Global Const hpe1476_TRIG_SOUR_TTLT7                      = 12
Global Const hpe1476_TRIG_SOUR_EXT                        = 13

' Used by Function hpe1476_trigSour_Q
'    hpe1476_TRIG_SOUR_BUS
'    hpe1476_TRIG_SOUR_ECLT0
'    hpe1476_TRIG_SOUR_ECLT1
'    hpe1476_TRIG_SOUR_HOLD
'    hpe1476_TRIG_SOUR_IMM
'    hpe1476_TRIG_SOUR_TTLT0
'    hpe1476_TRIG_SOUR_TTLT1
'    hpe1476_TRIG_SOUR_TTLT2
'    hpe1476_TRIG_SOUR_TTLT3
'    hpe1476_TRIG_SOUR_TTLT4
'    hpe1476_TRIG_SOUR_TTLT5
'    hpe1476_TRIG_SOUR_TTLT6
'    hpe1476_TRIG_SOUR_TTLT7
'    hpe1476_TRIG_SOUR_EXT


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1476_abor Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_armCoun Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal armCoun As Integer) As Long

Declare Function hpe1476_armCoun_Q Lib "hpe1476_32.dll" (ByVal vi As Long, armCoun As Integer) As Long

Declare Function hpe1476_closCardChan Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Channel As Integer) As Long

Declare Function hpe1476_initCont Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal initCont As Integer) As Long

Declare Function hpe1476_initCont_Q Lib "hpe1476_32.dll" (ByVal vi As Long, initCont As Integer) As Long

Declare Function hpe1476_initImm Lib "hpe1476_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1476_openCardChan Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Channel As Integer) As Long

Declare Function hpe1476_outpEcltStat_M Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, ByVal outpEcltStat As Integer) As Long

Declare Function hpe1476_outpEcltStat_M_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, outpEcltStat As Integer) As Long

Declare Function hpe1476_outpStat Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal outpStat As Integer) As Long

Declare Function hpe1476_outpStat_Q Lib "hpe1476_32.dll" (ByVal vi As Long, outpStat As Integer) As Long

Declare Function hpe1476_outpTtltStat_M Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, ByVal outpTtltStat As Integer) As Long

Declare Function hpe1476_outpTtltStat_M_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, outpTtltStat As Integer) As Long

Declare Function hpe1476_routClos Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1476_routClosList Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1476_routClosList_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routClosList As String) As Long

Declare Function hpe1476_routClos_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channel As Long, routClos As Integer) As Long

Declare Function hpe1476_routOpen Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1476_routOpenList Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1476_routOpenList_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routOpenList As String) As Long

Declare Function hpe1476_routOpen_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channel As Long, routOpen As Integer) As Long

Declare Function hpe1476_routScanList Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1476_routScanMode Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal routScanMode As Integer) As Long

Declare Function hpe1476_routScanMode_Q Lib "hpe1476_32.dll" (ByVal vi As Long, routScanMode As Integer) As Long

Declare Function hpe1476_routScanPort Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal routScanPort As Integer) As Long

Declare Function hpe1476_routScanPort_Q Lib "hpe1476_32.dll" (ByVal vi As Long, routScanPort As Integer) As Long

Declare Function hpe1476_systCdes_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCdes As String) As Long

Declare Function hpe1476_systCpon Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal card As Integer) As Long

Declare Function hpe1476_systCtyp_Q Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCtyp As String) As Long

Declare Function hpe1476_trigSour Lib "hpe1476_32.dll" (ByVal vi As Long, ByVal trigSour As Integer) As Long

Declare Function hpe1476_trigSour_Q Lib "hpe1476_32.dll" (ByVal vi As Long, trigSour As Integer) As Long

