/* Copyright (C) 1997-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1476*/

#ifndef hpe1476_INCLUDE 
#define hpe1476_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif
/*=============================*/
/*           HPE1476           */
/*=============================*/
/* Framework Revision: WIN95 4.0 */
/*                     WINNT 4.0 */
/* Driver Revision:    A.02.06 */
/* Firmware Revision:  A.09.00 */
/*=============================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1476.c                 */
/*   hpe1476.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   hpe1476.def               */
/*   hpe1476.rc                */
/*   hpe1476.bas               */
/*=============================*/

/******  Returned error status values *****/
/* Common Error numbers start at BFFC0D00 */
#define hpe1476_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1476_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1476_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1476_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1476_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1476_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1476_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */

#define hpe1476_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define hpe1476_STB_MAV				5 

#define hpe1476_ESR_OPC				601
#define hpe1476_ESR_QUERY_ERROR			603
#define hpe1476_ESR_DEVICE_DEPENDENT_ERROR		604
#define hpe1476_ESR_EXECUTION_ERROR			605
#define hpe1476_ESR_COMMAND_ERROR			606

#define hpe1476_OPER_SCAN_DONE			809


/******   Used by Function hpe1476_timeOut   *****/
#define  hpe1476_TIMEOUT_MAX  2147483647
#define  hpe1476_TIMEOUT_MIN  0

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC hpe1476_init (ViRsrc InstrDesc, ViBoolean id_query,
                            ViBoolean do_reset, ViPSession vi );

ViStatus _VI_FUNC hpe1476_close (ViSession vi);

ViStatus _VI_FUNC hpe1476_reset (ViSession vi);

ViStatus _VI_FUNC hpe1476_self_test (ViSession vi, ViPInt16 test_result,
                                 ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC hpe1476_error_query (ViSession vi, ViPInt32 error_number,
                                   ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1476_error_message (ViSession vi, ViStatus error_number,
                                     ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1476_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
                                      ViChar _VI_FAR instr_rev[]);

/* other standard functions */

ViStatus _VI_FUNC hpe1476_dcl(ViSession vi);

ViStatus _VI_FUNC hpe1476_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC hpe1476_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC hpe1476_opc(ViSession vi);

ViStatus _VI_FUNC hpe1476_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC hpe1476_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC hpe1476_statEvenClr(ViSession vi);

ViStatus _VI_FUNC hpe1476_statEven_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  hpe1476_InstrEventHandler)(
        ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC hpe1476_statEvenHdlr(ViSession vi, ViInt32 happening,       
                                   hpe1476_InstrEventHandler eventHandler,
                                   ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR hpe1476_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC hpe1476_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     hpe1476_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC hpe1476_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC hpe1476_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC hpe1476_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC hpe1476_trg(ViSession vi);

ViStatus _VI_FUNC hpe1476_wai(ViSession vi);

/* Instr Specific Functions follow */


/******   Used by Function hpe1476_armCoun   *****/
#define  hpe1476_ARM_COUN_MAX  32767
#define  hpe1476_ARM_COUN_MIN  1


/******   Used by Function hpe1476_closCardChan   *****/
#define  hpe1476_CARD_MAX  99
#define  hpe1476_CARD_MIN  1
#define  hpe1476_CHANNEL_NUMBER_MAX  94
#define  hpe1476_CHANNEL_NUMBER_MIN  0


/******   Used by Function hpe1476_openCardChan   *****/
/*  hpe1476_CARD_MAX  */
/*  hpe1476_CARD_MIN  */
/*  hpe1476_CHANNEL_NUMBER_MAX  */
/*  hpe1476_CHANNEL_NUMBER_MIN  */


/******   Used by Function hpe1476_outpEcltStat_M   *****/
#define  hpe1476_ECLTNUM_MAX  1
#define  hpe1476_ECLTNUM_MIN  0


/******   Used by Function hpe1476_outpEcltStat_M_Q   *****/
/*  hpe1476_ECLTNUM_MAX  */
/*  hpe1476_ECLTNUM_MIN  */


/******   Used by Function hpe1476_outpTtltStat_M   *****/
#define  hpe1476_TTLTNUM_MAX  7
#define  hpe1476_TTLTNUM_MIN  0


/******   Used by Function hpe1476_outpTtltStat_M_Q   *****/
/*  hpe1476_TTLTNUM_MAX  */
/*  hpe1476_TTLTNUM_MIN  */


/******   Used by Function hpe1476_routClos   *****/
#define  hpe1476_CHANNEL_MAX  999999
#define  hpe1476_CHANNEL_MIN  100


/******   Used by Function hpe1476_routClos_Q   *****/
/*  hpe1476_CHANNEL_MAX  */
/*  hpe1476_CHANNEL_MIN  */


/******   Used by Function hpe1476_routOpen   *****/
/*  hpe1476_CHANNEL_MAX  */
/*  hpe1476_CHANNEL_MIN  */


/******   Used by Function hpe1476_routOpen_Q   *****/
/*  hpe1476_CHANNEL_MAX  */
/*  hpe1476_CHANNEL_MIN  */


/******   Used by Function hpe1476_routScanMode   *****/
#define  hpe1476_ROUT_SCAN_MODE_NONE  0
#define  hpe1476_ROUT_SCAN_MODE_FRES  1
#define  hpe1476_ROUT_SCAN_MODE_RES  2
#define  hpe1476_ROUT_SCAN_MODE_VOLT  3


/******   Used by Function hpe1476_routScanMode_Q   *****/
/*  hpe1476_ROUT_SCAN_MODE_NONE  */
/*  hpe1476_ROUT_SCAN_MODE_FRES  */
/*  hpe1476_ROUT_SCAN_MODE_RES  */
/*  hpe1476_ROUT_SCAN_MODE_VOLT  */


/******   Used by Function hpe1476_routScanPort   *****/
#define  hpe1476_ROUT_SCAN_PORT_NONE  0
#define  hpe1476_ROUT_SCAN_PORT_ABUS  1


/******   Used by Function hpe1476_routScanPort_Q   *****/
/*  hpe1476_ROUT_SCAN_PORT_NONE  */
/*  hpe1476_ROUT_SCAN_PORT_ABUS  */


/******   Used by Function hpe1476_systCdes_Q   *****/
/*  hpe1476_CARD_MAX  */
/*  hpe1476_CARD_MIN  */


/******   Used by Function hpe1476_systCpon   *****/
/*  hpe1476_CARD_MAX  */
/*  hpe1476_CARD_MIN  */


/******   Used by Function hpe1476_systCtyp_Q   *****/
/*  hpe1476_CARD_MAX  */
/*  hpe1476_CARD_MIN  */


/******   Used by Function hpe1476_trigSour   *****/
#define  hpe1476_TRIG_SOUR_BUS  0
#define  hpe1476_TRIG_SOUR_ECLT0  1
#define  hpe1476_TRIG_SOUR_ECLT1  2
#define  hpe1476_TRIG_SOUR_HOLD  3
#define  hpe1476_TRIG_SOUR_IMM  4
#define  hpe1476_TRIG_SOUR_TTLT0  5
#define  hpe1476_TRIG_SOUR_TTLT1  6
#define  hpe1476_TRIG_SOUR_TTLT2  7
#define  hpe1476_TRIG_SOUR_TTLT3  8
#define  hpe1476_TRIG_SOUR_TTLT4  9
#define  hpe1476_TRIG_SOUR_TTLT5  10
#define  hpe1476_TRIG_SOUR_TTLT6  11
#define  hpe1476_TRIG_SOUR_TTLT7  12
#define  hpe1476_TRIG_SOUR_EXT  13


/******   Used by Function hpe1476_trigSour_Q   *****/
/*  hpe1476_TRIG_SOUR_BUS  */
/*  hpe1476_TRIG_SOUR_ECLT0  */
/*  hpe1476_TRIG_SOUR_ECLT1  */
/*  hpe1476_TRIG_SOUR_HOLD  */
/*  hpe1476_TRIG_SOUR_IMM  */
/*  hpe1476_TRIG_SOUR_TTLT0  */
/*  hpe1476_TRIG_SOUR_TTLT1  */
/*  hpe1476_TRIG_SOUR_TTLT2  */
/*  hpe1476_TRIG_SOUR_TTLT3  */
/*  hpe1476_TRIG_SOUR_TTLT4  */
/*  hpe1476_TRIG_SOUR_TTLT5  */
/*  hpe1476_TRIG_SOUR_TTLT6  */
/*  hpe1476_TRIG_SOUR_TTLT7  */
/*  hpe1476_TRIG_SOUR_EXT  */

ViStatus _VI_FUNC hpe1476_abor  (
  ViSession vi);

ViStatus _VI_FUNC hpe1476_armCoun  (
  ViSession vi,
  ViInt16 armCoun);

ViStatus _VI_FUNC hpe1476_armCoun_Q  (
  ViSession vi,
  ViPInt16 armCoun);

ViStatus _VI_FUNC hpe1476_closCardChan  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Channel);

ViStatus _VI_FUNC hpe1476_initCont  (
  ViSession vi,
  ViBoolean initCont);

ViStatus _VI_FUNC hpe1476_initCont_Q  (
  ViSession vi,
  ViPBoolean initCont);

ViStatus _VI_FUNC hpe1476_initImm  (
  ViSession vi);

ViStatus _VI_FUNC hpe1476_openCardChan  (
  ViSession vi,
  ViInt16 Card_Number,
  ViInt16 Channel);

ViStatus _VI_FUNC hpe1476_outpEcltStat_M  (
  ViSession vi,
  ViInt16 ecltNum,
  ViBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1476_outpEcltStat_M_Q  (
  ViSession vi,
  ViInt16 ecltNum,
  ViPBoolean outpEcltStat);

ViStatus _VI_FUNC hpe1476_outpStat  (
  ViSession vi,
  ViBoolean outpStat);

ViStatus _VI_FUNC hpe1476_outpStat_Q  (
  ViSession vi,
  ViPBoolean outpStat);

ViStatus _VI_FUNC hpe1476_outpTtltStat_M  (
  ViSession vi,
  ViInt16 ttltNum,
  ViBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1476_outpTtltStat_M_Q  (
  ViSession vi,
  ViInt16 ttltNum,
  ViPBoolean outpTtltStat);

ViStatus _VI_FUNC hpe1476_routClos  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1476_routClosList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1476_routClosList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routClosList[]);

ViStatus _VI_FUNC hpe1476_routClos_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routClos);

ViStatus _VI_FUNC hpe1476_routOpen  (
  ViSession vi,
  ViInt32 channel);

ViStatus _VI_FUNC hpe1476_routOpenList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1476_routOpenList_Q  (
  ViSession vi,
  ViString channelList,
  ViChar _VI_FAR routOpenList[]);

ViStatus _VI_FUNC hpe1476_routOpen_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean routOpen);

ViStatus _VI_FUNC hpe1476_routScanList  (
  ViSession vi,
  ViString channelList);

ViStatus _VI_FUNC hpe1476_routScanMode  (
  ViSession vi,
  ViInt16 routScanMode);

ViStatus _VI_FUNC hpe1476_routScanMode_Q  (
  ViSession vi,
  ViPInt16 routScanMode);

ViStatus _VI_FUNC hpe1476_routScanPort  (
  ViSession vi,
  ViInt16 routScanPort);

ViStatus _VI_FUNC hpe1476_routScanPort_Q  (
  ViSession vi,
  ViPInt16 routScanPort);

ViStatus _VI_FUNC hpe1476_systCdes_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCdes[]);

ViStatus _VI_FUNC hpe1476_systCpon  (
  ViSession vi,
  ViInt16 card);

ViStatus _VI_FUNC hpe1476_systCtyp_Q  (
  ViSession vi,
  ViInt16 card,
  ViChar _VI_FAR systCtyp[]);

ViStatus _VI_FUNC hpe1476_trigSour  (
  ViSession vi,
  ViInt16 trigSour);

ViStatus _VI_FUNC hpe1476_trigSour_Q  (
  ViSession vi,
  ViPInt16 trigSour);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1476_INCLUDE */

