'*****************************************************************************
'*  $Header:: /VXIPnP/Falcon/hp661x/hp661x.bas 1     5/09/00 11:20a Rkinne $ *
'*  Copyright 1998-2000 Agilent Technologies, Inc.                           *
'*---------------------------------------------------------------------------*
'*  Driver for HP661X Dynamic Measurement DC Source                          *
'*****************************************************************************

'*****************************************************************************
'*  STANDARD SECTION                                                         *
'*  Constants and function prototypes for HP standard functions.             *
'*****************************************************************************

'        ***************************************************
'        *  Standard constant error conditions returned    *
'        *  by driver functions.                           *
'        *    HP Common Error numbers start at BFFC0D00    *
'        *    The parameter errors extend the number of    *
'        *      errors over the eight defined in VPP 3.4   *
'        ***************************************************

Global Const HP661X_INSTR_ERROR_NULL_PTR = &HBFFC0D02
Global Const HP661X_INSTR_ERROR_RESET_FAILED = &HBFFC0D03
Global Const HP661X_INSTR_ERROR_UNEXPECTED = &HBFFC0D04
Global Const HP661X_INSTR_ERROR_INV_SESSION = &HBFFC0D05
Global Const HP661X_INSTR_ERROR_LOOKUP = &HBFFC0D06
Global Const HP661X_INSTR_ERROR_DETECTED = &HBFFC0D07
Global Const HP661X_INSTR_NO_LAST_COMMA = &HBFFC0D08

Global Const HP661X_INSTR_ERROR_MEAS_TMO = &HBFFC0D2A
Global Const HP661X_INSTR_ERROR_PORT_CONFIG = &HBFFC0D2B
Global Const HP661X_INSTR_ERROR_GET_MAX = &HBFFC0D2C

'        ***************************************************
'        *  Constants used by system status functions      *
'        *    These defines are bit numbers which define   *
'        *    the operation and questionable registers.    *
'        *    They are instrument specific.                *
'        ***************************************************

Global Const HP661X_STB_QUES = &H8
Global Const HP661X_STB_MAV = &H10
Global Const HP661X_STB_ESB = &H20
Global Const HP661X_STB_MSS = &H40
Global Const HP661X_STB_RQS = &H40
Global Const HP661X_STB_OPER = &H80

Global Const HP661X_SRE_QUES = &H8
Global Const HP661X_SRE_MAV = &H10
Global Const HP661X_SRE_ESB = &H20
Global Const HP661X_SRE_OPER = &H80

Global Const HP661X_OPER_CAL = &H1
Global Const HP661X_OPER_WTG = &H20
Global Const HP661X_OPER_CV = &H100
Global Const HP661X_OPER_CC_POS = &H400
Global Const HP661X_OPER_CC_NEG = &H800

Global Const HP661X_QUES_OV = &H1
Global Const HP661X_QUES_OCP = &H2
Global Const HP661X_QUES_FUSE = &H4
Global Const HP661X_QUES_OT = &H10
Global Const HP661X_QUES_RI = &H200
Global Const HP661X_QUES_UNREG = &H400
Global Const HP661X_QUES_OVLD = &H4000

Global Const HP661X_ESR_OPC = &H1
Global Const HP661X_ESR_QYE = &H4
Global Const HP661X_ESR_DDE = &H8
Global Const HP661X_ESR_EXE = &H10
Global Const HP661X_ESR_CME = &H20
Global Const HP661X_ESR_PON = &H80

Global Const HP661X_REG_ESE = 0
Global Const HP661X_REG_SRE = 1
Global Const HP661X_REG_OPER = 2
Global Const HP661X_REG_QUES = 3

Global Const HP661X_CMDSTRING_MAX = 256

Global Const HP661X_CMDSTRING_Q_MIN = 2
Global Const HP661X_CMDSTRING_Q_MAX = 32767&

'        ***************************************************
'        *  Constants used by function hp661x_timeOut      *
'        ***************************************************

Global Const HP661X_TIMEOUT_MAX = 2147483647
Global Const HP661X_TIMEOUT_MIN = 1&

'        ***************************************************
'        *  Required plug and play functions from VPP-3.1  *
'        ***************************************************

Declare Function hp661x_init Lib "hp661x_32.dll" _
        (ByVal resourceName As String, _
         ByVal IDQuery As Integer, _
         ByVal resetDevice As Integer, _
               instrumentHandle As Long) As Long

Declare Function hp661x_close Lib "hp661x_32.dll" _
        (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_reset Lib "hp661x_32.dll" _
        (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_self_test Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           selfTestResult As Integer, _
     ByVal selfTestMessage As String) As Long

Declare Function hp661x_error_query Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           errorCode As Long, _
     ByVal errorMessage As String) As Long

Declare Function hp661x_error_message Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal statusCode As Long, _
     ByVal message As String) As Long

Declare Function hp661x_revision_query Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal instrumentDriverRevision As String, _
     ByVal firmwareRevision As String) As Long


'        ***************************************************
'        *  HP standard utility functions                  *
'        ***************************************************

Declare Function hp661x_timeOut Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal setTimeOut As Long) As Long

Declare Function hp661x_timeOut_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           timeOut As Long) As Long

Declare Function hp661x_errorQueryDetect Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal setErrorQueryDetect As Integer) As Long

Declare Function hp661x_errorQueryDetect_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           errorQueryDetect As Integer) As Long

Declare Function hp661x_dcl Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_opc Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_opc_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           instrumentReady As Integer) As Long


'        ***************************************************
'        *  HP standard status functions                   *
'        ***************************************************

Declare Function hp661x_readStatusByte_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           statusByte As Integer) As Long

Declare Function hp661x_operEvent_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           operationEventRegister As Long) As Long

Declare Function hp661x_operCond_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           operationConditionRegister As Long) As Long

Declare Function hp661x_quesEvent_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           questionableEventRegister As Long) As Long

Declare Function hp661x_quesCond_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           questionableConditionRegister As Long) As Long


'        ***************************************************
'        *  HP standard command passthrough functions      *
'        ***************************************************

Declare Function hp661x_cmd Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal sendStringCommand As String) As Long

Declare Function hp661x_cmdString_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal queryStringCommand As String, _
     ByVal stringSize As Long, _
     ByVal stringResult As String) As Long

Declare Function hp661x_cmdInt Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal sendIntegerCommand As String, _
     ByVal sendInteger As Long) As Long

Declare Function hp661x_cmdInt16_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal queryI16Command As String, _
           i16Result As Integer) As Long

'* End of HP standard declarations */
'*---------------------------------------------------------------------------*


'*****************************************************************************
'*  INSTRUMENT SPECIFIC SECTION                                              *
'*  Constants and function prototypes for instrument specific functions.     *
'*****************************************************************************

'        ***************************************************
'        *  Instrument specific error numbers              *
'        ***************************************************
Global Const HP661X_INSTR_ERROR_NVRAM_RD0_CS = 1
Global Const HP661X_INSTR_ERROR_NVRAM_CONFIG_CS = 2
Global Const HP661X_INSTR_ERROR_NVRAM_CAL_CS = 3
Global Const HP661X_INSTR_ERROR_NVRAM_STATE_CS = 4
Global Const HP661X_INSTR_ERROR_NVRAM_RST_CS = 5
Global Const HP661X_INSTR_ERROR_RAM_SELFTEST = 10
Global Const HP661X_INSTR_ERROR_DAC_SELFTEST1 = 11
Global Const HP661X_INSTR_ERROR_DAC_SELFTEST2 = 12
Global Const HP661X_INSTR_ERROR_DAC_SELFTEST3 = 13
Global Const HP661X_INSTR_ERROR_DAC_SELFTEST4 = 14
Global Const HP661X_INSTR_ERROR_OVDAC_SELFTEST = 15
Global Const HP661X_INSTR_ERROR_DIGIO_SELFTEST = 80
Global Const HP661X_INSTR_ERROR_INGUARD_RXBUF_OVR = 213
Global Const HP661X_INSTR_ERROR_RS232_FRAMING = 216
Global Const HP661X_INSTR_ERROR_RS232_PARITY = 217
Global Const HP661X_INSTR_ERROR_RS232_RX_OVR = 218
Global Const HP661X_INSTR_ERROR_FP_UART_OVR = 220
Global Const HP661X_INSTR_ERROR_FP_UART_FRAMING = 221
Global Const HP661X_INSTR_ERROR_FP_UART_PARITY = 222
Global Const HP661X_INSTR_ERROR_FP_RXBUF_OVR = 223
Global Const HP661X_INSTR_ERROR_FP_TIMEOUT = 224
Global Const HP661X_INSTR_ERROR_CAL_SWITCH = 401
Global Const HP661X_INSTR_ERROR_CAL_PASSWORD = 402
Global Const HP661X_INSTR_ERROR_CAL_DISABLED = 403
Global Const HP661X_INSTR_ERROR_CAL_RB_CONST = 404
Global Const HP661X_INSTR_ERROR_CAL_PROG_CONST = 405
Global Const HP661X_INSTR_ERROR_CAL_CMD_SEQUENCE = 406
Global Const HP661X_INSTR_ERROR_CVCC_STATUS = 407
Global Const HP661X_INSTR_ERROR_ALC_NOT_NORMAL = 408
Global Const HP661X_INSTR_ERROR_TOO_MANY_SWE_POINTS = 601
Global Const HP661X_INSTR_ERROR_RS232_CMD_ONLY = 602
Global Const HP661X_INSTR_ERROR_INCOMPATIBLE_FETCH = 603
Global Const HP661X_INSTR_ERROR_MEAS_OVERRANGE = 604

'        /***************************************************/
'        /*  Instrument specific constants                  */
'        /***************************************************/

Global Const HP661X_VOLTAGE = 0
Global Const HP661X_CURRENT = 1

Global Const HP661X_DISP_NORMAL = 0
Global Const HP661X_DISP_TEXT = 1

Global Const HP661X_MEAS_DC = 0

Global Const HP661X_TRIG_SRC_BUS = 0
Global Const HP661X_TRIG_SRC_INT = 1

Global Const HP661X_TRIG_COUNT_MAX = 100
Global Const HP661X_TRIG_COUNT_MIN = 1

Global Const HP661X_TRIG_SLOPE_EITHER = 0
Global Const HP661X_TRIG_SLOPE_POS = 1
Global Const HP661X_TRIG_SLOPE_NEG = 2

Global Const HP661X_RELAY_POLARITY_NORMAL = 0
Global Const HP661X_RELAY_POLARITY_REVERSE = 1

Global Const HP661X_RI_OFF = 0
Global Const HP661X_RI_LATCHING = 1
Global Const HP661X_RI_LIVE = 2

Global Const HP661X_DFI_SRC_PREV = 0
Global Const HP661X_DFI_SRC_QUES = 1
Global Const HP661X_DFI_SRC_OPER = 2
Global Const HP661X_DFI_SRC_ESB = 3
Global Const HP661X_DFI_SRC_RQS = 4
Global Const HP661X_DFI_SRC_OFF = 5

Global Const HP661X_DIG_OUT_MAX = 7
Global Const HP661X_DIG_OUT_MIN = 0

Global Const HP661X_PON_STATE_RST = 0
Global Const HP661X_PON_STATE_RCL0 = 1

Global Const HP661X_SENSE_FUNC_VOLT = 0
Global Const HP661X_SENSE_FUNC_CURR = 1

Global Const HP661X_CURR_DET_ACDC = 0
Global Const HP661X_CURR_DET_DC = 1

Global Const HP661X_CURR_IMM = 0
Global Const HP661X_CURR_TRIG = 1

Global Const HP661X_CURR_Q = 0
Global Const HP661X_CURR_Q_TRIG = 1
Global Const HP661X_CURR_Q_MAX = 2
Global Const HP661X_CURR_Q_MIN = 3

Global Const HP661X_VOLT_IMM = 0
Global Const HP661X_VOLT_TRIG = 1
Global Const HP661X_VOLT_OVP = 2
Global Const HP661X_VOLT_OVP_MAX = 3
Global Const HP661X_VOLT_OVP_MIN = 4

Global Const HP661X_VOLT_Q = 0
Global Const HP661X_VOLT_Q_MAX = 1
Global Const HP661X_VOLT_Q_MIN = 2
Global Const HP661X_VOLT_Q_TRIG = 3
Global Const HP661X_VOLT_Q_TRIG_MAX = 4
Global Const HP661X_VOLT_Q_TRIG_MIN = 5
Global Const HP661X_VOLT_Q_OVP = 6
Global Const HP661X_VOLT_Q_OVP_MAX = 7
Global Const HP661X_VOLT_Q_OVP_MIN = 8

Global Const HP661X_ARM_OUTPUT_ONCE = 0
Global Const HP661X_ARM_OUTPUT_CONTINUOUS = 1
Global Const HP661X_ARM_ACQUISITION = 2
Global Const HP661X_ARM_VOLT_ACQUISITION = 3
Global Const HP661X_ARM_CURR_ACQUISITION = 4

Global Const HP661X_TRIG_OUTPUT = 0
Global Const HP661X_TRIG_ACQUISITION = 1

Global Const HP661X_SET_VOLT = 0
Global Const HP661X_SET_CURR = 1

Global Const HP661X_OUTP_STATUS_OFF = 0
Global Const HP661X_OUTP_STATUS_CV = 1
Global Const HP661X_OUTP_STATUS_CC = 2
Global Const HP661X_OUTP_STATUS_UNREG = 3
Global Const HP661X_OUTP_STATUS_PROT = 4
Global Const HP661X_OUTP_STATUS_UNKNOWN = 5

Global Const HP661X_VOLT_TRIG_MIN = 0
Global Const HP661X_VOLT_MIN = 0
Global Const HP661X_CURR_TRIG_MIN = 0
Global Const HP661X_CURR_MIN = 0

Global Const HP661X_SENSE_WIND_RECT = 0
Global Const HP661X_SENSE_WIND_HANN = 1

Global Const HP661X_ACQ_COUNT_MIN = 1
Global Const HP661X_ACQ_COUNT_MAX = 100

'        ***************************************************
'        *  Instrument specific functions                  *
'        ***************************************************
Declare Function hp661x_outputVoltCurr Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal voltLev As Double, _
     ByVal currLev As Double) As Long

Declare Function hp661x_readOutputStatus Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           outputStatus As Integer) As Long

Declare Function hp661x_rippleRiDfi Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_doDelay Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal milliSeconds As Integer) As Long

Declare Function hp661x_setMeasure Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal outputParam As Integer, _
     ByVal outputLev As Double, _
     ByVal settlingTime As Integer, _
           voltQLev As Double, _
           currQLev As Double, _
           outputStatus As Integer) As Long

Declare Function hp661x_setDisplay Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal dispState As Integer, _
     ByVal dispMode As Integer, _
     ByVal messageText As String) As Long

Declare Function hp661x_getDisplay Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           dispState As Integer, _
           dispMode As Integer, _
     ByVal messageText As String) As Long

Declare Function hp661x_measureVolt Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           measResult As Double) As Long

Declare Function hp661x_measureCurr Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           measResult As Double) As Long

Declare Function hp661x_setMeasTimeout Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal measTimeout As Long) As Long

Declare Function hp661x_getMeasTimeout Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           measTimeout As Long) As Long

Declare Function hp661x_setSweepParams Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal sampleInterval As Double, _
     ByVal sweepSize As Long) As Long

Declare Function hp661x_getSweepParams Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           sampleInterval As Double, _
           sweepSize As Long) As Long

Declare Function hp661x_clearOutpProt Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_setOutpRelayPolarity Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal relayPolarity As Integer) As Long

Declare Function hp661x_getOutpRelayPolarity Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           relayPolarity As Integer) As Long

Declare Function hp661x_setOutpState Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal outputState As Integer, _
     ByVal switchRelay As Integer) As Long

Declare Function hp661x_getOutpState Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           outputState As Integer) As Long

Declare Function hp661x_setPonState Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal ponState As Integer) As Long

Declare Function hp661x_getPonState Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           ponState As Integer) As Long

Declare Function hp661x_setOutpRelay Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal relayState As Integer) As Long

Declare Function hp661x_getOutpRelay Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           relayState As Integer) As Long

Declare Function hp661x_setRiDfi Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal riMode As Integer, _
     ByVal dfiState As Integer, _
     ByVal dfiSourceBit As Integer) As Long

Declare Function hp661x_getRiDfi Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           riMode As Integer, _
           dfiState As Integer, _
           dfiSourceBit As Integer) As Long

Declare Function hp661x_setOutpTrigSource Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal outpTrigSource As Integer) As Long

Declare Function hp661x_getOutpTrigSource Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           outpTrigSource As Integer) As Long

Declare Function hp661x_setCurrSenseParams Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal currSenseRange As Double, _
     ByVal currSenseDetector As Integer) As Long

Declare Function hp661x_getCurrSenseParams Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           currSenseRange As Double, _
           currSenseDetector As Integer) As Long

Declare Function hp661x_setCurr Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal currQParam As Integer, _
     ByVal currLev As Double) As Long

Declare Function hp661x_getCurr Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal currQParam As Integer, _
           currLev As Double) As Long

Declare Function hp661x_setVolt Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal voltQParam As Integer, _
     ByVal voltLev As Double) As Long

Declare Function hp661x_getVolt Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal voltQParam As Integer, _
           voltLev As Double) As Long

Declare Function hp661x_setOcpParams Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal ocpEnable As Integer, _
     ByVal ccDelay As Double) As Long

Declare Function hp661x_getOcpParams Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           ocpEnable As Integer, _
           ccDelay As Double) As Long

Declare Function hp661x_setDigio Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal digInData As Integer) As Long

Declare Function hp661x_getDigio Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           digInData As Integer) As Long

Declare Function hp661x_getVoltAlcBandwidth Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           alcBandwidth As Double) As Long

Declare Function hp661x_abort Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_arm Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal trigSystem As Integer) As Long

Declare Function hp661x_trigger Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long) As Long

Declare Function hp661x_stdEvent_Q Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
           stdEventStatus As Integer) As Long

Declare Function hp661x_setEnableReg Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal enableRegister As Integer, _
     ByVal enableMask As Integer) As Long

Declare Function hp661x_getEnableReg Lib "hp661x_32.dll" _
    (ByVal instrumentHandle As Long, _
     ByVal enableRegister As Integer, _
           enableMask As Integer) As Long

'* End of instrument specific declarations *
'*---------------------------------------------------------------------------*

