s        bf   N Qf                                        hp661x      HP661X                                          ViInt16      ViPInt16     
  	ViInt16 []     ViInt32      ViPInt32     
  	ViInt32 []    ViReal64     	 	ViPReal64       
ViReal64 []      ViString     	 	ViBoolean     
 
ViPBoolean      	 ViBoolean []      ViRsrc     	 	ViSession      ViStatus      ViPChar     	  ViChar []   h    hpxxxx  Instrument Driver
Copyright @1997, Hewlett-Packard Company

Put Instrument Description Here.

         Utility functions perform several standard P&P tasks and a variety of HP utility tasks.  They also include HP's instrument command passthrough functions which allow generic access to the instrument's command set.
         HP's instrument command passthrough functions.

These functions pass commands directly to the instrument, thus allowing generic access to the instrument's command set.
         The initialize function initializes the software connection to the instrument and optionally verifies that instrument is in the system.  In addition, it may perform any necessary actions to place the instrument in its reset state.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         The instrument's VISA resource description.

The default for this instrument is "GPIB0::5::INSTR".  If you change the HPIB address of this instrument, you must change the default resource description as well.         Perform an identity query to verify that the instrument is the one expected by the driver.


Macro Name  Value  Description
--------------------------------
VI_TRUE       1    Do Query
VI_FALSE      0    Skip Query         Preform instrument reset operation.

Macro Name  Value  Description
------------------------------
VI_TRUE       1    Reset
VI_FALSE      0    Don't Reset     p    The instrument's VISA session handle.  This is VI_NULL if an error occurred during the initialization process.    
o      Status                             7 .        Resource Name                      7#        Id Query                           7        Reset Device                      	$         Instrument Handle                  	           GPIB0::5::INSTR  % Do Query VI_TRUE Skip Query VI_FALSE  # Reset VI_TRUE Don't Reset VI_FALSE    	            9    This function queries the power source's output status.    
    The operating status of the power source.  The following values are returned:

Macro Name               Value  Description
---------------------------------------------------------------
HP661X_OUTP_STATUS_OFF     0    Output is in the off state.
HP661X_OUTP_STATUS_CV      1    Output is in Constant Voltage
                                mode.  The CV bit is set.
HP661X_OUTP_STATUS_CC      2    the output is in Constant
                                Current mode.  Either of the
                                CC+ or CC- bit is set.
HP661X_OUTP_STATUS_UNREG   3    the output is unregulated.  The
                                UNREG bit is set.
HP661X_OUTP_STATUS_PROT    4    Protection has tripped.  Either
                                of the OV or OCP bit is set.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    _ f         Output Status                     t  *        Instrument Handle                  s      Status                             	            0    	              This function enables the Remote Inhibit signal to ripple through the Discrete Fault Indicator signal.  By chaining the RI/DFI signals of multiple power sources, their outputs can be shutdown by one inhibit signal.

The function configures the digital control port for Remote Inhibit/Discrete Fault Interrupt operation; sets the Remote Inhibit protection to Latching mode;  selects the Questionable summary bit for the discrete fault indicator event and enables the output of the discrete fault signal.  The RI condition in the Questionable status register is also enabled for the Questionable summary bit.  The contents of the Questionable status enable register is not overwritten.
     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     (        Instrument Handle                 ^ q      Status                             0    	               This function programs the output current level, the output voltage level, and enables the output.  If option 760 is present the output relay will also be enabled.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     2    The immediate voltage level of the power supply.     2    The immediate current level of the power supply.    f $        Instrument Handle                 l      Status                             r         Volt Lev                           r.        Curr Lev                           0    	           0    0        This function sets the output voltage or the output current depending on the output parameter selection.  After the output level is set, the function measures the output voltage and current, and reads back the operating status.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Selects which output parameter to set, voltage or current:

Macro Name     Value   Description
----------------------------------
HP661X_VOLTAGE   0     set voltage
HP661X_CURRENT   1     set current
     9    The voltage measured at the output of the power supply.     9    The current measured at the output of the power supply.    
    The operating status of the power source.  The following values are returned:

Macro Name               Value  Description
---------------------------------------------------------------
HP661X_OUTP_STATUS_OFF     0    Output is in the off state.
HP661X_OUTP_STATUS_CV      1    Output is in Constant Voltage
                                mode.  The CV bit is set.
HP661X_OUTP_STATUS_CC      2    the output is in Constant
                                Current mode.  Either of the
                                CC+ or CC- bit is set.
HP661X_OUTP_STATUS_UNREG   3    the output is unregulated.  The
                                UNREG bit is set.
HP661X_OUTP_STATUS_PROT    4    Protection has tripped.  Either
                                of the OV or OCP bit is set.     :    The output voltage or current level of the power supply.     X    Time in milliseconds for the output to change and settle before measurements are made.    
 ,        Instrument Handle                 .
t      Status                             4        Output Param                        F        Volt Q Lev                        !          Curr Q Lev                        b         Output Status                     "w =         Output Lev                        " =        Settling Time                      0    	                      0Voltage HP661X_SET_VOLT Current HP661X_SET_CURR    	           	           	            0    0    B    This function provides a delay for the specified amount of time.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     N    Time delay in milliseconds.  Minimum is 0 and maximum is 30000 (30 seconds).    %  .        Instrument Handle                 % v      Status                            ' t         milliseconds                       0    	           0        This function controls the front panel display of the instrument.  The display can be programmed to display a customized message, blank screen, or display normal instrument measurements.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    T    The state of the front panel display.This parameter turns the front panel display on or off.  When off, the front panel display is blank.  The display annunciators are not affected by this command.

Macro Name  Value   Description
-------------------------------------
VI_TRUE       1     Display is on
VI_FALSE      0     Display is off
    '    The front panel display mode.  The following display modes
are available for the instrument:

Macro Name         Value   Description
--------------------------------------------------------
HP661X_DISP_NORMAL   0     Displays instrument functions
HP661X_DISP_TEXT     1     Displays user text
    ^    A case-sensitive user customized message to be displayed when the display mode is set to TEXT.  The display is capable of displaying up to 14 characters.  Message exceeding 14 characters will be truncated.

Note: to display the previous message text, send a null character string.  To clear current message text, send at leaste one blank character.     D    The instrument's VISA session handle returned from hp661x_init().
    )r      Status                            +d K )        Disp State                        , K        Disp Mode                         - K1       Message Text                      /U )        Instrument Handle                  	         ( Display On VI_TRUE Display Off VI_FALSE               0Normal HP661X_DISP_NORMAL Text HP661X_DISP_TEXT    "User Message"    0        This function queries the operating parameters of the instruments front panel display.  These parameters can be changed with the hp661x_setDisplay() function.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         The state of the front panel display.

Macro Name  Value   Description
------------------------------------
VI_TRUE       1     Display is on
VI_FALSE      0     Display is off
    Q    The front panel display mode.  The following display modes
are available for the instrument:

Macro                    Value  Description
-----------------------------------------------------------                            HP661X_DISP_NORMAL_MODE    0    Display instrument function 
HP661X_DISP_TEXT_MODE      1    Display user text         This parameter returns the user text message presently stored in the instrument.  An error occurs if no previous message was stored.  The resulting string may be truncated to 14 characters.    1  !        Instrument Handle                 2+ i      Status                            4 I 2        Disp State                        4 I         Disp Mode                         6 If       Message Text                       0    	           	            	            	           I    This function immediately start acquiring a new voltage measurement.  The speed of the measurement dependends on the digitizing parameters.  They include the number of samples, and the time interval between samples.  They are programmed with the hp661x_setSweepParams() function.

Note:  There is a tradeoff between these parameters and the speed, accuracy, and stability of the measurement in the presence of noise.

If the measurement does complete within the time alloted with the hp661x_setMeasTimeout() function,  the function returns a HP661X_INSTR_ERROR_MEAS_TMO error status.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Measurement result.
    :u ,        Instrument Handle                 :t      Status                            < \         Meas Volt                          0    	           	          E    This function immediately start acquiring new current measurement.The speed of the measurement dependends on the digitizing parameters.  They include the number of samples, and the time interval between samples.  They are programmed with the hp661x_setSweepParams() function.

Note:  There is a tradeoff between these parameters and the speed, accuracy, and stability of the measurement in the presence of noise.

If the measurement does complete within the time alloted with the hp661x_setMeasTimeout() function,  the function returns a HP661X_INSTR_ERROR_MEAS_TMO error status.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Measurement result.
    ?  +        Instrument Handle                 @ s      Status                            A M         Meas Curr                          0    	           	              This function sets the sweep parameters of a voltage or current measurement.

Dc voltage and current are measured by acquiring a number of readings at a specified time interval. Ripple rejection is a function of the number of cycles of the ripple frequency contained in the measurement.  More cycles in the measurement results in better ripple rejection.  Increasing the sample interval will increase the number of cycles in the measurement, but it also increases the measurement time.

The speed of the measurement can be increased by reducing the number of sample points.  However, the tradeoff is reduced measurement accuracy.

At power-on and after a reset function, the following parameters are set:
1. sweep interval - 15.6E-6 
2. sweep size - 2048     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        Time interval between samples in seconds.

Macro                   Value    Description
-------------------------------------------------------
HP661X_SWEEP_INT_MIN    15.6e-6  Minimum sweep interval
HP661X_SWEEP_INT_MAX    31200    Maximum sweep interval        Number of points in an acquisition.

Macro Name               Value  Description
---------------------------------------------------------
HP661X_SWEEP_SIZE_MAX    4096   Maximum number of samples
HP661X_SWEEP_SIZE_MIN    1      Minimum number of samples
    E +        Instrument Handle                 Fs      Status                            G p         Sample Interval                   H pK       Sweep Size                         0    	           15.6e-6                         Q    This function queries the sweep parameters of a voltage or current measurement.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Time period between samples.
     &    Number of points in an measurement.
    Ke  &        Instrument Handle                 K n      Status                            M ^ y        Sample Interval                   M ^;        Sweep Size                         0    	           	           	                This function sets the time for a voltage or current measurement to complete.  If the measurement does complete within the time alloted,  a HP661X_INSTR_ERROR_MEAS_TMO error status is returned by the measuement function.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    }    The measurement timeout value in milliseconds.

Note: Although zero is a valid value, it is usually not applicable to most measurements. Use a reasonable timeout value.

Macro Name          Value       Description
-----------------------------------------------------   
HP661X_TIMEOUT_MIN  0           Minimum timeout value
HP661X_TIMEOUT_MAX  2147483647  Maximum timeout value
    O  %        Instrument Handle                 P m      Status                            Q s         Meas Timeout                       0    	           2000    6    This function queries the measurement timeout value.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     1    The measurement timeout value in milliseconds.
    Tn  )        Instrument Handle                 T q      Status                            V h         Meas Timeout                       0    	           	           V    This function clears the latch that disables the output when an Over-Voltage, Over-Current, Over-Temperature, Remote Inhibit, or Fuse Status condition is detected. All conditions that generate the fault must be removed before the latch can be cleared. The output is then  restored to the state it was in before the fault condition occurred.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    X  !        Instrument Handle                 Y7 i      Status                             0    	               This function controls the polarity of the output relay contacts.  This function is only valid for units with Option 760, otherwise an error will occur.

If output is ON when this function is invoked, the output voltage is set to 0 during the time that the relays are changing polarity.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        Programming Normal causes the output relay polarity to be the same as the instrument output.  Programming Reverse causes the relay output polarity to be opposite to that of the instrument output.

Macro Name                     Value  Description
-------------------------------------------------------------
HP661X_RELAY_POLARITY_NORMAL     0    Normal output polarity
HP661X_RELAY_POLARITY_REVERSE    1    Reverse output polarity    \ %        Instrument Handle                 ]m      Status                            ^ U       Relay Polarity                     0    	                      JNormal HP661X_RELAY_POLARITY_NORMAL Reverse HP661X_RELAY_POLARITY_REVERSE        This function returns the present polarity setting of the output relay contacts.  This function is only valid for units with Option 760, otherwise an error will occur.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        The polarity of the output relay contacts.

Macro Name                     Value  Description
-------------------------------------------------------------
HP661X_RELAY_POLARITY_NORMAL     0    Normal output polarity
HP661X_RELAY_POLARITY_REVERSE    1    Reverse output polarity    bX  &        Instrument Handle                 b `      Status                            d \         Relay Polarity                     0    	           	           3    This function enables or disables the output of the instrument. The state of the disabled outputs is a condition of zero output voltage and current at the output terminals.

This function also controls the Option 760 output relay.  The Switch Relay parameter specifies if the output relay is also changed.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Output state of the unit.

Macro Name  Value   Description
--------------------------------------
VI_TRUE       1     Enable the output
VI_FALSE      0     Disable the output
        Option 760 output relay control.
         
Macro Name  Value   Description
---------------------------------------------------------------
VI_TRUE       1     Output relay is switched with the output
VI_FALSE      0     Output relay is NOT switched with the output
    g  (        Instrument Handle                 g o      Status                            i j         Output State                      j j=        Switch Relay                       0    	           ON VI_TRUE OFF VI_FALSE    YES VI_TRUE NO VI_FALSE    5    Queries the present output state of the instrument.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     |    Present state of the instruments output.

If VI_TRUE (1), the output is enabled.
If VI_FALSE (0), the output is disabled.    l  (        Instrument Handle                 m5 p      Status                            o T         Output State                       0    	           	            o    This function selects the power-on state of the instrument. This information is saved in non-volatile memory.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        Specifies the power-on state of the instrument. The following states can be selected:

*RST - Sets the power-on state to *RST. Refer to the *RST command in chapter 4 of the Programming Guide for information on the reset state of all programmable parameters.

RCL0 - Sets the power-on state to *RCL 0. This is the state stored in memory location 0 of the instrument.

Macro Name            Value   Description
-----------------------------------------
HP661X_PON_STATE_RST    0     *RST
HP661X_PON_STATE_RCL0   1     RCL0
    p  %        Instrument Handle                 q l      Status                            r R       Pon State                          0    	                      5*RST HP661X_PON_STATE_RST RCL0 HP661X_PON_STATE_RCL0    E    This function queries the power-on state setting of the instrument.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Power-on state recall setting.  The following values are returned:

Macro Name            Value   Description
-----------------------------------------
HP661X_PON_STATE_RST    0     *RST
HP661X_PON_STATE_RCL0   1     RCL0
    vK )        Instrument Handle                 vq      Status                            xv K         Pon State                          0    	           	           2    This function opens or closes the output relay contacts.  It is only valid for units with Option 760, otherwise an error will occur. The relay is controlled independently of the output state.  If the  instrument is supplying power to a load, that power will appear at the relay contacts during switching.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Specify the desire relay contact state.

If VI_TRUE (1), closes the output relay contacts;
If VI_FALSE (0), opens the output relay contacts.    {T $        Instrument Handle                 {l      Status                            } `         Relay State                        0    	           Close VI_TRUE Open VI_FALSE        This function queries the state of the output relay contacts.  It is only valid for units with Option 760, otherwise an error will occur. The relay state is independently of the output state.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         State of the output relay contact.

VI_TRUE (1), indicates the output relay contacts are closed;
VI_FALSE (0), indicates the contacts are opened.     +        Instrument Handle                 s      Status                             T         Relay State                        0    	           	           =    This function configures the digital control port for Remote Inhibit/Discrete Fault Interrupt (RI/DFI) operation and sets the RI/DFI parameters to the specified conditions. The parameters are saved in non-volatile memory.

Note:  The application must also program the Enable Register mask for each of the DFI source     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        This parameter selects the mode of operation of the Remote Inhibit protection.  This parameter is stored in non--volatile memory. The following modes can be selected:

Latching - A TTL low at the INH input latches the output in the
           protection shutdown state, which can only be cleared
           by the hp661x_clearProt() function.
Live     - The output state follows the state of the INH input.
           A TTL low at the INH input turns the output off; a
           TTL high returns the output to its programmed state.
Off      - The instrument ignores the INH input.

Macro Name        Value   Description
------------------------------------
HP661X_RI_OFF       0     Off
HP661X_RI_LATCHING  1     Latching
HP661X_RI_LIVE      2     Live
    -    Specify if the discrete fault indicator signal is enabled at the digital control port.

The discrete fault indicator (DFI) is a chassis-referenced, open-collector logic signal connected to the rear panel FLT connection, that can be used to signal external devices when a fault condition is detected.

This parameter is not stored in non-volatile memory.  It is defaulted to Disable after an instrument reset (*RST).

Macro Name  Value   Description
----------------------------------
VI_TRUE       1     DFI is enabled
VI_FALSE      0     DFI is disabled
        Specify the source of the DFI signal.

The internal sources that drive the discrete fault indicator signal are:

1. None, no discrete fault source is selected.  This has the same effect as disabling DFI.
Specify the source of the DFI signal.

The internal sources that drive the discrete fault indicator signal are:
Questionable event summary bit - bit 3 of the Status Byte Register.
Operation Event summary bit - bit 7 of the Status Byte Register.
Standard Event summary bit - bit 5 of the Status Byte Register.
The Request for Service bit -  bit 6 of the Status Byte Register.
None - No discrete fault source is selected.  This has the same effect as disabling DFI. 


This parameter is not stored in non-volatile memory.  It is defaulted to Off after an instrument reset (*RST).

Macro Name           Value  Description
--------------------------------------------------------
HP661X_DFI_SRC_PREV    0    Previous setting
HP661X_DFI_SRC_QUES    1    Questionable summary bit
HP661X_DFI_SRC_OPER    2    Operation summary bit
HP661X_DFI_SRC_ESB     3    Standard event summary bit
HP661X_DFI_SRC_RQS     4    Request for service bit
HP661X_DFI_SRC_OFF     5    Off
    t  &        Instrument Handle                  h      Status                             S        Ri Mode                            S         Dfi State                          S       Dfi Source Bit                     0    	                      BOFF HP661X_RI_OFF LATCHING HP661X_RI_LATCHING LIVE HP661X_RI_LIVE    ON VI_TRUE OFF VI_FALSE               Previous setting HP661X_DFI_SRC_PREV Questionable summary bit HP661X_DFI_SRC_QUES Operation summary bit HP661X_DFI_SRC_OPER Standard event summary bit HP661X_DFI_SRC_ESB Request for service bit HP661X_DFI_SRC_RQS Off HP661X_DFI_SRC_OFF    @    This function queries the RI/DFI settings of the power source.         Remote inhibit operating mode.

Macro Name        Value   Description
------------------------------------
HP661X_RI_OFF       0     Off
HP661X_RI_LATCHING  1     Latching
HP661X_RI_LIVE      2     Live
         Discrete fault indicator operation state.

Macro Name  Value   Description
----------------------------------
VI_TRUE       1     DFI is enabled
VI_FALSE      0     DFI is disabled
    q    Source of discrete faults.

Macro Name           Value  Description
--------------------------------------------------------
HP661X_DFI_SRC_QUES    1    Questionable summary bit
HP661X_DFI_SRC_OPER    2    Operation summary bit
HP661X_DFI_SRC_ESB     3    Standard event summary bit
HP661X_DFI_SRC_RQS     4    Request for service bit
HP661X_DFI_SRC_OFF     5    Off
     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    2 < .        Ri Mode                            <         Dfi State                          <        Dfi Source Bit                    ?  (        Instrument Handle                  p      Status                             	            	            	            0    	           9    This function sets the current sensing range parameter.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         The dc current measurement range.  The value that you program must be the maximum current that you expect to measure. The instrument will select the range that gives the best resolution.  The crossover value is 20 mA.     0        Instrument Handle                 4a      Status                             d         Curr Sense Range                   0    	           0    ,    Query the current sensing range parameter.     C    The instrument's VISA session handle returned from hp661x_init().        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     #    The current sense range setting.
     ,        Instrument Handle                 +s      Status                             f         Curr Sense Range                   0    	           	              This function directly programs the selected current parameter of the power supply.

Macro Name        Value  Description
-------------------------------------------------
HP661X_CURR_IMM     0    Immediate Current Level
HP661X_CURR_TRIG    1    Triggered Current Level     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Specify the current parameter to be programmed.

Current Parameter           Value
-----------------------------------
HP661X_CURR                   0
HP661X_CURR_TRIG              1
     %    The current level to be programmed.    	  !        Instrument Handle                 U i      Status                            5 S        Curr Param                         S<        Curr Lev                           0    	                      QImmediate Current Level HP661X_CURR_IMM Triggered Current Level HP661X_CURR_TRIG    0    I    This function queries the programmed current level of the power supply.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    @    Select the current parameter to be queried.


Macro Name        Value  Description
-------------------------------------------------
HP661X_CURR_Q       0   Current level/limit
HP661X_CURR_Q_TRIG  1   Triggered current level
HP661X_CURR_Q_MAX   2   Maximum output current
HP661X_CURR_Q_MIN   3   Minimum output current         The programmed current level.     %        Instrument Handle                 
m      Status                             W       Curr Q Param                      2 WH        Curr Lev                           0    	                      Current Level/Limit HP661X_CURR_Q Triggered Current Level HP661X_CURR_Q_TRIG Maximum Output Current HP661X_CURR_Q_MAX Minimum Output Current HP661X_CURR_Q_MIN    	           U    This function directly programs the selected voltage parameter of the power supply.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Specify the voltage parameter to be programmed.

Voltage Parameter        Value
-------------------------------
HP661X_VOLT_IMM          0
HP661X_VOLT_TRIG         1
HP661X_VOLT_OVP          2
HP661X_VOLT_OVP_MAX      3
HP661X_VOLT_OVP_MIN      4
     h    The voltage level to be programmed.

This parmater is not used if maximum or minimum OVP is selected.
    U  '        Instrument Handle                  p      Status                             R        Volt Param                         RM        Volt Lev                           0    	                      Immediate Voltage Level HP661X_VOLT_IMM Triggered Voltage Level HP661X_VOLT_TRIG OVP Level HP661X_VOLT_OVP Maximum OVP HP661X_VOLT_OVP_MAX Minimum OVP HP661X_VOLT_OVP_MIN    0    K    This function queries the selected voltage parameter of the power supply.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        Specifies the voltage parameter to query.

Macro Name             Value  Description
---------------------------------------------------------------
HP661X_VOLT_Q            0    Immediate Voltage Level
HP661X_VOLT_Q_MAX        1    Maximum Output Voltage
HP661X_VOLT_Q_MIN        2    Minimum Output Voltage
HP661X_VOLT_Q_TRIG       3    Triggered Voltage Level
HP661X_VOLT_Q_TRIG_MAX   4    Maximum Triggered Voltage
HP661X_VOLT_Q_TRIG_MIN   5    Minimum Triggered Voltage
HP661X_VOLT_Q_OVP        6    Overvoltage Protection Level
HP661X_VOLT_Q_OVP_MAX    7    Maximum Overvoltage Protection
HP661X_VOLT_Q_OVP_MIN    8    Minimum Overvoltage Protection         
      *        Instrument Handle                 5 r      Status                             :       Volt Q Param                       :l        Volt Lev                           0    	                   	  Immediate Voltage Level HP661X_VOLT_Q Maximum Output Voltage HP661X_VOLT_Q_MAX Minimum Output Voltage HP661X_VOLT_Q_MIN Triggered Voltage Level HP661X_VOLT_Q_TRIG Maximun Triggered Voltage HP661X_VOLT_Q_TRIG_MAX Minimum Triggered Voltage HP661X_VOLT_Q_TRIG_MIN Over-Voltage Protection Level HP661X_VOLT_Q_OVP Maximum Over-Voltage Protection HP661X_VOLT_Q_OVP_MAX Minimum Over-Voltage Protection HP661X_VOLT_Q_OVP_MIN    	           <    This function sets the over-current protection parameters.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         This parameter enables or disables the power supply over-current protection (OCP) function.

Macro Name  Value  Description
----------------------------------------
VI_TRUE       1    OCP enabled
VI_FALSE      0    OCP disabled        The time delay before a Constant Current condition is recognized.  The OverCurrent Protection is based on the Constant Current status bit.  The delay prevents the momentary changes in the constnat current status bit that can occur during output transients from being registered as events by the status subsystem. The unit of this parameter is seconds.  The default is 0.08s.

Note: This parameter is ignored if OCP is being disabled.

The unit of this parameter is seconds.  The allowable range is:

Macro Name           Value         Description
------------------------------------------------
HP661X_OCP_DELAY_MIN   0           Minimum delay
HP661X_OCP_DELAY_MAX   2147480000  Maximum delay      '        instrumentHandle                   d      Status                             T         Ocp Enable                         T/        Cc Delay                           0    	           On VI_TRUE Off VI_FALSE    0    ?    This function queries the over-current protection parameters.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Over-current protection enable.

Macro Name  Value  Description
-------------------------------
VI_TRUE       1    OCP enabled
VI_FALSE      0    OCP disabled     ?    Time delay before a Constant Current condition is recognized.      (        Instrument Handle                  i      Status                             N         Ocp Enable                        Ö N%        Cc Delay                           0    	           	            	          ,    This function configures the power supply digital control port to function as a digital I/O port and outputs the digIoData parameter to the port. The port has three signal pins and a digital ground pin. Bits 0 and 1 control port pins 1 and 2.  They are output only pins.  Bit 2 controls port pin 3, which is configurable to be input or output.  A 1 must be programmed to bit 2 to configure pin 3 as an input pin.  It must be reprogrammed with a 1 when changing the values of pins 1 and 2. 

The port configuration change is stored in non-volatile memory.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        I/O port value. Only the least 3 significant bits are used.  Therefore the output value can range from 0 to 7.

Program  Bit            Pin
Value    Configuration  Setting
         2    1    0    4     3          2         1
------------------------------------------------------
0        0    0    0    GND   Output     Lo        Lo
1        0    0    1    GND   Output     Lo        Hi
2        0    1    0    GND   Output     Hi        Lo
3        0    1    1    GND   Output     Hi        Hi
4        1    0    0    GND   Input      Lo        Lo
5        1    0    1    GND   Input      Lo        Hi
6        1    1    0    GND   Input      Hi        Lo
7        1    1    1    GND   Input      Hi        Hi
      $        Instrument Handle                 Z l      Status                            : k         Dig Io Data                        0    	           0   d    This function reads the digital control port when the port is configured for Digital I/O operation. Configuring of the port is done with the hp661x_setDigio() function.  The query returns the last programmed value in bits 0 and 1 and the value read at pin 3 in bit 2.

The function returns an error status if the port is configured as a digital I/O port.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     '    Value read from the digital I/O port.    -  &        Instrument Handle                 y o      Status                            Y e         Dig Io Data                        0    	           	            >    This function queries the setting of the output mode switch.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
         Output mode switch setting.  The returned value is 15,000 if the switch is set to Normal and 60,000 if the switch is set to Fast.    ъ  #        Instrument Handle                  l      Status                            Ӷ Z         Alc Bandwidth                      0    	           	                This function enables the output transient subsystem to receive triggers.  It moves the trigger system from the Idle state to the Initiated state.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
        Select trigger system to arm.

ONCE arms the output subsystem with single trigger.

CONTINUOUS arms the output subsystem with continuous trigger.

CONTINUOUS OFF turns off continuous triggering.

Macro Name                      Value  Description
-------------------------------------------------------------
HP661X_ARM_OUTPUT_ONCE            0    Output Once
HP661X_ARM_OUTPUT_CONTINUOUS      1    Output Continuous
HP661X_ARM_OUTPUT_CONTINUOUS_OFF  2    Output  Continuous Off
    ՙ          Instrument Handle                  n      Status                             U       Trig System                        0    	                      tOnce HP661X_ARM_OUTPUT_ONCE Continuous HP661X_ARM_OUTPUT_CONTINUOUS Continuous Off HP661X_ARM_OUTPUT_CONTINUOUS_OFF    z    Signal a subsystem to perform its action.  The subsystem must have been previously armed with the hp661x_arm() function.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    c          Instrument Handle                 ۯ q      Status                             0    	              This function cancels any trigger actions presently in process. Pending trigger levels are reset to their corresponding immediate values. hp661x_abort also resets the WTG bit in the Operation Condition Status register (see Programming the Status Registers). If the trigger system has been programmed to continuous, it will initiates itself immediately after hp661x_abort, thereby setting WTG. hp661x_abort is also executed at power turn on.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
      '        Instrument Handle                  p      Status                             0    	          C    The reset function places the instrument in a default state. 

The following commands are sent to the instrument:

1. Device Clear - to ensure that the instrument can execute a reset.
2. *RST - reset the instrument to factory define state.
3. *CLS - clear event and status registers, error queue, and the MAV status bit.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
    j      Status                             !        Instrument Handle                  	           0   1    The self-test function causes the instrument to perform a self-test and returns the result of that self-test.  This is used to verify that an instrument is operating properly.  A failure may indicate a potential hardware problem.

For a list of possible self-test errors, consult the Programming Guide.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     H    Numeric result from self-test operation.

0 = no error ( test passed)
     @    Self-test status message.  This is limited to 256 characters.
     D    The instrument's VISA session handle returned from hp661x_init().
    o      Status                            ~ 0 $       Test Result                         "      Test Message                       *        Instrument Handle                  	           	            	            0    l    This function returns the revision of the instrument driver and the firmware of the instrument being used.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     B    Instrument driver revision.  This is limited to 256 characters.
     D    Instrument firmware revision.  This is limited to 256 characters.
    
q      Status                            
 "        Instrument Handle                  /   ,    Instrument Driver Revision        I    ,    Firmware Revision                  	           0    	            	               This function sends a device clear (DCL) to the instrument.

A device clear will abort the current operation and enable the instrument to accept a new command or query.

This is particularly useful in situations where it is not possible to determine the instrument state. In this case, it is customary to send a device clear before issuing a new instrument driver function.  The device clear ensures that the instrument will be able to begin processing the new commands.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
    rt      Status                            R !        Instrument Handle                  	           0    T    This function sends an IEEE Group Execute Trigger (GET or *TRG) to the instrument.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require atention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message function to get a textual description of errors and warnings.
    u  -        Instrument Handle                  z      Status                             0    	           r    This function translates the error value returned from an instrument driver function to a user-readable string.
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     =    The error return value from an instrument driver function.
     <    Error message string.  This is limited to 256 characters.
     D    The instrument's VISA session handle returned from hp661x_init().
    	q      Status                            s 6 "       Status Code                         "      Status Message                    	 &        Instrument Handle                  	           0    	            0       This function returns the error numbers and corresponding error messages in the error queue of an instrument.  See the manual for a listing of the instrument error numbers and messages.

Instrument errors may occur when a user attempts to place the instrument in an invalid state such as sending an invalid sequence of coupled commands.

Instrument errors can be detected by polling.  Automatic polling can be accomplished by using the hpxxxx_errorQueryDetect() function.

        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
         Instrument's error code.
     B    Instrument's error message.  This is limited to 256 characters.
    !n      Status                             "        Instrument Handle                 M / "       Error Code                        p  "      Error Message                      	           0    	            	           *    This function enables or disables automatic instrument error checking.

When automatic instrument error querying is enabled, the driver will query the instrument for an error before returning from each driver function.  This adds the overhead of one instrument query to each dirver function call.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
        A boolean which enables/disables automatic instrument error querying.

Macro Name  Value  Description
------------------------------------------------------------
VI_TRUE       1    Enable automatic instrument error query.
VI_FALSE      0    Disable automatic instrument error query.
   	t      Status                           	 "        Instrument Handle                 D         Error Query Detect                 	           0     Enable VI_TRUE Disable VI_FALSE   <    This function indicates if automatic instrument error detection is enabled or disabled. 

When automatic instrument error querying is enalbed, the driver will query the instrument for an error before returning from each driver function.  This adds the overhead of one instrument query to each dirver function call.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
         A boolean which indicates if automatic instrument error querying is enabled or disabled.  

If VI_TRUE (1), automatic instrument error querying is enabled.

If VI_FALSE (0), automatic instrument error querying is disabled.
   R t      Status                           	2           Instrument Handle                	~ 4    d    Error Query Detect                 	           0    	           U    The timeout function sets the timeout value for driver I/O transactions in milliseconds. The timeout period may vary on computer platforms.

The default timeout period varies by VISA implementation.  For HP VISA, it is 2 seconds.

Some implementations of VISA will only accept a limited number of timeout values.  If you set the VISA timeout to a given value using one of those implementations, and then query the timeout, you may find that the query returns a different value than the one you set.  HP VISA sets the timeout to the precise value you specify, and returns that value when queried.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
    ;    This value sets the I/O timeout for all functions in the driver. It is specified in milliseconds. 

Macro Name           Value        Description
------------------------------------------------------   
HP661X_TIMEOUT_MIN   0            Minimum bus timoeut 
HP661X_TIMEOUT_MAX   2147483647   Maximum bus timeout
   
 s      Status                           `  '        Instrument Handle                 B        Time Out                           	           0                           The timeout query function returns the timeout value for driver I/O transactions in milliseconds.  The timeout period may vary on computer platforms.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     e    This value sets the I/O timeout for all functions in the driver. It is specified in milliseconds. 
   U
r      Status                           5
 "        Instrument Handle                 2       Time Out                           	           0    	            F    This function queries the operation complete bit in the Status Byte.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require atention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message function to get a textual description of errors and warnings.
     /    The status of the OPC bit in the Status Byte.     -        Instrument Handle                D z      Status                           ! \         Instrument Ready                   0    	           	            >    This function queries the instrument's Status Byte register.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     )    The value of the Status Byte register.
   Zv      Status                           : "        Instrument Handle                 /    d    Status Byte                        	           0    	            5    This function queries the Operation Event register.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     -    The value of the Operation Event register.
    p      Status                             "        Instrument Handle                 6    d    Operation Event Register           	           0    	            9    This function queries the Operation Condition register.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     1    The value of the Operation Condition register.
    u      Status                           ! "        Instrument Handle                ": 4    d    Operation Condition Register       	           0    	            8    This function queries the Questionable Event register.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     0    The value of the Questionable Event register.
   #or      Status                           %O "        Instrument Handle                % 8    d    Questionable Event Register        	           0    	            <    This function queries the Questionable Condition register.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     5    The value of the Questionable Condition register.
    &o      Status                           ( "        Instrument Handle                ( ?    d    Questionable Condition Register    	           0    	            ;    This function queries the Standart Event Status register.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
     4    The value of the Standard Event Status register.
    *; #        Instrument Handle                *	p      Status                           ,g ]    d    Standard Event Status              0    	           	                This function sets the enable mask of the specified status register.  The mask specifies the events to be included in the 
summary status bit.  The summary status bit is used by the status byte register and the DFI source register.
     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    L    Event register select.

The following status registers are defined for the dc source:

Macro Name      Value  Description
-----------------------------------------
HP661X_REG_ESE    0    Standard Event Status
HP661X_REG_SRE    1    Service Request
HP661X_REG_OPER   2    Operation Status
HP661X_REG_QUES   3    Questionable Status         The mask for the selected event register.  Refer to  Programming the Status Registers for a definition of  each status register bit.  A 1 in the mask enables the specified event.   .Q +        Instrument Handle                . x      Status                           0} A        Enable Register                  1 R=        Enable Mask                        0    	                     Standard Event Status HP661X_REG_ESE Service Request HP661X_REG_SRE Operation Status HP661X_REG_OPER Questionable Status HP661X_REG_QUES    0    7    Returns the contents of the selected enable register.     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.
    L    Event register select.

The following status registers are defined for the dc source:

Macro Name      Value  Description
-----------------------------------------
HP661X_REG_ESE    0    Standard Event Status
HP661X_REG_SRE    1    Service Request
HP661X_REG_OPER   2    Operation Status
HP661X_REG_QUES   3    Questionable Status     /    The contents of the selected enable register.   4N &        Instrument Handle                4 u      Status                           6z c        Enable Register                  7 j<        Enable Mask                        0    	                      Standard Event Status HP661X_REG_ESE Service Request HP661X_REG_SRE Operation Status HP661X_REG_OPER Questionable Status HP661X_REG_QUES    	            k    This function passes an instrument command to the instrument.  The function does not expect any response.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require atention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     i    The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
   :s      Status                           ; "        Instrument Handle                <* 1 "      String Command                     	           0    ""       Passes the command string to the instrument.  The function waits for a response which must be a string (character data).

A max of size-1 bytes will be read from the instrument into the string and the string will be NULL terminated (so its length can be found with strlen).

If more than size-1 bytes are generated by the instrument then remaining bytes will be discarded and the instrument's output buffer will be cleared.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require atention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message function to get a textual description of errors and warnings.
     D    The instrument's VISA session handle returned from hp661x_init().
     i    The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
        The length of result array in bytes. 

Macro Name              Value         Description
---------------------------------------------------------------  
HP661X_CMDSTRING_Q_MIN   1           Minimum string array size
HP661X_CMDSTRING_Q_MAX   2147483647  Maximum string array size     $    The response from the instrument.
   ?o      Status                           @ "        Instrument Handle                A+ 0 "      String Command                   A r "       String Size                      B         String Result                      	           0    " "                     	                This function passes the string in cmd_str followed by a space and then an integer.  Note that either a ViInt16 or 32 can be passed, as the ViInt16 will be promoted.
     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require atention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message function to get a textual description of errors and warnings.
     |    [INPUT PARAMETER]

The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
        The integer to be appended to the command string. 

Macro Name         Value        Description
------------------------------------------------------  
HP661X_CMDINT_MIN  -2147483647  Minimum integer value
HP661X_CMDINT_MAX  2147483647   Maximum integer value   D $        Instrument Handle                E*      Status                           G 3 $      Send Integer Command             G  &       Send Integer                       0    	           ""                     t    Passes the command string to the instrument.  The function expects a 16-bit integer response from the instrument.
     i    The instrument command.  It must be a NULL termianted C string and may not exceed 256 bytes in length.
     $    The response from the instrument.
     D    The instrument's VISA session handle returned from hp661x_init().
        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message function to get a textual description of errors and warnings.
   J , '      Query I16 Command                J k '        I16 Result                       J '        Instrument Handle                K w      Status                             ""    	            0    	               The close function terminates the software connection to the instrument and de-allocates system resources.  It is generally a good programming habit to close the instrument handle when the program is done using the instrument.        The meaning of the VISA status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the hp661x_error_message() function to get a textual description of errors and warnings.     C    The instrument's VISA session handle returned from hp661x_init().   N q      Status                           P  "        Instrument Handle                  	           0            	     K-    init                                            K.    readOutputStatus                         \  >     K.    rippleRiDfi                                     K.    outputVoltCurr                             #     K.    setMeasure                               %?  (     K.    doDelay                                  (  /     K.    setDisplay                               17  6     K.    getDisplay                               8$  <     K.    measureVolt                              =z  B     K.    measureCurr                              B  J     K.    setSweepParams                           K  M     K.    getSweepParams                           N  Sx     K.    setMeasTimeout                           T0  V     K.    getMeasTimeout                           W  [     K.    clearOutpProt                            [  `     K.    setOutpRelayPolarity                     a  e     K.    getOutpRelayPolarity                     f`  k     K.    setOutpState                             l  o     K.    getOutpState                             pU  u
     K.    setPonState                              u  y^     K.    getPonState                              z  ~     K.    setOutpRelay                             ~  s     K.    getOutpRelay                             /  i     K.    setRiDfi                                   j     K.    getRiDfi                                        K.    setCurrSenseRange                          6     K.    getCurrSenseRange                          #     K.    setCurr                                  m  Y     K.    getCurr                                         K.    setVolt                                         K.    getVolt                                  Z  v     K.    setOcpParams                             {       K.    getOcpParams                                    K.    setDigio                                   Ј     K.    getDigio                                 D  A     K.    getVoltAlcBandwidth                        ٮ     K.    arm                                        ݏ     K.    trigger                                  
       K.    abort                                    s       K-    reset                                    e  b     K-    self_test                                _       K-    revision_query                                  K-    dcl                                             K.    trg                                        H     K-    error_message                            >       K-    error_query                               ;     K-    errorQueryDetect                         
g     K-    errorQueryDetect_Q                      #      K-    timeOut                                       K-    timeOut_Q                                X     K.    opc_Q                                         K-    readStatusByte_Q                        s      K-    operEvent_Q                              "s     K-    operCond_Q                              #/ %     K-    quesEvent_Q                             & )<     K-    quesCond_Q                              ) ,     K.    stdEvent_Q                              -_ 2     K.    setEnableReg                            4 8     K.    getEnableReg                            9 <     K-    cmd                                     =Q B     K-    cmdString_Q                             D. H     K.    cmdInt                                  I L     K.    cmdInt16_Q                              M P     K-    close                                                                      DInitialize                        Application Functions                DRead Output Status                   DRipple RI/DFI                        DOutput Voltage and Current           DSet and Measure                      DDelay Program                     Display                              DSet Display Parameters               DQuery Display Parameters          Measure                              DVoltage Measurement                  DCurrent Measurement                  DSet Sweep Parameters                 DQuery Sweep Parameters               DSet Measurement Timeout              DQuery Measurement Timeout         Output                               DClear Output Protection              DSet Output Relay Polarity            DQuery Output Relay Polarity          DSet Output State                     DQuery Output State                   DSet Power-On Recall State            DQuery Power-On Recall State          DSet Output Relay State               DQuery Output Relay State             DSet RI/DFI Parameters                DQuery  RI/DFI Paramters           Sense                                DSet Current Sense Range              DQuery Current Sense Range         Source                               DSet Current Parameter                DQuery Current Parameter              DSet Voltage Parameter                DQuery Voltage Parameter              DSet Over-Current Protection          DQuery Over-Current Protection        DSet Digital I/O Port                 DQuery Digital I/O Port               DQuery Output Bandwidth Setting    Trigger                              DArm Trigger                          DGenerate Trigger                    dUtility                              DAbort                                DReset                                DSelf-Test                            DRevision Query                       DDevice Clear                         DGroup Execute Trigger             Error                                DError Message                        DError Query                          DSet Error Query Detect               DQuery Error Query Detect          Time Out                             DSet Timeout                          DQuery Timeout                     Synchronization                      DQuery Operation Complete          Status                               DRead Status Byte                     DOperation Status Events              DOperation Status Conditions          DQuestionable Status Events           DQuestionable Status Conditions       DStandard Event Status                DSet Enable Register                  DQuery Enable Register               CPassthrough Functions                DSend String                          DQuery String                         DSend Integer                         DQuery Int16                          DClose                           