' Copyright (C) 1995-2001 Agilent Technologies 
' VXIplug&play Instrument Driver for the Agilent E1441

'/*================================*/
'/*           HPE1441              */
'/*================================*/
'/* Framework Revision: WIN95 4.0  */
'/*                     WINNT 4.0  */
'/* Driver Revision:    A.01.02    */
'/* Firmware Revision:  A.01.00    */
'/*================================*/

'/*=============================*/
'/* Source Files:               */
'/*=============================*/
'/*   hpe1441.c                 */
'/*   hpe1441.h                 */
'/*=============================*/

'/*=============================*/
'/* WIN95/WINNT Framework Files */
'/*=============================*/
'/*   hpe1441.def               */
'/*   hpe1441.rc                */
'/*   hpe1441.bas               */
'/*=============================*/


'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Agilent Common Error numbers start at BFFC0D00

Global Const hpe1441_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1441_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1441_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1441_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1441_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1441_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1441_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Parameter errors not in VPP 3.4
Global Const hpe1441_INSTR_ERROR_PARAMETER9                   = &HBFFC0D20&
Global Const hpe1441_INSTR_ERROR_PARAMETER10                  = &HBFFC0D21&
Global Const hpe1441_INSTR_ERROR_PARAMETER11                  = &HBFFC0D22&
Global Const hpe1441_INSTR_ERROR_PARAMETER12                  = &HBFFC0D23&
Global Const hpe1441_INSTR_ERROR_PARAMETER13                  = &HBFFC0D24&
Global Const hpe1441_INSTR_ERROR_PARAMETER14                  = &HBFFC0D25&
Global Const hpe1441_INSTR_ERROR_PARAMETER15                  = &HBFFC0D26&
Global Const hpe1441_INSTR_ERROR_PARAMETER16                  = &HBFFC0D27&
Global Const hpe1441_INSTR_ERROR_PARAMETER17                  = &HBFFC0D28&
Global Const hpe1441_INSTR_ERROR_PARAMETER18                  = &HBFFC0D29&

' Used by Status System Functions
Global Const hpe1441_USER_ERROR_HANDLER                       = -1

Global Const hpe1441_QUES_LOCK                                = 406

Global Const hpe1441_ESR_OPC                                  = 601
Global Const hpe1441_ESR_QUERY_ERROR                          = 603
Global Const hpe1441_ESR_DEVICE_DEPENDENT_ERROR               = 604
Global Const hpe1441_ESR_EXECUTION_ERROR                      = 605
Global Const hpe1441_ESR_COMMAND_ERROR                        = 606

' Used by Function hpe1441_timeOut
Global Const hpe1441_TIMEOUT_MAX                              = 2147483647&
Global Const hpe1441_TIMEOUT_MIN                              = 1&

Global Const hpe1441_CMDSTRING_Q_MAX                              = 32767&
Global Const hpe1441_CMDSTRING_Q_MIN                              = 2&

Global Const hpe1441_CMDDATA_Q_MAX                              = 32767&
Global Const hpe1441_CMDDATA_Q_MIN                              = 2&

'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1441_init Lib "hpe1441_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1441_close Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_reset Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_self_test Lib "hpe1441_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1441_error_query Lib "hpe1441_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1441_error_message Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1441_revision_query Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' Agilent other standard functions 

Declare Function hpe1441_dcl Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_errorQueryDetect Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function hpe1441_errorQueryDetect_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function hpe1441_opc Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_opc_Q Lib "hpe1441_32.dll" (ByVal vi As Long, opc As Integer) As Long

Declare Function hpe1441_readStatusByte_Q Lib "hpe1441_32.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function hpe1441_statCond_Q Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal happening As Long, pCondition As Integer) As Long

Declare Function hpe1441_statEvenClr Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_statEven_Q Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal happening As Long, pEvent As Integer) As Long

Declare Function hpe1441_timeOut Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function hpe1441_timeOut_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function hpe1441_trg Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_wai Lib "hpe1441_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1441_cmd Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal pCmd As String) As Long

Declare Function hpe1441_cmdInt Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal cval as Long) As Long

Declare Function hpe1441_cmdReal Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal cval as Double) As Long

Declare Function hpe1441_cmdString_Q Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal Count As Long,ByVal pResult As String) As Long

Declare Function hpe1441_cmdReal64_Q Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal pCmd As String, pResult As Double) As Long

Declare Function hpe1441_cmdInt16_Q Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal pCmd As String, pResult As Integer) As Long

Declare Function hpe1441_quesEvent_Q Lib "hpe1441_32.dll" (ByVal vi As Long,StatVal As Long) As Long

Declare Function hpe1441_quesCond_Q Lib "hpe1441_32.dll" (ByVal vi As Long,StatVal As Long) As Long

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1441_amConf
Global Const hpe1441_AMP_MOD_SOUR_BOTH                    = 0
Global Const hpe1441_AMP_MOD_SOUR_EXT                     = 1
Global Const hpe1441_AMP_MOD_MAX                          = 120.0
Global Const hpe1441_AMP_MOD_MIN                          = 0.0
Global Const hpe1441_SIN                                  = 0
Global Const hpe1441_SQU                                  = 1
Global Const hpe1441_TRI                                  = 2
Global Const hpe1441_RAMP                                 = 3
Global Const hpe1441_NOIS                                 = 4
Global Const hpe1441_USER                                 = 5
Global Const hpe1441_AMP_MOD_FREQ_MAX                     = 20.0e3
Global Const hpe1441_AMP_MOD_FREQ_MIN                     = 10.0e-3
Global Const hpe1441_OFF                                  = 0
Global Const hpe1441_ON                                   = 1

' Used by Function hpe1441_amConf_Q
'    hpe1441_AMP_MOD_SOUR_BOTH
'    hpe1441_AMP_MOD_SOUR_EXT
'    hpe1441_SIN
'    hpe1441_SQU
'    hpe1441_TRI
'    hpe1441_RAMP
'    hpe1441_NOIS
'    hpe1441_USER

' Used by Function hpe1441_bmConf
Global Const hpe1441_BM_MOD_SOUR_INT                      = 0
Global Const hpe1441_BM_MOD_SOUR_EXT                      = 1
Global Const hpe1441_BM_MOD_NCYC_MAX                      = 50000
Global Const hpe1441_BM_MOD_NCYC_MIN                      = 0
Global Const hpe1441_BM_MOD_PHAS_MAX                      = 360
Global Const hpe1441_BM_MOD_PHAS_MIN                      = -360
Global Const hpe1441_BM_MOD_RATE_MAX                      = 50.0e3
Global Const hpe1441_BM_MOD_RATE_MIN                      = 10.0e-3
'    hpe1441_OFF
'    hpe1441_ON
Global Const hpe1441_TRIGGER_SOUR_IMM                     = 0
Global Const hpe1441_TRIGGER_SOUR_EXT                     = 1
Global Const hpe1441_TRIGGER_SOUR_BUS                     = 2
Global Const hpe1441_TRIGGER_SOUR_TTLT0                   = 3
Global Const hpe1441_TRIGGER_SOUR_TTLT1                   = 4
Global Const hpe1441_TRIGGER_SOUR_TTLT2                   = 5
Global Const hpe1441_TRIGGER_SOUR_TTLT3                   = 6
Global Const hpe1441_TRIGGER_SOUR_TTLT4                   = 7
Global Const hpe1441_TRIGGER_SOUR_TTLT5                   = 8
Global Const hpe1441_TRIGGER_SOUR_TTLT6                   = 9
Global Const hpe1441_TRIGGER_SOUR_TTLT7                   = 10

' Used by Function hpe1441_bmConf_Q
'    hpe1441_BM_MOD_SOUR_INT
'    hpe1441_BM_MOD_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_IMM
'    hpe1441_TRIGGER_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_BUS
'    hpe1441_TRIGGER_SOUR_TTLT0
'    hpe1441_TRIGGER_SOUR_TTLT1
'    hpe1441_TRIGGER_SOUR_TTLT2
'    hpe1441_TRIGGER_SOUR_TTLT3
'    hpe1441_TRIGGER_SOUR_TTLT4
'    hpe1441_TRIGGER_SOUR_TTLT5
'    hpe1441_TRIGGER_SOUR_TTLT6
'    hpe1441_TRIGGER_SOUR_TTLT7

' Used by Function hpe1441_conf
'    hpe1441_SIN
'    hpe1441_SQU
'    hpe1441_TRI
'    hpe1441_RAMP
'    hpe1441_NOIS
'    hpe1441_USER
Global Const hpe1441_DC                                   = 6
Global Const hpe1441_FREQ_MAX                             = 15.0e6
Global Const hpe1441_FREQ_MIN                             = 100.0e-6
Global Const hpe1441_AMPL_MAX                             = 22.22
Global Const hpe1441_AMPL_MIN                             = -23.8
Global Const hpe1441_OFFS_MAX                             = 10.0
Global Const hpe1441_OFFS_MIN                             = -10.0
Global Const hpe1441_OUTPUT_LOAD_INF                      = 9.9E+37
Global Const hpe1441_OUTPUT_LOAD_50                       = 50

' Used by Function hpe1441_conf_Q
'    hpe1441_SIN
'    hpe1441_SQU
'    hpe1441_TRI
'    hpe1441_RAMP
'    hpe1441_NOIS
'    hpe1441_USER
'    hpe1441_DC

' Used by Function hpe1441_dataDacVolatile
Global Const hpe1441_POINTS_MAX                           = 16000
Global Const hpe1441_POINTS_MIN                           = 8

' Used by Function hpe1441_dataVolatile
'    hpe1441_POINTS_MAX
'    hpe1441_POINTS_MIN

' Used by Function hpe1441_fmConf
Global Const hpe1441_FREQ_MOD_DEV_MAX                     = 7.5e+6
Global Const hpe1441_FREQ_MOD_DEV_MIN                     = 10.0e-3
'    hpe1441_SIN
'    hpe1441_SQU
'    hpe1441_TRI
'    hpe1441_RAMP
'    hpe1441_NOIS
'    hpe1441_USER
Global Const hpe1441_FREQ_MOD_FREQ_MAX                    = 10.0e3
Global Const hpe1441_FREQ_MOD_FREQ_MIN                    = 10.0e-3
'    hpe1441_OFF
'    hpe1441_ON

' Used by Function hpe1441_fmConf_Q
'    hpe1441_SIN
'    hpe1441_SQU
'    hpe1441_TRI
'    hpe1441_RAMP
'    hpe1441_NOIS
'    hpe1441_USER

' Used by Function hpe1441_freqSweep
Global Const hpe1441_SWEEP_FREQ__MAX                      = 15.0e6
Global Const hpe1441_SWEEP_FREQ__MIN                      = 10.0e-3
Global Const hpe1441_SWEEP_FREQ_MAX                       = 15.0e6
Global Const hpe1441_SWEEP_FREQ_MIN                       = 10.0e-3
Global Const hpe1441_SWEEP_TIME_MAX                       = 500
Global Const hpe1441_SWEEP_TIME_MIN                       = 1.0e-3
Global Const hpe1441_SWEEP_SPAC_LIN                       = 0
Global Const hpe1441_SWEEP_SPAC_LOG                       = 1
'    hpe1441_OFF
'    hpe1441_ON
'    hpe1441_TRIGGER_SOUR_IMM
'    hpe1441_TRIGGER_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_BUS
'    hpe1441_TRIGGER_SOUR_TTLT0
'    hpe1441_TRIGGER_SOUR_TTLT1
'    hpe1441_TRIGGER_SOUR_TTLT2
'    hpe1441_TRIGGER_SOUR_TTLT3
'    hpe1441_TRIGGER_SOUR_TTLT4
'    hpe1441_TRIGGER_SOUR_TTLT5
'    hpe1441_TRIGGER_SOUR_TTLT6
'    hpe1441_TRIGGER_SOUR_TTLT7

' Used by Function hpe1441_freqSweep_Q
'    hpe1441_SWEEP_SPAC_LIN
'    hpe1441_SWEEP_SPAC_LOG
'    hpe1441_TRIGGER_SOUR_IMM
'    hpe1441_TRIGGER_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_BUS
'    hpe1441_TRIGGER_SOUR_TTLT0
'    hpe1441_TRIGGER_SOUR_TTLT1
'    hpe1441_TRIGGER_SOUR_TTLT2
'    hpe1441_TRIGGER_SOUR_TTLT3
'    hpe1441_TRIGGER_SOUR_TTLT4
'    hpe1441_TRIGGER_SOUR_TTLT5
'    hpe1441_TRIGGER_SOUR_TTLT6
'    hpe1441_TRIGGER_SOUR_TTLT7

' Used by Function hpe1441_fskConf
Global Const hpe1441_FSK_SOUR_INT                         = 0
Global Const hpe1441_FSK_SOUR_EXT                         = 1
Global Const hpe1441_FSK_FREQ_MAX                         = 15.0e6
Global Const hpe1441_FSK_FREQ_MIN                         = 10.0e-3
Global Const hpe1441_FSK_RATE_MAX                         = 50.0e3
Global Const hpe1441_FSK_RATE_MIN                         = 10.0e-3
'    hpe1441_OFF
'    hpe1441_ON
'    hpe1441_TRIGGER_SOUR_IMM
'    hpe1441_TRIGGER_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_BUS
'    hpe1441_TRIGGER_SOUR_TTLT0
'    hpe1441_TRIGGER_SOUR_TTLT1
'    hpe1441_TRIGGER_SOUR_TTLT2
'    hpe1441_TRIGGER_SOUR_TTLT3
'    hpe1441_TRIGGER_SOUR_TTLT4
'    hpe1441_TRIGGER_SOUR_TTLT5
'    hpe1441_TRIGGER_SOUR_TTLT6
'    hpe1441_TRIGGER_SOUR_TTLT7

' Used by Function hpe1441_fskConf_Q
'    hpe1441_FSK_SOUR_INT
'    hpe1441_FSK_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_IMM
'    hpe1441_TRIGGER_SOUR_EXT
'    hpe1441_TRIGGER_SOUR_BUS
'    hpe1441_TRIGGER_SOUR_TTLT0
'    hpe1441_TRIGGER_SOUR_TTLT1
'    hpe1441_TRIGGER_SOUR_TTLT2
'    hpe1441_TRIGGER_SOUR_TTLT3
'    hpe1441_TRIGGER_SOUR_TTLT4
'    hpe1441_TRIGGER_SOUR_TTLT5
'    hpe1441_TRIGGER_SOUR_TTLT6
'    hpe1441_TRIGGER_SOUR_TTLT7


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1441_amConf Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal Sour As Integer, ByVal Dept As Double, ByVal Func As Integer, ByVal Freq As Double, ByVal Stat As Integer) As Long

Declare Function hpe1441_amConf_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pSour As Integer, pDept As Double, pFunc As Integer, pFreq As Double, pStat As Integer) As Long

Declare Function hpe1441_bmConf Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal Source As Integer, ByVal Ncycle As Long, ByVal Phase As Double, ByVal Rate As Double, ByVal State As Integer, ByVal trigSour As Integer) As Long

Declare Function hpe1441_bmConf_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pSour As Integer, pNcyc As Long, pPhas As Double, pRate As Double, pStat As Integer, pTrigSour As Integer) As Long

Declare Function hpe1441_conf Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal func As Integer, ByVal freq As Double, ByVal ampl As Double, ByVal offs As Double, ByVal outpLoad As Double) As Long

Declare Function hpe1441_conf_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pShape As Integer, pFreq As Double, pVolt As Double, pOffset As Double, pOutpLoad As Double) As Long

Declare Function hpe1441_dataDacVolatile Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal NoOfPoints As Integer, array As Integer) As Long

Declare Function hpe1441_dataVolatile Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal NoOfPoints As Integer, array As Double) As Long

Declare Function hpe1441_fmConf Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal Dev As Double, ByVal Func As Integer, ByVal Freq As Double, ByVal Stat As Integer) As Long

Declare Function hpe1441_fmConf_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pDev As Double, pFunc As Integer, pFreq As Double, pStat As Integer) As Long

Declare Function hpe1441_freqSweep Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal swStart As Double, ByVal swStop As Double, ByVal Time As Double, ByVal Space As Integer, ByVal State As Integer, ByVal trigSour As Integer) As Long

Declare Function hpe1441_freqSweep_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pStart As Double, pStop As Double, pTime As Double, pSpace As Integer, pState As Integer, pTrigSour As Integer) As Long

Declare Function hpe1441_fskConf Lib "hpe1441_32.dll" (ByVal vi As Long, ByVal Source As Integer, ByVal hopFreq As Double, ByVal Rate As Double, ByVal State As Integer, ByVal trigSour As Integer) As Long

Declare Function hpe1441_fskConf_Q Lib "hpe1441_32.dll" (ByVal vi As Long, pSour As Integer, pHopFreq As Double, pRate As Double, pStat As Integer, pTrigSour As Integer) As Long

