s            3  6  
      
                                    hpe1441     HPE1441                                         ViInt16     ViInt32    ViReal64     
  	ViInt16 []     
  	ViInt32 []       
ViReal64 []      ViRsrc     	 	ViSession     	  ViChar []      ViStatus     	 	ViBoolean      	 ViBoolean []      ViString   .    15MHz Function/Arbitrary Waveform Generator     d    Application functions describe how to use this driver to a perform setups/queries of basic instrument features-- setting many parameters in one function call.  Tweaking of an individual parameter may be done with the "Pass Through" functions.

This secion includes Configure which provides the most straightforward method to program the function generator. You can select the function, frequency, amplitude, offset and load all in one command.

Other commands in this section allow you to configure the Amplitude, Frequency and Burst Modulation subsystems, the FSK subsystem and the Frequency Sweep subsystem.      i    Low level controls are for manipulating the instrument settings and state at the most granular level.

     <    These functions pass commands directly to the instrument.      d    Status functions obtain the current status of the instrument or the status of pending operations.          Events indicate that something happened to the instrument. The event subsystem provides functions for reading events and clearing all events.          The synchronization subsystem provides functions that are used to synchronize instrument output by monitoring the status of pending operations.      \    These are functions that are not measurment oriented, but more general purpose in nature.     C    Error Handling functions deal with error conditions.  There are two types of errors - driver errors and instrument errors.  Driver errors are errors in parameters that are passed to functions.  Instrument errors are errors that occur in the instrument.  Instrument errors may not be automatically detected by the driver.          This is used for automatically querying the instrument for instrument errors. Normally, it is up to the user to query the instrument if an error occurs. That would provide faster programming speed once the user's program was error free.      ^    This class of function enable you to set and query the timeout parameter of the instrument.     Y    The initialize function initializes the software connection to the instrument and optionally verifies that instrument is in the system.  In addition, it may perform any necessary actions to place the instrument in its reset state.

If the hpe1441_init() function encounters an error, then the value of the vi output parameter will be VI_NULL.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      F    The Instrument Description. Examples: VXI::8, GPIB-VXI::128::INSTR.          if( VI_TRUE) Perform Identification Query if(VI_FALSE) Do not perform Identification Query 

 Macro Name    Value  Description
-----------------------------------------------------------
 VI_FALSE          0  Skip Query
 VI_TRUE           1  Do Query
         IF( VI_TRUE) Perform Reset Operation. if(VI_FALSE) Do not perform Reset operation 

 Macro Name    Value  Description
-----------------------------------------------------------
 VI_FALSE          0  Don't Reset
 VI_TRUE           1  Reset Device
     K    Instrument Handle. This is VI_NULL if an error occurred during the init.     
       Status                             F #        Resource Name                      F'        ID Query                           F        Reset Device                      
          Instrument Handle                  	           
"VXI::16"  % Do Query VI_TRUE Skip Query VI_FALSE  * Reset Device VI_TRUE Don't Reset VI_FALSE    	           4    The command provides the most straightforward method to program the main waveform of the function generator.  You can select the function, frequency, amplitude, offset and output load.

The amplitude is in the currently set units (which is defaulted to VPP at power on).  Although this function shows a range of amplitude values from -23.8 to 22.22, the output amplitude is limited to the range of 0.05 to 10 Volts Peak-to-Peak into a 50 Ohm load.  The wider range of values given here will enable you to program the full range in other voltage units and into an open load termination.  You may program the amplitude in other units by first using the SCPI Pass Through function:

hpe1441_cmd( vi, "VOLT:UNIT VPP|VRMS|DBM");

(using just one of the VPP, VRMS or DBM units).

The function generator has a fixed output impedence of 50 ohms on the OUTPUT terminal. You can specify whether you are terminating the output into a 50 ohm load or an open circuit.  Incorrect impedence matching between the function generator and your load will result in an amplitude or offset which does not match the specified signal level.

If you specify a 50 ohm termination but are actually terminating into an open circuit, the actual output will be twice the value specified.

To tweak other characteristics of the waveforms you may use the "Pass-Through" functions provided with this driver.  You will need to know the SCPI commands for the items that you wish to change.  For instance, to change the duty cycly of a square wave to 30% you would use:

errStatus =  hpe1441_cmdInt( vi, "PULS:DCYC", 30);          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument         The desired function to be output by the function generator. The allowable settings are shown below. 

 Macro Name        Value  Description
-----------------------------------------------------------
 hpe1441_SIN           0  Sinusoid
 hpe1441_SQU           1  Square
 hpe1441_TRI           2  Triangle
 hpe1441_RAMP          3  Ramp
 hpe1441_NOIS          4  Noise
 hpe1441_USER          5  User
 hpe1441_DC            6  DC
         The desired frequency of the function generator.  Note that the frequency range may be limited by the function that is selected. 

MAX = hpe1441_FREQ_MAX   15.0e6
MIN = hpe1441_FREQ_MIN   100.0e-6
         The desired amplitude of the function generator.  This amplitude is in the currently set units (which is defaulted to VPP at power on). 

MAX = hpe1441_AMPL_MAX   22.22
MIN = hpe1441_AMPL_MIN   -23.8
         The desired offset voltage of the function generator.  Note that the actual range of offset voltages depends upon the amplitude setting. 

MAX = hpe1441_OFFS_MAX   10.0
MIN = hpe1441_OFFS_MIN   -10.0
         Sets the output termination for output amplitude and offset voltage. 

MAX = hpe1441_OUTPUT_LOAD_INF   9.9E+37
MIN = hpe1441_OUTPUT_LOAD_50   50
           Status                             #         Instrument Handle                  /         func                              r /        freq                              A /y       ampl                                       offs                               K       outpLoad                           	           0               Sinusoid hpe1441_SIN Square hpe1441_SQU Triangle hpe1441_TRI Ramp hpe1441_RAMP Noise hpe1441_NOIS User hpe1441_USER DC hpe1441_DC @oT4Al8    ?6C-@@                ?rًg@68Q7?           ?`bM@$      $                         FfKGҞ6wo@I      @I                    Y    Queries the function, frequency, amplitude, offset and load of the function generator.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument         Shows the shape of the selected arbitrary waveform, as follows 

 Macro Name        Value  Description
-----------------------------------------------------------
 hpe1441_SIN           0  Sinusoid
 hpe1441_SQU           1  Square
 hpe1441_TRI           2  Triangle
 hpe1441_RAMP          3  Ramp
 hpe1441_NOIS          4  Noise
 hpe1441_USER          5  User
 hpe1441_DC            6  DC
         Gives the output frequency.      R    Gives the present output amplitude in whatever units have been set by the user.      #    Gives the present output offset.      [    The Output Load setting is returned in this parameter.  This will be 50 or 9.9E+37 Ohms.            Status                            B #         Instrument Handle                 i / Y        pShape                              /         pFreq                             ! /o        pVolt                             !x          pOffset                           ! A        pOutpLoad                          	           0    	            	           	           	           	              This function selects the amplitude modulation state and AM waveform source, shape, frequency and depth.

In AM, the amplitude of the carrier is varied by the amplitude of the modulating waveform. The function generator will accept an external modulating signal or both an external plus internal modulating signals.

The shape, and frequency are set, but not output if the source is EXT.

You cannot use the noise function or dc volts as the carrier waveform.

For the external modulating source, the modulation depth is controlled by signal level present on the AM Modulation terminal.

Only one modulation mode can be enabled at a time. Attempting to enable AM when another modulation is active will result in a settings conflict error.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument         Selects the source of the modulating signal, as follows. 

 Macro Name                     Value  Description
-----------------------------------------------------------
 hpe1441_AMP_MOD_SOUR_BOTH          0  Both
 hpe1441_AMP_MOD_SOUR_EXT           1  External
     o    Sets the AM modulation depth in percent. 

MAX = hpe1441_AMP_MOD_MAX   120.0
MIN = hpe1441_AMP_MOD_MIN   0.0
    e    Selects the shape of the modulating waveform, as follows. 

 Macro Name        Value  Description
-----------------------------------------------------------
 hpe1441_SIN           0  Sinusoid
 hpe1441_SQU           1  Square
 hpe1441_TRI           2  Triangle
 hpe1441_RAMP          3  Ramp
 hpe1441_NOIS          4  Noise
 hpe1441_USER          5  User
         Sets the frequency of the modulating waveform. 

MAX = hpe1441_AMP_MOD_FREQ_MAX   20.0e3
MIN = hpe1441_AMP_MOD_FREQ_MIN   10.0e-3
         Disable or enable AM. 

 Macro Name       Value  Description
-----------------------------------------------------------
 hpe1441_OFF          0  Off
 hpe1441_ON           1  On
    &       Status                            'S #         Instrument Handle                 'z / g        Sour                              ( /        Dept                              ) /        Func                              *n         Freq                              * ^        Stat                               	           0  A Both hpe1441_AMP_MOD_SOUR_BOTH External hpe1441_AMP_MOD_SOUR_EXT ?tj~@^              @Y                               tSinusoid hpe1441_SIN Square hpe1441_SQU Triangle hpe1441_TRI Ramp hpe1441_RAMP Noise hpe1441_NOIS User hpe1441_USER ?@ӈ     ?zG{@Y                   Off hpe1441_OFF On hpe1441_ON    4    This queries the Amplitude Modulation parameters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument          The AM Source is returned in this parameter. 

 Macro Name                     Value  Description
-----------------------------------------------------------
 hpe1441_AMP_MOD_SOUR_BOTH          0  Both
 hpe1441_AMP_MOD_SOUR_EXT           1  External
     .    The AM Depth is returned in this parameter.     b    Returns the shape of the internal modulating waveform. 

 Macro Name        Value  Description
-----------------------------------------------------------
 hpe1441_SIN           0  Sinusoid
 hpe1441_SQU           1  Square
 hpe1441_TRI           2  Triangle
 hpe1441_RAMP          3  Ramp
 hpe1441_NOIS          4  Noise
 hpe1441_USER          5  User
     M    The Internal Amplitude Modulation Frequency is returned in this parameter.      .    The AM State is returned in this parameter.     .       Status                            /T #         Instrument Handle                 /{ / Y        pSour                             0 /         pDept                             0 /o        pFunc                             2          pFreq                             2t A        pStat                              	           0    	            	           	            	           	               This selects the Frequency Modulation parameters and shape and frequency of the Internal Frequency Modulating waveform.

In FM, the frequency of the carrier is varied by the amplitude of the modulating waveform. The function generator will accept only an internal FM modulating signal--no external source is available.

You cannot use the noise function or dc volts as the carrier waveform.

The carrier frequency must always be greater than or equal to the peak frequency deviation.

The sum of the carrier frequency and peak frequency deviation must be less than or equal to the maximum frequency for the selected function plus 100 kHz.

Only one modulation mode can be enabled at a time. Attempting to enable FM when another modulation is active will result in a settings conflict error.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument          Sets the peak frequency deviation in hertz.  This value represents the variation in frequency of the modulating waveform from the carrier frequency. 

MAX = hpe1441_FREQ_MOD_DEV_MAX   7.5e+6
MIN = hpe1441_FREQ_MOD_DEV_MIN   10.0e-3
    e    Selects the shape of the modulating waveform, as follows. 

 Macro Name        Value  Description
-----------------------------------------------------------
 hpe1441_SIN           0  Sinusoid
 hpe1441_SQU           1  Square
 hpe1441_TRI           2  Triangle
 hpe1441_RAMP          3  Ramp
 hpe1441_NOIS          4  Noise
 hpe1441_USER          5  User
         Sets the frequency of the frequency modulation waveform. 

MAX = hpe1441_FREQ_MOD_FREQ_MAX   10.0e3
MIN = hpe1441_FREQ_MOD_FREQ_MIN   10.0e-3
         Disable or enable FM. 

 Macro Name       Value  Description
-----------------------------------------------------------
 hpe1441_OFF          0  Off
 hpe1441_ON           1  On
    7       Status                            8+ #         Instrument Handle                 8R / G       Dev                               9D /         Func                              : /&       Freq                              ;I /        Stat                               	           0 @oyCA\8    ?zG{@Y                               tSinusoid hpe1441_SIN Square hpe1441_SQU Triangle hpe1441_TRI Ramp hpe1441_RAMP Noise hpe1441_NOIS User hpe1441_USER ?!@È     ?zG{@Y                   Off hpe1441_OFF On hpe1441_ON    6    Queries of the Frequency Modulation the parameters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument      2    The FM Deviation is returned in this parameter.     `    Returns the frequency modulation source, as follows. 

 Macro Name        Value  Description
-----------------------------------------------------------
 hpe1441_SIN           0  Sinusoid
 hpe1441_SQU           1  Square
 hpe1441_TRI           2  Triangle
 hpe1441_RAMP          3  Ramp
 hpe1441_NOIS          4  Noise
 hpe1441_USER          5  User
     R    The frequency of the frequency modulation source is returned in this parameter.      .    The FM State is returned in this parameter.     >       Status                            ?, #         Instrument Handle                 ?S / =        pDev                              ? /         pFunc                             @ /        pFreq                             AO /        pStat                              	           0    	           	            	           	               This selects the burst modulation configuration parameters.

You can configure the function generator to output a waveform with a specified number of cycles, called burst. You can output the burst at a rate determined by the internal rate generator or an external signal. The function generator can produce a burst using sine, square, triangle, ramp, and arbitrary waveforms.

In the external (gated burst) mode, the output waveform is either "on" or "off" based on the level of the trigger selected by the trigSour parameter.  (Immediate and BUS trigger sources will produce the same result as if External had been selected.) When the external gate source is selected, the burst count, burst rate, burst phase, and burst trigger source are not used to generate the output signal (but they are set by the instrument).

The burst count indicates how many cycles will be output with each trigger. The trigger source is selected by the trigSour parameter. The burst count ranges from 1 to 50000 cycles.  However more than 1 cycle may be required at higher frequencies.  An infinite burst count can be used if the phase lock option is installed.  Setting the burst count parameter to 0 will send "INF" to the instrument.

The burst rate defines the interval between bursts when the internal trigger source has been selected.

It is possible to specify a burst rate which is too fast for the function generator to output with the specified carrier frequency and burst count. If the burst rate is too high, the function generator will internally adjust it as needed to continuously re-trigger the burst. The adjustment is handled internally by the function generator.

Only one modulation mode can be enabled at a time. Attempting to enable BM when another modulation is active will result in a settings conflict error.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument          Selects the burst modulation source, as follows. 

 Macro Name                   Value  Description
-----------------------------------------------------------
 hpe1441_BM_MOD_SOUR_INT          0  Internal
 hpe1441_BM_MOD_SOUR_EXT          1  External
         Sets the number of cycles to be output per burst.  Numbers from 1 to 50000 are valid.  0 is also valid, and will set "INF" if the phase lock option is installed. 

MAX = hpe1441_BM_MOD_NCYC_MAX   50000
MIN = hpe1441_BM_MOD_NCYC_MIN   0
         Sets the starting phase in degrees for the bursts. 

MAX = hpe1441_BM_MOD_PHAS_MAX   360
MIN = hpe1441_BM_MOD_PHAS_MIN   -360
         Sets the burst rate in Hz for internally triggered  bursts. 

MAX = hpe1441_BM_MOD_RATE_MAX   50.0e3
MIN = hpe1441_BM_MOD_RATE_MIN   10.0e-3
         Disable or enable burst modulation. 

 Macro Name       Value  Description
-----------------------------------------------------------
 hpe1441_OFF          0  Off
 hpe1441_ON           1  On
        Selects the trigger source, as follows. 

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1441_TRIGGER_SOUR_IMM            0  Immediate
 hpe1441_TRIGGER_SOUR_EXT            1  External
 hpe1441_TRIGGER_SOUR_BUS            2  Bus
 hpe1441_TRIGGER_SOUR_TTLT0          3  TTLT0
 hpe1441_TRIGGER_SOUR_TTLT1          4  TTLT1
 hpe1441_TRIGGER_SOUR_TTLT2          5  TTLT2
 hpe1441_TRIGGER_SOUR_TTLT3          6  TTLT3
 hpe1441_TRIGGER_SOUR_TTLT4          7  TTLT4
 hpe1441_TRIGGER_SOUR_TTLT5          8  TTLT5
 hpe1441_TRIGGER_SOUR_TTLT6          9  TTLT6
 hpe1441_TRIGGER_SOUR_TTLT7         10  TTLT7
    J$       Status                            J #         Instrument Handle                 J / K        Source                            K /        Ncycle                            L /&       Phase                             Mo /       Rate                              N  Z        State                             N         trigSour                           	           0  B Internal hpe1441_BM_MOD_SOUR_INT External hpe1441_BM_MOD_SOUR_EXT      P               ?nO;@v     v                        @!}@j     ?zG{@Y                   Off hpe1441_OFF On hpe1441_ON              jImmediate hpe1441_TRIGGER_SOUR_IMM External hpe1441_TRIGGER_SOUR_EXT Bus hpe1441_TRIGGER_SOUR_BUS TTLT0 hpe1441_TRIGGER_SOUR_TTLT0 TTLT1 hpe1441_TRIGGER_SOUR_TTLT1 TTLT2 hpe1441_TRIGGER_SOUR_TTLT2 TTLT3 hpe1441_TRIGGER_SOUR_TTLT3 TTLT4 hpe1441_TRIGGER_SOUR_TTLT4 TTLT5 hpe1441_TRIGGER_SOUR_TTLT5 TTLT6 hpe1441_TRIGGER_SOUR_TTLT6 TTLT7 hpe1441_TRIGGER_SOUR_TTLT7    F    This queries the present burst modulation configuration parameters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument         The burst modulation source is returned in this parameter. 

 Macro Name                   Value  Description
-----------------------------------------------------------
 hpe1441_BM_MOD_SOUR_INT          0  Internal
 hpe1441_BM_MOD_SOUR_EXT          1  External
         The number of cycles output per trigger is returned in this parameter. A "0" will be returned to indicate an Infinite count.      I    The Burst Modulation Phase (in degrees) is returned in this parameter.      \    The internal  burst modulation rate is returned in this parameter. The value is in Hertz.      <    The Burst Modulation State is returned in this parameter.         Returns the trigger source, as follows. 

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1441_TRIGGER_SOUR_IMM            0  Immediate
 hpe1441_TRIGGER_SOUR_EXT            1  External
 hpe1441_TRIGGER_SOUR_BUS            2  Bus
 hpe1441_TRIGGER_SOUR_TTLT0          3  TTLT0
 hpe1441_TRIGGER_SOUR_TTLT1          4  TTLT1
 hpe1441_TRIGGER_SOUR_TTLT2          5  TTLT2
 hpe1441_TRIGGER_SOUR_TTLT3          6  TTLT3
 hpe1441_TRIGGER_SOUR_TTLT4          7  TTLT4
 hpe1441_TRIGGER_SOUR_TTLT5          8  TTLT5
 hpe1441_TRIGGER_SOUR_TTLT6          9  TTLT6
 hpe1441_TRIGGER_SOUR_TTLT7         10  TTLT7
    U       Status                            Vf #         Instrument Handle                 V / =        pSour                             W /         pNcyc                             X$ /        pPhas                             Xu /        pRate                             X  =        pStat                             Y          pTrigSour                          	           0    	            	            	           	           	            	           o    This selects the FSK parameters.

You can configure the function generator to "shift" its output frequency between two preset values using FSK modulation. The rate at which the output shifts between the two frequencies (called the "carrier frequency" and the "hop frequency") is determined by the internal rate generator or the signal level on the selected trigger source (trigSour parameter).

When the internal FSK source is selected, the rate at which the output frequency "shifts" between the carrier frequency and hop frequency is determined by the FSK rate specified.  The trigger source (trigSour) will be set but ignored by the output.

When the external FSK source is selected, the output frequency is determined by the signal level of the trigger source (trigSour).  When a "low" TTL level is present, the carrier frequency is output. When a "high" TTL level is present, the hop frequency is output.

The hop frequency may be limited by the currently selected waveform.

Only one modulation mode can be enabled at a time. Attempting to enable FSK when another modulation is active will result in a settings conflict error.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument          Selects an internal or external FSK source, as follows. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1441_FSK_SOUR_INT          0  Internal
 hpe1441_FSK_SOUR_EXT          1  External
     k    Sets the FSK "hop" frequency. 

MAX = hpe1441_FSK_FREQ_MAX   15.0e6
MIN = hpe1441_FSK_FREQ_MIN   10.0e-3
         Sets the rate at which the output frequency "shifts" when the FSK source is set to internal. 

MAX = hpe1441_FSK_RATE_MAX   50.0e3
MIN = hpe1441_FSK_RATE_MIN   10.0e-3
         Disable or enable FSK modulation. 

 Macro Name       Value  Description
-----------------------------------------------------------
 hpe1441_OFF          0  Off
 hpe1441_ON           1  On
        Selects the trigger source, as follows. 

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1441_TRIGGER_SOUR_IMM            0  Immediate
 hpe1441_TRIGGER_SOUR_EXT            1  External
 hpe1441_TRIGGER_SOUR_BUS            2  Bus
 hpe1441_TRIGGER_SOUR_TTLT0          3  TTLT0
 hpe1441_TRIGGER_SOUR_TTLT1          4  TTLT1
 hpe1441_TRIGGER_SOUR_TTLT2          5  TTLT2
 hpe1441_TRIGGER_SOUR_TTLT3          6  TTLT3
 hpe1441_TRIGGER_SOUR_TTLT4          7  TTLT4
 hpe1441_TRIGGER_SOUR_TTLT5          8  TTLT5
 hpe1441_TRIGGER_SOUR_TTLT6          9  TTLT6
 hpe1441_TRIGGER_SOUR_TTLT7         10  TTLT7
    b8       Status                            b #         Instrument Handle                 b / g        Source                            d /        hopFreq                           dv /y       Rate                              e(          State                             e 2       trigSour                           	           0  <  Internal hpe1441_FSK_SOUR_INT External hpe1441_FSK_SOUR_EXT @o"Al8    ?zG{@Y                 @!}@j     ?zG{@$                   Off hpe1441_OFF On hpe1441_ON              jImmediate hpe1441_TRIGGER_SOUR_IMM External hpe1441_TRIGGER_SOUR_EXT Bus hpe1441_TRIGGER_SOUR_BUS TTLT0 hpe1441_TRIGGER_SOUR_TTLT0 TTLT1 hpe1441_TRIGGER_SOUR_TTLT1 TTLT2 hpe1441_TRIGGER_SOUR_TTLT2 TTLT3 hpe1441_TRIGGER_SOUR_TTLT3 TTLT4 hpe1441_TRIGGER_SOUR_TTLT4 TTLT5 hpe1441_TRIGGER_SOUR_TTLT5 TTLT6 hpe1441_TRIGGER_SOUR_TTLT6 TTLT7 hpe1441_TRIGGER_SOUR_TTLT7    #    This queries the FSK parameters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument          The FSK Source is returned in this parameter. 

 Macro Name                Value  Description
-----------------------------------------------------------
 hpe1441_FSK_SOUR_INT          0  Internal
 hpe1441_FSK_SOUR_EXT          1  External
     ?    The FSK Hop Frequency (in Hz) is returned in this parameter.      7    The FSK Internal Rate is returned in this parameter.      /    The FSK State is returned in this parameter.         Returns the trigger source, as follows. 

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1441_TRIGGER_SOUR_IMM            0  Immediate
 hpe1441_TRIGGER_SOUR_EXT            1  External
 hpe1441_TRIGGER_SOUR_BUS            2  Bus
 hpe1441_TRIGGER_SOUR_TTLT0          3  TTLT0
 hpe1441_TRIGGER_SOUR_TTLT1          4  TTLT1
 hpe1441_TRIGGER_SOUR_TTLT2          5  TTLT2
 hpe1441_TRIGGER_SOUR_TTLT3          6  TTLT3
 hpe1441_TRIGGER_SOUR_TTLT4          7  TTLT4
 hpe1441_TRIGGER_SOUR_TTLT5          8  TTLT5
 hpe1441_TRIGGER_SOUR_TTLT6          9  TTLT6
 hpe1441_TRIGGER_SOUR_TTLT7         10  TTLT7
    lq       Status                            m #         Instrument Handle                 m8 / Y        pSour                             n2 /         pHopFreq                          ny /o        pRate                             n          pStat                             n A        pTrigSour                          	           0    	            	           	           	            	               This sets the frequency sweep parameters.

In the frequency sweep mode, the function generator "steps" from the start frequency to the stop frequency at a sweep rate which you specify. You can sweep up or down in frequency, and with either linear or logarithmic spacing.  To sweep down in frequency, simply set the stop frequency lower than the start frequency.  You can configure the function generator to output a single sweep by applying an external or BUS trigger as set by the trigger source (trigSour parameter).

The frequencies may be limited by the currently selected function.

Frequency sweep cannot be used if another modulation mode is active. Attempting to do so will result in a settings conflict error.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument      s    Sets the sweep start frequency. 

MAX = hpe1441_SWEEP_FREQ__MAX   15.0e6
MIN = hpe1441_SWEEP_FREQ__MIN   10.0e-3
     p    Sets the sweep stop frequency. 

MAX = hpe1441_SWEEP_FREQ_MAX   15.0e6
MIN = hpe1441_SWEEP_FREQ_MIN   10.0e-3
         Sets the number of seconds for a complete frequency sweep. 

MAX = hpe1441_SWEEP_TIME_MAX   500
MIN = hpe1441_SWEEP_TIME_MIN   1.0e-3
        Selects the linear or logarithmic spacing for the sweep, as follows. 

 Macro Name                  Value  Description
-----------------------------------------------------------
 hpe1441_SWEEP_SPAC_LIN          0  Linear
 hpe1441_SWEEP_SPAC_LOG          1  Logarithmic
         Disable or enable the sweep mode. 

 Macro Name       Value  Description
-----------------------------------------------------------
 hpe1441_OFF          0  Off
 hpe1441_ON           1  On
        Selects the trigger source, as follows. 

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1441_TRIGGER_SOUR_IMM            0  Immediate
 hpe1441_TRIGGER_SOUR_EXT            1  External
 hpe1441_TRIGGER_SOUR_BUS            2  Bus
 hpe1441_TRIGGER_SOUR_TTLT0          3  TTLT0
 hpe1441_TRIGGER_SOUR_TTLT1          4  TTLT1
 hpe1441_TRIGGER_SOUR_TTLT2          5  TTLT2
 hpe1441_TRIGGER_SOUR_TTLT3          6  TTLT3
 hpe1441_TRIGGER_SOUR_TTLT4          7  TTLT4
 hpe1441_TRIGGER_SOUR_TTLT5          8  TTLT5
 hpe1441_TRIGGER_SOUR_TTLT6          9  TTLT6
 hpe1441_TRIGGER_SOUR_TTLT7         10  TTLT7
    v+       Status                            v #         Instrument Handle                 v / G       swStart                           wm /        swStop                            w /&       Time                              xu /        Space                             y  Z        State                             zU         trigSour                           	           0 @o"Al8    ?zG{@Y                 @o"Al8    ?zG{@@                ?>FB@@     ?PbM?                  A Linear hpe1441_SWEEP_SPAC_LIN Logarithmic hpe1441_SWEEP_SPAC_LOG   Off hpe1441_OFF On hpe1441_ON              jImmediate hpe1441_TRIGGER_SOUR_IMM External hpe1441_TRIGGER_SOUR_EXT Bus hpe1441_TRIGGER_SOUR_BUS TTLT0 hpe1441_TRIGGER_SOUR_TTLT0 TTLT1 hpe1441_TRIGGER_SOUR_TTLT1 TTLT2 hpe1441_TRIGGER_SOUR_TTLT2 TTLT3 hpe1441_TRIGGER_SOUR_TTLT3 TTLT4 hpe1441_TRIGGER_SOUR_TTLT4 TTLT5 hpe1441_TRIGGER_SOUR_TTLT5 TTLT6 hpe1441_TRIGGER_SOUR_TTLT6 TTLT7 hpe1441_TRIGGER_SOUR_TTLT7    /    This queries the frequency sweep parameters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument      ;    The sweep start frequency is returned in this parameter.      :    The sweep stop frequency is returned in this parameter.      :    The frequency sweep time is returned in this parameter.         The frequency sweep spacing is returned in this parameter. 

 Macro Name                  Value  Description
-----------------------------------------------------------
 hpe1441_SWEEP_SPAC_LIN          0  Linear
 hpe1441_SWEEP_SPAC_LOG          1  Logarithmic
     1    The sweep state is returned in this parameter.         Returns the trigger source, as follows. 

 Macro Name                      Value  Description
-----------------------------------------------------------
 hpe1441_TRIGGER_SOUR_IMM            0  Immediate
 hpe1441_TRIGGER_SOUR_EXT            1  External
 hpe1441_TRIGGER_SOUR_BUS            2  Bus
 hpe1441_TRIGGER_SOUR_TTLT0          3  TTLT0
 hpe1441_TRIGGER_SOUR_TTLT1          4  TTLT1
 hpe1441_TRIGGER_SOUR_TTLT2          5  TTLT2
 hpe1441_TRIGGER_SOUR_TTLT3          6  TTLT3
 hpe1441_TRIGGER_SOUR_TTLT4          7  TTLT4
 hpe1441_TRIGGER_SOUR_TTLT5          8  TTLT5
 hpe1441_TRIGGER_SOUR_TTLT6          9  TTLT6
 hpe1441_TRIGGER_SOUR_TTLT7         10  TTLT7
    G       Status                             #         Instrument Handle                  / =        pStart                            Q /         pStop                              /        pTime                              /        pSpace                              =        pState                                      pTrigSour                          	           0    	           	           	           	            	            	           m    Download floating-point values between -1 and +1 into volatile memory You can download between 8 and 16,000 points per waveform

The values -1 and +1 correspond to the peak values of the waveform.

Downloading the floating-point values is slower than downloading binary values but is more convenient when using the trignometric functions which returns values between -1 and +1.

The DATA VOLATILE command overwrites the previous waveform in VOLATILE memory.

The following statement shows how to use the DATA VOLATILE command to download nine points to volatile memory:

"DATA VOLATILE, 1,.75,.5,.25,0,.25,-.5,-.75,-1"          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument      |    Number of floating-point values to download from array[]. 

MAX = hpe1441_POINTS_MAX   16000
MIN = hpe1441_POINTS_MIN   8
     K    Floating-point values between -1 or +1 to download into volatile memory.     5       Status                             #         Instrument Handle                  /        NoOfPoints                         /A        array                              	           0      >                    O    Download binary integer values between -2047 and +2047 into volatile memory You can download between 8 and 16,000 points per waveform as a list of values. The binary range of values corresponds to the values available using internal 12-bit DAC codes.

The values -2047 and +2047 correspond to the peak values of the waveform.

The DATA:DAC VOLATILE command overwrites the previous waveform in VOLATILE memory.

There is a known defect in an old version of VISA which will generate a Format Error on this command.  Upgrading to the latest version of Agilent VISA should solve that problem.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"          The handle to the instrument      |    Number of floating-point values to download from array[]. 

MAX = hpe1441_POINTS_MAX   16000
MIN = hpe1441_POINTS_MIN   8
     K    Integer values between -2047 and +2047 to download into volatile memory.     *       Status                             #         Instrument Handle                  /        NoOfPoints                        u /A        array                              	           0      >                 0        Passes the cmd_str string to the instrument. Must be a NULL terminated C string.  Note that cmd_str cannot exceed 256 bytes in length.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().      4    SCPI command. (cannot exceed 256 bytes in length)     Z       Status                             #         Instrument Handle                 5 /         cmd_str                            	           0    ""       Passes the cmd_str string to the instrument.  This entry point WILL wait for a response which must be a string (character data).

A max of size-1 bytes will be read from the instrument and the string will be NULL terminated (so its length can be found with strlen).

If more than size-1 bytes are generated by the instrument then the instrument's output buffer will be cleared.

Note that the command string cannot exceed 256 bytes in length.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().      5    SCPI command. (cannot exceed 256 bytes in length).          length of param 4 (result) in bytes -- 32767 max. 

MAX = hpe1413_CMDSTRING_Q_MAX   32767L
MIN = hpe1413_CMDSTRING_Q_MIN   2
         Response from instrument            Status                             #         Instrument Handle                  / Y        cmd_str                            /        size                               /o        result                             	           0    ""                        	               Passes the cmd_str string to the instrument. This entry point passes the string in cmd_str followed by a space and then the integer in val. Note that either an int16 or 32 can be passed as the int16 will be promoted.  Also note that the cmd_str string cannot exceed 256 characters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().      5    SCPI command.  (cannot exceed 256 bytes in length)      i    Parameter for command 

MAX = hpe1441_CMDINT_MAX   2147483647L
MIN = hpe1441_CMDINT_MIN   -2147483647L
           Status                             #         Instrument Handle                  /         cmd_str                           - /K       val                                	           0    ""                         Passes the cmd_str string to the instrument. This command expects a response that can be returned as a 16 bit integer. Note that cmd_str cannot exceed 256 bytes in length.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().      4    SCPI command. (cannot exceed 256 bytes in length)          Result of command.     V       Status                             #         Instrument Handle                 1 /         cmd_str                           m /A        result                             	           0    ""    	               Passes the cmd_str string to the instrument. This entry point passes the string in cmd_str followed by a space and then the Real in val. Note that either an Real32 or 64 can be passed as the Real32 will be promoted.  Also note that the cmd_str string cannot exceed 256 characters.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().      0    Command.  (cannot exceed 256 bytes in length)      a    Parameter for command 

MAX = hpe1441_SCPIREAL_MAX   1e+40
MIN = hpe1441_SCPIREAL_MIN   -1e+40
           Status                            E #         Instrument Handle                  /         cmd_str                            /K       val                                	           0    "" Gxy H=c)\=c)\                          Passes the  cmd_str string to the instrument. This command expects a response that can be returned as a 64 bit real. Note that cmd_str cannot exceed 256 bytes in length.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().      5    SCPI command.  (cannot exceed 256 bytes in length)          Result of command.            Status                             #         Instrument Handle                  /         cmd_str                            /A        result                             	           0    ""    	               Reads the Status Byte          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()      +    Returns the contents of the status byte

    6       Status                             #         Instrument Handle                  /         statusByte                         	           0    	               This function indicates if an event has occurred since the last time the event was queried.  This function can be used as a history mechanism to record when an event occurred.  By repeated polling, a program can determine if or when an event occurs.

The happening input parameter corresponds to a valid happening value. (see happening section for more information).

The pEvent output parameter indicates if an event has occurred since the last time this routine was called. The output values are either VI_TRUE (event occurred since last query) or VI_FALSE (event did not occur since last query).

The event happening is automatically cleared each time the hpe1441_statEvent_Q() function is invoked.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().     >    Happenings refer to something that happens. These can refer to conditions or events. All of the conditions listed in the hpe1441_statCond_Q() function will be detected as events as well.   An event may be registered when a condition changes state from  VI_FALSE to VI_TRUE.

The following events are detected by this instrument 

 Macro Name                              Value  Description
-----------------------------------------------------------
 hpe1441_QUES_UNLOCKED                     406  Phase Unlocked
 hpe1441_ESR_OPC                           601  Operation Comp.
 hpe1441_ESR_QUERY_ERROR                   603  Query Error
 hpe1441_ESR_DEVICE_DEPENDENT_ERROR        604  Dev. Depend. Err
 hpe1441_ESR_EXECUTION_ERROR               605  Execution Error
 hpe1441_ESR_COMMAND_ERROR                 606  Command Error
     x    VI_TRUE  = event occurred sometime between event readings.
VI_FALSE = the event did not occur between event readings.
           Status                            g #         Instrument Handle                  /         happening                          /A        pEvent                             	           0              Phase Unlocked hpe1441_QUES_UNLOCKED Operation Comp. hpe1441_ESR_OPC Query Error hpe1441_ESR_QUERY_ERROR Dev. Depend. Err hpe1441_ESR_DEVICE_DEPENDENT_ERROR Execution Error hpe1441_ESR_EXECUTION_ERROR Command Error hpe1441_ESR_COMMAND_ERROR    	            k    This function will clear the status system of all events.

This will not affect conditions or callbacks.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message".      2    Instrument Handle returned from hpe1441_init().            Status                            l #         Instrument Handle                  	           0       This function is used to determine the current state (VI_TRUE or VI_FALSE) of a specified condition.

The condition input parameter corresponds to a valid condition value. (see the happening parameter description above for more information).

The pState output parameter represents the current state of a condition. It is either VI_TRUE (condition is true) or VI_FALSE (condition is not true).

Many conditions may be latched into event registers so that the setting in a event register represents the occurrance of a condition since the last query of the event register. Use the hpe1441_statEven_Q() function to detect conditions that come and go during the course of instrument operation.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()         The following conditions can occur on the function generator. Conditions are transient in nature, and this function reports the current setting of the condition. A 1 is returned if the condition is currently true, and 0 is returned if the condition is currently false.


 Macro Name                 Value  Description
-----------------------------------------------------------
 hpe1441_QUES_UNLOCKED        406  Phase Unlocked
     S    VI_TRUE  = condition is currently set VI_FALSE = condition is currently not set

           Status                            ~ #         Instrument Handle                  / x       condition                         m /A        pState                             	           0               %Phase Unlocked hpe1441_QUES_UNLOCKED    	                This function sends an IEEE Operation Complete (*OPC) command to the instrument to aid in synchronization with other instruments or processes. When the pending operation completes, the OPC bit in the Status Byte is set.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()            Status                            s #         Instrument Handle                  	           0        This function sends an IEEE Operation Complete Query (*OPC?)to the instrument to aid in synchronization with other instruments or processes. When the operation completes, this function returns 1.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()          *OPC? response, always 1.            Status                             #         Instrument Handle                  /         opc                                	           0    	                This function sends an IEEE Wait To Continue (*WAI) command to the instrument to aid in synchronization with other instruments or processes.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()     E       Status                             #         Instrument Handle                  	           0   k    The reset function places the instrument in a default state. Before issuing this function, it may be necessary to send a device clear to ensure that the instrument can execute a reset.  A device clear can be issued by invoking hpe1441_dcl().

Reset will affect the following state:

PUT STATES HERE

Reset does not affect the status system or clear any errors.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()            Status                            ì #         Instrument Handle                  	           0   H    The self-test function causes the instrument to perform a self-test and returns the result of that self-test.  This is used to verify that an instrument is operating properly.  A failure may indicate a potential hardware problem.

Sending a Device Clear to the instrument before the Self Test is complete may generate errors.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()          This function performs a complete self test of the function generator.  Returns 0 if the self test passes or 1 if it fails. If the self test fails an error message is also generated with additional information on why the test failed.

     A    Self-test status message.  This is limited to 256 characters.

    Ű       Status                            P #         Instrument Handle                 Ɖ F -        Self Test Result                  ~ F       Self-Test Message                  	           0    	            	               The error query function queries the instrument and returns the instrument specific error information. Instrument errors may occur when a user places the instrument in a bad state such as sending an invalid sequence of coupled commands.

Instrument errors can be detected either by polling or by callbacks.  Automatic polling can be accomplished by using the hpe1441_errorQueryDetect() function.  A callback can be set up for any instrument errors that are detected by the status system.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()          Instruments error code      B    Instrument's error message.  This is limited to 256 characters.     ʶ       Status                            V #         Instrument Handle                 ˏ F -        Error Code                        ˰ F       Error Message                      	           0    	            	            }    The error message function translates the error return value from an instrument driver function to a user-readable string.      W    VI_SUCCESS           : No error VI_ERROR_PARAMETER2  : The ViStatus error is invalid      G    Instrument Handle returned from hpe1441_init(). This may be VI_NULL.      <    The error return value from an instrument driver function      <    Error message string.  This is limited to 256 characters.     |       Status                             #         Instrument Handle                 * F -        Status Code                       n F       Message                            	           0    0    	                The revision function returns the revision of the instrument driver and the firmware of the instrument being used.  The instrument firmware revision for the E1441 has two parts--giving the revision of the inguard and outguard processor code.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()      C    Instrument driver revision.  This is limited to 256 characters.

     D    Instrument firmware revision.  This is limited to 256 characters.     Ф       Status                            D #         Instrument Handle                 } F 2       Instrument Driver Revision         F1       Firmware Revision                  	           0    	            	           R    This function sends a device clear (DCL) to the instrument.

A device clear will abort the current operation and enable the instrument to accept a new command or query.

This is particularly useful in situations where it is not possible to determine the instrument state.  This situation may occur in an error handler.  In this case, it is customary to send a device clear before issuing a new instrument driver function.  The device clear ensures that the instrument will be able to begin processing the new commands.

Error handlers can be set up using the hpe1441_statEvenHdlr() function.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()     k       Status                             #         Instrument Handle                  	           0       This function enables (VI_TRUE) or disables (VI_FALSE) automatic instrument error checking.

If automatic error checking is enabled then the driver will query the instrument for an error at the end of each function call.

Automatic error checking should only be used in a polling environment.  Automatic error checking should be disabled (VI_FALSE) when instrument error callbacks are utilized.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()     *    Boolean which enables (VI_TRUE) or disables (VI_FALSE) automatic instrument error querying. if VI_TRUE this will query the instrument for an error before returning from all driver functions.

if VI_FALSE this will not query the instrument for an error before returning from all driver functions.     T       Status                             #         Instrument Handle                 - /         errorQueryDetect                   	           0    On VI_TRUE Off VI_FALSE    o    This function indicates if automatic instrument error detection is enabled (VI_TRUE) or disabled (VI_FALSE).          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()      K    Boolean indicating if automatic instrument error querying is performed.

    ۡ       Status                            A #         Instrument Handle                 z /         pErrDetect                         	           0    	                The timeout function sets a minimum timeout value for driver I/O transactions in milliseconds. The timeout period may vary on computer platforms.

The default timeout period is 2 seconds.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()          This value sets the I/O timeout for all functions in the driver. It is specified in milliseconds. 

MAX = hpe1441_TIMEOUT_MAX   2147483647
MIN = hpe1441_TIMEOUT_MIN   1
    O       Status                             #         Instrument Handle                 ( /        timeOut                            	           0                          The timeout query function returns the timeout value for driver I/O transactions in milliseconds.

The timeout period may vary on computer platforms.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()      f    This is the minimum timeout period that the driver can be set to. It is specified in milliseconds.

    B       Status                             #         Instrument Handle                  /         pTimeOut                           	           0    	            U    This function sends an IEEE Group Execute Trigger (GET or *TRG) to the instrument.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()            Status                            B #         Instrument Handle                  	           0        The close function terminates the software connection to the instrument and deallocates system resources.  It is generally a good programming habit to close the instrument handle when the program is done using the instrument.          VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error condition. To determine error message, pass the return value to routine "hpe1441_error_message"      1    Instrument Handle returned from hpe1441_init()            Status                             #         Instrument Handle                  	           0          	  7     K-    init                                            K-    conf                                     A  "     K-    conf_Q                                   #  +     K-    amConf                                   .x  2     K-    amConf_Q                                 4j  <     K-    fmConf                                   >N  A     K-    fmConf_Q                                 C  Qs     K-    bmConf                                   Ux  [     K-    bmConf_Q                                 ]  h     K-    fskConf                                  lF  q     K-    fskConf_Q                                sR  |     K-    freqSweep                                       K-    freqSweep_Q                                     K-    dataVolatile                                    K-    dataDacVolatile                            q     K-    cmd                                      '       K-    cmdString_Q                                     K-    cmdInt                                          K-    cmdInt16_Q                                       K-    cmdReal                                  6       K-    cmdReal64_Q                                B     K-    readStatusByte_Q                           g     K-    statEven_Q                               X       K-    statEvenClr                              !       K-    statCond_Q                                      K-    opc                                      '       K-    opc_Q                                           K-    wai                                             K-    reset                                    `       K-    self_test                                       K-    error_query                                β     K-    error_message                            Ϩ       K-    revision_query                             D     K-    dcl                                      ֿ  _     K-    errorQueryDetect                         *       K-    errorQueryDetect_Q                       ݉       K-    timeOut                                         K-    timeOut_Q                                E  {     K-    trg                                             K-    close                                                                      DInitialize                          Application Functions                DConfigure Setup                      DConfigure Query                      DAmplitude Modulation Setup           DAmplitude Modulation Query           DFrequency Modulation Setup           DFrequency Modulation Query           DBurst Modulation Setup               DBurst Modulation Query               DFSK Setup                            DFSK Query                            DFrequency Sweep Setup                DFrequency Sweep Query               0Low Level Control                    DData Volatile Setup                  DData Dac Volatile Setup             Passthrough Functions                DSend String                          DQuery String                         DSend Integer                         DQuery Int16                          DSend Real                            DQuery Real64                        Status                               DRead Status Byte                    QEvent                                DEvent Query                          DClear All Events                     DCondition Query                     Synchronization                      DOperation Complete                   DOperation Complete Query             DWait To Continue                    Utility                              DReset                                DSelf Test                            DError Query                          DError Message                        DRevision Query                       DDevice Clear                        Error Handling                      2Auto Instrument Error Detection      DAuto Error Detection Setup           DAuto Error Detection Query          	)Time Out                             DTime Out Setup                       DTime Out Query                       DGroup Execute Trigger                DClose                           