/* Copyright (C) 1995-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1441 */

#ifndef hpe1441_INCLUDE 
#define hpe1441_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif
/*================================*/
/*           HPE1441              */
/*================================*/
/* Framework Revision: WIN95 4.0  */
/*                     WINNT 4.0  */
/* Driver Revision:    A.01.02    */
/* Firmware Revision:  A.01.00    */
/*================================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   hpe1441.c                 */
/*   hpe1441.h                 */
/*=============================*/

/*=============================*/
/* WIN95/WINNT Framework Files */
/*=============================*/
/*   hpe1441.def               */
/*   hpe1441.rc                */
/*   hpe1441.bas               */
/*=============================*/


/******  Returned error status values *****/
/* Common Error numbers start at BFFC0D00 */
#define hpe1441_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1441_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1441_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1441_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1441_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1441_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1441_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */

/* Parameter errors not in VPP 3.4 */
#define hpe1441_INSTR_ERROR_PARAMETER9	(_VI_ERROR+0x3FFC0D20L)/* 0xBFFC0D20 */
#define hpe1441_INSTR_ERROR_PARAMETER10	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D21 */
#define hpe1441_INSTR_ERROR_PARAMETER11	(_VI_ERROR+0x3FFC0D22L)/* 0xBFFC0D22 */
#define hpe1441_INSTR_ERROR_PARAMETER12	(_VI_ERROR+0x3FFC0D23L)/* 0xBFFC0D23 */
#define hpe1441_INSTR_ERROR_PARAMETER13	(_VI_ERROR+0x3FFC0D24L)/* 0xBFFC0D24 */
#define hpe1441_INSTR_ERROR_PARAMETER14	(_VI_ERROR+0x3FFC0D25L)/* 0xBFFC0D25 */
#define hpe1441_INSTR_ERROR_PARAMETER15	(_VI_ERROR+0x3FFC0D26L)/* 0xBFFC0D26 */
#define hpe1441_INSTR_ERROR_PARAMETER16	(_VI_ERROR+0x3FFC0D27L)/* 0xBFFC0D27 */
#define hpe1441_INSTR_ERROR_PARAMETER17	(_VI_ERROR+0x3FFC0D28L)/* 0xBFFC0D28 */
#define hpe1441_INSTR_ERROR_PARAMETER18	(_VI_ERROR+0x3FFC0D29L)/* 0xBFFC0D29 */

/* Error defined in the driver */
#define hpe1441_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define hpe1441_STB_MAV				5 
#define hpe1441_QUES_UNLOCKED			406
#define hpe1441_ESR_OPC				601
#define hpe1441_ESR_QUERY_ERROR			603
#define hpe1441_ESR_DEVICE_DEPENDENT_ERROR		604
#define hpe1441_ESR_EXECUTION_ERROR		605
#define hpe1441_ESR_COMMAND_ERROR			606


/******   Used by Function hpe1441_timeOut   *****/
#define  hpe1441_TIMEOUT_MAX  2147483647
#define  hpe1441_TIMEOUT_MIN  1

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC hpe1441_init (ViRsrc InstrDesc, ViBoolean id_query,
                            ViBoolean do_reset, ViPSession vi );

ViStatus _VI_FUNC hpe1441_close (ViSession vi);

ViStatus _VI_FUNC hpe1441_reset (ViSession vi);

ViStatus _VI_FUNC hpe1441_self_test (ViSession vi, ViPInt16 test_result,
                                 ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC hpe1441_error_query (ViSession vi, ViPInt32 error_number,
                                   ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1441_error_message (ViSession vi, ViStatus error_number,
                                     ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1441_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
                                      ViChar _VI_FAR instr_rev[]);

/* other standard functions */

ViStatus _VI_FUNC hpe1441_dcl(ViSession vi);

ViStatus _VI_FUNC hpe1441_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC hpe1441_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC hpe1441_opc(ViSession vi);

ViStatus _VI_FUNC hpe1441_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC hpe1441_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC hpe1441_statCond_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pCondition);

ViStatus _VI_FUNC hpe1441_statEvenClr(ViSession vi);

ViStatus _VI_FUNC hpe1441_statEven_Q(ViSession vi, ViInt32 happening,
                                 ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  hpe1441_InstrEventHandler)(
              ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC hpe1441_statEvenHdlr(ViSession vi, ViInt32 happening,       
                                   hpe1441_InstrEventHandler eventHandler,
                                   ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR hpe1441_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC hpe1441_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     hpe1441_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC hpe1441_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC hpe1441_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC hpe1441_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC hpe1441_trg(ViSession vi);

ViStatus _VI_FUNC hpe1441_wai(ViSession vi);

/* scpi escape functions */

ViStatus _VI_FUNC hpe1441_cmd( ViSession vi, ViString p1);
ViStatus _VI_FUNC hpe1441_cmdString_Q(ViSession vi, ViString p1, 
	ViInt32 p2,ViChar _VI_FAR p3[]);
ViStatus _VI_FUNC hpe1441_cmdInt16_Q(ViSession vi, ViString p1, ViPInt16 p2);
ViStatus _VI_FUNC hpe1441_cmdReal64_Q(ViSession vi, ViString p1,ViPReal64 p2);
ViStatus _VI_FUNC hpe1441_cmdInt( ViSession vi, ViString p1, ViInt32 p2);
ViStatus _VI_FUNC hpe1441_cmdReal( ViSession vi, ViString p1, ViReal64 p2);

/* Instr Specific Functions follow */



/******   Used by Function hpe1441_amConf   *****/
#define  hpe1441_AMP_MOD_SOUR_BOTH  0
#define  hpe1441_AMP_MOD_SOUR_EXT  1
#define  hpe1441_AMP_MOD_MAX  120.0
#define  hpe1441_AMP_MOD_MIN  0.0
#define  hpe1441_SIN  0
#define  hpe1441_SQU  1
#define  hpe1441_TRI  2
#define  hpe1441_RAMP  3
#define  hpe1441_NOIS  4
#define  hpe1441_USER  5
#define  hpe1441_AMP_MOD_FREQ_MAX  20.0e3
#define  hpe1441_AMP_MOD_FREQ_MIN  10.0e-3
#define  hpe1441_OFF  0
#define  hpe1441_ON  1


/******   Used by Function hpe1441_amConf_Q   *****/
/*  hpe1441_AMP_MOD_SOUR_BOTH  */
/*  hpe1441_AMP_MOD_SOUR_EXT  */
/*  hpe1441_SIN  */
/*  hpe1441_SQU  */
/*  hpe1441_TRI  */
/*  hpe1441_RAMP  */
/*  hpe1441_NOIS  */
/*  hpe1441_USER  */


/******   Used by Function hpe1441_bmConf   *****/
#define  hpe1441_BM_MOD_SOUR_INT  0
#define  hpe1441_BM_MOD_SOUR_EXT  1
#define  hpe1441_BM_MOD_NCYC_MAX  50000
#define  hpe1441_BM_MOD_NCYC_MIN  0
#define  hpe1441_BM_MOD_PHAS_MAX  360
#define  hpe1441_BM_MOD_PHAS_MIN  -360
#define  hpe1441_BM_MOD_RATE_MAX  50.0e3
#define  hpe1441_BM_MOD_RATE_MIN  10.0e-3
/*  hpe1441_OFF  */
/*  hpe1441_ON  */
#define  hpe1441_TRIGGER_SOUR_IMM  0
#define  hpe1441_TRIGGER_SOUR_EXT  1
#define  hpe1441_TRIGGER_SOUR_BUS  2
#define  hpe1441_TRIGGER_SOUR_TTLT0  3
#define  hpe1441_TRIGGER_SOUR_TTLT1  4
#define  hpe1441_TRIGGER_SOUR_TTLT2  5
#define  hpe1441_TRIGGER_SOUR_TTLT3  6
#define  hpe1441_TRIGGER_SOUR_TTLT4  7
#define  hpe1441_TRIGGER_SOUR_TTLT5  8
#define  hpe1441_TRIGGER_SOUR_TTLT6  9
#define  hpe1441_TRIGGER_SOUR_TTLT7  10


/******   Used by Function hpe1441_bmConf_Q   *****/
/*  hpe1441_BM_MOD_SOUR_INT  */
/*  hpe1441_BM_MOD_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_IMM  */
/*  hpe1441_TRIGGER_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_BUS  */
/*  hpe1441_TRIGGER_SOUR_TTLT0  */
/*  hpe1441_TRIGGER_SOUR_TTLT1  */
/*  hpe1441_TRIGGER_SOUR_TTLT2  */
/*  hpe1441_TRIGGER_SOUR_TTLT3  */
/*  hpe1441_TRIGGER_SOUR_TTLT4  */
/*  hpe1441_TRIGGER_SOUR_TTLT5  */
/*  hpe1441_TRIGGER_SOUR_TTLT6  */
/*  hpe1441_TRIGGER_SOUR_TTLT7  */


/******   Used by Function hpe1441_conf   *****/
/*  hpe1441_SIN  */
/*  hpe1441_SQU  */
/*  hpe1441_TRI  */
/*  hpe1441_RAMP  */
/*  hpe1441_NOIS  */
/*  hpe1441_USER  */
#define  hpe1441_DC  6
#define  hpe1441_FREQ_MAX  15.0e6
#define  hpe1441_FREQ_MIN  100.0e-6
#define  hpe1441_AMPL_MAX  22.22
#define  hpe1441_AMPL_MIN  -23.8
#define  hpe1441_OFFS_MAX  10.0
#define  hpe1441_OFFS_MIN  -10.0
#define  hpe1441_OUTPUT_LOAD_INF  9.9E+37
#define  hpe1441_OUTPUT_LOAD_50  50


/******   Used by Function hpe1441_conf_Q   *****/
/*  hpe1441_SIN  */
/*  hpe1441_SQU  */
/*  hpe1441_TRI  */
/*  hpe1441_RAMP  */
/*  hpe1441_NOIS  */
/*  hpe1441_USER  */
/*  hpe1441_DC  */


/******   Used by Function hpe1441_dataDacVolatile   *****/
#define  hpe1441_POINTS_MAX  16000
#define  hpe1441_POINTS_MIN  8


/******   Used by Function hpe1441_dataVolatile   *****/
/*  hpe1441_POINTS_MAX  */
/*  hpe1441_POINTS_MIN  */


/******   Used by Function hpe1441_fmConf   *****/
#define  hpe1441_FREQ_MOD_DEV_MAX  7.5e+6
#define  hpe1441_FREQ_MOD_DEV_MIN  10.0e-3
/*  hpe1441_SIN  */
/*  hpe1441_SQU  */
/*  hpe1441_TRI  */
/*  hpe1441_RAMP  */
/*  hpe1441_NOIS  */
/*  hpe1441_USER  */
#define  hpe1441_FREQ_MOD_FREQ_MAX  10.0e3
#define  hpe1441_FREQ_MOD_FREQ_MIN  10.0e-3
/*  hpe1441_OFF  */
/*  hpe1441_ON  */


/******   Used by Function hpe1441_fmConf_Q   *****/
/*  hpe1441_SIN  */
/*  hpe1441_SQU  */
/*  hpe1441_TRI  */
/*  hpe1441_RAMP  */
/*  hpe1441_NOIS  */
/*  hpe1441_USER  */


/******   Used by Function hpe1441_freqSweep   *****/
#define  hpe1441_SWEEP_FREQ__MAX  15.0e6
#define  hpe1441_SWEEP_FREQ__MIN  10.0e-3
#define  hpe1441_SWEEP_FREQ_MAX  15.0e6
#define  hpe1441_SWEEP_FREQ_MIN  10.0e-3
#define  hpe1441_SWEEP_TIME_MAX  500
#define  hpe1441_SWEEP_TIME_MIN  1.0e-3
#define  hpe1441_SWEEP_SPAC_LIN  0
#define  hpe1441_SWEEP_SPAC_LOG  1
/*  hpe1441_OFF  */
/*  hpe1441_ON  */
/*  hpe1441_TRIGGER_SOUR_IMM  */
/*  hpe1441_TRIGGER_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_BUS  */
/*  hpe1441_TRIGGER_SOUR_TTLT0  */
/*  hpe1441_TRIGGER_SOUR_TTLT1  */
/*  hpe1441_TRIGGER_SOUR_TTLT2  */
/*  hpe1441_TRIGGER_SOUR_TTLT3  */
/*  hpe1441_TRIGGER_SOUR_TTLT4  */
/*  hpe1441_TRIGGER_SOUR_TTLT5  */
/*  hpe1441_TRIGGER_SOUR_TTLT6  */
/*  hpe1441_TRIGGER_SOUR_TTLT7  */


/******   Used by Function hpe1441_freqSweep_Q   *****/
/*  hpe1441_SWEEP_SPAC_LIN  */
/*  hpe1441_SWEEP_SPAC_LOG  */
/*  hpe1441_TRIGGER_SOUR_IMM  */
/*  hpe1441_TRIGGER_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_BUS  */
/*  hpe1441_TRIGGER_SOUR_TTLT0  */
/*  hpe1441_TRIGGER_SOUR_TTLT1  */
/*  hpe1441_TRIGGER_SOUR_TTLT2  */
/*  hpe1441_TRIGGER_SOUR_TTLT3  */
/*  hpe1441_TRIGGER_SOUR_TTLT4  */
/*  hpe1441_TRIGGER_SOUR_TTLT5  */
/*  hpe1441_TRIGGER_SOUR_TTLT6  */
/*  hpe1441_TRIGGER_SOUR_TTLT7  */


/******   Used by Function hpe1441_fskConf   *****/
#define  hpe1441_FSK_SOUR_INT  0
#define  hpe1441_FSK_SOUR_EXT  1
#define  hpe1441_FSK_FREQ_MAX  15.0e6
#define  hpe1441_FSK_FREQ_MIN  10.0e-3
#define  hpe1441_FSK_RATE_MAX  50.0e3
#define  hpe1441_FSK_RATE_MIN  10.0e-3
/*  hpe1441_OFF  */
/*  hpe1441_ON  */
/*  hpe1441_TRIGGER_SOUR_IMM  */
/*  hpe1441_TRIGGER_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_BUS  */
/*  hpe1441_TRIGGER_SOUR_TTLT0  */
/*  hpe1441_TRIGGER_SOUR_TTLT1  */
/*  hpe1441_TRIGGER_SOUR_TTLT2  */
/*  hpe1441_TRIGGER_SOUR_TTLT3  */
/*  hpe1441_TRIGGER_SOUR_TTLT4  */
/*  hpe1441_TRIGGER_SOUR_TTLT5  */
/*  hpe1441_TRIGGER_SOUR_TTLT6  */
/*  hpe1441_TRIGGER_SOUR_TTLT7  */


/******   Used by Function hpe1441_fskConf_Q   *****/
/*  hpe1441_FSK_SOUR_INT  */
/*  hpe1441_FSK_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_IMM  */
/*  hpe1441_TRIGGER_SOUR_EXT  */
/*  hpe1441_TRIGGER_SOUR_BUS  */
/*  hpe1441_TRIGGER_SOUR_TTLT0  */
/*  hpe1441_TRIGGER_SOUR_TTLT1  */
/*  hpe1441_TRIGGER_SOUR_TTLT2  */
/*  hpe1441_TRIGGER_SOUR_TTLT3  */
/*  hpe1441_TRIGGER_SOUR_TTLT4  */
/*  hpe1441_TRIGGER_SOUR_TTLT5  */
/*  hpe1441_TRIGGER_SOUR_TTLT6  */
/*  hpe1441_TRIGGER_SOUR_TTLT7  */

ViStatus _VI_FUNC hpe1441_amConf  (ViSession vi, ViInt16 Sour, ViReal64 Dept, ViInt16 Func, ViReal64 Freq, ViInt16 Stat);

ViStatus _VI_FUNC hpe1441_amConf_Q  (ViSession vi, ViPInt16 pSour, ViPReal64 pDept, ViPInt16 pFunc, ViPReal64 pFreq, ViPInt16 pStat);

ViStatus _VI_FUNC hpe1441_bmConf  (ViSession vi, ViInt16 Source, ViInt32 Ncycle, ViReal64 Phase, ViReal64 Rate, ViInt16 State, ViInt16 trigSour);

ViStatus _VI_FUNC hpe1441_bmConf_Q  (ViSession vi, ViPInt16 pSour, ViPInt32 pNcyc, ViPReal64 pPhas, ViPReal64 pRate, ViPInt16 pStat, ViPInt16 pTrigSour);

ViStatus _VI_FUNC hpe1441_conf  (ViSession vi, ViInt16 func, ViReal64 freq, ViReal64 ampl, ViReal64 offs, ViReal64 outpLoad);

ViStatus _VI_FUNC hpe1441_conf_Q  (ViSession vi, ViPInt16 pShape, ViPReal64 pFreq, ViPReal64 pVolt, ViPReal64 pOffset, ViPReal64 pOutpLoad);

ViStatus _VI_FUNC hpe1441_dataDacVolatile  (ViSession vi, ViInt16 NoOfPoints, ViInt16 _VI_FAR array[]);

ViStatus _VI_FUNC hpe1441_dataVolatile  (ViSession vi, ViInt16 NoOfPoints, ViReal64 _VI_FAR array[]);

ViStatus _VI_FUNC hpe1441_fmConf  (ViSession vi, ViReal64 Dev, ViInt16 Func, ViReal64 Freq, ViInt16 Stat);

ViStatus _VI_FUNC hpe1441_fmConf_Q  (ViSession vi, ViPReal64 pDev, ViPInt16 pFunc, ViPReal64 pFreq, ViPInt16 pStat);

ViStatus _VI_FUNC hpe1441_freqSweep  (ViSession vi, ViReal64 swStart, ViReal64 swStop, ViReal64 Time, ViInt16 Space, ViInt16 State, ViInt16 trigSour);

ViStatus _VI_FUNC hpe1441_freqSweep_Q  (ViSession vi, ViPReal64 pStart, ViPReal64 pStop, ViPReal64 pTime, ViPInt16 pSpace, ViPInt16 pState, ViPInt16 pTrigSour);

ViStatus _VI_FUNC hpe1441_fskConf  (ViSession vi, ViInt16 Source, ViReal64 hopFreq, ViReal64 Rate, ViInt16 State, ViInt16 trigSour);

ViStatus _VI_FUNC hpe1441_fskConf_Q  (ViSession vi, ViPInt16 pSour, ViPReal64 pHopFreq, ViPReal64 pRate, ViPInt16 pStat, ViPInt16 pTrigSour);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1441_INCLUDE */

