' Copyright (C) 1997 Agilent Technologies
' VXIplug&play Instrument Driver for the Agilent E1445

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Common Error numbers start at BFFC0D00

Global Const hpe1445_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1445_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1445_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1445_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1445_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1445_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1445_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Parameter errors not in VPP 3.4
Global Const hpe1445_INSTR_ERROR_PARAMETER9                   = &HBFFC0D20&
Global Const hpe1445_INSTR_ERROR_PARAMETER10                  = &HBFFC0D21&
Global Const hpe1445_INSTR_ERROR_PARAMETER11                  = &HBFFC0D22&
Global Const hpe1445_INSTR_ERROR_PARAMETER12                  = &HBFFC0D23&
Global Const hpe1445_INSTR_ERROR_PARAMETER13                  = &HBFFC0D24&
Global Const hpe1445_INSTR_ERROR_PARAMETER14                  = &HBFFC0D25&
Global Const hpe1445_INSTR_ERROR_PARAMETER15                  = &HBFFC0D26&
Global Const hpe1445_INSTR_ERROR_PARAMETER16                  = &HBFFC0D27&
Global Const hpe1445_INSTR_ERROR_PARAMETER17                  = &HBFFC0D28&
Global Const hpe1445_INSTR_ERROR_PARAMETER18                  = &HBFFC0D29&

Global Const hpe1445_QUES_VOLT                                = 1
Global Const hpe1445_QUES_CURR                                = 2
Global Const hpe1445_QUES_TIME                                = 4
Global Const hpe1445_QUES_POW                                 = 8
Global Const hpe1445_QUES_TEMP                                = 16
Global Const hpe1445_QUES_FREQ                                = 32
Global Const hpe1445_QUES_PHAS                                = 64
Global Const hpe1445_QUES_MOD                                 = 128
Global Const hpe1445_QUES_CAL                                 = 256
Global Const hpe1445_QUES_AVAIL10                             = 512
Global Const hpe1445_QUES_AVAIL11                             = 1024
Global Const hpe1445_QUES_AVAIL12                             = 2048
Global Const hpe1445_QUES_AVAIL13                             = 4096
Global Const hpe1445_QUES_INST                                = 8192
Global Const hpe1445_QUES_CMD_WARN                            = 16384

Global Const hpe1445_OPER_CAL                                 = 1
Global Const hpe1445_OPER_SETT                                = 2
Global Const hpe1445_OPER_RANG                                = 4
Global Const hpe1445_OPER_SWE                                 = 8
Global Const hpe1445_OPER_MEAS                                = 16
Global Const hpe1445_OPER_TRIG                                = 32
Global Const hpe1445_OPER_ARM                                 = 64
Global Const hpe1445_OPER_CORR                                = 128
Global Const hpe1445_OPER_AVAIL9                              = 256
Global Const hpe1445_OPER_AVAIL10                             = 512
Global Const hpe1445_OPER_AVAIL11                             = 1024
Global Const hpe1445_OPER_AVAIL12                             = 2048
Global Const hpe1445_OPER_AVAIL13                             = 4096
Global Const hpe1445_OPER_INST                                = 8192
Global Const hpe1445_OPER_PROG                                = 16384

' Used by Function hpe1445_timeOut
Global Const hpe1445_TIMEOUT_MAX                              = 2147483647&
Global Const hpe1445_TIMEOUT_MIN                              = 0&

Global Const hpe1445_CMDSTRING_Q_MAX                              = 32767&
Global Const hpe1445_CMDSTRING_Q_MIN                              = 2&

Global Const hpe1445_CMDDATA_Q_MAX                              = 32767&
Global Const hpe1445_CMDDATA_Q_MIN                              = 2&


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1445_init Lib "hpe1445.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1445_close Lib "hpe1445.dll" (ByVal vi As Long) As Long

Declare Function hpe1445_reset Lib "hpe1445.dll" (ByVal vi As Long) As Long

Declare Function hpe1445_self_test Lib "hpe1445.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1445_error_query Lib "hpe1445.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1445_error_message Lib "hpe1445.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1445_revision_query Lib "hpe1445.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' other standard functions 

Declare Function hpe1445_dcl Lib "hpe1445.dll" (ByVal vi As Long) As Long

Declare Function hpe1445_errorQueryDetect Lib "hpe1445.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function hpe1445_errorQueryDetect_Q Lib "hpe1445.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function hpe1445_readStatusByte_Q Lib "hpe1445.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function hpe1445_timeOut Lib "hpe1445.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function hpe1445_timeOut_Q Lib "hpe1445.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function hpe1445_cmdInt Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal cval as Long) As Long

Declare Function hpe1445_cmdReal Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal cval as Double) As Long

Declare Function hpe1445_cmd Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal cval as Long) As Long

Declare Function hpe1445_cmdData_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal Count As Long,ByVal pResult As String) As Long

Declare Function hpe1445_cmdString_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal Count As Long,ByVal pResult As String) As Long

Declare Function hpe1445_cmdData_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String,ByVal Count As Long,ByVal pResult As String) As Long

Declare Function hpe1445_cmdInt32_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, pResult As Long) As Long

Declare Function hpe1445_cmdReal32_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, pResult As Single) As Long

Declare Function hpe1445_cmdReal64_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, pResult As Double) As Long

Declare Function hpe1445_cmdInt16_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, pResult As Integer) As Long

Declare Function hpe1445_cmdReal32Arr_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, Count As Long, pResult As Any) As Long

Declare Function hpe1445_cmdReal64Arr_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, Count As Long, pResult As Any) As Long

Declare Function hpe1445_cmdInt16Arr_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, Count As Long, pResult As Any) As Long

Declare Function hpe1445_cmdInt32Arr_Q Lib "hpe1445.dll" (ByVal vi As Long, ByVal pCmd As String, Count As Long, pResult As Any) As Long

Declare Function hpe1445_operEvent_Q Lib "hpe1445.dll" (ByVal vi As Long,StatVal As Long) As Long

Declare Function hpe1445_operCond_Q Lib "hpe1445.dll" (ByVal vi As Long,StatVal As Long) As Long

Declare Function hpe1445_quesEvent_Q Lib "hpe1445.dll" (ByVal vi As Long,StatVal As Long) As Long

Declare Function hpe1445_quesCond_Q Lib "hpe1445.dll" (ByVal vi As Long,StatVal As Long) As Long

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1445_arbWave
Global Const hpe1445_ARBRATEMAX                           = 42.94e6
Global Const hpe1445_ARBRATEMIN                           = 0
Global Const hpe1445_ARBAMPL_MAX                          = 12.05
Global Const hpe1445_ARBAMPL_MIN                          = -12.05
Global Const hpe1445_ARBSEQNO_MAX                         = 32768
Global Const hpe1445_ARBSEQNO_MIN                         = 0
Global Const hpe1445_Z_50                                 = 50
Global Const hpe1445_Z_75                                 = 75

' Used by Function hpe1445_couple1446
Global Const hpe1445_46ATTENZERO                          = 0
Global Const hpe1445_46ATTEN20                            = 20
Global Const hpe1445_46UNUSED                             = -20
Global Const hpe1445_46IMP0                               = 0
Global Const hpe1445_46IMP50                              = 50
Global Const hpe1445_46IMP75                              = 75
'    hpe1445_46UNUSED
Global Const hpe1445_46OFFMAX                             = 10.0
'    hpe1445_46UNUSED

' Used by Function hpe1445_coupleCGFV
Global Const hpe1445_CGFVPOINTSMAX                        = 262144
Global Const hpe1445_CGFVUNUSED                           = -1

' Used by Function hpe1445_coupleCGfreq
Global Const hpe1445_CGFREQF2MAX                          = 42.9497e6
Global Const hpe1445_CGFREQUNUSED                         = -1
Global Const hpe1445_CGFREQROSCMAX                        = 42.94967296e6
'    hpe1445_CGFREQUNUSED
Global Const hpe1445_CGFREQSCOUNTMAX                      = 2147483647
'    hpe1445_CGFREQUNUSED

' Used by Function hpe1445_coupleCGvolt
Global Const hpe1445_CGVOLT_UNUSED                        = -20
'    hpe1445_Z_50
'    hpe1445_Z_75
'    hpe1445_CGVOLT_UNUSED
'    hpe1445_Z_50
'    hpe1445_Z_75
Global Const hpe1445_CGVOLT_INF                           = 9.9e37
Global Const hpe1445_CGVOLT_AMPLMAX                       = 12.05
'    hpe1445_CGVOLT_UNUSED
'    hpe1445_CGVOLT_AMPLMAX
'    hpe1445_CGVOLT_UNUSED

' Used by Function hpe1445_coupleSourFreq1
Global Const hpe1445_FREQ1MAX                             = 42.94967296e6
Global Const hpe1445_FREQ1_UNUSED                         = -1
'    hpe1445_FREQ1MAX
'    hpe1445_FREQ1_UNUSED
'    hpe1445_FREQ1MAX
'    hpe1445_FREQ1_UNUSED
Global Const hpe1445_FREQ1_FSK2_MAX                       = 42.94967296e6
Global Const hpe1445_FREQ1_FSK2_MIN                       = 0
'    hpe1445_FREQ1MAX
'    hpe1445_FREQ1_UNUSED
'    hpe1445_FREQ1MAX
'    hpe1445_FREQ1_UNUSED
'    hpe1445_FREQ1MAX
'    hpe1445_FREQ1_UNUSED
'    hpe1445_FREQ1MAX
'    hpe1445_FREQ1_UNUSED

' Used by Function hpe1445_coupleSourSweep
Global Const hpe1445_SWEEPCOUNTCMAX                       = 2147483647
Global Const hpe1445_SWEEPUNUSED                          = -1
Global Const hpe1445_SWEEPPOINTSMAX                       = 1073741824
'    hpe1445_SWEEPUNUSED
Global Const hpe1445_REALMAX                              = 1e39
'    hpe1445_SWEEPUNUSED

' Used by Function hpe1445_coupleTrig
Global Const hpe1445_TRIGPERIODMAX                        = 4.19430375
Global Const hpe1445_TRIGUNUSED                           = -1

' Used by Function hpe1445_createSeg
Global Const hpe1445_SEGNO_MAX                            = 262144
Global Const hpe1445_SEGNO_MIN                            = 8

' Used by Function hpe1445_fsk1
Global Const hpe1445_FSKF1_MAX                            = 42.94e6
Global Const hpe1445_FSKF1_MIN                            = 0
Global Const hpe1445_FSKF2_MAX                            = 42.94e6
Global Const hpe1445_FSKF2_MIN                            = 0
Global Const hpe1445_FSKAMPL_MAX                          = 12.05
Global Const hpe1445_FSKAMPL_MIN                          = 0
'    hpe1445_Z_50
'    hpe1445_Z_75

' Used by Function hpe1445_sinWave
Global Const hpe1445_SIN_FREQ_MAX                         = 42.94e6
Global Const hpe1445_SIN_FREQ_MIN                         = 0
Global Const hpe1445_SIN_AMPL_MAX                         = 12.05
Global Const hpe1445_SIN_AMPL_MIN                         = 0
'    hpe1445_Z_50
'    hpe1445_Z_75

' Used by Function hpe1445_squareWave
Global Const hpe1445_SQU_FREQ_MAX                         = 42.94e6
Global Const hpe1445_SQU_FREQ_MIN                         = 0
Global Const hpe1445_SQU_AMPL_MAX                         = 12.05
Global Const hpe1445_SQU_AMPL_MIN                         = 0
Global Const hpe1445_SQU_OFFSETMAX                        = 12.05
Global Const hpe1445_SQU_OFFSETMIN                        = -12.05
'    hpe1445_Z_50
'    hpe1445_Z_75

' Used by Function hpe1445_sweep
Global Const hpe1445_SWEEPSTART_MAX                       = 42.94e6
Global Const hpe1445_SWEEPSTART_MIN                       = 0
Global Const hpe1445_SWEEPSTOP_MAX                        = 42.94e6
Global Const hpe1445_SWEEPSTOP_MIN                        = 0
Global Const hpe1445_SWEEPAMPL_MAX                        = 12.05
Global Const hpe1445_SWEEPAMPL_MIN                        = -12.05
Global Const hpe1445_SWEEPPOINTS_MAX                      = 262144
Global Const hpe1445_SWEEPPOINTS_MIN                      = 4
'    hpe1445_Z_50
'    hpe1445_Z_75

' Used by Function hpe1445_triWave
Global Const hpe1445_TRI_FREQ_MAX                         = 42.94e6
Global Const hpe1445_TRI_FREQ_MIN                         = 0
Global Const hpe1445_TRI_AMPL_MAX                         = 12.05
Global Const hpe1445_TRI_AMPL_MIN                         = 0
Global Const hpe1445_TRI_OFFSETMAX                        = 12.05
Global Const hpe1445_TRI_OFFSETMIN                        = -12.05
'    hpe1445_Z_50
'    hpe1445_Z_75
Global Const hpe1445_TRI_POINTSMAX                        = 262144
Global Const hpe1445_TRI_POINTSMIN                        = 4


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1445_arbWave Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal samplerate As Double, ByVal ampl As Double, ByVal sequence As String, ByVal seqlength As Long, ByVal seqorder As String, dwell As Long, ByVal impedance As Long, ByVal load As String) As Long

Declare Function hpe1445_couple1446 Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal attenuation As Long, ByVal impedance As Long, ByVal offset As Double) As Long

Declare Function hpe1445_coupleBegin Lib "hpe1445_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1445_coupleCGFV Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal dacsour As String, ByVal shape As String, ByVal points As Double) As Long

Declare Function hpe1445_coupleCGfreq Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal sourfreq2 As Double, ByVal freqlist2 As String, ByVal pmsource As String, ByVal pmstate As String, ByVal roscfreq As Double, ByVal roscsour As String, ByVal armsweepcount As Long, ByVal armsweepsour As String) As Long

Declare Function hpe1445_coupleCGvolt Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal impedance As Long, ByVal load As Double, ByVal loadauto As String, ByVal ramppol As String, ByVal ampl As Double, ByVal offset As Double) As Long

Declare Function hpe1445_coupleEnd Lib "hpe1445_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1445_coupleSourFreq1 Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal center As Double, ByVal fixed As Double, ByVal fsk1 As Double, ByVal fsk2 As Double, ByVal fskSour As String, ByVal mode As String, ByVal range As Double, ByVal span As Double, ByVal start As Double, ByVal stop As Double) As Long

Declare Function hpe1445_coupleSourSweep Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal count As Long, ByVal direction As String, ByVal points As Long, ByVal spacing As String, ByVal time As Double) As Long

Declare Function hpe1445_coupleTrig Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal polarity As String, ByVal gatesour As String, ByVal gatestate As String, ByVal startsour As String, ByVal slope As String, ByVal stopsour As String, ByVal sweepsour As String, ByVal period As Double) As Long

Declare Function hpe1445_createSeg Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal name As String, ByVal size As Long, data As Double) As Long

Declare Function hpe1445_fsk1 Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal freq1 As Double, ByVal freq2 As Double, ByVal ampl As Double, ByVal fsksource As String, ByVal impedance As Long, ByVal load As String) As Long

Declare Function hpe1445_marker Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal segment As String, markerlist As Integer) As Long

Declare Function hpe1445_outpState Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal state As String) As Long

Declare Function hpe1445_sinWave Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal freq As Double, ByVal ampl As Double, ByVal impedance As Long, ByVal load As String) As Long

Declare Function hpe1445_squareWave Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal freq As Double, ByVal ampl As Double, ByVal polarity As String, ByVal offset As Double, ByVal impedance As Long, ByVal load As String) As Long

Declare Function hpe1445_sweep Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal shape As String, ByVal startfreq As Double, ByVal stopfreq As Double, ByVal ampl As Double, ByVal points As Long, ByVal impedance As Long, ByVal load As String) As Long

Declare Function hpe1445_triWave Lib "hpe1445_32.dll" (ByVal vi As Long, ByVal freq As Double, ByVal ampl As Double, ByVal polarity As String, ByVal offset As Double, ByVal impedance As Long, ByVal load As String, ByVal points As Long) As Long

