#!/bin/ash
# If a PC blade (ie hilo) is found in slot 1, configure IDT switch for that PC blade to be the root complex.  Disable
# PCIe x8 chassis out connector.


LOGIT="logger -t $0 -p 6 -s "
cntTotal=0

func_error_exit()
{
  $LOGIT $*
  exit 1
}

func_i2ca ()
{

  cnt=0
  notdone=true
  while $notdone
  do
     i2ca $1 $2 $3 $4 $5 $6 $7 $8 $9 $10 $11 $12 $13 $14 $15

     if [ "$?" = "0" ]
     then
       notdone=false
     elif test $cnt != 10
     then
       cntTotal=`expr $cntTotal + 1`
       usleep 500
     else
       func_error_exit "$0: ERROR: Timed out ($cntTotal) attempting to communicate with $1 $2 $3 $4 $5" 
     fi

   cnt=`expr $cnt + 1`

  done

  
}

func_i2ca_test ()
{ 
  # $1 is device address ie 0x72
  DEVICES=$(i2c_test | grep $1)
  if [ "$?" -eq 0 ]
  then
    return 
  else
    func_error_exit "$0: ERROR: Device $1 not found"
    exit
  fi
}

# Read EEPROM
func_read_eeprom ()
{
  cnt4=0
  notdone1=true

  func_i2ca 0 77 w 0x43 0x07 0x0f 0xb4 0xfa $2 $1 0x00 0x04 > /dev/null

  while $notdone1
  do  
     response=`func_i2ca 0 77 w 0x43 0x03 0x1f 0xb4 0xfa r 5 | grep read | awk '{print $5 " " $6 " " $7 " " $8}'`
     donebyte=`echo $response | awk '{print $4}'`
     databyte=`echo $response | awk '{print $3}'`

     if [ "$donebyte" = "0x06" ]
     then
       notdone1=false
     elif test $cnt4 != 10
     then
       cntTotal=`expr $cntTotal + 1`
       usleep 500
     else
       func_error_exit "$0: ERROR: Timed out attempting to read EEPROM address $1 $2" 
     fi

   cnt4=`expr $cnt4 + 1`

  done

  echo $databyte

}

# Write EEPROM
func_write_eeprom ()
{
  cnt3=0
  writedone=true

  while $writedone
  do

    cnt2=0
    notdone2=true
    func_i2ca 0 77 w 0x43 0x07 0x0f 0xb4 0xfa $2 $1 $3 0x00 > /dev/null
    while $notdone2
    do  
       eeprom_done=`func_i2ca 0 77 w 0x43 0x03 0x1f 0xb4 0xfa r 5 | grep read | awk '{print $8}'`
       if [ "$eeprom_done" = "0x02" ]
       then
         notdone2=false
       elif test $cnt2 != 10
       then
         cntTotal=`expr $cntTotal + 1`
         usleep 500
       else
         func_error_exit "$0: ERROR: Timed out attempting to write EEPROM at address $1 $2 with data $3" 
       fi
     cnt2=`expr $cnt2 + 1`

    done

    readback=`func_read_eeprom $1 $2`

    if [ "$readback" = "$3" ]
    then
      writedone=false
    elif test $cnt3 != 10
    then
      cntTotal=`expr $cntTotal + 1`
      usleep 500
    else
      func_error_exit "$0: ERROR: Read back error while attempting to write EEPROM. Wrote $3, Read $readback" 
    fi
    cnt3=`expr $cnt3 + 1`
  
  done

  return 

}

# Setup PC in hubslot

#
## MAIN
#

#func_write_eeprom <AddressMSB> <AddressLSB> <DATA>

func_i2ca 0 71 w 1

notdone5=true
bytecnt=0

filesize=`ls -l $1 | awk '{print $5}'`
byteerr=0

while $notdone5
do
 if test $filesize = $bytecnt
   then
     notdone5=false
 else
   read=`hexdump -C $1 -n 1 -s $bytecnt | head -n 1 | awk '{print $2}'`
   if [ "$read" = "" ]
     then
     read="00"
   fi
   cntmsb=`printf %04x $bytecnt | head -c 2`
   cntlsb=`printf %04x $bytecnt | tail -c 2`
   
   readbyte=`func_read_eeprom 0x$cntmsb 0x$cntlsb`
   if [ "$readbyte" != "0x$read" ] 
   then 
     byteerr=`expr $byteerr + 1`
     echo Mismatch $bytecnt: $readbyte $read
   else
     echo -n .
   fi
   
   bytecnt=`expr $bytecnt + 1` 

 fi
done

echo File size = $filesize
echo Bytes read = $bytecnt
echo Error count = $byteerr

