/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.help;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.components.help.EclHelpHtmlWindow;
import com.agilent.tntd.eclipse.viewlayer.components.help.HelpDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.help.HelpPopupMenu;
import com.agilent.tntd.eclipse.viewlayer.components.help.ViewportListener;
import espial.browser.env.BrowserEnv;
import espial.browser.env.BrowserViewport;
import espial.browser.env.BrowserViewportListener;
import espial.browser.navigation.NavigatableObject;
import espial.browser.navigation.TwoDNavigationManager;
import espial.browser.navigation.TwoDNavigationRenderer;
import espial.browser.plugins.InvalidStateException;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;

class BrowserConnection
implements ApplicationObjectObserver,
KnownLengthStringDataReceiver,
MaskedIntegerDataReceiver {
    private String theStartupURL;
    private PropertyResourceBundle propertyBundle;
    private BrowserViewport rootViewport;
    private String onlineHelpRoot = null;
    private String userHelpRoot = null;
    private boolean hasTrappedTransientError = false;
    private boolean hasTrappedPermanentError = false;
    private boolean urlsAreInitialized = false;
    private boolean clearHistoryRequired = false;
    private boolean debug = false;
    private static final String statusVariableName = "INST_ONLINE_HELP_STATUS";
    private ApplicationObject theStatusAO = null;
    private MaskedIntegerValue theStatusValue = null;
    private static final String modeVariableName = "INST_ONLINE_HELP_MODE";
    private ApplicationObject theModeAO = null;
    private KnownLengthStringValue theModeValue = null;
    private EclHelpHtmlWindow theHelpWindow;
    private HelpPopupMenu theHelpPopup;
    private NavigatableObject theCurrentNavigatable;

    public BrowserConnection(EclHelpHtmlWindow eclHelpHtmlWindow) {
        this.theHelpWindow = eclHelpHtmlWindow;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: failed to initialize because " + applicationObject.toString() + " failed to initialize.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: failed to initialize because the requested domain is not available.");
            this.permanentError();
        } else if (applicationObject.getName().equals(statusVariableName)) {
            this.theStatusAO = applicationObject;
        } else if (applicationObject.getName().equals(modeVariableName)) {
            this.theModeAO = applicationObject;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + applicationObject.toString());
        }
    }

    private void activateHelpMenu() {
        if (!this.isInError()) {
            this.getHelpPopup().showPopupMenu(this.isBackMenuItemEnabled(), this.isForwardMenuItemEnabled());
        }
    }

    public void backActionInHistory() {
        this.getViewport().doGoBack();
    }

    public void changeToURL(String string) {
        try {
            this.getViewport().gotoURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            EclipseSystem.instance().beep();
            EventLog.instance().log("ERROR: " + this.toString() + ": changeToURL: Malformed URL exception");
        }
    }

    public void clearHistoryWhenNecessary() {
        if (this.isClearHistoryRequired()) {
            this.getViewport().getRootViewport().doClearHistory();
            this.setClearHistoryRequired(false);
        }
    }

    private void createViewport() {
        if (this.debug) {
            EventLog.instance().log("INFO: " + this.toString() + ": creating viewport and initialising bowser properties");
        }
        Properties properties = System.getProperties();
        int n = 0;
        while (n < HelpDefaults.espialBrowserProperties.length) {
            ((Hashtable)properties).put(HelpDefaults.espialBrowserProperties[n][0], HelpDefaults.espialBrowserProperties[n][1]);
            ++n;
        }
        System.setProperties(properties);
        TwoDNavigationManager.enableNavigation((boolean)true);
        TwoDNavigationRenderer twoDNavigationRenderer = BrowserEnv.getInstance().get2DNavigationRenderer();
        twoDNavigationRenderer.setFocusColor(HelpDefaults.cursorInnerFocusColor, HelpDefaults.cursorOuterFocusColor);
        twoDNavigationRenderer.setActiveColor(HelpDefaults.cursorInnerActiveColor, HelpDefaults.cursorOuterActiveColor);
        twoDNavigationRenderer.setHighliteBorderWidth(2);
        this.rootViewport = BrowserEnv.getInstance().createViewport("Help");
        this.rootViewport.setHistorySize(10);
        this.rootViewport.scaleContent(100);
        this.rootViewport.setListener((BrowserViewportListener)new ViewportListener(this));
        this.getHelpWindow().addHelp(this.rootViewport.getContainer());
    }

    public void finishInitialise() {
        String string;
        this.trapTransientError(true);
        this.urlsAreInitialized = false;
        String string2 = System.getProperty("help.debug");
        if (string2 != null && string2.equals("1")) {
            this.debug = true;
        }
        if ((string = System.getProperty("help.properties.file")) == null || string.equalsIgnoreCase("")) {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: A help properties file MUST be defined.");
            this.permanentError();
        } else {
            try {
                this.readPropertiesFile(string);
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: The help properties file is invalid: " + string);
                this.permanentError();
            }
        }
        this.onlineHelpRoot = this.getProperty("help.online.root");
        this.userHelpRoot = this.getProperty("help.user.root");
        if (this.onlineHelpRoot == null) {
            this.onlineHelpRoot = "";
            EventLog.instance().log("WARNING: " + this.toString() + ": Online help root, help.online.root, is NOT specified in the help properties file.");
        }
        if (this.userHelpRoot == null) {
            this.userHelpRoot = "";
            EventLog.instance().log("WARNING: " + this.toString() + ": User help root, help.user.root, is NOT specified in the help properties file.");
        }
        if (EclipseSystem.instance().isOnInstrument()) {
            ApplicationManager.instance().request("ISS", 1, statusVariableName, (ApplicationObjectObserver)this);
        } else {
            this.theStatusValue = new MaskedIntegerValue(1);
        }
        ApplicationManager.instance().request("ISS", 1, modeVariableName, (ApplicationObjectObserver)this);
    }

    public void forwardActionInHistory() {
        this.getViewport().doGoForward();
    }

    private HelpPopupMenu getHelpPopup() {
        if (this.theHelpPopup == null) {
            this.theHelpPopup = new HelpPopupMenu(this);
        }
        return this.theHelpPopup;
    }

    public EclHelpHtmlWindow getHelpWindow() {
        return this.theHelpWindow;
    }

    private String getProperty(String string) {
        String string2 = "";
        try {
            string2 = this.propertyBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            EventLog.instance().log(missingResourceException.toString());
            EventLog.instance().log("ERROR: " + this.toString() + ": getProperty: Property " + string + " NOT FOUND");
        }
        catch (Exception exception) {
            exception.toString();
        }
        return string2;
    }

    private BrowserViewport getViewport() {
        if (this.rootViewport == null) {
            this.createViewport();
        }
        return this.rootViewport;
    }

    private void initializeURLs() {
        String string = this.theModeValue.getValue();
        String string2 = string == null || string.equalsIgnoreCase("") ? "help." : "help." + string + ".";
        this.theStartupURL = String.valueOf(this.onlineHelpRoot) + "/" + this.getProperty(String.valueOf(string2) + "startup");
        this.getHelpPopup().initializeURLs(this.onlineHelpRoot, this.userHelpRoot, string2, this.propertyBundle);
        this.urlsAreInitialized = true;
    }

    private boolean isBackMenuItemEnabled() {
        if (this.rootViewport == null) {
            return false;
        }
        return this.getViewport().canGoBack();
    }

    private boolean isClearHistoryRequired() {
        return this.clearHistoryRequired;
    }

    private boolean isForwardMenuItemEnabled() {
        if (this.rootViewport == null) {
            return false;
        }
        return this.getViewport().canGoForward();
    }

    private boolean isInError() {
        return this.hasTrappedPermanentError || this.hasTrappedTransientError;
    }

    public void loadStartupURL() {
        this.changeToURL(this.theStartupURL);
    }

    public void notifyHelpVisibilityChange(boolean bl) {
        if (bl) {
            if (this.theCurrentNavigatable != null) {
                this.theCurrentNavigatable.requestFocus();
            }
        } else {
            this.theCurrentNavigatable = TwoDNavigationManager.getController().getSearchStrategy().getCurrentNavigatable();
            this.getHelpPopup().hide();
        }
    }

    private void permanentError() {
        this.hasTrappedPermanentError = true;
        this.hasTrappedTransientError = false;
        this.updateView();
        this.removeViewport();
        this.unregister();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (!this.hasTrappedTransientError && keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)keyEvent)) {
                case 107: {
                    this.activateHelpMenu();
                    keyEvent.consume();
                    break;
                }
                case 2000: {
                    this.changeToURL(this.theStartupURL);
                    keyEvent.consume();
                    break;
                }
                case 2001: {
                    this.backActionInHistory();
                    keyEvent.consume();
                    break;
                }
                case 2002: {
                    this.forwardActionInHistory();
                    keyEvent.consume();
                    break;
                }
                case 33: 
                case 2010: {
                    this.scrollAndJump(false);
                    keyEvent.consume();
                    break;
                }
                case 34: 
                case 2013: {
                    this.scrollAndJump(true);
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.tabNavigate(-9000002);
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.tabNavigate(-9000014);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.tabNavigate(-9000003);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.tabNavigate(-9000013);
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    TwoDNavigationManager.getController().navigate(-9000010, null);
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getHelpWindow().processUnconsumedKeyEvent(keyEvent);
        }
    }

    private void readPropertiesFile(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            this.propertyBundle = new PropertyResourceBundle(fileInputStream);
        }
        catch (IOException iOException) {
            EventLog.instance().log(iOException.toString());
            EventLog.instance().log("ERROR: " + this.toString() + ": readPropertiesFile: Error opening file " + string);
        }
        catch (Exception exception) {
            exception.toString();
        }
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue knownLengthStringValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theModeAO) {
            if (this.debug) {
                EventLog.instance().log("INFO: " + this.toString() + ": receiveKnownLengthStringData: received value = " + knownLengthStringValue.getValue());
            }
            if (!knownLengthStringValue.equals(this.theModeValue)) {
                this.theModeValue = knownLengthStringValue;
                this.initializeURLs();
                if (this.theStatusValue.getValue() == 1) {
                    try {
                        this.setClearHistoryRequired(true);
                        this.getViewport().gotoURL(new URL(this.theStartupURL));
                        this.trapTransientError(false);
                    }
                    catch (MalformedURLException malformedURLException) {
                        EventLog.instance().log("ERROR: " + this.toString() + ": receiveKnownLengthStringData: Malformed URL exception");
                    }
                }
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveKnownLengthStringData: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theStatusAO) {
            if (this.debug) {
                EventLog.instance().log("INFO: " + this.toString() + ": receivedMaskedIntegerData: received value = " + maskedIntegerValue.getValue());
            }
            if (!maskedIntegerValue.equals(this.theStatusValue)) {
                if (maskedIntegerValue.getValue() == 1) {
                    if (this.debug) {
                        EventLog.instance().log("INFO: " + this.toString() + ": receivedMaskedIntegerData: Online help now valid");
                    }
                    if (this.urlsAreInitialized) {
                        try {
                            this.setClearHistoryRequired(true);
                            this.getViewport().gotoURL(new URL(this.theStartupURL));
                            this.trapTransientError(false);
                        }
                        catch (MalformedURLException malformedURLException) {
                            EventLog.instance().log("ERROR: " + this.toString() + ": receivedMaskedIntegerData: Malformed URL exception");
                        }
                    }
                } else {
                    if (this.debug) {
                        EventLog.instance().log("WARNING: " + this.toString() + ": receivedMaskedIntegerData: Online help currently invalid");
                    }
                    this.trapTransientError(true);
                    this.stopViewport();
                    System.gc();
                    try {
                        if (this.debug) {
                            EventLog.instance().log("INFO: " + this.toString() + ": receivedMaskedIntegerData: Setting viewport to the blank URL");
                        }
                        this.getViewport().gotoURL(new URL("file:///ata0/EPA/blank.html"));
                    }
                    catch (MalformedURLException malformedURLException) {
                        EventLog.instance().log("ERROR: " + this.toString() + ": receivedMaskedIntegerData: Malformed URL exception");
                    }
                }
                this.theStatusValue = maskedIntegerValue;
            } else if (this.debug) {
                EventLog.instance().log("INFO: " + this.toString() + ": receivedMaskedIntegerData: Doing nothing because received value is identical to the last: " + maskedIntegerValue.getValue());
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    private void removeViewport() {
        if (this.rootViewport != null) {
            try {
                if (this.debug) {
                    EventLog.instance().log("INFO: " + this.toString() + ": removeViewport: Removing viewport");
                }
                this.rootViewport.doStop();
                ((Container)((Object)this.getHelpWindow())).remove(this.rootViewport.getContainer());
                this.rootViewport.setListener(null);
                this.rootViewport.dispose();
                this.rootViewport = null;
            }
            catch (Exception exception) {
                EventLog.instance().log("ERROR: " + this.toString() + ": removeViewport: The following exception was caught ...");
                exception.printStackTrace();
                this.rootViewport = null;
            }
        }
    }

    private void scrollAndJump(boolean bl) {
        try {
            if (this.getViewport().getScrollController().getContentHeight() > this.getViewport().getScrollController().getVisibleHeight()) {
                NavigatableObject navigatableObject;
                NavigatableObject navigatableObject2 = TwoDNavigationManager.getController().getSearchStrategy().getCurrentNavigatable();
                int n = this.getViewport().getScrollController().getOffsetY();
                if (bl) {
                    this.tabNavigate(-9000009);
                } else {
                    this.tabNavigate(-9000008);
                }
                if (n != this.getViewport().getScrollController().getOffsetY() && (navigatableObject = TwoDNavigationManager.getController().getSearchStrategy().getNavigatable(-9000013, this.getViewport().getAbsoluteLocation())) != null && navigatableObject2 != null && navigatableObject != navigatableObject2) {
                    navigatableObject2.releaseFocus();
                    navigatableObject.requestFocus();
                    this.theHelpWindow.requestFocus();
                }
            }
        }
        catch (InvalidStateException invalidStateException) {}
    }

    private void setClearHistoryRequired(boolean bl) {
        this.clearHistoryRequired = bl;
    }

    private void stopViewport() {
        if (this.rootViewport != null) {
            try {
                if (this.debug) {
                    EventLog.instance().log("INFO: " + this.toString() + ": stopViewport: Stopping viewport");
                }
                this.rootViewport.doStop();
            }
            catch (Exception exception) {
                EventLog.instance().log("ERROR: " + this.toString() + ": stopViewport: The following exception was caught ...");
                exception.printStackTrace();
            }
        }
    }

    public void tabNavigate(int n) {
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < 10) {
            try {
                TwoDNavigationManager.getController().navigate(n, null);
                bl = false;
            }
            catch (NullPointerException nullPointerException) {
                EventLog.instance().log("DEBUG: " + this.toString() + ": getNextLink: Caught null pointer exception thrown in Espial code when requesting next navigable object");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                EventLog.instance().log("DEBUG: " + this.toString() + ": getNextLink: Caught array index out-of-bounds exception thrown in Espial code");
            }
            ++n2;
        }
    }

    public void transferFocus() {
        if (this.getHelpPopup().hide()) {
            this.getHelpWindow().requestFocus();
        }
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
            this.updateView();
        }
    }

    public void unregister() {
        if (this.theStatusAO != null) {
            this.theStatusAO.unregister((ApplicationObjectObserver)this);
            this.theStatusAO = null;
            this.theStatusValue = null;
        }
        if (this.theModeAO != null) {
            this.theModeAO.unregister((ApplicationObjectObserver)this);
            this.theModeAO = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": update: The right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString() + " has not been implemented.");
            this.permanentError();
        }
    }

    private void updateView() {
        this.getHelpWindow().updateView(this.hasTrappedPermanentError, this.hasTrappedTransientError || this.rootViewport == null);
    }
}

