/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.help;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.components.help.BrowserConnection;
import com.agilent.tntd.eclipse.viewlayer.components.help.HelpDefaults;
import com.agilent.tntd.eclipse.viewlayer.menus.EclActionMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenuModel;
import com.agilent.tntd.eclipse.viewlayer.menus.EclSeparatorMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

class HelpPopupMenu {
    private BrowserConnection theBrowser;
    private EclipsePopupMenu thePopupMenu;
    private HelpMenuEventHandler theHelpMenuEventHandler;
    private EclActionMenuItem theBackMenuItem;
    private EclActionMenuItem theForwardMenuItem;
    private EclActionMenuItem theHomeMenuItem;
    private EclActionMenuItem theGettingStartedMenuItem;
    private EclActionMenuItem theInstrumentUseMenuItem;
    private EclActionMenuItem theInstrumentDetailsMenuItem;
    private EclActionMenuItem theTelecomsConceptsMenuItem;
    private EclActionMenuItem theIndexMenuItem;
    private EclActionMenuItem theUserHelpMenuItem;
    private EclActionMenuItem theExitMenuItem;
    private String theHomeURL;
    private String theGettingStartedURL;
    private String theInstrumentUseURL;
    private String theInstrumentDetailsURL;
    private String theTelecomsConceptsURL;
    private String theIndexURL;
    private String theUserHelpURL;

    public HelpPopupMenu(BrowserConnection browserConnection) {
        this.theBrowser = browserConnection;
        this.describeMainMenu();
    }

    private void describeMainMenu() {
        EclMainMenu eclMainMenu = new EclMainMenu();
        eclMainMenu.setEclModel(new EclMainMenuModel(null, new SelfInitialisedMenuElement[]{this.getBackMenuItem(), this.getForwardMenuItem(), new EclSeparatorMenuItem(), this.getHomeMenuItem(), this.getGettingStartedMenuItem(), this.getInstrumentUseMenuItem(), this.getInstrumentDetailsMenuItem(), this.getTelecomsConceptsMenuItem(), this.getIndexMenuItem(), new EclSeparatorMenuItem(), this.getUserHelpMenuItem(), new EclSeparatorMenuItem(), this.getExitMenuItem()}, false));
        eclMainMenu.finishInitialise();
        this.thePopupMenu = eclMainMenu.getRootPopupMenu();
    }

    private EclActionMenuItem getBackMenuItem() {
        if (this.theBackMenuItem == null) {
            this.theBackMenuItem = new EclActionMenuItem("Back", this.getHelpMenuEventHandler());
        }
        return this.theBackMenuItem;
    }

    private EclActionMenuItem getExitMenuItem() {
        if (this.theExitMenuItem == null) {
            this.theExitMenuItem = new EclActionMenuItem("Exit Online Help", this.getHelpMenuEventHandler());
        }
        return this.theExitMenuItem;
    }

    private EclActionMenuItem getForwardMenuItem() {
        if (this.theForwardMenuItem == null) {
            this.theForwardMenuItem = new EclActionMenuItem("Fwd", this.getHelpMenuEventHandler());
        }
        return this.theForwardMenuItem;
    }

    private EclActionMenuItem getGettingStartedMenuItem() {
        if (this.theGettingStartedMenuItem == null) {
            this.theGettingStartedMenuItem = new EclActionMenuItem("Getting Started", this.getHelpMenuEventHandler());
        }
        return this.theGettingStartedMenuItem;
    }

    private ActionListener getHelpMenuEventHandler() {
        if (this.theHelpMenuEventHandler == null) {
            this.theHelpMenuEventHandler = new HelpMenuEventHandler(this);
        }
        return this.theHelpMenuEventHandler;
    }

    private EclActionMenuItem getHomeMenuItem() {
        if (this.theHomeMenuItem == null) {
            this.theHomeMenuItem = new EclActionMenuItem("Home", this.getHelpMenuEventHandler());
        }
        return this.theHomeMenuItem;
    }

    private EclActionMenuItem getIndexMenuItem() {
        if (this.theIndexMenuItem == null) {
            this.theIndexMenuItem = new EclActionMenuItem("Index", this.getHelpMenuEventHandler());
        }
        return this.theIndexMenuItem;
    }

    private EclActionMenuItem getInstrumentDetailsMenuItem() {
        if (this.theInstrumentDetailsMenuItem == null) {
            this.theInstrumentDetailsMenuItem = new EclActionMenuItem("Instrument Details", this.getHelpMenuEventHandler());
        }
        return this.theInstrumentDetailsMenuItem;
    }

    private EclActionMenuItem getInstrumentUseMenuItem() {
        if (this.theInstrumentUseMenuItem == null) {
            this.theInstrumentUseMenuItem = new EclActionMenuItem("Instrument Use", this.getHelpMenuEventHandler());
        }
        return this.theInstrumentUseMenuItem;
    }

    private String getProperty(String string, PropertyResourceBundle propertyResourceBundle) {
        String string2 = "";
        try {
            string2 = propertyResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            EventLog.instance().log(missingResourceException.toString());
            EventLog.instance().log("ERROR: " + this.toString() + ": getProperty: Property " + string + " NOT FOUND");
        }
        catch (Exception exception) {
            exception.toString();
        }
        return string2;
    }

    private EclActionMenuItem getTelecomsConceptsMenuItem() {
        if (this.theTelecomsConceptsMenuItem == null) {
            this.theTelecomsConceptsMenuItem = new EclActionMenuItem("Telecoms Concepts", this.getHelpMenuEventHandler());
        }
        return this.theTelecomsConceptsMenuItem;
    }

    private EclActionMenuItem getUserHelpMenuItem() {
        if (this.theUserHelpMenuItem == null) {
            this.theUserHelpMenuItem = new EclActionMenuItem("Your Own Help", this.getHelpMenuEventHandler());
        }
        return this.theUserHelpMenuItem;
    }

    public boolean hide() {
        if (this.thePopupMenu.getEclipseMenuComponent().isVisible()) {
            this.thePopupMenu.getEclipseMenuComponent().setVisible(false);
            return true;
        }
        return false;
    }

    public void initializeURLs(String string, String string2, String string3, PropertyResourceBundle propertyResourceBundle) {
        this.theHomeURL = String.valueOf(string) + "/" + this.getProperty(String.valueOf(string3) + "home", propertyResourceBundle);
        this.theGettingStartedURL = String.valueOf(string) + "/" + this.getProperty(String.valueOf(string3) + "gettingStarted", propertyResourceBundle);
        this.theInstrumentUseURL = String.valueOf(string) + "/" + this.getProperty(String.valueOf(string3) + "instrumentUse", propertyResourceBundle);
        this.theInstrumentDetailsURL = String.valueOf(string) + "/" + this.getProperty(String.valueOf(string3) + "instrumentDetails", propertyResourceBundle);
        this.theTelecomsConceptsURL = String.valueOf(string) + "/" + this.getProperty(String.valueOf(string3) + "telecomsConcepts", propertyResourceBundle);
        this.theIndexURL = String.valueOf(string) + "/" + this.getProperty(String.valueOf(string3) + "index", propertyResourceBundle);
        this.theUserHelpURL = String.valueOf(string2) + "/" + this.getProperty(String.valueOf(string3) + "userHelp", propertyResourceBundle);
    }

    public void showPopupMenu(boolean bl, boolean bl2) {
        this.getBackMenuItem().setEnabled(bl);
        this.getForwardMenuItem().setEnabled(bl2);
        this.thePopupMenu.setComponentFocusableOnClose(EclipseFocusManager.getInstance().getFocusedComponent());
        this.thePopupMenu.showRelativeToComponent((Component)((Object)this.theBrowser.getHelpWindow()), HelpDefaults.helpMenuPosition.x, HelpDefaults.helpMenuPosition.y);
        this.thePopupMenu.getEclipseMenuComponent().requestFocus();
    }

    public void updateMenuItems(boolean bl, boolean bl2) {
        this.getBackMenuItem().getEclipseMenuComponent().setEnabled(bl);
        this.getForwardMenuItem().getEclipseMenuComponent().setEnabled(bl2);
    }

    static String access$theInstrumentDetailsURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theInstrumentDetailsURL;
    }

    static String access$theTelecomsConceptsURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theTelecomsConceptsURL;
    }

    static String access$theHomeURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theHomeURL;
    }

    static String access$theInstrumentUseURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theInstrumentUseURL;
    }

    static BrowserConnection access$theBrowser(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theBrowser;
    }

    static String access$theGettingStartedURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theGettingStartedURL;
    }

    static String access$theIndexURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theIndexURL;
    }

    static String access$theUserHelpURL(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.theUserHelpURL;
    }

    static EclActionMenuItem access$getGettingStartedMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getGettingStartedMenuItem();
    }

    static EclActionMenuItem access$getInstrumentUseMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getInstrumentUseMenuItem();
    }

    static EclActionMenuItem access$getForwardMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getForwardMenuItem();
    }

    static EclActionMenuItem access$getInstrumentDetailsMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getInstrumentDetailsMenuItem();
    }

    static EclActionMenuItem access$getUserHelpMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getUserHelpMenuItem();
    }

    static EclActionMenuItem access$getBackMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getBackMenuItem();
    }

    static EclActionMenuItem access$getExitMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getExitMenuItem();
    }

    static EclActionMenuItem access$getHomeMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getHomeMenuItem();
    }

    static EclActionMenuItem access$getTelecomsConceptsMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getTelecomsConceptsMenuItem();
    }

    static EclActionMenuItem access$getIndexMenuItem(HelpPopupMenu helpPopupMenu) {
        return helpPopupMenu.getIndexMenuItem();
    }

    class HelpMenuEventHandler
    implements ActionListener {
        /* synthetic */ HelpPopupMenu this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HelpPopupMenu.access$getHomeMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theHomeURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getGettingStartedMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theGettingStartedURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getInstrumentUseMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theInstrumentUseURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getInstrumentDetailsMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theInstrumentDetailsURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getTelecomsConceptsMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theTelecomsConceptsURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getIndexMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theIndexURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getUserHelpMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).changeToURL(HelpPopupMenu.access$theUserHelpURL(this.this$0));
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getForwardMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).forwardActionInHistory();
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getBackMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).backActionInHistory();
            } else if (actionEvent.getSource() == HelpPopupMenu.access$getExitMenuItem(this.this$0)) {
                HelpPopupMenu.access$theBrowser(this.this$0).getHelpWindow().exitHelp();
            }
        }

        HelpMenuEventHandler(HelpPopupMenu helpPopupMenu) {
            this.this$0 = helpPopupMenu;
        }
    }
}

