/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.help;

import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.components.help.EclHelpHtmlWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class MouseHider
extends EclPanePage
implements DialogEventReceiver,
UnconsumedKeyHandler {
    private EclDialog theWindow;
    public EclHelpHtmlWindow theHelpWindow;

    public MouseHider() {
        ((Component)((Object)this)).enableEvents(16L);
    }

    private synchronized EclDialog getWindow() {
        if (this.theWindow == null) {
            String string = "Mouse operation currently not supported on Help. Please use the keys.";
            this.theWindow = new EclDialog();
            this.theWindow.setVisible(false);
            int n = 320;
            int n2 = 200;
            Dimension dimension = ((Component)((Object)this)).getSize();
            int n3 = dimension.width / 2 - n / 2;
            int n4 = dimension.height / 2 - n2 / 2;
            this.theWindow.setBounds(n3, n4, n, n2);
            this.theWindow.initialiseMessageWindow(false, true, false, string, "Warning", (DialogEventReceiver)this, null);
            ((Container)((Object)this)).add((Component)this.theWindow);
            this.theWindow.validate();
        }
        return this.theWindow;
    }

    public void notifyEvent(int n, EclDialog eclDialog) {
        this.getWindow().setVisible(false);
        ((Component)((Object)this)).getParent().requestFocus();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && !GenericMouseHelper.isRightMouseButton((MouseEvent)mouseEvent) && !this.getWindow().isVisible()) {
            this.getWindow().setVisible(true);
            this.getWindow().setSelected(true, null);
            this.getWindow().repaint();
        }
        if (mouseEvent.getID() == 500 && GenericMouseHelper.isRightMouseButton((MouseEvent)mouseEvent) && !this.getWindow().isVisible()) {
            Component component = EclipseFocusManager.getInstance().getWindowFocusedComponent();
            this.theHelpWindow.processKeyEvent(InstrumentKeyMappings.getMenuKeyEvent((Component)component));
        }
        mouseEvent.consume();
    }

    public void processUnconsumedKeyEvents(KeyEvent keyEvent, Component component) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)keyEvent)) {
                case 107: {
                    if (!this.getWindow().isVisible()) {
                        this.theHelpWindow.processKeyEvent(keyEvent);
                    }
                }
                case 113: 
                case 116: 
                case 119: 
                case 120: {
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    if (keyEvent.getID() == 401) {
                        this.getWindow().setVisible(false);
                        ((Component)((Object)this)).getParent().requestFocus();
                    }
                    keyEvent.consume();
                }
            }
        }
    }

    public void setHelpWindow(EclHelpHtmlWindow eclHelpHtmlWindow) {
        this.theHelpWindow = eclHelpHtmlWindow;
    }
}

