/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.help;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.components.help.BrowserConnection;
import espial.browser.env.BrowserEnv;
import espial.browser.env.BrowserViewport;
import espial.browser.env.DataPoster;
import espial.browser.env.HotKey;
import espial.browser.helpers.BasicBrowserViewportListener;
import espial.browser.plugins.BasicPluginEvent;
import espial.browser.plugins.InvalidStateException;
import espial.browser.plugins.PluginEvent;
import espial.browser.plugins.html.HtmlPluginEvent;
import espial.net.cert.X509Certificate;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;

class ViewportListener
extends BasicBrowserViewportListener {
    private BrowserConnection theBrowserConnection = null;
    private boolean debug = false;

    public ViewportListener(BrowserConnection browserConnection) {
        this.theBrowserConnection = browserConnection;
        String string = System.getProperty("viewport.info");
        if (string != null && string.equals("1")) {
            this.debug = true;
        }
        BrowserEnv.getInstance().registerHotKey(107, '+', 0, 401);
        BrowserEnv.getInstance().registerHotKey(107, '=', 0, 401);
        BrowserEnv.getInstance().registerHotKey(112);
    }

    public boolean connInsecureSuccess(BrowserViewport browserViewport, URL uRL) {
        if (this.debug) {
            EventLog.instance().log("INFO: successfully loaded " + uRL.toString());
        }
        return true;
    }

    public boolean connSecureFailure(BrowserViewport browserViewport, URL uRL, X509Certificate[] x509CertificateArray, String string) {
        EventLog.instance().log("ERROR: failed to load " + uRL.toString());
        return true;
    }

    public boolean connSecureSuccess(BrowserViewport browserViewport, URL uRL, X509Certificate[] x509CertificateArray) {
        if (this.debug) {
            EventLog.instance().log("INFO: successfully loaded " + uRL.toString());
        }
        return true;
    }

    public void focusGained(BrowserViewport browserViewport) {
        this.theBrowserConnection.transferFocus();
    }

    public void focusLost(BrowserViewport browserViewport) {
        if (this.debug) {
            EventLog.instance().log("INFO: " + this.toString() + ": focusLost: Received event");
        }
    }

    private boolean hasNavigatableObjectOnScreen(BrowserViewport browserViewport) {
        boolean bl;
        browserViewport.getFirstNavigatableObj();
        boolean bl2 = bl = browserViewport.getFirstNavigatableObj() != null;
        if (bl) {
            try {
                if (browserViewport.getScrollController().getOffsetX() != 0 || browserViewport.getScrollController().getOffsetY() != 0) {
                    bl = false;
                    browserViewport.getScrollController().scrollTo(0, 0);
                }
            }
            catch (InvalidStateException invalidStateException) {
                System.out.println((Object)invalidStateException);
            }
        }
        return bl;
    }

    public String httpAuthenticate(String string, URL uRL) {
        return null;
    }

    public String httpProxyAuthenticate(String string, URL uRL) {
        return null;
    }

    public boolean openRootViewport(String string, URL uRL, DataPoster dataPoster) {
        if (this.debug) {
            EventLog.instance().log("INFO: " + this.toString() + ": openRootViewport: event received");
        }
        return false;
    }

    public Object pluginEvent(BrowserViewport browserViewport, PluginEvent pluginEvent) {
        if (pluginEvent instanceof BasicPluginEvent) {
            BasicPluginEvent basicPluginEvent = (BasicPluginEvent)pluginEvent;
            switch (basicPluginEvent.getID()) {
                case 9: {
                    HotKey hotKey = (HotKey)basicPluginEvent.getArg();
                    KeyEvent keyEvent = new KeyEvent((Component)((Object)this.theBrowserConnection.getHelpWindow()), hotKey.getKeyState(), 0L, hotKey.getModifiers(), hotKey.getKeyCode(), hotKey.getKeyChar());
                    this.theBrowserConnection.processKeyEvent(keyEvent);
                    break;
                }
                case 3: {
                    if (this.hasNavigatableObjectOnScreen(browserViewport)) {
                        browserViewport.getFirstNavigatableObj().requestFocus();
                    }
                    this.theBrowserConnection.getHelpWindow().requestFocus();
                }
            }
        } else if (pluginEvent instanceof HtmlPluginEvent && ((HtmlPluginEvent)pluginEvent).getArg() instanceof MouseEvent) {
            this.theBrowserConnection.processKeyEvent(InstrumentKeyMappings.getMenuKeyEvent((Component)((Object)this.theBrowserConnection.getHelpWindow())));
        }
        return null;
    }

    protected void progressTracking(int n, boolean bl) {
        if (this.debug) {
            EventLog.instance().log("INFO: " + this.toString() + ": progressTracking: progress = " + n);
        }
        if (n == 100) {
            this.theBrowserConnection.clearHistoryWhenNecessary();
        }
    }

    public void sessionHistoryChanged(BrowserViewport browserViewport) {
        if (this.debug) {
            EventLog.instance().log("INFO: " + this.toString() + ": sessionHistoryChanged: event received");
        }
    }

    public boolean sessionHistorySaveConfirm(BrowserViewport browserViewport, boolean bl) {
        if (this.debug) {
            EventLog.instance().log("INFO: " + this.toString() + ": sessionHistorySaveConfirm: event received");
        }
        return true;
    }

    public String toString() {
        return "Help-ViewportListener";
    }
}

