/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.AttrImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CDATASectionImpl;
import org.w3c.dom.Comment;
import org.w3c.dom.CommentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMExceptionImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationImpl;
import org.w3c.dom.DeepNodeListImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentFragmentImpl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.DocumentTypeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.ElementDefinitionImpl;
import org.w3c.dom.ElementImpl;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityImpl;
import org.w3c.dom.EntityReference;
import org.w3c.dom.EntityReferenceImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeImpl;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.NotationImpl;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ProcessingInstructionImpl;
import org.w3c.dom.Text;
import org.w3c.dom.TextImpl;

public class DocumentImpl
extends NodeImpl
implements Document {
    protected Hashtable identifiers;
    protected ElementImpl docElement;
    protected DocumentTypeImpl docType;

    public static boolean isXMLName(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        if (!Character.isLetter(cArray[0]) && "_:".indexOf(cArray[0]) == -1) {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            char c2 = cArray[n2];
            int n3 = Character.getType(c2);
            if (!Character.isLetterOrDigit(c2) && ".-_:".indexOf(c2) == -1 && (n3 < 6 || n3 > 8 || c2 >= '\u06dd' && c2 <= '\u06de' || c2 >= '\u20dd' && c2 <= '\u20e0' || c2 >= '\u309b') && (n3 != 4 || c2 >= '\u02d0' && c2 <= '\u0559' || c2 >= '\u06e5' && c2 <= '\u06e6' || c2 >= '\u309b' && c2 <= '\u309c') && c2 != '\u00b7' && c2 != '\u0387') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Enumeration getIdentifiers() {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public void removeIdentifier(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    public Element getIdentifier(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2;
        Object object = null;
        short s2 = node.getNodeType();
        switch (s2) {
            case 1: {
                node2 = this.createElement(node.getNodeName());
                Object object2 = node.getAttributes();
                if (object2 != null) {
                    int n2 = 0;
                    while (n2 < object2.getLength()) {
                        node2.setAttributeNode((AttrImpl)this.importNode(object2.item(n2), true));
                        ++n2;
                    }
                }
                object = (NodeImpl)node2;
                break;
            }
            case 2: {
                object = (NodeImpl)((Object)this.createAttribute(node.getNodeName()));
                break;
            }
            case 3: {
                object = (NodeImpl)((Object)this.createTextNode(node.getNodeValue()));
                break;
            }
            case 4: {
                object = (NodeImpl)((Object)this.createCDATASection(node.getNodeValue()));
                break;
            }
            case 5: {
                object = (NodeImpl)((Object)this.createEntityReference(node.getNodeName()));
                bl = false;
                break;
            }
            case 6: {
                node2 = (Entity)node;
                Object object2 = (EntityImpl)this.createEntity(node.getNodeName());
                ((EntityImpl)object2).setPublicId(node2.getPublicId());
                ((EntityImpl)object2).setSystemId(node2.getSystemId());
                ((EntityImpl)object2).setNotationName(node2.getNotationName());
                object = object2;
                break;
            }
            case 7: {
                object = (ProcessingInstructionImpl)this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                object = (NodeImpl)((Object)this.createComment(node.getNodeValue()));
                break;
            }
            case 10: {
                int n3;
                node2 = (DocumentTypeImpl)this.createDocumentType(node.getNodeName());
                Object object2 = ((DocumentType)node).getEntities();
                NamedNodeMap namedNodeMap = ((DocumentTypeImpl)node2).getEntities();
                if (object2 != null) {
                    n3 = 0;
                    while (n3 < object2.getLength()) {
                        namedNodeMap.setNamedItem((EntityImpl)this.importNode(object2.item(n3), true));
                        ++n3;
                    }
                }
                object2 = ((DocumentType)node).getNotations();
                namedNodeMap = ((DocumentTypeImpl)node2).getNotations();
                if (object2 != null) {
                    n3 = 0;
                    while (n3 < object2.getLength()) {
                        namedNodeMap.setNamedItem((NotationImpl)this.importNode(object2.item(n3), true));
                        ++n3;
                    }
                }
                object = node2;
                break;
            }
            case 11: {
                object = (NodeImpl)((Object)this.createDocumentFragment());
                break;
            }
            case 12: {
                node2 = (Notation)node;
                Object object2 = (NotationImpl)this.createNotation(node.getNodeName());
                ((NotationImpl)object2).setPublicId(node2.getPublicId());
                ((NotationImpl)object2).setSystemId(node2.getSystemId());
                object = object2;
                break;
            }
            default: {
                throw new DOMExceptionImpl(3, null);
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                ((NodeImpl)object).appendChild(this.importNode(node2, true));
                node2 = node2.getNextSibling();
            }
        }
        return object;
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        return new ElementDefinitionImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        return new NotationImpl(this, string);
    }

    public Entity createEntity(String string) throws DOMException {
        return new EntityImpl(this, string);
    }

    public DocumentType createDocumentType(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new DocumentTypeImpl(this, string);
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public Element getDocumentElement() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public DocumentType getDoctype() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new EntityReferenceImpl(this, string);
    }

    public Element createElement(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ElementImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Attr createAttribute(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new AttrImpl(this, string);
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s2 = node.getNodeType();
        if (s2 == 1) {
            this.docElement = null;
        } else if (s2 == 10) {
            this.docType = null;
        }
        return node;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s2 = node.getNodeType();
        if (s2 == 1 && this.docElement != null || s2 == 10 && this.docType != null) {
            throw new DOMExceptionImpl(3, null);
        }
        super.insertBefore(node, node2);
        if (s2 == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s2 == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        if (bl) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            while (nodeImpl != null) {
                documentImpl.appendChild(documentImpl.importNode(nodeImpl, true));
                nodeImpl = nodeImpl.nextSibling;
            }
        }
        return documentImpl;
    }

    public String getNodeValue() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentImpl() {
        super(null, null, null);
        this.ownerDocument = this;
    }
}

