/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom;

import org.w3c.dom.Attr;
import org.w3c.dom.AttrImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMExceptionImpl;
import org.w3c.dom.DeepNodeListImpl;
import org.w3c.dom.DocumentImpl;
import org.w3c.dom.DocumentTypeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.ElementDefinitionImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NamedNodeMapImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeImpl;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends NodeImpl
implements Element {
    protected NamedNodeMapImpl attributes;

    protected void setupDefaultAttributes() {
        ElementDefinitionImpl elementDefinitionImpl;
        NamedNodeMapImpl namedNodeMapImpl = null;
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (documentTypeImpl != null && (elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName())) != null) {
            namedNodeMapImpl = (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
        }
        this.attributes = new NamedNodeMapImpl(this, namedNodeMapImpl);
    }

    protected void synchronizeData() {
        this.syncData = false;
        this.setupDefaultAttributes();
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        this.attributes.setReadOnly(bl, true);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (!(attr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(4, null);
        }
        AttrImpl attrImpl = (AttrImpl)attr;
        AttrImpl attrImpl2 = (AttrImpl)this.attributes.getNamedItem(attr.getName());
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
        return attrImpl2;
    }

    public void setAttribute(String string, String string2) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        AttrImpl attrImpl = (AttrImpl)this.getOwnerDocument().createAttribute(string);
        attrImpl.setNodeValue(string2);
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attrImpl = (AttrImpl)this.attributes.getNamedItem(attr.getName())) == attr) {
            this.attributes.removeNamedItem(attr.getName());
            attrImpl.owned = false;
            return attrImpl;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public void removeAttribute(String string) {
        AttrImpl attrImpl;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if ((attrImpl = (AttrImpl)this.attributes.getNamedItem(string)) != null) {
            attrImpl.owned = false;
            this.attributes.removeNamedItem(string);
        }
    }

    public void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node2 != null && node.getNodeType() == 3 && node2.getNodeType() == 3) {
                ((Text)node).appendData(node2.getNodeValue());
                this.removeChild(node2);
                node2 = node;
            } else if (node.getNodeType() == 1) {
                ((Element)node).normalize();
            }
            node = node2;
        }
    }

    public String getTagName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public Attr getAttributeNode(String string) {
        if (this.syncData) {
            this.synchronizeData();
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public String getAttribute(String string) {
        Attr attr;
        if (this.syncData) {
            this.synchronizeData();
        }
        return (attr = (Attr)this.attributes.getNamedItem(string)) == null ? "" : attr.getValue();
    }

    public String getValue() {
        return null;
    }

    public Node cloneNode(boolean bl) {
        if (this.syncData) {
            this.synchronizeData();
        }
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        elementImpl.attributes = this.attributes.cloneMap();
        return elementImpl;
    }

    public NamedNodeMap getAttributes() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.attributes;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public String getNodeValue() {
        return null;
    }

    public short getNodeType() {
        return 1;
    }

    public ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
        this.syncData = true;
    }
}

