/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.AttrImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMExceptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.ElementImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeImpl;

public class NamedNodeMapImpl
implements Serializable,
NamedNodeMap {
    protected boolean readOnly = false;
    protected int lastDefaultsChanges = -1;
    protected int changes;
    protected NamedNodeMapImpl defaults;
    protected ElementImpl element;
    protected Document ownerDocument;
    protected Vector nodes = new Vector();

    private int findNamePoint(String string) {
        this.reconcileDefaults();
        int n2 = 0;
        if (this.nodes != null) {
            int n3 = 0;
            int n4 = this.nodes.size() - 1;
            while (n3 <= n4) {
                n2 = (n3 + n4) / 2;
                int n5 = string.compareTo(((Node)this.nodes.elementAt(n2)).getNodeName());
                if (n5 == 0) {
                    return n2;
                }
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
        }
        return -1 - n2;
    }

    protected void reconcileDefaults() {
        if (this.defaults != null && this.lastDefaultsChanges != this.defaults.changes) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.nodes.size();
            int n5 = this.defaults.nodes.size();
            Attr attr = n4 == 0 ? null : (Attr)this.nodes.elementAt(0);
            Attr attr2 = n5 == 0 ? null : (Attr)this.defaults.nodes.elementAt(0);
            while (n2 < n4 && n3 < n5) {
                NodeImpl nodeImpl;
                attr = (Attr)this.nodes.elementAt(n2);
                attr2 = (Attr)this.defaults.nodes.elementAt(n3);
                int n6 = attr.getNodeName().compareTo(attr2.getNodeName());
                if (n6 == 0 && !attr.getSpecified()) {
                    nodeImpl = (NodeImpl)attr2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.setElementAt(nodeImpl, n2);
                    ++n2;
                    ++n3;
                    continue;
                }
                if (n6 > 0) {
                    nodeImpl = (NodeImpl)attr2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.insertElementAt(nodeImpl, n2);
                    ++n2;
                    ++n3;
                    continue;
                }
                if (!attr.getSpecified()) {
                    this.nodes.removeElementAt(n2);
                    continue;
                }
                ++n2;
            }
            while (n3 < n5) {
                attr2 = (Attr)this.defaults.nodes.elementAt(n3++);
                NodeImpl nodeImpl = (NodeImpl)attr2.cloneNode(true);
                nodeImpl.parentNode = this.element;
                this.nodes.addElement(nodeImpl);
            }
            this.lastDefaultsChanges = this.defaults.changes;
        }
    }

    void setReadOnly(boolean bl, boolean bl2) {
        this.readOnly = bl;
        if (bl2 && this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeImpl)enumeration.nextElement()).setReadOnly(bl, bl2);
            }
        }
    }

    public NamedNodeMapImpl cloneMap() {
        boolean bl = true;
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(this.ownerDocument, this.defaults);
        if (this.nodes != null) {
            namedNodeMapImpl.nodes = new Vector(this.nodes.size());
            int n2 = 0;
            while (n2 < this.nodes.size()) {
                NodeImpl nodeImpl = (NodeImpl)((Node)this.nodes.elementAt(n2)).cloneNode(bl);
                nodeImpl.parentNode = this.element;
                namedNodeMapImpl.nodes.addElement(nodeImpl);
                ++n2;
            }
        }
        namedNodeMapImpl.defaults = this.defaults;
        namedNodeMapImpl.lastDefaultsChanges = this.lastDefaultsChanges;
        return namedNodeMapImpl;
    }

    public Node removeNamedItem(String string) throws DOMException {
        Node node;
        int n2 = this.findNamePoint(string);
        if (n2 < 0) {
            throw new DOMExceptionImpl(8, null);
        }
        Node node2 = (Node)this.nodes.elementAt(n2);
        if (this.defaults != null && (node = this.defaults.getNamedItem(string)) != null) {
            NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
            nodeImpl.parentNode = this.element;
            this.nodes.setElementAt(nodeImpl, n2);
        } else {
            this.nodes.removeElementAt(n2);
        }
        if (this.element != null) {
            ((NodeImpl)node2).parentNode = null;
        }
        ++this.changes;
        return node2;
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMExceptionImpl(4, null);
        }
        if (node instanceof AttrImpl && ((AttrImpl)node).owned) {
            throw new DOMExceptionImpl(10, null);
        }
        int n2 = this.findNamePoint(node.getNodeName());
        Node node2 = null;
        if (n2 >= 0) {
            node2 = (Node)this.nodes.elementAt(n2);
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.setElementAt(node, n2);
        } else {
            n2 = -1 - n2;
            if (null == this.nodes) {
                this.nodes = new Vector();
            }
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.insertElementAt(node, n2);
        }
        if (this.element != null) {
            ((NodeImpl)node).parentNode = this.element;
        }
        ++this.changes;
        return node2;
    }

    public Node getNamedItem(String string) {
        int n2 = this.findNamePoint(string);
        return n2 < 0 ? null : (Node)this.nodes.elementAt(n2);
    }

    public Node item(int n2) {
        this.reconcileDefaults();
        return this.nodes != null && n2 < this.nodes.size() ? (Node)this.nodes.elementAt(n2) : null;
    }

    public int getLength() {
        this.reconcileDefaults();
        return this.nodes != null ? this.nodes.size() : 0;
    }

    protected NamedNodeMapImpl(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        this(elementImpl.getOwnerDocument(), namedNodeMapImpl);
        this.element = elementImpl;
    }

    protected NamedNodeMapImpl(Document document, NamedNodeMapImpl namedNodeMapImpl) {
        this.ownerDocument = document;
        this.defaults = namedNodeMapImpl;
    }
}

