/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMExceptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentImpl;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
implements Serializable,
Cloneable,
NodeList,
Node {
    protected static int[] kidOK = new int[13];
    int changes = 0;
    protected transient boolean syncData;
    protected transient boolean syncChildren;
    protected NodeImpl lastChild;
    protected NodeImpl firstChild;
    protected Object userData;
    protected boolean readOnly;
    protected String value;
    protected String name;
    protected NodeImpl nextSibling;
    protected NodeImpl previousSibling;
    protected NodeImpl parentNode;
    protected DocumentImpl ownerDocument;
    public static final short ELEMENT_DEFINITION_NODE = -1;

    static {
        NodeImpl.kidOK[9] = 1410;
        NodeImpl.kidOK[1] = 442;
        NodeImpl.kidOK[5] = 442;
        NodeImpl.kidOK[6] = 442;
        NodeImpl.kidOK[11] = 442;
        NodeImpl.kidOK[2] = 40;
        NodeImpl.kidOK[12] = 0;
        NodeImpl.kidOK[4] = 0;
        NodeImpl.kidOK[3] = 0;
        NodeImpl.kidOK[8] = 0;
        NodeImpl.kidOK[7] = 0;
        NodeImpl.kidOK[10] = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    protected static boolean isKidOK(Node node, Node node2) {
        return 0 != (kidOK[node.getNodeType()] & 1 << node2.getNodeType());
    }

    protected void changed() {
        ++this.changes;
        if (this.parentNode != null) {
            this.parentNode.changed();
        }
    }

    protected void synchronizeData() {
    }

    protected void synchronizeChildren() {
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public boolean getReadOnly() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.syncData) {
            this.synchronizeData();
        }
        this.readOnly = bl;
        if (bl2) {
            if (this.syncChildren) {
                this.synchronizeChildren();
            }
            NodeImpl nodeImpl = this.firstChild;
            while (nodeImpl != null) {
                if (!(nodeImpl instanceof EntityReference)) {
                    nodeImpl.setReadOnly(bl, true);
                }
                nodeImpl = nodeImpl.nextSibling;
            }
        }
    }

    public Node item(int n2) {
        NodeImpl nodeImpl = this.firstChild;
        int n3 = 0;
        while (n3 < n2 && nodeImpl != null) {
            nodeImpl = nodeImpl.nextSibling;
            ++n3;
        }
        return nodeImpl;
    }

    public int getLength() {
        int n2 = 0;
        NodeImpl nodeImpl = this.firstChild;
        while (nodeImpl != null) {
            ++n2;
            nodeImpl = nodeImpl.nextSibling;
        }
        return n2;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.insertBefore(node, node2);
        return this.removeChild(node2);
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (node != null && node.getParentNode() != this) {
            throw new DOMExceptionImpl(8, null);
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = nodeImpl.previousSibling;
        NodeImpl nodeImpl3 = nodeImpl.nextSibling;
        if (nodeImpl2 != null) {
            nodeImpl2.nextSibling = nodeImpl3;
        } else {
            this.firstChild = nodeImpl3;
        }
        if (nodeImpl3 != null) {
            nodeImpl3.previousSibling = nodeImpl2;
        } else {
            this.lastChild = nodeImpl2;
        }
        nodeImpl.parentNode = null;
        nodeImpl.nextSibling = null;
        nodeImpl.previousSibling = null;
        this.changed();
        return nodeImpl;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (!(node instanceof NodeImpl) || node.getOwnerDocument() != this.ownerDocument && (this.getNodeType() != 9 || node.getOwnerDocument() != (Document)((Object)this))) {
            throw new DOMExceptionImpl(4, null);
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        boolean bl = true;
        NodeImpl nodeImpl2 = this.parentNode;
        while (bl && nodeImpl2 != null) {
            bl = nodeImpl != nodeImpl2;
            nodeImpl2 = nodeImpl2.parentNode;
        }
        if (!bl) {
            throw new DOMExceptionImpl(3, null);
        }
        if (node2 != null && node2.getParentNode() != this) {
            throw new DOMExceptionImpl(8, null);
        }
        if (nodeImpl.getNodeType() == 11) {
            Node node3 = nodeImpl.getFirstChild();
            while (node3 != null) {
                if (!NodeImpl.isKidOK(this, node3)) {
                    throw new DOMExceptionImpl(3, null);
                }
                node3 = node3.getNextSibling();
            }
            while (nodeImpl.hasChildNodes()) {
                this.insertBefore(nodeImpl.getFirstChild(), node2);
            }
        } else {
            if (!NodeImpl.isKidOK(this, nodeImpl)) {
                throw new DOMExceptionImpl(3, null);
            }
            Node node4 = nodeImpl.getParentNode();
            if (node4 != null) {
                node4.removeChild(nodeImpl);
            }
            NodeImpl nodeImpl3 = node2 == null ? this.lastChild : ((NodeImpl)node2).previousSibling;
            nodeImpl.parentNode = this;
            nodeImpl.previousSibling = nodeImpl3;
            if (nodeImpl3 == null) {
                this.firstChild = nodeImpl;
            } else {
                nodeImpl3.nextSibling = nodeImpl;
            }
            nodeImpl.nextSibling = (NodeImpl)node2;
            if (node2 == null) {
                this.lastChild = nodeImpl;
            } else {
                ((NodeImpl)node2).previousSibling = nodeImpl;
            }
        }
        this.changed();
        return nodeImpl;
    }

    public Node getLastChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.lastChild;
    }

    public Node getFirstChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public NodeList getChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this;
    }

    public boolean hasChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        nodeImpl.readOnly = false;
        nodeImpl.parentNode = null;
        nodeImpl.previousSibling = null;
        nodeImpl.nextSibling = null;
        nodeImpl.firstChild = null;
        nodeImpl.lastChild = null;
        if (bl) {
            NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
            while (nodeImpl2 != null) {
                nodeImpl.appendChild(nodeImpl2.cloneNode(true));
                nodeImpl2 = (NodeImpl)nodeImpl2.getNextSibling();
            }
        }
        return nodeImpl;
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public String getNodeValue() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public void setNodeValue(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        this.value = string;
    }

    public String getNodeName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public abstract short getNodeType();

    public NodeImpl() {
    }

    protected NodeImpl(DocumentImpl documentImpl, String string, String string2) {
        this.ownerDocument = documentImpl != null ? documentImpl : (DocumentImpl)this;
        this.name = string;
        this.value = string2;
    }
}

