/*
 * Decompiled with CFR 0.152.
 */
package espial.browser.navigation;

import espial.browser.Quirks;
import espial.browser.env.BrowserEnv;
import espial.browser.env.HotKey;
import espial.browser.navigation.DefaultSearchStrategy;
import espial.browser.navigation.NavigatableObject;
import espial.browser.navigation.SearchStrategy;
import espial.browser.navigation.TwoDNavigationController;
import espial.browser.plugins.BasicPluginEvent;
import espial.browser.plugins.Plugin;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;

public class HTMLTwoDNavigationController
implements KeyListener,
MouseListener,
TwoDNavigationController {
    protected Hashtable keyMap;
    private SearchStrategy a;

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void keyTyped(KeyEvent keyEvent) {
        HotKey hotKey = BrowserEnv.getInstance().isRegisteredHotKey(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getModifiers(), keyEvent.getID());
        if (hotKey != null) {
            keyEvent.consume();
            Plugin plugin = this.a.getCurrentPlugin();
            if (plugin != null) {
                plugin.getPluginOwner().pluginEvent(plugin, new BasicPluginEvent(9, hotKey));
            }
        }
    }

    public final void keyReleased(KeyEvent keyEvent) {
        Object object;
        HotKey hotKey = BrowserEnv.getInstance().isRegisteredHotKey(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getModifiers(), keyEvent.getID());
        if (hotKey != null) {
            keyEvent.consume();
            object = this.a.getCurrentPlugin();
            if (object != null) {
                ((Plugin)object).getPluginOwner().pluginEvent((Plugin)object, new BasicPluginEvent(9, hotKey));
            }
        }
        if (Quirks.PlatformIsDeviceTop) {
            switch (keyEvent.getKeyCode()) {
                case 10: 
                case 27: {
                    object = this.a.getCurrentNavigatable();
                    if (object == null) break;
                    object.activate();
                }
            }
        }
    }

    public final void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getWhen() == 5L) {
            return;
        }
        NavigatableObject navigatableObject = this.a.getCurrentNavigatable();
        if (navigatableObject == null) {
            navigatableObject = this.a.getFirstNavigatableObject();
        }
        int n = keyEvent.getKeyCode();
        int n2 = this.getKeyMapping(n);
        HotKey hotKey = BrowserEnv.getInstance().isRegisteredHotKey(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getModifiers(), keyEvent.getID());
        if (hotKey != null) {
            keyEvent.consume();
            Plugin plugin = this.a.getCurrentPlugin();
            if (plugin == null) {
                this.a.getFirstNavigatableObject();
                plugin = this.a.getCurrentPlugin();
            }
            plugin.getPluginOwner().pluginEvent(plugin, new BasicPluginEvent(8, new Integer(keyEvent.getKeyCode())));
            plugin.getPluginOwner().pluginEvent(plugin, new BasicPluginEvent(9, hotKey));
            return;
        }
        if (navigatableObject != null) {
            boolean bl = false;
            bl = n2 != -1 ? this.navigate(n2, keyEvent) : this.navigate(-9000012, keyEvent);
            if (!bl && n2 != -1) {
                navigatableObject.releaseFocus();
                this.navigate(n2, keyEvent);
            }
        }
    }

    public void clearKeyMappings() {
        this.keyMap = new Hashtable();
    }

    public int getKeyMapping(int n) {
        Integer n2 = (Integer)this.keyMap.get(new Integer(n));
        if (this.keyMap != null && n2 != null) {
            return n2;
        }
        return -1;
    }

    public void setKeyMapping(int n, int n2) {
        if (this.keyMap == null) {
            this.keyMap = new Hashtable();
        }
        this.keyMap.put(new Integer(n), new Integer(n2));
    }

    public void registerListener(Component component) {
        component.addKeyListener(this);
        component.addMouseListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean navigate(int n, KeyEvent keyEvent) {
        NavigatableObject navigatableObject = null;
        Plugin plugin = this.a.getCurrentPlugin();
        NavigatableObject navigatableObject2 = this.a.getCurrentNavigatable();
        boolean bl = false;
        if (navigatableObject2 != null) {
            boolean bl2 = navigatableObject2.navigate(n, keyEvent);
            if (bl2) return true;
            navigatableObject = this.a.getNavigatable(n, null);
            if (keyEvent != null) {
                switch (keyEvent.getKeyCode()) {
                    case 9: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        keyEvent.consume();
                    }
                }
            }
            if (navigatableObject != null && navigatableObject != navigatableObject2) {
                navigatableObject2.releaseFocus();
                this.a.setCurrentNavigatable(navigatableObject);
                return true;
            }
        } else {
            navigatableObject = this.a.getNavigatable(n, null);
            plugin = this.a.getCurrentPlugin();
        }
        if (plugin == null) {
            return false;
        }
        if (navigatableObject2 != null && (navigatableObject != null || plugin != this.a.getCurrentPlugin()) && navigatableObject2 != navigatableObject) {
            navigatableObject2.releaseFocus();
        }
        if (navigatableObject == null) return true;
        this.a.setCurrentNavigatable(navigatableObject);
        return true;
    }

    public boolean navigateKey(int n, KeyEvent keyEvent) {
        if (n == 9 && keyEvent.isShiftDown()) {
            return this.navigate(-9000014, keyEvent);
        }
        int n2 = this.getKeyMapping(n);
        if (n2 != -1) {
            return this.navigate(n2, keyEvent);
        }
        return this.navigate(-9000012, keyEvent);
    }

    public SearchStrategy getSearchStrategy() {
        return this.a;
    }

    public void setSearchStrategy(SearchStrategy searchStrategy) {
        this.a = searchStrategy;
    }

    public void reset() {
        this.a.reset();
    }

    public HTMLTwoDNavigationController() {
        this.setKeyMapping(9, -9000013);
        this.setKeyMapping(40, -9000003);
        this.setKeyMapping(38, -9000002);
        this.setKeyMapping(37, -9000000);
        this.setKeyMapping(39, -9000001);
        this.setKeyMapping(10, -9000010);
        this.setKeyMapping(27, -9100011);
        this.setKeyMapping(33, -9000008);
        this.setKeyMapping(34, -9000009);
        this.setKeyMapping(36, -9000006);
        this.setKeyMapping(35, -9000007);
        this.setSearchStrategy(new DefaultSearchStrategy());
    }
}

