/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

class InterpretedFunction
extends NativeFunction {
    InterpreterData itsData;
    Scriptable itsClosure;

    InterpretedFunction(InterpreterData interpreterData, Context context) {
        this.itsData = interpreterData;
        this.init(context);
    }

    void init(Context context) {
        this.names = new String[this.itsData.itsVariableTable.size() + 1];
        this.names[0] = this.itsData.itsName;
        int n = 0;
        while (n < this.itsData.itsVariableTable.size()) {
            this.names[n + 1] = this.itsData.itsVariableTable.getName(n);
            ++n;
        }
        this.argCount = (short)this.itsData.itsVariableTable.getParameterCount();
        this.source = this.itsData.itsSource;
        this.nestedFunctions = this.itsData.itsNestedFunctions;
        if (context != null) {
            this.version = (short)context.getLanguageVersion();
        }
    }

    InterpretedFunction(InterpretedFunction interpretedFunction, Scriptable scriptable, Context context) {
        this.itsData = interpretedFunction.itsData;
        this.itsClosure = scriptable;
        this.init(context);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.itsClosure != null) {
            scriptable = this.itsClosure;
        } else if (!this.itsData.itsUseDynamicScope) {
            scriptable = this.getParentScope();
        }
        if (this.itsData.itsNeedsActivation) {
            scriptable = ScriptRuntime.initVarObj(context, scriptable, this, scriptable2, objectArray);
        }
        return Interpreter.interpret(context, scriptable, scriptable2, objectArray, this.itsData);
    }
}

