/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends ScriptableObject {
    NativeCall caller;
    NativeFunction funObj;
    Scriptable thisObj;
    Object[] originalArgs;
    public int debugPC;

    NativeCall(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        this(context, scriptable, nativeFunction, scriptable2);
        this.originalArgs = objectArray;
        String[] stringArray = nativeFunction.names;
        if (stringArray != null) {
            int n = 0;
            while (n < nativeFunction.argCount) {
                Scriptable scriptable3 = n < objectArray.length ? objectArray[n] : Undefined.instance;
                super.put(stringArray[n + 1], (Scriptable)this, (Object)scriptable3);
                ++n;
            }
        }
        super.put("arguments", (Scriptable)this, (Object)new Arguments(this));
    }

    NativeCall(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2) {
        this.funObj = nativeFunction;
        this.thisObj = scriptable2;
        this.setParentScope(scriptable);
        this.caller = context.currentActivation;
        context.currentActivation = this;
    }

    public NativeCall() {
    }

    public String getClassName() {
        return "Call";
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        if (!bl) {
            Object[] objectArray2 = new Object[]{"Call"};
            throw Context.reportRuntimeError(Context.getMessage("msg.only.from.new", objectArray2));
        }
        ScriptRuntime.checkDeprecated(context, "Call");
        NativeCall nativeCall = new NativeCall();
        nativeCall.setPrototype(ScriptableObject.getObjectPrototype(function));
        return nativeCall;
    }

    NativeCall getActivation(NativeFunction nativeFunction) {
        NativeCall nativeCall = this;
        do {
            if (nativeCall.funObj != nativeFunction) continue;
            return nativeCall;
        } while ((nativeCall = nativeCall.caller) != null);
        return null;
    }

    public NativeFunction getFunctionObject() {
        return this.funObj;
    }

    public Object[] getOriginalArguments() {
        return this.originalArgs;
    }

    public NativeCall getCaller() {
        return this.caller;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }
}

