/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeDate
extends ScriptableObject {
    private static final double HalfTimeDomain = 8.64E15;
    private static final double HoursPerDay = 24.0;
    private static final double MinutesPerHour = 60.0;
    private static final double SecondsPerMinute = 60.0;
    private static final double msPerSecond = 1000.0;
    private static final double MinutesPerDay = 1440.0;
    private static final double SecondsPerDay = 86400.0;
    private static final double SecondsPerHour = 3600.0;
    private static final double msPerDay = 8.64E7;
    private static final double msPerHour = 3600000.0;
    private static final double msPerMinute = 60000.0;
    private static final boolean TZO_WORKAROUND = false;
    private static final int MAXARGS = 7;
    private static String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static int[] ttb = new int[]{-1, -2, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
    private static String js_NaN_date_str = "Invalid Date";
    private static String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final TimeZone thisTimeZone = TimeZone.getDefault();
    private static final double LocalTZA = thisTimeZone.getRawOffset();
    private static DateFormat timeZoneFormatter;
    private static final DateFormat localeDateFormatter;
    private double date;
    static /* synthetic */ Class class$java$lang$String;

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) throws PropertyException {
        ((ScriptableObject)scriptable2).defineProperty("toGMTString", scriptable2.get("toUTCString", scriptable2), 2);
        String[] stringArray = new String[]{"setSeconds", "setUTCSeconds", "setMinutes", "setUTCMinutes", "setHours", "setUTCHours", "setMonth", "setUTCMonth", "setFullYear", "setUTCFullYear"};
        short[] sArray = new short[]{2, 2, 3, 3, 4, 4, 2, 2, 3, 3};
        int n = 0;
        while (n < stringArray.length) {
            Object object = scriptable2.get(stringArray[n], scriptable2);
            ((FunctionObject)object).setLength(sArray[n]);
            ++n;
        }
        ((NativeDate)scriptable2).date = ScriptRuntime.NaN;
    }

    public String getClassName() {
        return "Date";
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null) {
            clazz = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(clazz);
    }

    private static boolean isFinite(double d) {
        return d == d && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY;
    }

    private static double Day(double d) {
        return Math.floor(d / 8.64E7);
    }

    private static double TimeWithinDay(double d) {
        double d2 = d % 8.64E7;
        if (d2 < 0.0) {
            d2 += 8.64E7;
        }
        return d2;
    }

    private static int DaysInYear(int n) {
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            return 366;
        }
        return 365;
    }

    private static double DayFromYear(double d) {
        return 365.0 * (d - 1970.0) + Math.floor((d - 1969.0) / 4.0) - Math.floor((d - 1901.0) / 100.0) + Math.floor((d - 1601.0) / 400.0);
    }

    private static double TimeFromYear(double d) {
        return NativeDate.DayFromYear(d) * 8.64E7;
    }

    private static int YearFromTime(double d) {
        int n;
        int n2 = (int)Math.floor(d / 8.64E7 / 366.0) + 1970;
        int n3 = (int)Math.floor(d / 8.64E7 / 365.0) + 1970;
        if (n3 < n2) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        while (n3 > n2) {
            int n4 = (n3 + n2) / 2;
            if (NativeDate.TimeFromYear(n4) > d) {
                n3 = n4 - 1;
                continue;
            }
            if (!(NativeDate.TimeFromYear(n4) <= d)) continue;
            n = n4 + 1;
            if (NativeDate.TimeFromYear(n) > d) {
                return n4;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    private static boolean InLeapYear(double d) {
        return NativeDate.DaysInYear(NativeDate.YearFromTime(d)) == 366;
    }

    private static int DayWithinYear(double d) {
        int n = NativeDate.YearFromTime(d);
        return (int)(NativeDate.Day(d) - NativeDate.DayFromYear(n));
    }

    private static double DayFromMonth(int n, boolean bl) {
        double[] dArray = new double[]{0.0, 31.0, 59.0, 90.0, 120.0, 151.0, 181.0, 212.0, 243.0, 273.0, 304.0, 334.0};
        double[] dArray2 = new double[]{0.0, 31.0, 60.0, 91.0, 121.0, 152.0, 182.0, 213.0, 244.0, 274.0, 305.0, 335.0};
        if (bl) {
            return dArray2[n];
        }
        return dArray[n];
    }

    private static int MonthFromTime(double d) {
        int n = NativeDate.DayWithinYear(d);
        int n2 = 31;
        if (n < 31) {
            return 0;
        }
        n2 = NativeDate.InLeapYear(d) ? (n2 += 29) : (n2 += 28);
        if (n < n2) {
            return 1;
        }
        if (n < (n2 += 31)) {
            return 2;
        }
        if (n < (n2 += 30)) {
            return 3;
        }
        if (n < (n2 += 31)) {
            return 4;
        }
        if (n < (n2 += 30)) {
            return 5;
        }
        if (n < (n2 += 31)) {
            return 6;
        }
        if (n < (n2 += 31)) {
            return 7;
        }
        if (n < (n2 += 30)) {
            return 8;
        }
        if (n < (n2 += 31)) {
            return 9;
        }
        if (n < (n2 += 30)) {
            return 10;
        }
        return 11;
    }

    private static int DateFromTime(double d) {
        int n = NativeDate.DayWithinYear(d);
        int n2 = 30;
        if (n <= 30) {
            return n + 1;
        }
        int n3 = n2;
        n2 = NativeDate.InLeapYear(d) ? (n2 += 29) : (n2 += 28);
        if (n <= n2) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        return n - n3;
    }

    private static int WeekDay(double d) {
        double d2 = NativeDate.Day(d) + 4.0;
        if ((d2 %= 7.0) < 0.0) {
            d2 += 7.0;
        }
        return (int)d2;
    }

    private static double Now() {
        return System.currentTimeMillis();
    }

    private static double DaylightSavingTA(double d) {
        Date date = new Date((long)d);
        if (thisTimeZone.inDaylightTime(date)) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static double LocalTime(double d) {
        return d + LocalTZA + NativeDate.DaylightSavingTA(d);
    }

    private static double internalUTC(double d) {
        return d - LocalTZA - NativeDate.DaylightSavingTA(d - LocalTZA);
    }

    private static int HourFromTime(double d) {
        double d2 = Math.floor(d / 3600000.0) % 24.0;
        if (d2 < 0.0) {
            d2 += 24.0;
        }
        return (int)d2;
    }

    private static int MinFromTime(double d) {
        double d2 = Math.floor(d / 60000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int SecFromTime(double d) {
        double d2 = Math.floor(d / 1000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int msFromTime(double d) {
        double d2 = d % 1000.0;
        if (d2 < 0.0) {
            d2 += 1000.0;
        }
        return (int)d2;
    }

    private static double MakeTime(double d, double d2, double d3, double d4) {
        return ((d * 60.0 + d2) * 60.0 + d3) * 1000.0 + d4;
    }

    private static double MakeDay(double d, double d2, double d3) {
        d += Math.floor(d2 / 12.0);
        if ((d2 %= 12.0) < 0.0) {
            d2 += 12.0;
        }
        boolean bl = NativeDate.DaysInYear((int)d) == 366;
        double d4 = Math.floor(NativeDate.TimeFromYear(d) / 8.64E7);
        double d5 = NativeDate.DayFromMonth((int)d2, bl);
        double d6 = d4 + d5 + d3 - 1.0;
        return d6;
    }

    private static double MakeDate(double d, double d2) {
        return d * 8.64E7 + d2;
    }

    private static double TimeClip(double d) {
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Math.abs(d) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d > 0.0) {
            return Math.floor(d + 0.0);
        }
        return Math.ceil(d + 0.0);
    }

    private static double date_msecFromDate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = NativeDate.MakeDay(d, d2, d3);
        double d9 = NativeDate.MakeTime(d4, d5, d6, d7);
        double d10 = NativeDate.MakeDate(d8, d9);
        return d10;
    }

    public static double jsStaticFunction_UTC(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d;
        double[] dArray = new double[7];
        int n = 0;
        while (n < 7) {
            if (n < objectArray.length) {
                d = ScriptRuntime.toNumber(objectArray[n]);
                if (d != d || Double.isInfinite(d)) {
                    return ScriptRuntime.NaN;
                }
                dArray[n] = ScriptRuntime.toInteger(objectArray[n]);
            } else {
                dArray[n] = 0.0;
            }
            ++n;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        if (dArray[2] < 1.0) {
            dArray[2] = 1.0;
        }
        d = NativeDate.date_msecFromDate(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
        d = NativeDate.TimeClip(d);
        return d;
    }

    private static boolean date_regionMatches(String string, int n, String string2, int n2, int n3) {
        boolean bl = false;
        int n4 = string.length();
        int n5 = string2.length();
        while (n3 > 0 && n < n4 && n2 < n5) {
            if (Character.toLowerCase(string.charAt(n)) != Character.toLowerCase(string2.charAt(n2))) break;
            ++n;
            ++n2;
            --n3;
        }
        if (n3 == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double date_parseString(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        char c = '\u0000';
        char c2 = '\u0000';
        int n7 = 0;
        int n8 = -1;
        double d = -1.0;
        char c3 = '\u0000';
        int n9 = 0;
        boolean bl = false;
        if (string == null) {
            return ScriptRuntime.NaN;
        }
        n9 = string.length();
        block0: while (n7 < n9) {
            int n10;
            c = string.charAt(n7);
            ++n7;
            if (c <= ' ' || c == ',' || c == '-') {
                if (n7 >= n9) continue;
                c2 = string.charAt(n7);
                if (c != '-' || '0' > c2 || c2 > '9') continue;
                c3 = c;
                continue;
            }
            if (c == '(') {
                n10 = 1;
                while (n7 < n9) {
                    c = string.charAt(n7);
                    ++n7;
                    if (c == '(') {
                        ++n10;
                        continue;
                    }
                    if (c == ')' && --n10 <= 0) continue block0;
                }
                continue;
            }
            if ('0' <= c && c <= '9') {
                n8 = c - 48;
                while (n7 < n9 && '0' <= (c = string.charAt(n7)) && c <= '9') {
                    n8 = n8 * 10 + c - 48;
                    ++n7;
                }
                if (c3 == '+' || c3 == '-') {
                    bl = true;
                    n8 = n8 < 24 ? (n8 *= 60) : n8 % 100 + n8 / 100 * 60;
                    if (c3 == '+') {
                        n8 = -n8;
                    }
                    if (d != 0.0 && d != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    d = n8;
                } else if (n8 >= 70 || c3 == '/' && n2 >= 0 && n3 >= 0 && n < 0) {
                    if (n >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c > ' ' && c != ',' && c != '/' && n7 < n9) return ScriptRuntime.NaN;
                    n = n8 < 100 ? n8 + 1900 : n8;
                } else if (c == ':') {
                    if (n4 < 0) {
                        n4 = n8;
                    } else {
                        if (n5 >= 0) return ScriptRuntime.NaN;
                        n5 = n8;
                    }
                } else if (c == '/') {
                    if (n2 < 0) {
                        n2 = n8 - 1;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                } else {
                    if (n7 < n9 && c != ',' && c > ' ' && c != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (bl && n8 < 60) {
                        d = d < 0.0 ? (d -= (double)n8) : (d += (double)n8);
                    } else if (n4 >= 0 && n5 < 0) {
                        n5 = n8;
                    } else if (n5 >= 0 && n6 < 0) {
                        n6 = n8;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                }
                c3 = '\u0000';
                continue;
            }
            if (c == '/' || c == ':' || c == '+' || c == '-') {
                c3 = c;
                continue;
            }
            n10 = n7 - 1;
            while (n7 < n9) {
                c = string.charAt(n7);
                if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) break;
                ++n7;
            }
            if (n7 <= n10 + 1) {
                return ScriptRuntime.NaN;
            }
            int n11 = wtb.length;
            while (--n11 >= 0) {
                if (!NativeDate.date_regionMatches(wtb[n11], 0, string, n10, n7 - n10)) continue;
                int n12 = ttb[n11];
                if (n12 == 0) break;
                if (n12 < 0) {
                    if (n4 > 12 || n4 < 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (n12 == -1 && n4 == 12) {
                        n4 = 0;
                        break;
                    }
                    if (n12 != -2 || n4 == 12) break;
                    n4 += 12;
                    break;
                }
                if (n12 <= 13) {
                    if (n2 >= 0) return ScriptRuntime.NaN;
                    n2 = n12 - 2;
                    break;
                }
                d = n12 - 10000;
                break;
            }
            if (n11 < 0) {
                return ScriptRuntime.NaN;
            }
            c3 = '\u0000';
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            return ScriptRuntime.NaN;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (d == -1.0) {
            double d2 = NativeDate.date_msecFromDate(n, n2, n3, n4, n5, n6, 0.0);
            return NativeDate.internalUTC(d2);
        }
        double d3 = NativeDate.date_msecFromDate(n, n2, n3, n4, n5, n6, 0.0);
        return d3 += d * 60000.0;
    }

    public static double jsStaticFunction_parse(String string) {
        return NativeDate.date_parseString(string);
    }

    private static String date_format(double d) {
        StringBuffer stringBuffer = new StringBuffer(60);
        double d2 = NativeDate.LocalTime(d);
        int n = (int)Math.floor((LocalTZA + NativeDate.DaylightSavingTA(d)) / 60000.0);
        int n2 = n / 60 * 100 + n % 60;
        String string = Integer.toString(NativeDate.DateFromTime(d2));
        String string2 = Integer.toString(NativeDate.HourFromTime(d2));
        String string3 = Integer.toString(NativeDate.MinFromTime(d2));
        String string4 = Integer.toString(NativeDate.SecFromTime(d2));
        String string5 = Integer.toString(n2 > 0 ? n2 : -n2);
        int n3 = NativeDate.YearFromTime(d2);
        String string6 = Integer.toString(n3 > 0 ? n3 : -n3);
        stringBuffer.append(days[NativeDate.WeekDay(d2)]);
        stringBuffer.append(" ");
        stringBuffer.append(months[NativeDate.MonthFromTime(d2)]);
        if (string.length() == 1) {
            stringBuffer.append(" 0");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        if (string2.length() == 1) {
            stringBuffer.append(" 0");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string2);
        if (string3.length() == 1) {
            stringBuffer.append(":0");
        } else {
            stringBuffer.append(":");
        }
        stringBuffer.append(string3);
        if (string4.length() == 1) {
            stringBuffer.append(":0");
        } else {
            stringBuffer.append(":");
        }
        stringBuffer.append(string4);
        if (n2 > 0) {
            stringBuffer.append(" GMT+");
        } else {
            stringBuffer.append(" GMT-");
        }
        int n4 = string5.length();
        while (n4 < 4) {
            stringBuffer.append("0");
            ++n4;
        }
        stringBuffer.append(string5);
        if (timeZoneFormatter != null) {
            stringBuffer.append(" (");
            Date date = new Date((long)d);
            stringBuffer.append(timeZoneFormatter.format(date));
            stringBuffer.append(") ");
        } else {
            stringBuffer.append(" ");
        }
        if (n3 < 0) {
            stringBuffer.append("-");
        }
        n4 = string6.length();
        while (n4 < 4) {
            stringBuffer.append("0");
            ++n4;
        }
        stringBuffer.append(string6);
        return stringBuffer.toString();
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        if (!bl) {
            return NativeDate.date_format(NativeDate.Now());
        }
        NativeDate nativeDate = new NativeDate();
        if (objectArray.length == 0) {
            nativeDate.date = NativeDate.Now();
            return nativeDate;
        }
        if (objectArray.length == 1) {
            double d;
            if (!(objectArray[0] instanceof String)) {
                d = ScriptRuntime.toNumber(objectArray[0]);
            } else {
                String string = (String)objectArray[0];
                d = NativeDate.date_parseString(string);
            }
            nativeDate.date = NativeDate.TimeClip(d);
            return nativeDate;
        }
        double[] dArray = new double[7];
        int n = 0;
        while (n < 7) {
            if (n < objectArray.length) {
                double d = ScriptRuntime.toNumber(objectArray[n]);
                if (d != d || Double.isInfinite(d)) {
                    nativeDate.date = ScriptRuntime.NaN;
                    return nativeDate;
                }
                dArray[n] = ScriptRuntime.toInteger(objectArray[n]);
            } else {
                dArray[n] = 0.0;
            }
            ++n;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        if (dArray[2] < 1.0) {
            dArray[2] = 1.0;
        }
        double d = NativeDate.MakeDay(dArray[0], dArray[1], dArray[2]);
        double d2 = NativeDate.MakeTime(dArray[3], dArray[4], dArray[5], dArray[6]);
        d2 = NativeDate.MakeDate(d, d2);
        d2 = NativeDate.internalUTC(d2);
        nativeDate.date = NativeDate.TimeClip(d2);
        return nativeDate;
    }

    public String jsFunction_toString() {
        if (this.date != this.date) {
            return js_NaN_date_str;
        }
        return NativeDate.date_format(this.date);
    }

    public String jsFunction_toLocaleString() {
        if (this.date != this.date) {
            return js_NaN_date_str;
        }
        Date date = new Date((long)this.date);
        return localeDateFormatter.format(date);
    }

    public String jsFunction_toUTCString() {
        if (this.date != this.date) {
            return js_NaN_date_str;
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        String string = Integer.toString(NativeDate.DateFromTime(this.date));
        String string2 = Integer.toString(NativeDate.HourFromTime(this.date));
        String string3 = Integer.toString(NativeDate.MinFromTime(this.date));
        String string4 = Integer.toString(NativeDate.SecFromTime(this.date));
        int n = NativeDate.YearFromTime(this.date);
        String string5 = Integer.toString(n > 0 ? n : -n);
        stringBuffer.append(days[NativeDate.WeekDay(this.date)]);
        stringBuffer.append(", ");
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(months[NativeDate.MonthFromTime(this.date)]);
        if (n < 0) {
            stringBuffer.append(" -");
        } else {
            stringBuffer.append(" ");
        }
        int n2 = string5.length();
        while (n2 < 4) {
            stringBuffer.append("0");
            ++n2;
        }
        stringBuffer.append(string5);
        if (string2.length() == 1) {
            stringBuffer.append(" 0");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string2);
        if (string3.length() == 1) {
            stringBuffer.append(":0");
        } else {
            stringBuffer.append(":");
        }
        stringBuffer.append(string3);
        if (string4.length() == 1) {
            stringBuffer.append(":0");
        } else {
            stringBuffer.append(":");
        }
        stringBuffer.append(string4);
        stringBuffer.append(" GMT");
        return stringBuffer.toString();
    }

    public double jsFunction_valueOf() {
        return this.date;
    }

    public double jsFunction_getTime() {
        return this.date;
    }

    public double jsFunction_getYear() {
        if (this.date != this.date) {
            return this.date;
        }
        int n = NativeDate.YearFromTime(NativeDate.LocalTime(this.date));
        Context context = Context.getContext();
        int n2 = context.getLanguageVersion();
        if (n2 == 100 || n2 == 110 || n2 == 120) {
            if (n >= 1900 && n < 2000) {
                n -= 1900;
            }
        } else {
            n -= 1900;
        }
        return n;
    }

    public double jsFunction_getFullYear() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.YearFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCFullYear() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.YearFromTime(this.date);
    }

    public double jsFunction_getMonth() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.MonthFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCMonth() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.MonthFromTime(this.date);
    }

    public double jsFunction_getDate() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.DateFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCDate() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.DateFromTime(this.date);
    }

    public double jsFunction_getDay() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.WeekDay(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCDay() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.WeekDay(this.date);
    }

    public double jsFunction_getHours() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.HourFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCHours() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.HourFromTime(this.date);
    }

    public double jsFunction_getMinutes() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.MinFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCMinutes() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.MinFromTime(this.date);
    }

    public double jsFunction_getSeconds() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.SecFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCSeconds() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.SecFromTime(this.date);
    }

    public double jsFunction_getMilliseconds() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.msFromTime(NativeDate.LocalTime(this.date));
    }

    public double jsFunction_getUTCMilliseconds() {
        if (this.date != this.date) {
            return this.date;
        }
        return NativeDate.msFromTime(this.date);
    }

    public double jsFunction_getTimezoneOffset() {
        if (this.date != this.date) {
            return this.date;
        }
        return (this.date - NativeDate.LocalTime(this.date)) / 60000.0;
    }

    public double jsFunction_setTime(double d) {
        this.date = NativeDate.TimeClip(d);
        return this.date;
    }

    private static NativeDate checkInstance(Scriptable scriptable, Function function) {
        if (scriptable == null || !(scriptable instanceof NativeDate)) {
            Context context = Context.getCurrentContext();
            Object[] objectArray = new Object[]{((NativeFunction)function).names[0]};
            String string = Context.getMessage("msg.incompat.call", objectArray);
            throw NativeGlobal.constructError(context, "TypeError", string, function);
        }
        return (NativeDate)scriptable;
    }

    private static double makeTime(Scriptable scriptable, Object[] objectArray, int n, boolean bl, Function function) {
        double[] dArray = new double[4];
        NativeDate nativeDate = NativeDate.checkInstance(scriptable, function);
        double d = nativeDate.date;
        if (d != d) {
            return d;
        }
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        int n2 = 0;
        while (n2 < objectArray.length && n2 < n) {
            dArray[n2] = ScriptRuntime.toNumber(objectArray[n2]);
            if (dArray[n2] != dArray[n2] || Double.isInfinite(dArray[n2])) {
                nativeDate.date = ScriptRuntime.NaN;
                return nativeDate.date;
            }
            dArray[n2] = ScriptRuntime.toInteger(dArray[n2]);
            ++n2;
        }
        double d2 = bl ? NativeDate.LocalTime(d) : d;
        n2 = 0;
        int n3 = objectArray.length;
        double d3 = n >= 4 && n2 < n3 ? dArray[n2++] : (double)NativeDate.HourFromTime(d2);
        double d4 = n >= 3 && n2 < n3 ? dArray[n2++] : (double)NativeDate.MinFromTime(d2);
        double d5 = n >= 2 && n2 < n3 ? dArray[n2++] : (double)NativeDate.SecFromTime(d2);
        double d6 = n >= 1 && n2 < n3 ? dArray[n2++] : (double)NativeDate.msFromTime(d2);
        double d7 = NativeDate.MakeTime(d3, d4, d5, d6);
        double d8 = NativeDate.MakeDate(NativeDate.Day(d2), d7);
        if (bl) {
            d8 = NativeDate.internalUTC(d8);
        }
        nativeDate.date = d = NativeDate.TimeClip(d8);
        return d;
    }

    public static double jsFunction_setMilliseconds(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 1, true, function);
    }

    public static double jsFunction_setUTCMilliseconds(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 1, false, function);
    }

    public static double jsFunction_setSeconds(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 2, true, function);
    }

    public static double jsFunction_setUTCSeconds(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 2, false, function);
    }

    public static double jsFunction_setMinutes(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 3, true, function);
    }

    public static double jsFunction_setUTCMinutes(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 3, false, function);
    }

    public static double jsFunction_setHours(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 4, true, function);
    }

    public static double jsFunction_setUTCHours(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeTime(scriptable, objectArray, 4, false, function);
    }

    private static double makeDate(Scriptable scriptable, Object[] objectArray, int n, boolean bl, Function function) {
        double d;
        double[] dArray = new double[3];
        NativeDate nativeDate = NativeDate.checkInstance(scriptable, function);
        double d2 = nativeDate.date;
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        int n2 = 0;
        while (n2 < objectArray.length && n2 < n) {
            dArray[n2] = ScriptRuntime.toNumber(objectArray[n2]);
            if (dArray[n2] != dArray[n2] || Double.isInfinite(dArray[n2])) {
                nativeDate.date = ScriptRuntime.NaN;
                return nativeDate.date;
            }
            dArray[n2] = ScriptRuntime.toInteger(dArray[n2]);
            ++n2;
        }
        if (d2 != d2) {
            if (objectArray.length < 3) {
                return ScriptRuntime.NaN;
            }
            d = 0.0;
        } else {
            d = bl ? NativeDate.LocalTime(d2) : d2;
        }
        n2 = 0;
        int n3 = objectArray.length;
        double d3 = n >= 3 && n2 < n3 ? dArray[n2++] : (double)NativeDate.YearFromTime(d);
        double d4 = n >= 2 && n2 < n3 ? dArray[n2++] : (double)NativeDate.MonthFromTime(d);
        double d5 = n >= 1 && n2 < n3 ? dArray[n2++] : (double)NativeDate.DateFromTime(d);
        d5 = NativeDate.MakeDay(d3, d4, d5);
        double d6 = NativeDate.MakeDate(d5, NativeDate.TimeWithinDay(d));
        if (bl) {
            d6 = NativeDate.internalUTC(d6);
        }
        nativeDate.date = d2 = NativeDate.TimeClip(d6);
        return d2;
    }

    public static double jsFunction_setDate(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeDate(scriptable, objectArray, 1, true, function);
    }

    public static double jsFunction_setUTCDate(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeDate(scriptable, objectArray, 1, false, function);
    }

    public static double jsFunction_setMonth(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeDate(scriptable, objectArray, 2, true, function);
    }

    public static double jsFunction_setUTCMonth(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeDate(scriptable, objectArray, 2, false, function);
    }

    public static double jsFunction_setFullYear(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeDate(scriptable, objectArray, 3, true, function);
    }

    public static double jsFunction_setUTCFullYear(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeDate.makeDate(scriptable, objectArray, 3, false, function);
    }

    public double jsFunction_setYear(double d) {
        if (d != d || Double.isInfinite(d)) {
            this.date = ScriptRuntime.NaN;
            return this.date;
        }
        if (this.date != this.date) {
            this.date = 0.0;
        }
        if (d >= 0.0 && d <= 99.0) {
            d += 1900.0;
        }
        double d2 = NativeDate.MakeDay(d, NativeDate.MonthFromTime(this.date), NativeDate.DateFromTime(this.date));
        double d3 = NativeDate.MakeDate(d2, NativeDate.TimeWithinDay(this.date));
        d3 = NativeDate.internalUTC(d3);
        this.date = NativeDate.TimeClip(d3);
        return this.date;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NativeDate.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{"zzz"};
            Class<?> clazz = Class.forName("java.text.SimpleDateFormat");
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            timeZoneFormatter = (DateFormat)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            timeZoneFormatter = null;
        }
        localeDateFormatter = DateFormat.getDateTimeInstance(1, 1);
    }
}

