/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FlattenedObject;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeFunction
extends ScriptableObject
implements Function {
    private static final int OFFSET = 4;
    private static final int SETBACK = 2;
    private static final boolean printSource = false;
    protected String[] names;
    protected short argCount;
    protected short version;
    protected String source;
    public NativeFunction[] nestedFunctions;
    public int debug_level = -1;
    public String debug_srcName;

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        functionObject.setPrototype(scriptable2);
        String[] stringArray = new String[]{""};
        ((NativeFunction)scriptable2).names = stringArray;
    }

    public String getClassName() {
        return "Function";
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("prototype") || string.equals("arguments") || super.has(string, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        if (string.equals("prototype")) {
            NativeObject nativeObject = new NativeObject();
            nativeObject.defineProperty("constructor", this, 7);
            this.put(string, (Scriptable)this, (Object)nativeObject);
            Scriptable scriptable2 = ScriptableObject.getObjectPrototype(this);
            if (scriptable2 != nativeObject) {
                nativeObject.setPrototype(scriptable2);
            }
            return nativeObject;
        }
        if (string.equals("arguments")) {
            NativeCall nativeCall = this.getActivation(Context.getContext());
            return nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
        }
        return Scriptable.NOT_FOUND;
    }

    public boolean hasInstance(Scriptable scriptable) {
        FlattenedObject flattenedObject = new FlattenedObject(this);
        Object object = flattenedObject.getProperty("prototype");
        if (object instanceof FlattenedObject && (object = ((FlattenedObject)object).getObject()) != Undefined.instance) {
            return ScriptRuntime.jsDelegatesTo(scriptable, (Scriptable)object);
        }
        Object[] objectArray = new Object[]{this.names[0]};
        String string = ScriptRuntime.getMessage("msg.instanceof.bad.prototype", objectArray);
        throw NativeGlobal.constructError(Context.getContext(), "TypeError", string, scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return Undefined.instance;
    }

    protected Scriptable getClassPrototype() {
        Object object = this.get("prototype", (Scriptable)this);
        if (object == null || !(object instanceof Scriptable) || object == Undefined.instance) {
            object = ScriptableObject.getClassPrototype(this, "Object");
        }
        return (Scriptable)object;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        NativeObject nativeObject = new NativeObject();
        nativeObject.setPrototype(this.getClassPrototype());
        nativeObject.setParentScope(this.getParentScope());
        Object object = this.call(context, scriptable, nativeObject, objectArray);
        if (object != null && object != Undefined.instance && object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return nativeObject;
    }

    private boolean nextIs(int n, int n2) {
        if (n + 1 < this.source.length()) {
            return this.source.charAt(n + 1) == n2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public String decompile(int var1_1, boolean var2_2, boolean var3_3) {
        block137: {
            if (this.source == null) {
                return "function " + this.jsGet_name() + "() {\n\t[native code]\n}\n";
            }
            var4_4 = new StringBuffer();
            var5_5 = 0;
            if (this.source.length() <= 0) break block137;
            if (var2_2) {
                if (!var3_3) {
                    var4_4.append('\n');
                }
                var6_6 = 0;
                while (var6_6 < var1_1) {
                    var4_4.append(' ');
                    ++var6_6;
                }
            }
            if (this.source.charAt(0) != 'm' || this.source.length() <= 1 || this.source.charAt(1) != ',' && this.source.charAt(1) != ']') break block137;
            if (var3_3) ** GOTO lbl26
            var4_4.append("function ");
            if (this.nextIs(var5_5, 93) && this.version != 120 && this.names != null && this.names[0].equals("anonymous")) {
                var4_4.append("anonymous");
            }
            ++var5_5;
            break block137;
lbl-1000:
            // 1 sources

            {
                ++var5_5;
lbl26:
                // 2 sources

                ** while (var5_5 < this.source.length() && (this.source.charAt((int)var5_5) != '\u0001' || var5_5 > 0 && this.source.charAt((int)(var5_5 - 1)) == ','))
            }
lbl27:
            // 1 sources

            ++var5_5;
        }
        while (var5_5 < this.source.length()) {
            switch (this.source.charAt(var5_5)) {
                case ',': 
                case '8': {
                    var6_6 = ++var5_5 + this.source.charAt(var5_5);
                    var4_4.append(this.source.substring(var5_5 + 1, var6_6 + 1));
                    var5_5 = var6_6;
                    break;
                }
                case '-': {
                    var7_7 = 0L;
                    switch (this.source.charAt(++var5_5)) {
                        case 'S': {
                            var4_4.append((int)this.source.charAt(++var5_5));
                            break;
                        }
                        case 'J': {
                            v0 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v0) << 48;
                            v1 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v1) << 32;
                            v2 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v2) << 16;
                            var4_4.append(var7_7 |= (long)this.source.charAt(++var5_5));
                            break;
                        }
                        case 'D': {
                            v3 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v3) << 48;
                            v4 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v4) << 32;
                            v5 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v5) << 16;
                            var9_8 = Double.longBitsToDouble(var7_7 |= (long)this.source.charAt(++var5_5));
                            var4_4.append(ScriptRuntime.numberToString(var9_8, 10));
                        }
                    }
                    break;
                }
                case '.': {
                    var6_6 = ++var5_5 + this.source.charAt(var5_5);
                    var4_4.append('\"');
                    var4_4.append(ScriptRuntime.escapeString(this.source.substring(var5_5 + 1, var6_6 + 1)));
                    var4_4.append('\"');
                    var5_5 = var6_6;
                    break;
                }
                case 'l': {
                    switch (this.source.charAt(++var5_5)) {
                        case '4': {
                            var4_4.append("true");
                            break;
                        }
                        case '3': {
                            var4_4.append("false");
                            break;
                        }
                        case '1': {
                            var4_4.append("null");
                            break;
                        }
                        case '2': {
                            var4_4.append("this");
                            break;
                        }
                        case ' ': {
                            var4_4.append("typeof");
                            break;
                        }
                        case '\u0083': {
                            var4_4.append("void");
                            break;
                        }
                        case 'J': {
                            var4_4.append("undefined");
                        }
                    }
                    break;
                }
                case 'm': {
                    var11_9 = this.source.charAt(++var5_5);
                    if (this.nestedFunctions == null || var11_9 > this.nestedFunctions.length) {
                        if (this.names != null && this.names.length > 0 && this.names[0].length() > 0) {
                            var13_12 = new Object[]{new Integer(this.source.charAt(var5_5)), this.names[0]};
                            var12_11 = Context.getMessage("msg.no.function.ref.found.in", var13_12);
                        } else {
                            var13_13 = new Object[]{new Integer(this.source.charAt(var5_5))};
                            var12_11 = Context.getMessage("msg.no.function.ref.found", var13_13);
                        }
                        throw Context.reportRuntimeError(var12_11);
                    }
                    var4_4.append(this.nestedFunctions[var11_9].decompile(var1_1, false, false));
                    break;
                }
                case '_': {
                    var4_4.append(", ");
                    break;
                }
                case '[': {
                    if (this.nextIs(var5_5, 1)) {
                        var1_1 += 4;
                    }
                    var4_4.append("{");
                    break;
                }
                case '\\': {
                    if (var3_3 && var2_2 && var5_5 + 1 == this.source.length()) break;
                    if (this.nextIs(var5_5, 1)) {
                        var1_1 -= 4;
                    }
                    if (this.nextIs(var5_5, 117) || this.nextIs(var5_5, 113)) {
                        var1_1 -= 4;
                        var4_4.append("} ");
                        break;
                    }
                    var4_4.append('}');
                    break;
                }
                case ']': {
                    var4_4.append('(');
                    break;
                }
                case '^': {
                    if (this.nextIs(var5_5, 91)) {
                        var4_4.append(") ");
                        break;
                    }
                    var4_4.append(')');
                    break;
                }
                case 'Y': {
                    var4_4.append('[');
                    break;
                }
                case 'Z': {
                    var4_4.append(']');
                    break;
                }
                case '\u0001': {
                    var4_4.append('\n');
                    if (var5_5 + 1 >= this.source.length()) break;
                    var11_9 = 0;
                    if (this.nextIs(var5_5, 115) || this.nextIs(var5_5, 116)) {
                        var11_9 = 2;
                    } else if (this.nextIs(var5_5, 92)) {
                        var11_9 = 4;
                    } else if (this.nextIs(var5_5, 44) && this.source.charAt(var5_5 + (var12_10 = this.source.charAt(var5_5 + 2)) + 3) == 'b') {
                        var11_9 = 4;
                    }
                    while (var11_9 < var1_1) {
                        var4_4.append(' ');
                        ++var11_9;
                    }
                    break;
                }
                case 'k': {
                    var4_4.append('.');
                    break;
                }
                case '\u001e': {
                    var4_4.append("new ");
                    break;
                }
                case '\u001f': {
                    var4_4.append("delete ");
                    break;
                }
                case 'p': {
                    var4_4.append("if ");
                    break;
                }
                case 'q': {
                    var4_4.append("else ");
                    break;
                }
                case 'w': {
                    var4_4.append("for ");
                    break;
                }
                case '?': {
                    var4_4.append(" in ");
                    break;
                }
                case '{': {
                    var4_4.append("with ");
                    break;
                }
                case 'u': {
                    var4_4.append("while ");
                    break;
                }
                case 'v': {
                    var4_4.append("do ");
                    break;
                }
                case 'K': {
                    var4_4.append("try ");
                    break;
                }
                case '|': {
                    var4_4.append("catch ");
                    break;
                }
                case '}': {
                    var4_4.append("finally ");
                    break;
                }
                case '>': {
                    var4_4.append("throw ");
                    break;
                }
                case 'r': {
                    var4_4.append("switch ");
                    break;
                }
                case 'x': {
                    if (this.nextIs(var5_5, 44)) {
                        var4_4.append("break ");
                        break;
                    }
                    var4_4.append("break");
                    break;
                }
                case 'y': {
                    if (this.nextIs(var5_5, 44)) {
                        var4_4.append("continue ");
                        break;
                    }
                    var4_4.append("continue");
                    break;
                }
                case 's': {
                    var4_4.append("case ");
                    break;
                }
                case 't': {
                    var4_4.append("default");
                    break;
                }
                case '\u0005': {
                    if (this.nextIs(var5_5, 88)) {
                        var4_4.append("return");
                        break;
                    }
                    var4_4.append("return ");
                    break;
                }
                case 'z': {
                    var4_4.append("var ");
                    break;
                }
                case 'X': {
                    if (this.nextIs(var5_5, 1)) {
                        var4_4.append(";");
                        break;
                    }
                    var4_4.append("; ");
                    break;
                }
                case '`': {
                    switch (this.source.charAt(++var5_5)) {
                        case '\u007f': {
                            var4_4.append(" = ");
                            break;
                        }
                        case '\u0017': {
                            var4_4.append(" += ");
                            break;
                        }
                        case '\u0018': {
                            var4_4.append(" -= ");
                            break;
                        }
                        case '\u0019': {
                            var4_4.append(" *= ");
                            break;
                        }
                        case '\u001a': {
                            var4_4.append(" /= ");
                            break;
                        }
                        case '\u001b': {
                            var4_4.append(" %= ");
                            break;
                        }
                        case '\u000b': {
                            var4_4.append(" |= ");
                            break;
                        }
                        case '\f': {
                            var4_4.append(" ^= ");
                            break;
                        }
                        case '\r': {
                            var4_4.append(" &= ");
                            break;
                        }
                        case '\u0014': {
                            var4_4.append(" <<= ");
                            break;
                        }
                        case '\u0015': {
                            var4_4.append(" >>= ");
                            break;
                        }
                        case '\u0016': {
                            var4_4.append(" >>>= ");
                        }
                    }
                    break;
                }
                case 'a': {
                    var4_4.append(" ? ");
                    break;
                }
                case '\u0086': {
                    var4_4.append(':');
                    break;
                }
                case 'b': {
                    if (this.nextIs(var5_5, 1)) {
                        var4_4.append(":");
                        break;
                    }
                    var4_4.append(" : ");
                    break;
                }
                case 'c': {
                    var4_4.append(" || ");
                    break;
                }
                case 'd': {
                    var4_4.append(" && ");
                    break;
                }
                case '\u000b': {
                    var4_4.append(" | ");
                    break;
                }
                case '\f': {
                    var4_4.append(" ^ ");
                    break;
                }
                case '\r': {
                    var4_4.append(" & ");
                    break;
                }
                case 'e': {
                    switch (this.source.charAt(++var5_5)) {
                        case '5': {
                            var4_4.append(this.version == 120 ? " == " : " === ");
                            break;
                        }
                        case '6': {
                            var4_4.append(this.version == 120 ? " != " : " !== ");
                            break;
                        }
                        case '\u000e': {
                            var4_4.append(" == ");
                            break;
                        }
                        case '\u000f': {
                            var4_4.append(" != ");
                        }
                    }
                    break;
                }
                case 'f': {
                    switch (this.source.charAt(++var5_5)) {
                        case '\u0011': {
                            var4_4.append(" <= ");
                            break;
                        }
                        case '\u0010': {
                            var4_4.append(" < ");
                            break;
                        }
                        case '\u0013': {
                            var4_4.append(" >= ");
                            break;
                        }
                        case '\u0012': {
                            var4_4.append(" > ");
                            break;
                        }
                        case '@': {
                            var4_4.append(" instanceof ");
                        }
                    }
                    break;
                }
                case 'g': {
                    switch (this.source.charAt(++var5_5)) {
                        case '\u0014': {
                            var4_4.append(" << ");
                            break;
                        }
                        case '\u0015': {
                            var4_4.append(" >> ");
                            break;
                        }
                        case '\u0016': {
                            var4_4.append(" >>> ");
                        }
                    }
                    break;
                }
                case 'h': {
                    switch (this.source.charAt(++var5_5)) {
                        case ' ': {
                            var4_4.append("typeof ");
                            break;
                        }
                        case '\u0083': {
                            var4_4.append("void ");
                            break;
                        }
                        case '\u0080': {
                            var4_4.append('!');
                            break;
                        }
                        case '\u001c': {
                            var4_4.append('~');
                            break;
                        }
                        case '\u0017': {
                            var4_4.append('+');
                            break;
                        }
                        case '\u0018': {
                            var4_4.append('-');
                        }
                    }
                    break;
                }
                case 'i': {
                    var4_4.append("++");
                    break;
                }
                case 'j': {
                    var4_4.append("--");
                    break;
                }
                case '\u0017': {
                    var4_4.append(" + ");
                    break;
                }
                case '\u0018': {
                    var4_4.append(" - ");
                    break;
                }
                case '\u0019': {
                    var4_4.append(" * ");
                    break;
                }
                case '\u001a': {
                    var4_4.append(" / ");
                    break;
                }
                case '\u001b': {
                    var4_4.append(" % ");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown token " + this.source.charAt(var5_5));
                }
            }
            ++var5_5;
        }
        if (var2_2 && !var3_3) {
            var4_4.append('\n');
        }
        return var4_4.toString();
    }

    public static Object jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (!(object instanceof NativeFunction)) {
            Object[] objectArray2 = new Object[]{"toString"};
            String string = Context.getMessage("msg.incompat.call", objectArray2);
            throw NativeGlobal.constructError(context, "TypeError", string, function);
        }
        if (object instanceof NativeJavaMethod) {
            return "\nfunction " + ((NativeFunction)object).jsGet_name() + "() {/*\n" + object.toString() + "*/}\n";
        }
        int n = 0;
        if (objectArray.length > 0) {
            n = (int)ScriptRuntime.toNumber(objectArray[0]);
        }
        return ((NativeFunction)object).decompile(n, true, false);
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - 1) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ScriptRuntime.toString(objectArray[n2]));
            ++n2;
        }
        String string = n == 0 ? "" : ScriptRuntime.toString(objectArray[n2]);
        String string2 = "function (" + stringBuffer.toString() + ") {" + string + "}";
        int[] nArray = new int[]{0};
        String string3 = Context.getSourcePositionFromStack(nArray);
        if (string3 == null) {
            string3 = "<eval'ed string>";
            nArray[0] = 1;
        }
        Object object = context.getSecurityDomainForStackDepth(4);
        Scriptable scriptable = context.ctorScope;
        if (scriptable == null) {
            scriptable = function;
        }
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        int n3 = context.getOptimizationLevel();
        context.setOptimizationLevel(-1);
        NativeFunction nativeFunction = (NativeFunction)context.compileFunction(scriptable2, string2, string3, nArray[0], object);
        context.setOptimizationLevel(n3);
        if (nativeFunction.names == null) {
            nativeFunction.names = new String[1];
        }
        nativeFunction.names[0] = "anonymous";
        nativeFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable2));
        nativeFunction.setParentScope(scriptable2);
        return nativeFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object jsFunction_apply(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object[] objectArray2;
        Scriptable scriptable2;
        if (objectArray.length != 2) {
            return NativeFunction.jsFunction_call(context, scriptable, objectArray, function);
        }
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        Scriptable scriptable3 = scriptable2 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable) : ScriptRuntime.toObject(function, objectArray[0]);
        if (objectArray.length > 1) {
            if (!(objectArray[1] instanceof NativeArray) && !(objectArray[1] instanceof Arguments)) throw NativeGlobal.constructError(context, "TypeError", ScriptRuntime.getMessage("msg.arg.isnt.array", null), scriptable);
            objectArray2 = context.getElements((Scriptable)objectArray[1]);
            return ScriptRuntime.call(context, object, scriptable2, objectArray2, scriptable2);
        } else {
            objectArray2 = new Object[]{};
        }
        return ScriptRuntime.call(context, object, scriptable2, objectArray2, scriptable2);
    }

    public static Object jsFunction_call(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (objectArray.length == 0) {
            Scriptable scriptable2 = ScriptRuntime.toObject(function, object);
            Scriptable scriptable3 = scriptable2.getParentScope();
            return ScriptRuntime.call(context, object, scriptable3, ScriptRuntime.emptyArgs, scriptable3);
        }
        Scriptable scriptable4 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable) : ScriptRuntime.toObject(function, objectArray[0]);
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return ScriptRuntime.call(context, object, scriptable4, objectArray2, scriptable4);
    }

    public int jsGet_length() {
        Context context = Context.getContext();
        if (context != null && context.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall nativeCall = this.getActivation(context);
        if (nativeCall == null) {
            return this.argCount;
        }
        return nativeCall.getOriginalArguments().length;
    }

    public int jsGet_arity() {
        return this.argCount;
    }

    public String jsGet_name() {
        Context context;
        if (this.names == null) {
            return "";
        }
        if (this.names[0].equals("anonymous") && (context = Context.getCurrentContext()) != null && context.getLanguageVersion() == 120) {
            return "";
        }
        return this.names[0];
    }

    private NativeCall getActivation(Context context) {
        NativeCall nativeCall = context.currentActivation;
        while (nativeCall != null) {
            if (nativeCall.getFunctionObject() == this) {
                return nativeCall;
            }
            nativeCall = nativeCall.caller;
        }
        return null;
    }
}

