/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeScript
extends NativeFunction
implements Script {
    private Script script;

    public String getClassName() {
        return "Script";
    }

    public void initScript(Scriptable scriptable) {
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        Scriptable scriptable = context.ctorScope;
        if (scriptable == null) {
            scriptable = function;
        }
        return NativeScript.compile(scriptable, string);
    }

    public static Script compile(Scriptable scriptable, String string) {
        Context context = Context.getContext();
        StringReader stringReader = new StringReader(string);
        try {
            int[] nArray = new int[]{0};
            String string2 = Context.getSourcePositionFromStack(nArray);
            if (string2 == null) {
                string2 = "<Script object>";
                nArray[0] = 1;
            }
            Object object = context.getSecurityDomainForStackDepth(5);
            return context.compileReader(scriptable, stringReader, string2, nArray[0], object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected IOException");
        }
    }

    public Scriptable jsFunction_compile(String string) {
        this.script = NativeScript.compile(null, string);
        return this;
    }

    public Object jsFunction_exec() throws JavaScriptException {
        Object[] objectArray = new Object[]{"exec"};
        throw Context.reportRuntimeError(Context.getMessage("msg.cant.call.indirect", objectArray));
    }

    public static Object jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Script script = ((NativeScript)scriptable).script;
        if (script == null) {
            script = (Script)((Object)scriptable);
        }
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        return context.decompileScript(script, scriptable2, 0);
    }

    public String jsGet_name() {
        return "";
    }

    public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(context, scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return this.exec(context, scriptable);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        String string = Context.getMessage("msg.script.is.not.constructor", null);
        throw Context.reportRuntimeError(string);
    }
}

