/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.ShallowNodeIterator;

public class Node
implements Cloneable {
    public static final int TARGET_PROP = 1;
    public static final int BREAK_PROP = 2;
    public static final int CONTINUE_PROP = 3;
    public static final int ENUM_PROP = 4;
    public static final int FUNCTION_PROP = 5;
    public static final int TEMP_PROP = 6;
    public static final int LOCAL_PROP = 7;
    public static final int CODEOFFSET_PROP = 8;
    public static final int FIXUPS_PROP = 9;
    public static final int VARS_PROP = 10;
    public static final int USES_PROP = 11;
    public static final int REGEXP_PROP = 12;
    public static final int CASES_PROP = 13;
    public static final int DEFAULT_PROP = 14;
    public static final int CASEARRAY_PROP = 15;
    public static final int SOURCENAME_PROP = 16;
    public static final int SOURCE_PROP = 17;
    public static final int TYPE_PROP = 18;
    public static final int SPECIAL_PROP_PROP = 19;
    public static final int LABEL_PROP = 20;
    public static final int FINALLY_PROP = 21;
    public static final int LOCALCOUNT_PROP = 22;
    public static final int TARGETBLOCK_PROP = 23;
    public static final int VARIABLE_PROP = 24;
    public static final int LASTUSE_PROP = 25;
    public static final int ISNUMBER_PROP = 26;
    public static final int DIRECTCALL_PROP = 27;
    public static final int BASE_LINENO_PROP = 28;
    public static final int END_LINENO_PROP = 29;
    public static final int SPECIALCALL_PROP = 30;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private static String[] propNames;
    protected int type;
    protected Node next;
    protected Node first;
    protected Node last;
    protected Hashtable props;
    protected Object datum;

    public Node(int n) {
        this.type = n;
    }

    public Node(int n, Node node) {
        this.type = n;
        this.first = this.last = node;
        node.next = null;
    }

    public Node(int n, Node node, Node node2) {
        this.type = n;
        this.first = node;
        this.last = node2;
        node.next = node2;
        node2.next = null;
    }

    public Node(int n, Node node, Node node2, Node node3) {
        this.type = n;
        this.first = node;
        this.last = node3;
        node.next = node2;
        node2.next = node3;
        node3.next = null;
    }

    public Node(int n, Object object) {
        this.type = n;
        this.datum = object;
    }

    public Node(int n, Node node, Object object) {
        this(n, node);
        this.datum = object;
    }

    public Node(int n, Node node, Node node2, Object object) {
        this(n, node, node2);
        this.datum = object;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNextSibling() {
        return this.next;
    }

    public Node getChildBefore(Node node) {
        if (node == this.first) {
            return null;
        }
        Node node2 = this.first;
        while (node2.next != node) {
            node2 = node2.next;
            if (node2 != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return node2;
    }

    public Node getLastSibling() {
        Node node = this;
        while (node.next != null) {
            node = node.next;
        }
        return node;
    }

    public ShallowNodeIterator getChildIterator() {
        return new ShallowNodeIterator(this.first);
    }

    public PreorderNodeIterator getPreorderIterator() {
        return new PreorderNodeIterator(this);
    }

    public void addChildToFront(Node node) {
        node.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        }
    }

    public void addChildToBack(Node node) {
        node.next = null;
        if (this.last == null) {
            this.first = this.last = node;
            return;
        }
        this.last.next = node;
        this.last = node;
    }

    public void addChildrenToFront(Node node) {
        Node node2 = node.getLastSibling();
        node2.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node2;
        }
    }

    public void addChildrenToBack(Node node) {
        if (this.last != null) {
            this.last.next = node;
        }
        this.last = node.getLastSibling();
        if (this.first == null) {
            this.first = node;
        }
    }

    public void addChildBefore(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.first == node2) {
            node.next = this.first;
            this.first = node;
            return;
        }
        Node node3 = this.getChildBefore(node2);
        this.addChildAfter(node, node3);
    }

    public void addChildAfter(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        node.next = node2.next;
        node2.next = node;
        if (this.last == node2) {
            this.last = node;
        }
    }

    public void removeChild(Node node) {
        Node node2 = this.getChildBefore(node);
        if (node2 == null) {
            this.first = this.first.next;
        } else {
            node2.next = node.next;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void replaceChild(Node node, Node node2) {
        node2.next = node.next;
        if (node == this.first) {
            this.first = node2;
        } else {
            Node node3 = this.getChildBefore(node);
            node3.next = node2;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    private static final String propToString(int n) {
        return propNames[n - 1];
    }

    public Object getProp(int n) {
        if (this.props == null) {
            return null;
        }
        return this.props.get(new Integer(n));
    }

    public void putProp(int n, Object object) {
        if (this.props == null) {
            this.props = new Hashtable(2);
        }
        if (object == null) {
            this.props.remove(new Integer(n));
        } else {
            this.props.put(new Integer(n), object);
        }
    }

    public Object getDatum() {
        return this.datum;
    }

    public void setDatum(Object object) {
        this.datum = object;
    }

    public int getInt() {
        return ((Number)this.datum).intValue();
    }

    public double getDouble() {
        return ((Number)this.datum).doubleValue();
    }

    public long getLong() {
        return ((Number)this.datum).longValue();
    }

    public String getString() {
        return (String)this.datum;
    }

    public Node cloneNode() {
        Node node;
        try {
            node = (Node)super.clone();
            node.next = null;
            node.first = null;
            node.last = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
        return node;
    }

    public String toString() {
        return null;
    }

    public String toStringTree() {
        return this.toStringTreeHelper(0);
    }

    private String toStringTreeHelper(int n) {
        return "";
    }

    public Node getFirst() {
        return this.first;
    }

    public Node getNext() {
        return this.next;
    }
}

