/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ShallowNodeIterator;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected Stack loops;
    protected Stack loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        Node node3;
        this.loops = new Stack();
        this.loopEnds = new Stack();
        boolean bl = this.inFunction = node.getType() == 109;
        if (!this.inFunction) {
            this.addVariables(node, this.getVariableTable(node));
        }
        this.irFactory = this.createIRFactory(tokenStream, scriptable);
        boolean bl2 = false;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        block22: while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            block0 : switch (n) {
                case 109: {
                    Object object3;
                    if (node3 == node) {
                        object3 = this.getVariableTable(node);
                        this.addVariables(node, (VariableTable)object3);
                        Node node4 = node3.getLastChild();
                        Node node5 = node4.getLastChild();
                        if (node5 != null && node5.getType() == 5) continue block22;
                        node4.addChildToBack(new Node(5));
                        break;
                    }
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    object3 = (FunctionNode)node3.getProp(5);
                    this.addParameters((FunctionNode)object3);
                    NodeTransformer nodeTransformer = this.newInstance();
                    object3 = (FunctionNode)nodeTransformer.transform((Node)object3, node, tokenStream, scriptable);
                    node3.putProp(5, object3);
                    Vector<Cloneable> vector = (Vector<Cloneable>)node.getProp(5);
                    if (vector == null) {
                        vector = new Vector<Cloneable>(7);
                        node.putProp(5, vector);
                    }
                    vector.addElement((Cloneable)object3);
                    break;
                }
                case 135: {
                    Object object4;
                    Object object2;
                    Node node6;
                    Object object3 = node3.getFirstChild();
                    node3.removeChild((Node)object3);
                    String string = ((Node)object3).getString();
                    int n2 = this.loops.size() - 1;
                    while (n2 >= 0) {
                        node6 = (Node)this.loops.elementAt(n2);
                        if (node6.getType() == 135 && string.equals(object2 = (String)node6.getProp(20))) {
                            Object[] objectArray = new Object[]{string};
                            object4 = Context.getMessage("msg.dup.label", objectArray);
                            this.reportMessage(Context.getContext(), (String)object4, node3, node, true, scriptable);
                            break block0;
                        }
                        --n2;
                    }
                    node3.putProp(20, string);
                    node6 = new Node(136);
                    object2 = preorderNodeIterator.getCurrentParent();
                    Node node7 = node3.getNextSibling();
                    while (node7 != null && (node7.getType() == 135 || node7.getType() == 136)) {
                        node7 = node7.getNextSibling();
                    }
                    if (node7 == null) continue block22;
                    ((Node)object2).addChildAfter(node6, node7);
                    node3.putProp(2, node6);
                    if (node7.getType() == 137) {
                        node3.putProp(3, node7.getProp(3));
                    }
                    this.loops.push(node3);
                    this.loopEnds.push(node6);
                    break;
                }
                case 114: {
                    Object object2;
                    Object object3 = new Node(136);
                    Node node8 = preorderNodeIterator.getCurrentParent();
                    node8.addChildAfter((Node)object3, node3);
                    Node node9 = node3;
                    Object object = node3.getFirstChild().next;
                    while (object != null) {
                        object2 = ((Node)object).next;
                        node3.removeChild((Node)object);
                        node8.addChildAfter((Node)object, node9);
                        node9 = object;
                        object = object2;
                    }
                    node3.putProp(2, object3);
                    this.loops.push(node3);
                    this.loopEnds.push(object3);
                    node3.putProp(13, new Vector(13));
                    break;
                }
                case 115: 
                case 116: {
                    Object object3 = (Node)this.loops.peek();
                    if (n == 115) {
                        Vector vector = (Vector)((Node)object3).getProp(13);
                        vector.addElement(node3);
                        break;
                    }
                    ((Node)object3).putProp(14, node3);
                    break;
                }
                case 143: {
                    Object object3 = (Integer)node.getProp(22);
                    if (object3 == null) {
                        node.putProp(22, new Integer(1));
                        break;
                    }
                    node.putProp(22, new Integer((Integer)object3 + 1));
                    break;
                }
                case 137: {
                    this.loops.push(node3);
                    this.loopEnds.push(node3.getProp(2));
                    break;
                }
                case 123: {
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    this.loops.push(node3);
                    Object object3 = node3.getNextSibling();
                    if (((Node)object3).getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(object3);
                    break;
                }
                case 75: {
                    Integer n3;
                    Object object3 = (Node)node3.getProp(21);
                    if (object3 != null) {
                        bl2 = true;
                        this.loops.push(node3);
                        this.loopEnds.push(object3);
                    }
                    if ((n3 = (Integer)node.getProp(22)) == null) {
                        node.putProp(22, new Integer(1));
                        break;
                    }
                    node.putProp(22, new Integer(n3 + 1));
                    break;
                }
                case 4: 
                case 136: {
                    if (this.loopEnds.empty() || this.loopEnds.peek() != node3) continue block22;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    Object object2;
                    if (!bl2) continue block22;
                    Object object3 = preorderNodeIterator.getCurrentParent();
                    int n4 = this.loops.size() - 1;
                    while (n4 >= 0) {
                        Node node10 = (Node)this.loops.elementAt(n4);
                        int n5 = node10.getType();
                        if (n5 == 75) {
                            object2 = new Node(142);
                            Object object = node10.getProp(21);
                            ((Node)object2).putProp(1, object);
                            ((Node)object3).addChildBefore((Node)object2, node3);
                        } else if (n5 == 123) {
                            ((Node)object3).addChildBefore(new Node(4), node3);
                        }
                        --n4;
                    }
                    continue block22;
                }
                case 120: 
                case 121: {
                    Object[] objectArray;
                    Object object;
                    Object object4;
                    Object object3 = null;
                    boolean bl3 = node3.hasChildren();
                    String string = null;
                    if (bl3) {
                        Node node11 = node3.getFirstChild();
                        string = node11.getString();
                        node3.removeChild(node11);
                    }
                    Object object2 = preorderNodeIterator.getCurrentParent();
                    int n6 = this.loops.size() - 1;
                    while (n6 >= 0) {
                        Node node12 = (Node)this.loops.elementAt(n6);
                        int n7 = node12.getType();
                        if (n7 == 123) {
                            ((Node)object2).addChildBefore(new Node(4), node3);
                        } else if (n7 == 75) {
                            object = new Node(142);
                            objectArray = node12.getProp(21);
                            ((Node)object).putProp(1, objectArray);
                            ((Node)object2).addChildBefore((Node)object, node3);
                        } else {
                            if (!bl3 && (n7 == 137 || n7 == 114 && n == 120)) {
                                object3 = node12;
                                break;
                            }
                            if (bl3 && n7 == 135 && string.equals((String)node12.getProp(20))) {
                                object3 = node12;
                                break;
                            }
                        }
                        --n6;
                    }
                    int n8 = n == 120 ? 2 : 3;
                    Object object5 = object4 = object3 == null ? null : (Node)((Node)object3).getProp(n8);
                    if (object3 == null || object4 == null) {
                        if (!bl3) {
                            object = n == 121 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (object3 != null) {
                            object = Context.getMessage("msg.continue.nonloop", null);
                        } else {
                            objectArray = new Object[]{string};
                            object = Context.getMessage("msg.undef.label", objectArray);
                        }
                        this.reportMessage(Context.getContext(), (String)object, node3, node, true, scriptable);
                        node3.setType(127);
                        break;
                    }
                    node3.setType(6);
                    node3.putProp(1, object4);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node3, node);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node3, node);
                    break;
                }
                case 107: {
                    Object object3 = node3.getLastChild();
                    ((Node)object3).setType(46);
                    break;
                }
                case 139: {
                    node3.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    Object object3 = (Vector)node.getProp(12);
                    if (object3 == null) {
                        object3 = new Vector<Node>(3);
                        node.putProp(12, object3);
                    }
                    ((Vector)object3).addElement(node3);
                    Node node13 = new Node(56);
                    preorderNodeIterator.replaceCurrent(node13);
                    node13.putProp(12, node3);
                    break;
                }
                case 122: {
                    Object object2;
                    Object object3 = node3.getChildIterator();
                    Node node14 = new Node(132);
                    while (((ShallowNodeIterator)object3).hasMoreElements()) {
                        Node node15 = ((ShallowNodeIterator)object3).nextNode();
                        if (!node15.hasChildren()) continue;
                        Node node16 = node15.getFirstChild();
                        node15.removeChild(node16);
                        object2 = (Node)this.irFactory.createAssignment(127, node15, node16, null, false);
                        Node node17 = new Node(57, (Node)object2, node3.getDatum());
                        node14.addChildToBack(node17);
                    }
                    preorderNodeIterator.replaceCurrent(node14);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable variableTable;
                    Object object3;
                    if (!this.inFunction || this.inWithStatement() || (object3 = node3.getFirstChild()) == null || ((Node)object3).getType() != 61) continue block22;
                    String string = ((Node)object3).getString();
                    if (string.equals("arguments")) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if ((variableTable = this.getVariableTable(node)).get(string) == null) break;
                    if (n == 10) {
                        node3.setType(73);
                        ((Node)object3).setType(46);
                        break;
                    }
                    Node node18 = new Node(108, new Integer(51));
                    preorderNodeIterator.replaceCurrent(node18);
                    break;
                }
                case 39: {
                    String string;
                    if (!this.inFunction) break;
                    Object object3 = node3.getFirstChild().getNextSibling();
                    String string2 = string = object3 == null ? "" : ((Node)object3).getString();
                    if (!string.equals("arguments") && (!string.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)node).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable variableTable;
                    if (!this.inFunction || this.inWithStatement()) continue block22;
                    Object object3 = node3.getString();
                    if (((String)object3).equals("arguments")) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if ((variableTable = this.getVariableTable(node)).get((String)object3) == null) break;
                    node3.setType(72);
                }
            }
        }
        return node;
    }

    protected void addVariables(Node node, VariableTable variableTable) {
        Node node2;
        boolean bl = node.getType() == 109;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        Hashtable<Object, Boolean> hashtable = null;
        while ((node2 = preorderNodeIterator.nextNode()) != null) {
            Object object;
            int n = node2.getType();
            if (bl && n == 109 && node2 != node) {
                object = node2.getString();
                if (object == null) continue;
                variableTable.removeLocal((String)object);
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Boolean>();
                }
                hashtable.put(object, Boolean.TRUE);
            }
            if (n != 122) continue;
            object = node2.getChildIterator();
            while (((ShallowNodeIterator)object).hasMoreElements()) {
                Node node3 = ((ShallowNodeIterator)object).nextNode();
                if (hashtable != null && hashtable.get(node3.getString()) != null) continue;
                variableTable.addLocal(node3.getString());
            }
        }
    }

    protected void addParameters(FunctionNode functionNode) {
        VariableTable variableTable = functionNode.getVariableTable();
        Node node = functionNode.getFirstChild();
        if (node.getType() == 93 && variableTable.getParameterCount() == 0) {
            ShallowNodeIterator shallowNodeIterator = node.getChildIterator();
            while (shallowNodeIterator.hasMoreElements()) {
                Node node2 = shallowNodeIterator.nextNode();
                String string = node2.getString();
                variableTable.addParameter(string);
            }
        }
    }

    protected void visitNew(Node node, Node node2) {
    }

    protected void visitCall(Node node, Node node2) {
        Node node3;
        Object object;
        Object object2;
        Node node4 = node.getFirstChild();
        int n = 0;
        Node node5 = node4.getNextSibling();
        while (node5 != null) {
            node5 = node5.getNextSibling();
            ++n;
        }
        boolean bl = false;
        if (node4.getType() == 44) {
            object2 = this.getVariableTable(node2);
            object = node4.getString();
            if (this.inFunction && ((VariableTable)object2).get((String)object) != null && !this.inWithStatement()) {
                node4.setType(72);
            } else {
                node.removeChild(node4);
                node4.setType(71);
                node3 = node4.cloneNode();
                node3.setType(46);
                Node node6 = new Node(39, node4, node3);
                node.addChildToFront(node6);
                node4 = node6;
                boolean bl2 = bl = this.inWithStatement() || !this.inFunction;
            }
        }
        if (node4.getType() != 39 && node4.getType() != 41) {
            node.removeChild(node4);
            object2 = this.irFactory.createNewTemp(node4);
            object = this.irFactory.createUseTemp((Node)object2);
            ((Node)object).putProp(6, object2);
            node3 = new Node(140, (Node)object);
            node.addChildToFront(node3);
            node.addChildToFront((Node)object2);
            return;
        }
        object2 = node4.getFirstChild();
        node4.removeChild((Node)object2);
        object = this.irFactory.createNewTemp((Node)object2);
        node4.addChildToFront((Node)object);
        node3 = this.irFactory.createUseTemp((Node)object);
        node3.putProp(6, object);
        if (bl) {
            node3 = new Node(68, node3);
        }
        node.addChildAfter(node3, node4);
    }

    protected boolean inWithStatement() {
        int n = this.loops.size() - 1;
        while (n >= 0) {
            Node node = (Node)this.loops.elementAt(n);
            if (node.getType() == 123) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean isSpecialCallName(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 44) {
            String string = node3.getString();
            bl = string.equals("eval") || string.equals("With");
        } else if (node3.getType() == 39) {
            String string = node3.getLastChild().getString();
            bl = string.equals("exec");
        }
        if (bl) {
            if (this.inFunction) {
                ((FunctionNode)node).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node node) {
        if (this.inFunction) {
            return ((FunctionNode)node).getVariableTable();
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        if (variableTable == null) {
            variableTable = this.createVariableTable();
            node.putProp(10, variableTable);
        }
        return variableTable;
    }

    protected void reportMessage(Context context, String string, Node node, Node node2, boolean bl, Scriptable scriptable) {
        Object object;
        Object object2 = node.getDatum();
        int n = 0;
        if (object2 != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        Object object3 = object = node2 == null ? null : node2.getProp(16);
        if (bl) {
            if (scriptable != null) {
                throw NativeGlobal.constructError(context, "SyntaxError", string, scriptable, (String)object, n, 0, null);
            }
            Context.reportError(string, (String)object, n, null, 0);
        } else {
            Context.reportWarning(string, (String)object, n, null, 0);
        }
    }
}

