/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

final class Source {
    char functionNumber;
    StringBuffer buf = new StringBuffer(64);

    Source() {
    }

    void append(char c) {
        this.buf.append(c);
    }

    void addString(int n, String string) {
        this.buf.append((char)n);
        this.buf.append((char)string.length());
        this.buf.append(string);
    }

    void addNumber(Number number) {
        this.buf.append('-');
        if (number instanceof Double || number instanceof Float) {
            this.buf.append('D');
            long l = Double.doubleToLongBits(number.doubleValue());
            this.buf.append((char)(l >> 48 & 0xFFFFL));
            this.buf.append((char)(l >> 32 & 0xFFFFL));
            this.buf.append((char)(l >> 16 & 0xFFFFL));
            this.buf.append((char)(l & 0xFFFFL));
        } else {
            long l = number.longValue();
            if (l <= 65535L) {
                this.buf.append('S');
                this.buf.append((char)l);
            } else {
                this.buf.append('J');
                this.buf.append((char)(l >> 48 & 0xFFFFL));
                this.buf.append((char)(l >> 32 & 0xFFFFL));
                this.buf.append((char)(l >> 16 & 0xFFFFL));
                this.buf.append((char)(l & 0xFFFFL));
            }
        }
    }
}

