/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LocalVariable;

public class VariableTable {
    protected Vector itsVariables = new Vector();
    protected Hashtable itsVariableNames = new Hashtable(11);
    protected int varStart;

    public int size() {
        return this.itsVariables.size();
    }

    public int getParameterCount() {
        return this.varStart;
    }

    public LocalVariable createLocalVariable(String string, boolean bl) {
        return new LocalVariable(string, bl);
    }

    public LocalVariable get(int n) {
        return (LocalVariable)this.itsVariables.elementAt(n);
    }

    public LocalVariable get(String string) {
        Integer n = (Integer)this.itsVariableNames.get(string);
        if (n != null) {
            return (LocalVariable)this.itsVariables.elementAt(n);
        }
        return null;
    }

    public int getOrdinal(String string) {
        Integer n = (Integer)this.itsVariableNames.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public String getName(int n) {
        return ((LocalVariable)this.itsVariables.elementAt(n)).getName();
    }

    public void establishIndices() {
        int n = 0;
        while (n < this.itsVariables.size()) {
            LocalVariable localVariable = (LocalVariable)this.itsVariables.elementAt(n);
            localVariable.setIndex(n);
            ++n;
        }
    }

    public void addParameter(String string) {
        Object[] objectArray;
        Integer n = (Integer)this.itsVariableNames.get(string);
        if (n != null) {
            LocalVariable localVariable = (LocalVariable)this.itsVariables.elementAt(n);
            if (localVariable.isParameter()) {
                objectArray = new Object[]{string};
                String string2 = Context.getMessage("msg.dup.parms", objectArray);
                Context.reportWarning(string2, null, 0, null, 0);
            } else {
                this.itsVariables.removeElementAt(n);
            }
        }
        int n2 = this.varStart++;
        objectArray = this.createLocalVariable(string, true);
        this.itsVariables.insertElementAt(objectArray, n2);
        this.itsVariableNames.put(string, new Integer(n2));
    }

    public void addLocal(String string) {
        LocalVariable localVariable;
        Integer n = (Integer)this.itsVariableNames.get(string);
        if (n != null && !(localVariable = (LocalVariable)this.itsVariables.elementAt(n)).isParameter()) {
            return;
        }
        int n2 = this.itsVariables.size();
        LocalVariable localVariable2 = this.createLocalVariable(string, false);
        this.itsVariables.addElement(localVariable2);
        this.itsVariableNames.put(string, new Integer(n2));
    }

    public void removeLocal(String string) {
        Integer n = (Integer)this.itsVariableNames.get(string);
        if (n != null) {
            this.itsVariables.removeElementAt(n);
            this.itsVariableNames.remove(string);
            Hashtable hashtable = new Hashtable(11);
            Enumeration enumeration = this.itsVariableNames.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Integer n2 = (Integer)this.itsVariableNames.get(k);
                int n3 = n2;
                if (n3 > n) {
                    n2 = new Integer(n3 - 1);
                }
                hashtable.put(k, n2);
            }
            this.itsVariableNames = hashtable;
        }
    }
}

