/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExp;

class RENode {
    public static final int ANCHORED = 1;
    public static final int SINGLE = 2;
    public static final int NONEMPTY = 4;
    public static final int ISNEXT = 8;
    public static final int GOODNEXT = 16;
    public static final int ISJOIN = 32;
    public static final int REALLOK = 64;
    public static final int MINIMAL = 128;
    byte op;
    byte flags;
    short offset;
    RENode next;
    Object kid;
    int kid2;
    int num;
    char chr;
    short min;
    short max;
    short kidlen;
    short bmsize;
    char[] s;
    byte[] bitmap;

    RENode(CompilerState compilerState, byte by, Object object) {
        this.op = by;
        this.kid = object;
    }

    private void calcBMSize(char[] cArray, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n < n2) {
            int n4;
            int n5;
            if ((n5 = cArray[n++]) == 92) {
                if (n + 5 <= n2 && cArray[n] == 'u' && NativeRegExp.isHex(cArray[n + 1]) && NativeRegExp.isHex(cArray[n + 2]) && NativeRegExp.isHex(cArray[n + 3]) && NativeRegExp.isHex(cArray[n + 4])) {
                    n4 = (((NativeRegExp.unHex(cArray[n + 0]) << 4) + NativeRegExp.unHex(cArray[n + 1]) << 4) + NativeRegExp.unHex(cArray[n + 2]) << 4) + NativeRegExp.unHex(cArray[n + 3]);
                    n5 = (char)n4;
                    n += 5;
                } else {
                    if (n3 >= 255) continue;
                    n3 = 255;
                    continue;
                }
            }
            if (bl) {
                n4 = Character.toUpperCase((char)n5);
                if (n4 > n3) {
                    n3 = n4;
                }
                if ((n4 = Character.toLowerCase((char)n4)) > n3) {
                    n3 = n4;
                }
            }
            if (n5 <= n3) continue;
            n3 = n5;
        }
        this.bmsize = (short)((n3 + 8) / 8);
    }

    private void matchBit(char c, int n) {
        int n2 = c >> 3;
        byte by = (byte)(c & 7);
        by = (byte)(1 << by);
        if (n != 0) {
            int n3 = n2;
            this.bitmap[n3] = (byte)(this.bitmap[n3] & ~by);
        } else {
            int n4 = n2;
            this.bitmap[n4] = (byte)(this.bitmap[n4] | by);
        }
    }

    private void checkRange(char c, int n) {
        this.matchBit(c, n);
        this.matchBit('-', n);
    }

    /*
     * Unable to fully structure code
     */
    void buildBitmap(MatchState var1_1, char[] var2_2, boolean var3_3) {
        var4_4 = (Integer)this.kid;
        var5_5 = this.kid2;
        var6_6 = 0;
        var10_7 = false;
        this.kid2 = 0;
        if (var2_2[var4_4] == '^') {
            var10_7 = true;
            this.kid2 = -1;
            ++var4_4;
        }
        this.calcBMSize(var2_2, var4_4, var5_5, var3_3);
        this.bitmap = new byte[this.bmsize];
        if (var10_7) {
            var6_6 = -1;
            var7_8 = 0;
            while (var7_8 < this.bmsize) {
                this.bitmap[var7_8] = -1;
                ++var7_8;
            }
            this.bitmap[0] = -2;
        }
        var11_9 = this.bmsize * 8;
        var12_10 = var11_9;
        var13_11 = false;
        block14: while (var4_4 < var5_5) {
            if ((var14_14 = var2_2[var4_4++]) != '\\') ** GOTO lbl-1000
            var14_14 = var2_2[var4_4++];
            switch (var14_14) {
                case 'b': 
                case 'f': 
                case 'n': 
                case 'r': 
                case 't': 
                case 'v': {
                    var14_14 = NativeRegExp.getEscape(var14_14);
                    ** GOTO lbl136
                }
                case 'd': {
                    if (var13_11) {
                        this.checkRange(var12_10, var6_6);
                    }
                    var12_10 = var11_9;
                    var14_14 = '0';
                    while (var14_14 <= '9') {
                        this.matchBit(var14_14, var6_6);
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    continue block14;
                }
                case 'D': {
                    if (var13_11) {
                        this.checkRange(var12_10, var6_6);
                    }
                    var12_10 = var11_9;
                    var14_14 = '\u0000';
                    while (var14_14 < '0') {
                        this.matchBit(var14_14, var6_6);
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    var14_14 = ':';
                    while (var14_14 < var11_9) {
                        this.matchBit(var14_14, var6_6);
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    continue block14;
                }
                case 'w': {
                    if (var13_11) {
                        this.checkRange(var12_10, var6_6);
                    }
                    var12_10 = var11_9;
                    var14_14 = '\u0000';
                    while (var14_14 < var11_9) {
                        if (NativeRegExp.isWord(var14_14)) {
                            this.matchBit(var14_14, var6_6);
                        }
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    continue block14;
                }
                case 'W': {
                    if (var13_11) {
                        this.checkRange(var12_10, var6_6);
                    }
                    var12_10 = var11_9;
                    var14_14 = '\u0000';
                    while (var14_14 < var11_9) {
                        if (!NativeRegExp.isWord(var14_14)) {
                            this.matchBit(var14_14, var6_6);
                        }
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    continue block14;
                }
                case 's': {
                    if (var13_11) {
                        this.checkRange(var12_10, var6_6);
                    }
                    var12_10 = var11_9;
                    var14_14 = '\u0000';
                    while (var14_14 < var11_9) {
                        if (Character.isWhitespace(var14_14)) {
                            this.matchBit(var14_14, var6_6);
                        }
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    continue block14;
                }
                case 'S': {
                    if (var13_11) {
                        this.checkRange(var12_10, var6_6);
                    }
                    var12_10 = var11_9;
                    var14_14 = '\u0000';
                    while (var14_14 < var11_9) {
                        if (!Character.isWhitespace(var14_14)) {
                            this.matchBit(var14_14, var6_6);
                        }
                        var14_14 = (char)(var14_14 + '\u0001');
                    }
                    continue block14;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    var8_12 = NativeRegExp.unDigit(var14_14);
                    var9_13 = var4_4 - 2;
                    var14_14 = var2_2[var4_4];
                    if ('0' <= var14_14 && var14_14 <= '7') {
                        var8_12 = 8 * var8_12 + NativeRegExp.unDigit(var14_14);
                        if ('0' <= (var14_14 = var2_2[++var4_4]) && var14_14 <= '7') {
                            ++var4_4;
                            var7_8 = 8 * var8_12 + NativeRegExp.unDigit(var14_14);
                            if (var7_8 <= 255) {
                                var8_12 = var7_8;
                            } else {
                                --var4_4;
                            }
                        }
                    }
                    var14_14 = (char)var8_12;
                    ** GOTO lbl136
                }
                case 'x': {
                    var9_13 = var4_4;
                    if (var4_4 < var2_2.length && NativeRegExp.isHex(var14_14 = var2_2[var4_4++])) {
                        var8_12 = NativeRegExp.unHex(var14_14);
                        if (var4_4 < var2_2.length && NativeRegExp.isHex(var14_14 = var2_2[var4_4++])) {
                            var8_12 <<= 4;
                            var8_12 += NativeRegExp.unHex(var14_14);
                        }
                    } else {
                        var4_4 = var9_13;
                        var8_12 = 120;
                    }
                    var14_14 = (char)var8_12;
                    ** GOTO lbl136
                }
                case 'u': {
                    if (var2_2.length > var4_4 + 3 && NativeRegExp.isHex(var2_2[var4_4 + 0]) && NativeRegExp.isHex(var2_2[var4_4 + 1]) && NativeRegExp.isHex(var2_2[var4_4 + 2]) && NativeRegExp.isHex(var2_2[var4_4 + 3])) {
                        var8_12 = (((NativeRegExp.unHex(var2_2[var4_4 + 0]) << 4) + NativeRegExp.unHex(var2_2[var4_4 + 1]) << 4) + NativeRegExp.unHex(var2_2[var4_4 + 2]) << 4) + NativeRegExp.unHex(var2_2[var4_4 + 3]);
                        var14_14 = (char)var8_12;
                        var4_4 += 4;
                    }
                    ** GOTO lbl136
                }
                case 'c': {
                    var14_14 = var2_2[var4_4++];
                    var14_14 = Character.toUpperCase(var14_14);
                    var14_14 = (char)(var14_14 ^ 64);
                }
lbl136:
                // 6 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (!var13_11) ** GOTO lbl142
                    if (var12_10 > var14_14) {
                        throw NativeGlobal.constructError(Context.getCurrentContext(), "RangeError", ScriptRuntime.getMessage("msg.bad.range", null), var1_1.scope);
                    }
                    var13_11 = false;
                    ** GOTO lbl154
lbl142:
                    // 1 sources

                    var12_10 = var14_14;
                    if (var4_4 + 1 >= var5_5 || var2_2[var4_4] != '-' || var2_2[var4_4 + 1] == ']') ** GOTO lbl154
                    ++var4_4;
                    var13_11 = true;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this.matchBit(var12_10, var6_6);
                        if (var3_3) {
                            var15_15 = Character.toUpperCase(var12_10);
                            this.matchBit(var15_15, var6_6);
                            var15_15 = Character.toLowerCase(var15_15);
                            this.matchBit(var15_15, var6_6);
                        }
                        var12_10 = (char)(var12_10 + '\u0001');
lbl154:
                        // 3 sources

                        ** while (var12_10 <= var14_14)
                    }
lbl155:
                    // 1 sources

                    var12_10 = var14_14;
                }
            }
        }
    }
}

