/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.minishell;

import com.agilent.tntd.eclipse.minishell.Command;
import com.agilent.tntd.eclipse.minishell.Pathname;
import com.agilent.tntd.eclipse.minishell.TaskParameters;
import com.agilent.tntd.eclipse.rshd.Shell;
import com.agilent.tntd.eclipse.swupg.Instrument;
import com.agilent.tntd.eclipse.vfs.MetafileFSMount;
import com.agilent.tntd.eclipse.vfs.RealFSMount;
import com.agilent.tntd.eclipse.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class MiniShell
extends Shell {
    private Pathname cwd = new Pathname("/");
    private VirtualFileSystem vfs;
    public static final String version = "EPA_4205";

    public MiniShell(Instrument instrument) throws Exception {
        super(instrument);
        String string = System.getProperty("filesystem");
        if (string == null) {
            throw new Exception("Must set the \"filesystem\" property");
        }
        this.vfs = new VirtualFileSystem(new RealFSMount(string));
        this.vfs.mount("meta", new MetafileFSMount());
    }

    public int exec() throws IOException {
        boolean bl = false;
        while (!bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            this.stdout.write("$ ".getBytes());
            while (true) {
                int n;
                if ((n = this.stdin.read()) == 4) {
                    bl = true;
                    break;
                }
                if (n == 13) break;
                if (n >= 32 && n <= 126) {
                    this.stdout.write(n);
                    stringBuffer.append((char)n);
                }
                if (n != 8 && n != 127 || stringBuffer.length() <= 0) continue;
                string = stringBuffer.toString();
                stringBuffer = new StringBuffer(string.substring(0, string.length() - 1));
                this.stdout.write(8);
            }
            this.stdout.write(new byte[]{13, 10});
            string = stringBuffer.toString();
            if (string.length() <= 0) continue;
            this.exec(string);
        }
        return 0;
    }

    public int exec(String string) throws IOException {
        int n;
        Object obj;
        Class<?> clazz;
        TaskParameters taskParameters;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        string = String.valueOf(string) + " ";
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ' ' && !bl && !bl2) {
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                bl2 = true;
            } else if (c == '\"') {
                bl = !bl;
            } else {
                stringBuffer.append(c);
                bl2 = false;
            }
            ++n2;
        }
        try {
            taskParameters = this.makeTaskParams(vector);
        }
        catch (Exception exception) {
            this.stderr.write(("MiniShell: cannot run " + vector.elementAt(0) + ": " + exception.getMessage()).getBytes());
            return -1;
        }
        if (taskParameters == null) {
            return -1;
        }
        String string2 = (String)vector.elementAt(0);
        String[] stringArray = new String[vector.size() - 1];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = (String)vector.elementAt(n3 + 1);
            ++n3;
        }
        int n4 = string2.lastIndexOf(47);
        if (n4 != -1) {
            string2 = string2.substring(n4 + 1);
        }
        String string3 = "com.agilent.tntd.eclipse.minishell." + string2;
        try {
            clazz = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.stderr.write(("MiniShell: " + string3 + ": not found\r\n").getBytes());
            return -1;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.stderr.write(("MiniShell: " + string2 + ": cannot execute (InstantiationException)").getBytes());
            return -1;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.stderr.write(("MiniShell: " + string2 + ": cannot execute (IllegalAccessException)").getBytes());
            return -1;
        }
        boolean bl3 = false;
        try {
            bl3 = Class.forName("com.agilent.tntd.eclipse.minishell.Command").isInstance(obj);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.stderr.write(("MiniShell: " + string2 + ": not a command").getBytes());
            return -1;
        }
        try {
            n = ((Command)obj).exec(taskParameters, stringArray);
        }
        catch (Exception exception) {
            PrintWriter printWriter = new PrintWriter(taskParameters.stderr());
            printWriter.print(String.valueOf(string2) + ": " + exception + "\r\n");
            printWriter.flush();
            exception.printStackTrace();
            n = -1;
        }
        this.cwd = taskParameters.cwd();
        if (taskParameters.stdin() != this.stdin) {
            taskParameters.stdin().close();
        }
        if (taskParameters.stdout() != this.stdout) {
            taskParameters.stdout().close();
        }
        if (taskParameters.stderr() != this.stderr) {
            taskParameters.stderr().close();
        }
        return n;
    }

    private TaskParameters makeTaskParams(Vector vector) {
        InputStream inputStream = this.stdin;
        OutputStream outputStream = this.stdout;
        OutputStream outputStream2 = this.stderr;
        int n = 1;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            try {
                String string2;
                if (string.startsWith(">>")) {
                    if (string.length() > 2) {
                        string2 = string.substring(2);
                        vector.removeElementAt(n);
                        --n;
                    } else {
                        vector.removeElementAt(n);
                        string2 = (String)vector.elementAt(n);
                        vector.removeElementAt(n);
                        --n;
                    }
                    outputStream = this.vfs.getOutputStream(this.cwd.change(string2).toString(), this.instrument);
                } else if (string.startsWith(">")) {
                    if (string.length() > 1) {
                        string2 = string.substring(1);
                        vector.removeElementAt(n);
                        --n;
                    } else {
                        vector.removeElementAt(n);
                        string2 = (String)vector.elementAt(n);
                        vector.removeElementAt(n);
                        --n;
                    }
                    outputStream = this.vfs.getOutputStream(this.cwd.change(string2).toString(), this.instrument);
                } else if (string.startsWith("<")) {
                    if (string.length() > 1) {
                        string2 = string.substring(1);
                        vector.removeElementAt(n);
                        --n;
                    } else {
                        vector.removeElementAt(n);
                        string2 = (String)vector.elementAt(n);
                        vector.removeElementAt(n);
                        --n;
                    }
                    inputStream = this.vfs.getInputStream(this.cwd.change(string2).toString(), this.instrument);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    this.stderr.write("MiniShell: bad redirection\r\n".getBytes());
                }
                catch (IOException iOException) {}
                return null;
            }
            catch (IOException iOException) {
                try {
                    this.stderr.write(("MiniShell: redirection problem: " + iOException.getMessage() + "\r\n").getBytes());
                }
                catch (IOException iOException2) {}
                return null;
            }
            ++n;
        }
        return new TaskParameters(inputStream, outputStream, outputStream2, this.cwd, this.vfs, this.instrument);
    }
}

