/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.minishell;

import com.agilent.tntd.eclipse.minishell.Pathname;
import com.agilent.tntd.eclipse.swupg.Instrument;
import com.agilent.tntd.eclipse.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TaskParameters {
    private InputStream theStdin;
    private OutputStream theStdout;
    private OutputStream theStderr;
    private Pathname theCwd;
    private VirtualFileSystem vfs;
    private Instrument instrument;

    TaskParameters(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Pathname pathname, VirtualFileSystem virtualFileSystem, Instrument instrument) {
        this.theStdin = inputStream;
        this.theStdout = outputStream;
        this.theStderr = outputStream2;
        this.theCwd = pathname;
        this.vfs = virtualFileSystem;
        this.instrument = instrument;
    }

    public InputStream stdin() {
        return this.theStdin;
    }

    public OutputStream stdout() {
        return this.theStdout;
    }

    public OutputStream stderr() {
        return this.theStderr;
    }

    public Pathname cwd() {
        return this.theCwd;
    }

    public void setCwd(String string) throws IOException {
        Pathname pathname = this.theCwd.change(string);
        File file = this.vfs.getFile(pathname.toString(), this.instrument);
        if (!file.isDirectory()) {
            throw new IOException("not a directory");
        }
        this.theCwd = pathname;
    }

    public File getFile(Pathname pathname) throws IOException {
        return this.vfs.getFile(pathname.toString(), this.instrument);
    }

    public InputStream getInputStream(Pathname pathname) throws IOException {
        return this.vfs.getInputStream(pathname.toString(), this.instrument);
    }

    public OutputStream getOutputStream(Pathname pathname) throws IOException {
        return this.vfs.getOutputStream(pathname.toString(), this.instrument);
    }
}

