/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.rshd;

import com.agilent.tntd.eclipse.rshd.NaiveSecurityApprover;
import com.agilent.tntd.eclipse.rshd.RcmdAbortException;
import com.agilent.tntd.eclipse.rshd.SecurityApprover;
import com.agilent.tntd.eclipse.swupg.Instrument;
import com.agilent.tntd.eclipse.swupg.StateManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

abstract class RcmdConnection {
    protected static SecurityApprover approver = new NaiveSecurityApprover();
    protected Socket theSocket;
    protected Socket errSocket;
    protected String client;
    protected String usernameC;
    protected String username;
    protected InputStream stdin;
    protected InputStream signal;
    protected OutputStream stdout;
    protected OutputStream stderr;
    protected Instrument inst;

    RcmdConnection(Socket socket) throws IOException {
        this.theSocket = socket;
        this.errSocket = null;
        this.client = String.valueOf(socket.getInetAddress().getHostName()) + "[" + socket.getPort() + "]";
        this.stdin = this.theSocket.getInputStream();
        this.stderr = this.stdout = this.theSocket.getOutputStream();
        this.signal = null;
        this.usernameC = null;
        this.username = null;
        this.inst = StateManager.instance().getConnection(this.theSocket.getInetAddress());
    }

    boolean initiate(boolean bl, boolean bl2) throws Exception {
        try {
            String string;
            int n;
            if (this.theSocket.getPort() < 512 || this.theSocket.getPort() > 1023) {
                throw new RcmdAbortException("Permission denied.");
            }
            if (bl && (n = (string = this.readUpToNull()).length() != 0 ? new Integer(string) : 0) != 0) {
                this.openStderrPort(n);
            }
            this.usernameC = this.readUpToNull();
            if (this.usernameC.length() > 16) {
                throw new RcmdAbortException("Locuser too long.");
            }
            this.username = this.readUpToNull();
            if (this.username.length() > 16) {
                throw new RcmdAbortException("Ruser too long.");
            }
            if (!approver.approveRhosts(this.theSocket.getInetAddress(), this.usernameC, this.username)) {
                if (bl2) {
                    throw new RcmdAbortException("Login incorrect.");
                }
                return false;
            }
            return true;
        }
        catch (RcmdAbortException rcmdAbortException) {
            this.inst.log(0, rcmdAbortException.getMessage());
            this.stdout.write(1);
            this.stdout.write((String.valueOf(rcmdAbortException.getMessage()) + "\n").getBytes());
            throw rcmdAbortException;
        }
    }

    protected String readUpToNull() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.stdin.read()) > 0) {
            stringBuffer.append((char)n);
        }
        if (n == -1) {
            throw new Exception("unexpected end of stream");
        }
        return stringBuffer.toString();
    }

    private void openStderrPort(int n) throws Exception {
        if (this.theSocket.getPort() < 512 || this.theSocket.getPort() > 1023) {
            throw new RcmdAbortException("Permission denied.");
        }
        int n2 = 1023;
        boolean bl = false;
        while (n2 >= 512 && !bl) {
            try {
                this.errSocket = new Socket(this.theSocket.getInetAddress(), n, this.theSocket.getLocalAddress(), n2);
                bl = true;
            }
            catch (SocketException socketException) {}
            --n2;
        }
        if (!bl) {
            throw new Exception("no reserved ports available");
        }
        this.stderr = this.errSocket.getOutputStream();
        this.signal = this.errSocket.getInputStream();
    }
}

