/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.swupg;

import com.agilent.tntd.eclipse.swupg.ConnectionStatusReporter;
import com.agilent.tntd.eclipse.swupg.StateManager;
import com.agilent.tntd.eclipse.swupg.UIFactory;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Instrument {
    public static final int LEVEL_PROTOCOL = 0;
    public static final int LEVEL_COMMAND = 1;
    public static final int LEVEL_APPLICATION = 2;
    public static final int LEVEL_CONNECTION = 3;
    public static final int STATUS_PRESTART = 0;
    public static final int STATUS_START = 1;
    public static final int STATUS_STAGE1START = 2;
    public static final int STATUS_STAGE1DONE = 3;
    public static final int STATUS_STAGE2START = 4;
    public static final int STATUS_STAGE2DONE = 5;
    public static final int STATUS_DONE = 6;
    public static final int STATUS_ABORT = -1;
    private InetAddress myIP;
    private int useCount;
    private boolean concluded;
    private Vector filesForXfer;
    private int status;
    private int xferred;
    private int toXfer;
    private ConnectionStatusReporter statusReporter;

    Instrument(InetAddress inetAddress, UIFactory uIFactory) {
        this.myIP = inetAddress;
        this.useCount = 0;
        this.concluded = false;
        this.filesForXfer = new Vector();
        this.status = 0;
        this.statusReporter = uIFactory.newConnectionStatusReporter(this);
        this.log(3, "New connection");
    }

    public void log(int n, String string) {
        this.statusReporter.log(n, string);
    }

    public synchronized void addFilesForXfer(Vector vector) {
        this.xferred = 0;
        this.toXfer = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.filesForXfer.addElement(string);
            ++this.toXfer;
        }
        this.statusReporter.log(2, String.valueOf(this.toXfer) + " files to be sent");
    }

    public synchronized void recordFileXfer(String string) {
        String string2 = "Sending file " + string;
        if (this.filesForXfer.contains(string)) {
            ++this.xferred;
            string2 = String.valueOf(string2) + " (" + this.xferred + " of " + this.toXfer + ")";
            this.filesForXfer.removeElement(string);
        }
        this.statusReporter.log(2, string2);
    }

    public void setStatus(int n) {
        String string;
        this.status = n;
        switch (this.status) {
            case 0: {
                string = "Prestart";
                break;
            }
            case 1: {
                string = "Starting upgrade";
                break;
            }
            case 2: {
                string = "Beginning stage 1";
                break;
            }
            case 3: {
                string = "Completed stage 1";
                break;
            }
            case 4: {
                string = "Beginning stage 2";
                break;
            }
            case 5: {
                string = "Completed stage 2";
                break;
            }
            case 6: {
                string = "Upgrade completed!";
                this.concluded = true;
                break;
            }
            default: {
                string = "< invalid state >";
            }
        }
        this.log(3, string);
    }

    public void openConnection() {
        ++this.useCount;
    }

    public void closeConnection() {
        --this.useCount;
        if (this.useCount == 0 && this.concluded) {
            StateManager.instance().deregister(this);
            this.log(3, "Concluded connection");
        }
    }

    public InetAddress getInetAddress() {
        return this.myIP;
    }
}

