/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.swupg;

import com.agilent.tntd.eclipse.swupg.Instrument;
import com.agilent.tntd.eclipse.swupg.UIFactory;
import java.net.InetAddress;
import java.util.Hashtable;

public class StateManager {
    private static StateManager theInstance = null;
    private Hashtable connections = new Hashtable();
    private UIFactory uiFactory;

    public static StateManager instance() {
        return theInstance;
    }

    static void instantiate(UIFactory uIFactory) {
        theInstance = new StateManager(uIFactory);
    }

    private StateManager(UIFactory uIFactory) {
        this.uiFactory = uIFactory;
    }

    public Instrument getConnection(InetAddress inetAddress) {
        Instrument instrument = (Instrument)this.connections.get(inetAddress);
        if (instrument == null) {
            instrument = new Instrument(inetAddress, this.uiFactory);
            this.connections.put(inetAddress, instrument);
        }
        return instrument;
    }

    void deregister(Instrument instrument) {
        this.connections.remove(instrument);
    }
}

