/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.vfs;

import com.agilent.tntd.eclipse.swupg.Instrument;
import com.agilent.tntd.eclipse.vfs.VFSException;
import com.agilent.tntd.eclipse.vfs.VFSMount;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class VirtualFileSystem {
    private Hashtable mountList = new Hashtable();
    private VFSMount root;

    public VirtualFileSystem(VFSMount vFSMount) {
        this.root = vFSMount;
    }

    public void setRoot(VFSMount vFSMount) {
        this.root = vFSMount;
    }

    public void mount(String string, VFSMount vFSMount) throws VFSException {
        if (string.indexOf(File.separator) != -1) {
            throw new VFSException("Illegal character in mount point");
        }
        if (this.mountList.containsKey(string)) {
            throw new VFSException("Mount point already in use");
        }
        this.mountList.put(string, vFSMount);
    }

    private MountAndRemainder getMountAndRemainder(String string) throws VFSException {
        if (!string.startsWith("/")) {
            throw new VFSException("Relative pathname not acceptable");
        }
        int n = string.indexOf("/", 1);
        if (n == -1) {
            n = string.length();
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n);
        VFSMount vFSMount = (VFSMount)this.mountList.get(string2);
        if (vFSMount != null) {
            return new MountAndRemainder(vFSMount, string3);
        }
        if (this.root == null) {
            throw new VFSException("Unknown filesystem");
        }
        return new MountAndRemainder(this.root, string);
    }

    public File getFile(String string, Instrument instrument) throws IOException {
        MountAndRemainder mountAndRemainder = this.getMountAndRemainder(string);
        return mountAndRemainder.mount.getFile(mountAndRemainder.remainder, instrument);
    }

    public InputStream getInputStream(String string, Instrument instrument) throws IOException {
        instrument.recordFileXfer(string);
        MountAndRemainder mountAndRemainder = this.getMountAndRemainder(string);
        return mountAndRemainder.mount.getInputStream(mountAndRemainder.remainder, instrument);
    }

    public OutputStream getOutputStream(String string, Instrument instrument) throws IOException {
        MountAndRemainder mountAndRemainder = this.getMountAndRemainder(string);
        return mountAndRemainder.mount.getOutputStream(mountAndRemainder.remainder, instrument);
    }

    private class MountAndRemainder {
        public VFSMount mount;
        public String remainder;

        public MountAndRemainder(VFSMount vFSMount, String string) {
            VirtualFileSystem.this = VirtualFileSystem.this;
            this.mount = vFSMount;
            this.remainder = string;
        }
    }
}

