/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JTree;
import com.sun.java.swing.event.CellEditorListener;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import com.sun.java.swing.tree.TreeCellEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;

public class BasicTreeCellEditorContainer
extends Container
implements TreeCellEditor {
    protected BasicTreeCellRenderer renderer;
    protected transient Component editor;
    protected transient TreeCellEditor realEditor;
    protected transient Icon editingIcon;
    protected int editingOffset;
    protected boolean editingLeaf;
    protected boolean editingExpanded;

    public BasicTreeCellEditorContainer(TreeCellEditor treeCellEditor, BasicTreeCellRenderer basicTreeCellRenderer) {
        this.realEditor = treeCellEditor;
        this.renderer = basicTreeCellRenderer;
        this.setLayout(null);
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.realEditor.isCellEditable(eventObject)) {
            this.prepareForEditing();
            return true;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.realEditor.shouldSelectCell(eventObject);
    }

    protected void prepareForEditing() {
        this.add(this.editor);
        if (this.renderer != null) {
            this.editingIcon = this.editingLeaf ? this.renderer.getLeafIcon() : (this.editingExpanded ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
            if (this.editingIcon == null) {
                this.editingOffset = 0;
                return;
            }
            this.editingOffset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
            return;
        }
        this.editingOffset = 0;
        this.editingIcon = null;
    }

    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editor != null) {
                this.remove(this.editor);
            }
            this.editingIcon = null;
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editor != null) {
            this.remove(this.editor);
        }
        this.editingIcon = null;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    public void doLayout() {
        if (this.editor != null) {
            Dimension dimension = this.getSize();
            this.editor.getPreferredSize();
            this.editor.setLocation(this.editingOffset, 0);
            this.editor.setBounds(this.editingOffset, 0, dimension.width - this.editingOffset, dimension.height);
        }
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.editingLeaf = bl3;
        this.editingExpanded = bl2;
        this.editor = this.realEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        return this;
    }

    public void paint(Graphics graphics) {
        if (this.editingIcon != null) {
            int n = Math.max(0, (this.getSize().height - this.editingIcon.getIconHeight()) / 2);
            this.editingIcon.paintIcon(this, graphics, 0, n);
        }
        super.paint(graphics);
    }

    public Dimension getPreferredSize() {
        if (this.editor != null) {
            Dimension dimension = this.editor.getPreferredSize();
            dimension.width += this.editingOffset + 5;
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public void requestFocus() {
        if (this.editor != null) {
            this.editor.requestFocus();
            return;
        }
        super.requestFocus();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.editingIcon != null && this.editingIcon instanceof Serializable) {
            vector.addElement("editingIcon");
            vector.addElement(this.editingIcon);
        }
        if (this.realEditor != null && this.realEditor instanceof Serializable) {
            vector.addElement("realEditor");
            vector.addElement(this.realEditor);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("editingIcon")) {
            this.editingIcon = (Icon)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("realEditor")) {
            this.realEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
    }
}

