/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.graphs;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.SupportsCodeInitialisation;
import com.agilent.tntd.eclipse.viewlayer.designtime.CodeGenerationHelper;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DatasetProperties
implements SupportsCodeInitialisation,
Serializable {
    static final long serialVersionUID = -3411138815685158378L;
    private String variable = "";
    private String xDataName = "";
    private String yDataName = "";
    private String passFlag = "";
    private Color color = null;
    private transient Color defaultColor = null;
    private int dataMarkers = 0;
    private boolean connected = true;

    public DatasetProperties(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public DatasetProperties(String variable, String xDataName, String yDataName, String passFlag, Color color) {
        this.variable = variable;
        this.xDataName = xDataName;
        this.yDataName = yDataName;
        this.passFlag = passFlag;
        this.color = color;
    }

    public DatasetProperties(String variable, String xDataName, String yDataName, String passFlag, Color color, int dataMarkers, boolean connected) {
        this.variable = variable;
        this.xDataName = xDataName;
        this.yDataName = yDataName;
        this.passFlag = passFlag;
        this.color = color;
        this.dataMarkers = dataMarkers;
        this.connected = connected;
    }

    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        return this.defaultColor;
    }

    public int getDataMarkers() {
        return this.dataMarkers;
    }

    public String getInitialisationString() {
        StringBuffer s = new StringBuffer(1000);
        s.append("new " + this.getClass().getName() + "(");
        s.append(CodeGenerationHelper.createVariableString((String)this.variable));
        s.append(", ");
        s.append(CodeGenerationHelper.createVariableString((String)this.xDataName));
        s.append(", ");
        s.append(CodeGenerationHelper.createVariableString((String)this.yDataName));
        s.append(", ");
        s.append(CodeGenerationHelper.createVariableString((String)this.passFlag));
        s.append(", ");
        s.append(CodeGenerationHelper.createColorString((Color)this.getRealColor()));
        s.append(", ");
        s.append(this.getDataMarkers());
        s.append(", ");
        s.append(this.isConnected());
        s.append(")");
        return s.toString();
    }

    public String getPassFlag() {
        return this.passFlag;
    }

    private Color getRealColor() {
        if (this.defaultColor != null) {
            return this.defaultColor.equals(this.color) ? null : this.color;
        }
        return this.color;
    }

    public String getVariable() {
        return this.variable;
    }

    public String getXDataName() {
        return this.xDataName;
    }

    public String getYDataName() {
        return this.yDataName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        int version = s.readInt();
        switch (version) {
            case 0: {
                this.variable = (String)s.readObject();
                this.xDataName = (String)s.readObject();
                this.yDataName = (String)s.readObject();
                this.passFlag = (String)s.readObject();
                this.color = (Color)s.readObject();
                break;
            }
            case 1: {
                this.variable = (String)s.readObject();
                this.xDataName = (String)s.readObject();
                this.yDataName = (String)s.readObject();
                this.passFlag = (String)s.readObject();
                this.color = (Color)s.readObject();
                this.dataMarkers = s.readInt();
                this.connected = s.readBoolean();
                break;
            }
            default: {
                String details = "DatasetProperties: readObject: Cannot deserialize. Unknown version encountered: " + version;
                throw new IOException(details);
            }
        }
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public void setConnected(boolean c) {
        this.connected = c;
    }

    public void setDataMarkers(int d) {
        this.dataMarkers = d;
    }

    public void setDefaultColor(Color newColor) {
        this.defaultColor = newColor;
    }

    public void setPassFlag(String newPassFlag) {
        this.passFlag = newPassFlag;
    }

    public void setVariable(String newVariable) {
        this.variable = newVariable;
    }

    public void setXDataName(String newXDataName) {
        this.xDataName = newXDataName;
    }

    public void setYDataName(String newYDataName) {
        this.yDataName = newYDataName;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(1);
        s.writeObject(this.variable);
        s.writeObject(this.xDataName);
        s.writeObject(this.yDataName);
        s.writeObject(this.passFlag);
        s.writeObject(this.color);
        s.writeInt(this.dataMarkers);
        s.writeBoolean(this.connected);
    }
}

