/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.graphs;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.EclGraphModel;
import com.agilent.tntd.eclipse.graphs.EclGraphView;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import java.io.IOException;

public class EclGraph
extends EclipseComponent
implements CcConnectedComponent,
ApplicationGenericDataReceiver {
    static final int maxDataSets = 8;
    private EclGraphModel eclModel = null;
    private transient boolean initialized = false;
    private transient boolean[] initDataOnly = new boolean[8];
    private transient boolean hasTrappedTransientError = false;
    private transient boolean hasTrappedPermanentError = false;
    private transient EclGraphView eclView = null;
    private transient ApplicationObject graphInfoAO = null;
    private transient ApplicationObject dataSet0_AO = null;
    private transient ApplicationObject dataSet1_AO = null;
    private transient ApplicationObject dataSet2_AO = null;
    private transient ApplicationObject dataSet3_AO = null;
    private transient ApplicationObject dataSet4_AO = null;
    private transient ApplicationObject dataSet5_AO = null;
    private transient ApplicationObject dataSet6_AO = null;
    private transient ApplicationObject dataSet7_AO = null;
    transient boolean debug = false;

    public EclGraph() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        ((Component)((Object)this)).setSize(150, 150);
        this.setInitDataOnlyFlag(true);
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals(this.eclModel.getGraphInfoVariable())) {
            this.graphInfoAO = anAO;
            if (anAO.getInitialisationState() == 2) {
                this.query(anAO, 1);
            }
        } else {
            if (anAO.getName().equals(this.eclModel.getDatasetVariable(0))) {
                this.dataSet0_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(1))) {
                this.dataSet1_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(2))) {
                this.dataSet2_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(3))) {
                this.dataSet3_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(4))) {
                this.dataSet4_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(5))) {
                this.dataSet5_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(6))) {
                this.dataSet6_AO = anAO;
            } else if (anAO.getName().equals(this.eclModel.getDatasetVariable(7))) {
                this.dataSet7_AO = anAO;
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Unknown AO received: " + anAO.toString());
                return;
            }
            if (this.initialized && anAO.getInitialisationState() == 2) {
                this.query(anAO, 1);
            }
        }
    }

    protected ApplicationGenericMetaData createMetaData(ApplicationObject ao, int dataID) {
        ApplicationGenericMetaData meta = null;
        try {
            meta = new ApplicationGenericMetaData();
            PrimitiveTypesWriter writer = meta.getPrimitiveTypesWriter();
            if (ao == this.graphInfoAO) {
                writer.write(dataID);
            } else {
                String z = null;
                float min = 0.0f;
                writer.write(dataID);
                int dataset = this.getDataSet((ApplicationDataSender)ao);
                if (dataset >= 8) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: AO does not correspond to a data set: " + ao.toString());
                    this.permanentError();
                    return null;
                }
                String x = this.eclModel.getXDataName(dataset);
                String y = this.eclModel.getYDataName(dataset);
                z = this.eclModel.getPassFlag(dataset);
                min = this.eclView.getLastReceivedXValue(dataset);
                if (x == null || y == null || z == null) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Cannot create meta data for AO " + ao.toString() + ". A dataName has been ommitted. Check design-time parameters.");
                    this.permanentError();
                    return null;
                }
                writer.write(x);
                writer.write(y);
                writer.write(z);
                writer.write(min);
                Float max = this.eclView.isXLog() ? new Float(Math.pow(10.0, Math.ceil(this.eclView.getXRangeMax()))) : new Float(Math.ceil(this.eclView.getXRangeMax()));
                writer.write(max.floatValue());
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Creation of meta data failed!");
            return null;
        }
        meta.completedMetaDataInitialisation();
        return meta;
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        String debugProperty = System.getProperty("graph.debug");
        if (debugProperty != null && debugProperty.equals("1")) {
            this.debug = true;
        }
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        Color color = super.getBackground();
        if (color != null) {
            return color;
        }
        Container c = ((Component)((Object)this)).getParent();
        while (c != null) {
            if (c.getBackground() != null) {
                return c.getBackground();
            }
            c = c.getParent();
        }
        return Color.lightGray;
    }

    public int getDataSet(ApplicationDataSender sender) {
        int dataset = -1;
        if (sender == this.dataSet0_AO) {
            dataset = 0;
        } else if (sender == this.dataSet1_AO) {
            dataset = 1;
        } else if (sender == this.dataSet2_AO) {
            dataset = 2;
        } else if (sender == this.dataSet3_AO) {
            dataset = 3;
        } else if (sender == this.dataSet4_AO) {
            dataset = 4;
        } else if (sender == this.dataSet5_AO) {
            dataset = 5;
        } else if (sender == this.dataSet6_AO) {
            dataset = 6;
        } else if (sender == this.dataSet7_AO) {
            dataset = 7;
        }
        return dataset;
    }

    protected EclGraphView getEclGraphView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.getEclGraphView();
    }

    public EclGraphModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclGraphModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    public Color getForeground() {
        if (this.hasTrappedTransientError) {
            return GraphDefaults.transientErrorColour;
        }
        Color color = super.getForeground();
        if (color != null) {
            return color;
        }
        Container c = ((Component)((Object)this)).getParent();
        while (c != null) {
            if (c.getForeground() != null) {
                return c.getForeground();
            }
            c = c.getParent();
        }
        return Color.black;
    }

    public boolean hasTrappedPermanentError() {
        return this.hasTrappedPermanentError;
    }

    public boolean hasTrappedTransientError() {
        return this.hasTrappedTransientError;
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void paint(Graphics g) {
        if (this.eclView != null) {
            this.eclView.paint(g);
        }
    }

    public void permanentError() {
        this.setBackground(GraphDefaults.permanentErrorColour);
        this.setForeground(GraphDefaults.permanentErrorColour);
        this.eclView.setGraphAreaColor(GraphDefaults.permanentErrorColour);
        this.eclView.setGridColor(GraphDefaults.permanentErrorColour);
        this.hasTrappedPermanentError = true;
        this.hasTrappedTransientError = false;
        ((Component)((Object)this)).setVisible(true);
        this.unregister();
    }

    public void query(ApplicationObject ao, int dataID) {
        ApplicationGenericMetaData meta = this.createMetaData(ao, dataID);
        if (meta != null) {
            ao.asyncQuery((ApplicationMetaData)meta, (ApplicationObjectObserver)this);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": query: Unable to create meta data! Query for AO " + ao.toString() + " failed.");
        }
    }

    public void readGraphData(int dataset, ApplicationGenericData v, ApplicationDataSender s) {
        PrimitiveTypesReader reader = v.getPrimitiveTypesReader();
        if (reader == null) {
            this.trapTransientError(true);
        } else {
            try {
                int size;
                int dataID = reader.readInt();
                if (this.initDataOnly[dataset]) {
                    if (dataID == 1) {
                        if (this.debug) {
                            EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphData: Received INIT data for dataset " + dataset);
                        }
                        this.initDataOnly[dataset] = false;
                    } else {
                        if (this.debug) {
                            EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphData: Dropping data for dataset " + dataset + ". Waiting for INIT data.");
                        }
                        return;
                    }
                }
                if ((size = reader.readInt()) > 0) {
                    float[] x = new float[size];
                    float[] y = new float[size];
                    float[] z = new float[size];
                    int i = 0;
                    while (i < size) {
                        x[i] = reader.readFloat();
                        y[i] = reader.readFloat();
                        z[i] = reader.readFloat();
                        ++i;
                    }
                    this.eclView.plotData(dataset, x, y, z);
                    this.trapTransientError(false);
                } else if (size == 0) {
                    if (this.debug) {
                        EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphData: No graph data currently available for dataset " + dataset);
                    }
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": readGraphData: Invalid data received: size = " + size);
                    this.trapTransientError(true);
                }
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": readGraphData: Received meaningless data for graphs");
                this.trapTransientError(true);
            }
        }
    }

    public void readGraphInfo(ApplicationGenericData v, ApplicationDataSender s) {
        PrimitiveTypesReader reader = v.getPrimitiveTypesReader();
        if (reader == null) {
            this.trapTransientError(true);
        } else {
            int dataID = 999;
            try {
                dataID = reader.readInt();
                switch (dataID) {
                    case -3: {
                        if (this.debug) {
                            EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphInfo: Received CURSOR CHANGE event from server");
                        }
                        this.eclView.setCursorLocation(reader.readFloat());
                        ((Component)((Object)this)).repaint();
                        break;
                    }
                    case 0: {
                        if (this.debug) {
                            EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphInfo: Received NEW DATA event from server; Initialized = " + this.initialized);
                        }
                        if (this.initialized) {
                            this.eclView.setEndOfDataLocation(reader.readFloat());
                            if (this.dataSet0_AO != null && this.dataSet0_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(0) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet0_AO, 2);
                            }
                            if (this.dataSet1_AO != null && this.dataSet1_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(1) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet1_AO, 2);
                            }
                            if (this.dataSet2_AO != null && this.dataSet2_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(2) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet2_AO, 2);
                            }
                            if (this.dataSet3_AO != null && this.dataSet3_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(3) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet3_AO, 2);
                            }
                            if (this.dataSet4_AO != null && this.dataSet4_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(4) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet4_AO, 2);
                            }
                            if (this.dataSet5_AO != null && this.dataSet5_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(5) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet5_AO, 2);
                            }
                            if (this.dataSet6_AO != null && this.dataSet6_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(6) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet6_AO, 2);
                            }
                            if (this.dataSet7_AO != null && this.dataSet7_AO.getInitialisationState() == 2 && this.eclView.getLastReceivedXValue(7) < this.eclView.getXRangeMax()) {
                                this.query(this.dataSet7_AO, 2);
                            }
                        }
                        break;
                    }
                    case -1: {
                        if (this.debug) {
                            EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphInfo: Received RESET event from server");
                        }
                        float xRangeMin = reader.readFloat();
                        float xRangeMax = reader.readFloat();
                        float yRangeMin = reader.readFloat();
                        float yRangeMax = reader.readFloat();
                        int commonFlags = reader.readInt();
                        int xFlags = reader.readInt();
                        int yFlags = reader.readInt();
                        float endOfDataLocation = reader.readFloat();
                        float cursorLocation = reader.readFloat();
                        this.eclView.setGraphInfoParameters(xRangeMin, xRangeMax, yRangeMin, yRangeMax, commonFlags, xFlags, yFlags, endOfDataLocation, cursorLocation);
                        ((Component)((Object)this)).repaint();
                        break;
                    }
                    case 1: {
                        if (this.debug) {
                            EventLog.instance().log("DEBUG: " + this.toString() + ": readGraphInfo: Received INIT response from server");
                        }
                        this.setInitDataOnlyFlag(true);
                        float xRangeMin = reader.readFloat();
                        float xRangeMax = reader.readFloat();
                        float yRangeMin = reader.readFloat();
                        float yRangeMax = reader.readFloat();
                        int commonFlags = reader.readInt();
                        int xFlags = reader.readInt();
                        int yFlags = reader.readInt();
                        float endOfDataLocation = reader.readFloat();
                        float cursorLocation = reader.readFloat();
                        this.eclView.setGraphInfoParameters(xRangeMin, xRangeMax, yRangeMin, yRangeMax, commonFlags, xFlags, yFlags, endOfDataLocation, cursorLocation);
                        this.initialized = true;
                        if (this.dataSet0_AO != null) {
                            this.query(this.dataSet0_AO, 1);
                        }
                        if (this.dataSet1_AO != null) {
                            this.query(this.dataSet1_AO, 1);
                        }
                        if (this.dataSet2_AO != null) {
                            this.query(this.dataSet2_AO, 1);
                        }
                        if (this.dataSet3_AO != null) {
                            this.query(this.dataSet3_AO, 1);
                        }
                        if (this.dataSet4_AO != null) {
                            this.query(this.dataSet4_AO, 1);
                        }
                        if (this.dataSet5_AO != null) {
                            this.query(this.dataSet5_AO, 1);
                        }
                        if (this.dataSet6_AO != null) {
                            this.query(this.dataSet6_AO, 1);
                        }
                        if (this.dataSet7_AO != null) {
                            this.query(this.dataSet7_AO, 1);
                        }
                        break;
                    }
                    default: {
                        EventLog.instance().log("WARNING: " + this.toString() + ":readGraphInfo: Received unhandled data ID: " + dataID);
                    }
                }
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": readGraphInfo: Received meaningless data for graphs");
                this.trapTransientError(true);
            }
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData v, ApplicationDataSender s) {
        if (s == this.graphInfoAO) {
            this.readGraphInfo(v, s);
        } else {
            int dataset = this.getDataSet(s);
            if (dataset > -1 && dataset < 8) {
                this.readGraphData(dataset, v, s);
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Received data from an unknown sender: " + s.toString());
            }
        }
    }

    public void setEclGraphView(EclGraphView newView) {
        this.eclView = newView;
    }

    public void setEclModel(EclGraphModel newModel) {
        this.eclModel = newModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setInitDataOnlyFlag(boolean value) {
        int i = 0;
        while (i < this.initDataOnly.length) {
            this.initDataOnly[i] = value;
            ++i;
        }
    }

    public String toString() {
        return ((Component)((Object)this)).getName() == null || ((Component)((Object)this)).getName().equalsIgnoreCase("") ? "EclGraph" : ((Component)((Object)this)).getName();
    }

    public void trapTransientError(boolean isInError) {
        this.trapTransientError(isInError, true);
    }

    public void trapTransientError(boolean isInError, boolean repaint) {
        if (this.hasTrappedTransientError != isInError) {
            if (this.debug) {
                EventLog.instance().log("DEBUG: " + this.toString() + ": trapTransientError: Transient error = " + this.hasTrappedTransientError);
            }
            this.hasTrappedTransientError = isInError;
            if (repaint) {
                ((Component)((Object)this)).repaint();
            }
        }
    }

    public void unregister() {
        if (this.graphInfoAO != null) {
            this.graphInfoAO.unregister((ApplicationObjectObserver)this);
            this.graphInfoAO = null;
        }
        if (this.dataSet0_AO != null) {
            this.dataSet0_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet0_AO = null;
        }
        if (this.dataSet1_AO != null) {
            this.dataSet1_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet1_AO = null;
        }
        if (this.dataSet2_AO != null) {
            this.dataSet2_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet2_AO = null;
        }
        if (this.dataSet3_AO != null) {
            this.dataSet3_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet3_AO = null;
        }
        if (this.dataSet4_AO != null) {
            this.dataSet4_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet4_AO = null;
        }
        if (this.dataSet5_AO != null) {
            this.dataSet5_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet5_AO = null;
        }
        if (this.dataSet6_AO != null) {
            this.dataSet6_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet6_AO = null;
        }
        if (this.dataSet7_AO != null) {
            this.dataSet7_AO.unregister((ApplicationObjectObserver)this);
            this.dataSet7_AO = null;
        }
        this.initialized = false;
        this.eclView.resetGraphParameters();
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update: Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        }
    }
}

