/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.graphs;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.AccessibleEclGraphModel;
import com.agilent.tntd.eclipse.graphs.DatasetProperties;
import com.agilent.tntd.eclipse.graphs.EclGraph;
import com.agilent.tntd.eclipse.graphs.EclGraphView;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclGraphModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = -3963813225805279598L;
    private transient EclGraph controller = null;
    private String graphInfoVariable = null;
    private boolean drawGridLines = false;
    private boolean drawCursor = false;
    private boolean drawEOD = false;
    private DatasetProperties[] datasetProperties = new DatasetProperties[8];
    private int selectedDataset = -1;

    public EclGraphModel() {
        int i = 0;
        while (i < this.datasetProperties.length) {
            this.datasetProperties[i] = new DatasetProperties(GraphDefaults.lineColor[i]);
            ++i;
        }
    }

    public EclGraphModel(String aGraphInfoVariable, boolean aDrawGridLinesFlag, boolean aDrawCursorFlag, DatasetProperties[] aDatasetPropertiesArray, int anIndex) {
        this.graphInfoVariable = aGraphInfoVariable;
        this.drawGridLines = aDrawGridLinesFlag;
        this.drawCursor = aDrawCursorFlag;
        this.datasetProperties = aDatasetPropertiesArray;
        this.selectedDataset = anIndex;
    }

    public EclGraphModel(String aGraphInfoVariable, boolean aDrawGridLinesFlag, boolean aDrawCursorFlag, boolean aDrawEODFlag, DatasetProperties[] aDatasetPropertiesArray, int anIndex) {
        this.graphInfoVariable = aGraphInfoVariable;
        this.drawGridLines = aDrawGridLinesFlag;
        this.drawCursor = aDrawCursorFlag;
        this.drawEOD = aDrawEODFlag;
        this.datasetProperties = aDatasetPropertiesArray;
        this.selectedDataset = anIndex;
    }

    protected AccessibleEclGraphModel createAccessibleModel() {
        return new AccessibleEclGraphModel(this.graphInfoVariable, this.drawGridLines, this.drawCursor, this.drawEOD, this.datasetProperties, this.selectedDataset, this.controller);
    }

    public void createView() {
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(GraphDefaults.background);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(GraphDefaults.font);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(GraphDefaults.foreground);
        }
        if (this.controller.getEclGraphView() == null) {
            this.controller.setEclGraphView(new EclGraphView(this.controller));
        }
        this.controller.getEclGraphView().setDrawGrid(this.drawGridLines);
        this.controller.getEclGraphView().setDrawCursor(this.drawCursor);
        this.controller.getEclGraphView().setDrawEOD(this.drawEOD);
        Color[] colors = new Color[this.datasetProperties.length];
        int[] markers = new int[this.datasetProperties.length];
        boolean[] connected = new boolean[this.datasetProperties.length];
        int i = 0;
        while (i < this.datasetProperties.length) {
            colors[i] = this.datasetProperties[i].getColor();
            markers[i] = this.datasetProperties[i].getDataMarkers();
            connected[i] = this.datasetProperties[i].isConnected();
            ++i;
        }
        this.controller.getEclGraphView().setPlotColors(colors);
        this.controller.getEclGraphView().setDataMarkers(markers);
        this.controller.getEclGraphView().setConnected(connected);
    }

    public void finishInitialise() {
        if (this.graphInfoVariable == null || this.graphInfoVariable.equalsIgnoreCase("")) {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishiInitialise: A graph info variable MUST be specified");
            this.controller.permanentError();
        } else {
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.graphInfoVariable, (ApplicationObjectObserver)this.controller);
            int i = 0;
            while (i < this.datasetProperties.length) {
                if (this.getDatasetVariable(i) != null) {
                    ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.getDatasetVariable(i), (ApplicationObjectObserver)this.controller);
                }
                ++i;
            }
        }
    }

    public String getDatasetVariable(int dataset) {
        return this.datasetProperties[dataset].getVariable();
    }

    public String getGraphInfoVariable() {
        return this.graphInfoVariable;
    }

    public String getPassFlag(int dataset) {
        return this.datasetProperties[dataset].getPassFlag();
    }

    public String getXDataName(int dataset) {
        return this.datasetProperties[dataset].getXDataName();
    }

    public String getYDataName(int dataset) {
        return this.datasetProperties[dataset].getYDataName();
    }

    public void initialiseDefaults() {
        this.controller.setBackground(GraphDefaults.background);
        this.controller.setForeground(GraphDefaults.foreground);
        this.controller.setFont(GraphDefaults.font);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        int version = s.readInt();
        switch (version) {
            case 0: {
                this.graphInfoVariable = (String)s.readObject();
                this.drawGridLines = s.readBoolean();
                this.drawCursor = s.readBoolean();
                this.selectedDataset = s.readInt();
                int length = s.readInt();
                this.datasetProperties = new DatasetProperties[8];
                int i = 0;
                while (i < length) {
                    this.datasetProperties[i] = (DatasetProperties)s.readObject();
                    this.datasetProperties[i].setDefaultColor(GraphDefaults.lineColor[i]);
                    ++i;
                }
                i = length;
                while (i < 8) {
                    this.datasetProperties[i] = new DatasetProperties(GraphDefaults.lineColor[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                this.graphInfoVariable = (String)s.readObject();
                this.drawGridLines = s.readBoolean();
                this.drawCursor = s.readBoolean();
                this.drawEOD = s.readBoolean();
                this.selectedDataset = s.readInt();
                int length = s.readInt();
                this.datasetProperties = new DatasetProperties[8];
                int i = 0;
                while (i < length) {
                    this.datasetProperties[i] = (DatasetProperties)s.readObject();
                    this.datasetProperties[i].setDefaultColor(GraphDefaults.lineColor[i]);
                    ++i;
                }
                i = length;
                while (i < 8) {
                    this.datasetProperties[i] = new DatasetProperties(GraphDefaults.lineColor[i]);
                    ++i;
                }
                break;
            }
            default: {
                String details = "EclGraphModel: readObject: Cannot deserialize. Unknown version encountered: " + version;
                throw new IOException(details);
            }
        }
    }

    public void setController(EclGraph newController) {
        this.controller = newController;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("[");
        b.append(this.graphInfoVariable == null ? "null" : this.graphInfoVariable);
        b.append(", ");
        b.append(this.drawGridLines);
        b.append(", ");
        b.append(this.drawCursor);
        b.append(", ");
        b.append(this.drawEOD);
        int i = 0;
        while (i < this.datasetProperties.length) {
            b.append(", ");
            String datasetVariable = this.datasetProperties[i].getVariable();
            b.append(datasetVariable == null ? "null" : datasetVariable);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int length = this.datasetProperties.length;
        s.writeInt(1);
        s.writeObject(this.graphInfoVariable);
        s.writeBoolean(this.drawGridLines);
        s.writeBoolean(this.drawCursor);
        s.writeBoolean(this.drawEOD);
        s.writeInt(this.selectedDataset);
        s.writeInt(length);
        int i = 0;
        while (i < length) {
            s.writeObject(this.datasetProperties[i]);
            ++i;
        }
    }
}

