/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.graphs;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.AccessibleEclGraphModel;
import com.agilent.tntd.eclipse.graphs.DataMarkers;
import com.agilent.tntd.eclipse.graphs.DatasetProperties;
import com.agilent.tntd.eclipse.graphs.EclGraph;
import com.agilent.tntd.eclipse.graphs.EclGraphModel;
import com.agilent.tntd.eclipse.graphs.EclGraphModelEditor;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EtchedBorder;
import com.sun.java.swing.preview.JColorChooser;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class EclGraphModelWindow
extends Panel {
    private EclGraph theComponentForModel;
    private static final String[] datasets = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
    private DatasetProperties[] datasetProperties = null;
    private JCheckBox ivjCursorCheckBox = null;
    private JLabel ivjDatasetLabel = null;
    private JPanel ivjDatasetPanel = null;
    private JLabel ivjGeneralLabel = null;
    private JCheckBox ivjGridCheckBox = null;
    private JLabel ivjDatasetVariableLabel = null;
    private JLabel ivjXAxisLabel = null;
    private JLabel ivjYAxisLabel = null;
    private JTextField ivjDatasetVariableTextField = null;
    private JLabel ivjGraphInfoVariableLabel = null;
    private JTextField ivjGraphInfoVariableTextField = null;
    private JTextField ivjXAxisTextField = null;
    private JTextField ivjYAxisTextField = null;
    private JLabel ivjPassFailLabel = null;
    private JTextField ivjPassFailTextField = null;
    private JLabel ivjColorLabel = null;
    private JButton ivjLineColorButton = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);
    private JPanel ivjGeneralPanel = null;
    private Choice ivjDatasetChoice = null;
    private JLabel ivjPropertiesLabel = null;
    private JButton ivjSaveButton = null;
    private JPanel ivjSavePanel = null;
    private JCheckBox ivjEODCheckBox = null;
    private Choice ivjDataMarkerChoice = null;
    private JLabel ivjMarkerLabel = null;
    private JCheckBox ivjConnectPointsCheckBox = null;

    public EclGraphModelWindow() {
        this.initialize();
    }

    public void colorButton_ActionPerformed() {
        JPanel p = new JPanel();
        Color old = this.getLineColorButton().getBackground();
        Color newColor = JColorChooser.showDialog((Component)p, (String)"Select line colour", (Color)old);
        this.datasetProperties[this.getDatasetChoice().getSelectedIndex()].setColor(newColor);
        if (newColor != null) {
            this.getLineColorButton().setBackground(newColor);
        }
    }

    public void connectPointsCheckBox_ActionPerformed() {
        int index = this.getDatasetChoice().getSelectedIndex();
        this.datasetProperties[index].setConnected(this.getConnectPointsCheckBox().isSelected());
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.colorButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.saveButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(FocusEvent arg1) {
        try {
            this.datasetVariableTextField_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(FocusEvent arg1) {
        try {
            this.xAxisTextField_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(FocusEvent arg1) {
        try {
            this.yAxisTextField_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(FocusEvent arg1) {
        try {
            this.passFailTextField_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ItemEvent arg1) {
        try {
            this.dataMarkerChoice_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ItemEvent arg1) {
        try {
            this.datasetChoice_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ActionEvent arg1) {
        try {
            this.connectPointsCheckBox_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void dataMarkerChoice_ItemStateChanged() {
        int index = this.getDatasetChoice().getSelectedIndex();
        this.datasetProperties[index].setDataMarkers(this.getDataMarkerChoice().getSelectedIndex());
        if (this.getDataMarkerChoice().getSelectedIndex() == 0) {
            this.datasetProperties[index].setConnected(true);
            this.getConnectPointsCheckBox().setSelected(true);
            this.getConnectPointsCheckBox().setEnabled(false);
        } else {
            this.getConnectPointsCheckBox().setEnabled(true);
        }
    }

    public void datasetChoice_ItemStateChanged(ItemEvent itemEvent) {
        int index = this.getDatasetChoice().getSelectedIndex();
        if (this.datasetProperties != null && this.datasetProperties.length > 0) {
            try {
                if (this.datasetProperties[index] != null) {
                    if (this.datasetProperties[index].getVariable() != null) {
                        this.getDatasetVariableTextField().setText(this.datasetProperties[index].getVariable());
                    }
                    if (this.datasetProperties[index].getXDataName() != null) {
                        this.getXAxisTextField().setText(this.datasetProperties[index].getXDataName());
                    }
                    if (this.datasetProperties[index].getYDataName() != null) {
                        this.getYAxisTextField().setText(this.datasetProperties[index].getYDataName());
                    }
                    if (this.datasetProperties[index].getPassFlag() != null) {
                        this.getPassFailTextField().setText(this.datasetProperties[index].getPassFlag());
                    }
                    if (this.datasetProperties[index].getColor() == null) {
                        this.getLineColorButton().setBackground(this.getBackground());
                    } else {
                        this.getLineColorButton().setBackground(this.datasetProperties[index].getColor());
                    }
                    this.getLineColorButton().repaint();
                    this.getDataMarkerChoice().select(this.datasetProperties[index].getDataMarkers());
                    this.getConnectPointsCheckBox().setSelected(this.datasetProperties[index].isConnected());
                    this.dataMarkerChoice_ItemStateChanged();
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": datasetChoice_ItemStateChanged: selected dataset " + index + " has no properties!");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": datasetChoice_ItemStateChanged: selected dataset has caused an out-of-bounds error in the dataset properties array");
            }
        }
    }

    public void datasetVariableTextField_FocusLost(FocusEvent focusEvent) {
        int index = this.getDatasetChoice().getSelectedIndex();
        this.datasetProperties[index].setVariable(this.getDatasetVariableTextField().getText());
    }

    private static void getBuilderData() {
    }

    private JLabel getColorLabel() {
        if (this.ivjColorLabel == null) {
            try {
                this.ivjColorLabel = new JLabel();
                this.ivjColorLabel.setName("ColorLabel");
                this.ivjColorLabel.setAlignmentX(0.5f);
                this.ivjColorLabel.setText("Dataset line color");
                this.ivjColorLabel.setBounds(10, 204, 174, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjColorLabel;
    }

    private JCheckBox getConnectPointsCheckBox() {
        if (this.ivjConnectPointsCheckBox == null) {
            try {
                this.ivjConnectPointsCheckBox = new JCheckBox();
                this.ivjConnectPointsCheckBox.setName("ConnectPointsCheckBox");
                this.ivjConnectPointsCheckBox.setText("Connect points");
                this.ivjConnectPointsCheckBox.setForeground(new Color(102, 102, 153));
                this.ivjConnectPointsCheckBox.setHorizontalTextPosition(4);
                this.ivjConnectPointsCheckBox.setSelected(true);
                this.ivjConnectPointsCheckBox.setBounds(186, 277, 205, 25);
                this.ivjConnectPointsCheckBox.setHorizontalAlignment(2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConnectPointsCheckBox;
    }

    private JCheckBox getCursorCheckBox() {
        if (this.ivjCursorCheckBox == null) {
            try {
                this.ivjCursorCheckBox = new JCheckBox();
                this.ivjCursorCheckBox.setName("CursorCheckBox");
                this.ivjCursorCheckBox.setText("Draw cursor");
                this.ivjCursorCheckBox.setBounds(10, 91, 107, 25);
                this.ivjCursorCheckBox.setForeground(new Color(102, 102, 153));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCursorCheckBox;
    }

    private Choice getDataMarkerChoice() {
        if (this.ivjDataMarkerChoice == null) {
            try {
                this.ivjDataMarkerChoice = new Choice();
                this.ivjDataMarkerChoice.setName("DataMarkerChoice");
                this.ivjDataMarkerChoice.setBounds(186, 243, 205, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDataMarkerChoice;
    }

    private Choice getDatasetChoice() {
        if (this.ivjDatasetChoice == null) {
            try {
                this.ivjDatasetChoice = new Choice();
                this.ivjDatasetChoice.setName("DatasetChoice");
                this.ivjDatasetChoice.setBounds(61, 9, 40, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatasetChoice;
    }

    private JLabel getDatasetLabel() {
        if (this.ivjDatasetLabel == null) {
            try {
                this.ivjDatasetLabel = new JLabel();
                this.ivjDatasetLabel.setName("DatasetLabel");
                this.ivjDatasetLabel.setText("Dataset ");
                this.ivjDatasetLabel.setBounds(10, 9, 50, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatasetLabel;
    }

    private JPanel getDatasetPanel() {
        if (this.ivjDatasetPanel == null) {
            try {
                this.ivjDatasetPanel = new JPanel();
                this.ivjDatasetPanel.setName("DatasetPanel");
                this.ivjDatasetPanel.setBorder((Border)new EtchedBorder());
                this.ivjDatasetPanel.setLayout(null);
                this.ivjDatasetPanel.setBounds(12, 148, 402, 316);
                this.getDatasetPanel().add((Component)this.getDatasetLabel(), this.getDatasetLabel().getName());
                this.getDatasetPanel().add((Component)this.getDatasetVariableLabel(), this.getDatasetVariableLabel().getName());
                this.getDatasetPanel().add((Component)this.getDatasetVariableTextField(), this.getDatasetVariableTextField().getName());
                this.getDatasetPanel().add((Component)this.getXAxisTextField(), this.getXAxisTextField().getName());
                this.getDatasetPanel().add((Component)this.getXAxisLabel(), this.getXAxisLabel().getName());
                this.getDatasetPanel().add((Component)this.getYAxisLabel(), this.getYAxisLabel().getName());
                this.getDatasetPanel().add((Component)this.getYAxisTextField(), this.getYAxisTextField().getName());
                this.getDatasetPanel().add((Component)this.getPassFailLabel(), this.getPassFailLabel().getName());
                this.getDatasetPanel().add((Component)this.getPassFailTextField(), this.getPassFailTextField().getName());
                this.getDatasetPanel().add((Component)this.getColorLabel(), this.getColorLabel().getName());
                this.getDatasetPanel().add((Component)this.getLineColorButton(), this.getLineColorButton().getName());
                this.getDatasetPanel().add((Component)this.getDatasetChoice(), this.getDatasetChoice().getName());
                this.getDatasetPanel().add((Component)this.getPropertiesLabel(), this.getPropertiesLabel().getName());
                this.getDatasetPanel().add((Component)this.getMarkerLabel(), this.getMarkerLabel().getName());
                this.getDatasetPanel().add((Component)this.getDataMarkerChoice(), this.getDataMarkerChoice().getName());
                this.getDatasetPanel().add((Component)this.getConnectPointsCheckBox(), this.getConnectPointsCheckBox().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatasetPanel;
    }

    private JLabel getDatasetVariableLabel() {
        if (this.ivjDatasetVariableLabel == null) {
            try {
                this.ivjDatasetVariableLabel = new JLabel();
                this.ivjDatasetVariableLabel.setName("DatasetVariableLabel");
                this.ivjDatasetVariableLabel.setAlignmentX(0.5f);
                this.ivjDatasetVariableLabel.setText("Dataset variable name");
                this.ivjDatasetVariableLabel.setBounds(10, 48, 155, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatasetVariableLabel;
    }

    private JTextField getDatasetVariableTextField() {
        if (this.ivjDatasetVariableTextField == null) {
            try {
                this.ivjDatasetVariableTextField = new JTextField();
                this.ivjDatasetVariableTextField.setName("DatasetVariableTextField");
                this.ivjDatasetVariableTextField.setAlignmentX(0.5f);
                this.ivjDatasetVariableTextField.setBounds(186, 48, 205, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatasetVariableTextField;
    }

    private JCheckBox getEODCheckBox() {
        if (this.ivjEODCheckBox == null) {
            try {
                this.ivjEODCheckBox = new JCheckBox();
                this.ivjEODCheckBox.setName("EODCheckBox");
                this.ivjEODCheckBox.setText("Draw end-of-data marker");
                this.ivjEODCheckBox.setBounds(186, 64, 205, 25);
                this.ivjEODCheckBox.setForeground(new Color(102, 102, 153));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEODCheckBox;
    }

    private JLabel getGeneralLabel() {
        if (this.ivjGeneralLabel == null) {
            try {
                this.ivjGeneralLabel = new JLabel();
                this.ivjGeneralLabel.setName("GeneralLabel");
                this.ivjGeneralLabel.setText("General Graph Properties:");
                this.ivjGeneralLabel.setBounds(10, 7, 155, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGeneralLabel;
    }

    private JPanel getGeneralPanel() {
        if (this.ivjGeneralPanel == null) {
            try {
                this.ivjGeneralPanel = new JPanel();
                this.ivjGeneralPanel.setName("GeneralPanel");
                this.ivjGeneralPanel.setBorder((Border)new EtchedBorder());
                this.ivjGeneralPanel.setLayout(null);
                this.ivjGeneralPanel.setBounds(12, 13, 402, 125);
                this.getGeneralPanel().add((Component)this.getGeneralLabel(), this.getGeneralLabel().getName());
                this.getGeneralPanel().add((Component)this.getGraphInfoVariableLabel(), this.getGraphInfoVariableLabel().getName());
                this.getGeneralPanel().add((Component)this.getGraphInfoVariableTextField(), this.getGraphInfoVariableTextField().getName());
                this.getGeneralPanel().add((Component)this.getGridCheckBox(), this.getGridCheckBox().getName());
                this.getGeneralPanel().add((Component)this.getCursorCheckBox(), this.getCursorCheckBox().getName());
                this.getGeneralPanel().add((Component)this.getEODCheckBox(), this.getEODCheckBox().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGeneralPanel;
    }

    private JLabel getGraphInfoVariableLabel() {
        if (this.ivjGraphInfoVariableLabel == null) {
            try {
                this.ivjGraphInfoVariableLabel = new JLabel();
                this.ivjGraphInfoVariableLabel.setName("GraphInfoVariableLabel");
                this.ivjGraphInfoVariableLabel.setAlignmentX(0.5f);
                this.ivjGraphInfoVariableLabel.setText("Graph Info variable name");
                this.ivjGraphInfoVariableLabel.setBounds(10, 37, 155, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraphInfoVariableLabel;
    }

    private JTextField getGraphInfoVariableTextField() {
        if (this.ivjGraphInfoVariableTextField == null) {
            try {
                this.ivjGraphInfoVariableTextField = new JTextField();
                this.ivjGraphInfoVariableTextField.setName("GraphInfoVariableTextField");
                this.ivjGraphInfoVariableTextField.setAlignmentX(0.5f);
                this.ivjGraphInfoVariableTextField.setBounds(186, 37, 205, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraphInfoVariableTextField;
    }

    private JCheckBox getGridCheckBox() {
        if (this.ivjGridCheckBox == null) {
            try {
                this.ivjGridCheckBox = new JCheckBox();
                this.ivjGridCheckBox.setName("GridCheckBox");
                this.ivjGridCheckBox.setText("Draw grid lines");
                this.ivjGridCheckBox.setBounds(10, 64, 107, 25);
                this.ivjGridCheckBox.setForeground(new Color(102, 102, 153));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGridCheckBox;
    }

    private JButton getLineColorButton() {
        if (this.ivjLineColorButton == null) {
            try {
                this.ivjLineColorButton = new JButton();
                this.ivjLineColorButton.setName("LineColorButton");
                this.ivjLineColorButton.setBounds(new Rectangle(173, 156, 216, 19));
                this.ivjLineColorButton.setLocation(new Point(173, 156));
                this.ivjLineColorButton.setText("");
                this.ivjLineColorButton.setBounds(186, 205, 205, 19);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLineColorButton;
    }

    private JLabel getMarkerLabel() {
        if (this.ivjMarkerLabel == null) {
            try {
                this.ivjMarkerLabel = new JLabel();
                this.ivjMarkerLabel.setName("MarkerLabel");
                this.ivjMarkerLabel.setAlignmentX(0.5f);
                this.ivjMarkerLabel.setText("Data markers");
                this.ivjMarkerLabel.setBounds(10, 243, 174, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMarkerLabel;
    }

    private JLabel getPassFailLabel() {
        if (this.ivjPassFailLabel == null) {
            try {
                this.ivjPassFailLabel = new JLabel();
                this.ivjPassFailLabel.setName("PassFailLabel");
                this.ivjPassFailLabel.setAlignmentX(0.5f);
                this.ivjPassFailLabel.setText("Pass/Fail data name on server");
                this.ivjPassFailLabel.setBounds(10, 165, 174, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPassFailLabel;
    }

    private JTextField getPassFailTextField() {
        if (this.ivjPassFailTextField == null) {
            try {
                this.ivjPassFailTextField = new JTextField();
                this.ivjPassFailTextField.setName("PassFailTextField");
                this.ivjPassFailTextField.setAlignmentX(0.5f);
                this.ivjPassFailTextField.setBounds(186, 165, 205, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPassFailTextField;
    }

    private JLabel getPropertiesLabel() {
        if (this.ivjPropertiesLabel == null) {
            try {
                this.ivjPropertiesLabel = new JLabel();
                this.ivjPropertiesLabel.setName("PropertiesLabel");
                this.ivjPropertiesLabel.setText("Properties:");
                this.ivjPropertiesLabel.setBounds(108, 9, 75, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPropertiesLabel;
    }

    private JButton getSaveButton() {
        if (this.ivjSaveButton == null) {
            try {
                this.ivjSaveButton = new JButton();
                this.ivjSaveButton.setName("SaveButton");
                this.ivjSaveButton.setText("Save");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSaveButton;
    }

    private JPanel getSavePanel() {
        if (this.ivjSavePanel == null) {
            try {
                this.ivjSavePanel = new JPanel();
                this.ivjSavePanel.setName("SavePanel");
                this.ivjSavePanel.setLayout(new FlowLayout());
                this.ivjSavePanel.setBounds(523, 23, 105, 48);
                this.getSavePanel().add((Component)this.getSaveButton(), this.getSaveButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSavePanel;
    }

    public EclGraphModel getTheNewModel() {
        String aGraphInfoVariable = null;
        boolean aDrawGridLinesFlag = false;
        boolean aDrawCursorFlag = false;
        boolean aDrawEODFlag = false;
        int anIndex = -1;
        if (this.getGraphInfoVariableTextField().getText().trim().length() != 0) {
            aGraphInfoVariable = this.getGraphInfoVariableTextField().getText();
        }
        aDrawGridLinesFlag = this.getGridCheckBox().isSelected();
        aDrawCursorFlag = this.getCursorCheckBox().isSelected();
        aDrawEODFlag = this.getEODCheckBox().isSelected();
        anIndex = this.getDatasetChoice().getSelectedIndex();
        return new EclGraphModel(aGraphInfoVariable, aDrawGridLinesFlag, aDrawCursorFlag, aDrawEODFlag, this.datasetProperties, anIndex);
    }

    private JLabel getXAxisLabel() {
        if (this.ivjXAxisLabel == null) {
            try {
                this.ivjXAxisLabel = new JLabel();
                this.ivjXAxisLabel.setName("XAxisLabel");
                this.ivjXAxisLabel.setAlignmentX(0.5f);
                this.ivjXAxisLabel.setText("X-axis data name on server");
                this.ivjXAxisLabel.setBounds(10, 87, 162, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjXAxisLabel;
    }

    private JTextField getXAxisTextField() {
        if (this.ivjXAxisTextField == null) {
            try {
                this.ivjXAxisTextField = new JTextField();
                this.ivjXAxisTextField.setName("XAxisTextField");
                this.ivjXAxisTextField.setAlignmentX(0.5f);
                this.ivjXAxisTextField.setBounds(186, 87, 205, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjXAxisTextField;
    }

    private JLabel getYAxisLabel() {
        if (this.ivjYAxisLabel == null) {
            try {
                this.ivjYAxisLabel = new JLabel();
                this.ivjYAxisLabel.setName("YAxisLabel");
                this.ivjYAxisLabel.setAlignmentX(0.5f);
                this.ivjYAxisLabel.setText("Y-axis data name on server");
                this.ivjYAxisLabel.setBounds(10, 126, 162, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjYAxisLabel;
    }

    private JTextField getYAxisTextField() {
        if (this.ivjYAxisTextField == null) {
            try {
                this.ivjYAxisTextField = new JTextField();
                this.ivjYAxisTextField.setName("YAxisTextField");
                this.ivjYAxisTextField.setAlignmentX(0.5f);
                this.ivjYAxisTextField.setBounds(186, 126, 205, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjYAxisTextField;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getLineColorButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getSaveButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getDatasetVariableTextField().addFocusListener(this.ivjEventHandler);
        this.getXAxisTextField().addFocusListener(this.ivjEventHandler);
        this.getYAxisTextField().addFocusListener(this.ivjEventHandler);
        this.getDatasetChoice().addItemListener(this.ivjEventHandler);
        this.getPassFailTextField().addFocusListener(this.ivjEventHandler);
        this.getDataMarkerChoice().addItemListener(this.ivjEventHandler);
        this.getConnectPointsCheckBox().addActionListener((ActionListener)this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("EclGraphModelWindow");
            this.setLayout(null);
            this.setBackground(new Color(204, 204, 204));
            this.setSize(426, 476);
            this.add((Component)this.getGeneralPanel(), this.getGeneralPanel().getName());
            this.add((Component)this.getDatasetPanel(), this.getDatasetPanel().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        int i = 0;
        while (i < DataMarkers.markerNames.length) {
            this.getDataMarkerChoice().addItem(DataMarkers.markerNames[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            ((Component)frame).setSize(435, 455);
            frame.setLayout(new BorderLayout());
            EclGraphModelWindow w = new EclGraphModelWindow();
            frame.add((Component)w, "Center");
            frame.add((Component)w.getSavePanel(), "South");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            w.setTheNewModel(new EclGraphModel());
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("ERROR: EcGraphModelWindow: Exception occurred in main() of java.awt.Panel");
            exception.printStackTrace(System.out);
        }
    }

    public void passFailTextField_FocusLost(FocusEvent focusEvent) {
        int index = this.getDatasetChoice().getSelectedIndex();
        this.datasetProperties[index].setPassFlag(this.getPassFailTextField().getText());
    }

    public void saveButton_ActionPerformed(ActionEvent actionEvent) {
        EclGraphModelEditor editor = new EclGraphModelEditor();
        editor.setValue(this.getTheNewModel());
        EventLog.instance().log(editor.getJavaInitializationString());
    }

    public void setTheNewModel(EclGraphModel m) {
        AccessibleEclGraphModel a = m.createAccessibleModel();
        this.theComponentForModel = a.getController();
        if (a.getGraphInfoVariable() != null) {
            this.getGraphInfoVariableTextField().setText(a.getGraphInfoVariable());
        }
        this.getGridCheckBox().setSelected(a.getDrawGridLines());
        this.getCursorCheckBox().setSelected(a.getDrawCursor());
        this.getEODCheckBox().setSelected(a.getDrawEOD());
        if (this.getDatasetChoice().getItemCount() == 0) {
            int i = 0;
            while (i < datasets.length) {
                this.getDatasetChoice().add(datasets[i]);
                ++i;
            }
        }
        int index = a.getSelectedDataset() == -1 ? 0 : a.getSelectedDataset();
        this.getDatasetChoice().select(index);
        this.datasetProperties = a.getDatasetProperties();
        if (this.datasetProperties != null && this.datasetProperties.length > 0) {
            try {
                if (this.datasetProperties[index] != null) {
                    if (this.datasetProperties[index].getVariable() != null) {
                        this.getDatasetVariableTextField().setText(this.datasetProperties[index].getVariable());
                    }
                    if (this.datasetProperties[index].getXDataName() != null) {
                        this.getXAxisTextField().setText(this.datasetProperties[index].getXDataName());
                    }
                    if (this.datasetProperties[index].getYDataName() != null) {
                        this.getYAxisTextField().setText(this.datasetProperties[index].getYDataName());
                    }
                    if (this.datasetProperties[index].getPassFlag() != null) {
                        this.getPassFailTextField().setText(this.datasetProperties[index].getPassFlag());
                    }
                    if (this.datasetProperties[index].getColor() != null) {
                        this.getLineColorButton().setBackground(this.datasetProperties[index].getColor());
                    }
                    this.getDataMarkerChoice().select(this.datasetProperties[index].getDataMarkers());
                    this.getConnectPointsCheckBox().setSelected(this.datasetProperties[index].isConnected());
                    this.dataMarkerChoice_ItemStateChanged();
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": setTheNewModel: dataset properties for index " + index + " has not been initialized properly!");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": setTheNewModel: selected index is out of bounds!");
            }
        }
    }

    public void xAxisTextField_FocusLost(FocusEvent focusEvent) {
        int index = this.getDatasetChoice().getSelectedIndex();
        this.datasetProperties[index].setXDataName(this.getXAxisTextField().getText());
    }

    public void yAxisTextField_FocusLost(FocusEvent focusEvent) {
        int index = this.getDatasetChoice().getSelectedIndex();
        this.datasetProperties[index].setYDataName(this.getYAxisTextField().getText());
    }

    static JButton access$getSaveButton(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getSaveButton();
    }

    static void access$connEtoC3(EclGraphModelWindow eclGraphModelWindow, FocusEvent focusEvent) {
        eclGraphModelWindow.connEtoC3(focusEvent);
    }

    static void access$connEtoC6(EclGraphModelWindow eclGraphModelWindow, FocusEvent focusEvent) {
        eclGraphModelWindow.connEtoC6(focusEvent);
    }

    static JTextField access$getDatasetVariableTextField(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getDatasetVariableTextField();
    }

    static void access$connEtoC7(EclGraphModelWindow eclGraphModelWindow, ItemEvent itemEvent) {
        eclGraphModelWindow.connEtoC7(itemEvent);
    }

    static void access$connEtoC4(EclGraphModelWindow eclGraphModelWindow, FocusEvent focusEvent) {
        eclGraphModelWindow.connEtoC4(focusEvent);
    }

    static Choice access$getDatasetChoice(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getDatasetChoice();
    }

    static void access$connEtoC9(EclGraphModelWindow eclGraphModelWindow, ActionEvent actionEvent) {
        eclGraphModelWindow.connEtoC9(actionEvent);
    }

    static JTextField access$getXAxisTextField(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getXAxisTextField();
    }

    static JCheckBox access$getConnectPointsCheckBox(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getConnectPointsCheckBox();
    }

    static void access$connEtoC5(EclGraphModelWindow eclGraphModelWindow, FocusEvent focusEvent) {
        eclGraphModelWindow.connEtoC5(focusEvent);
    }

    static void access$connEtoC2(EclGraphModelWindow eclGraphModelWindow, ActionEvent actionEvent) {
        eclGraphModelWindow.connEtoC2(actionEvent);
    }

    static JTextField access$getYAxisTextField(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getYAxisTextField();
    }

    static JTextField access$getPassFailTextField(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getPassFailTextField();
    }

    static void access$connEtoC8(EclGraphModelWindow eclGraphModelWindow, ItemEvent itemEvent) {
        eclGraphModelWindow.connEtoC8(itemEvent);
    }

    static void access$connEtoC1(EclGraphModelWindow eclGraphModelWindow, ActionEvent actionEvent) {
        eclGraphModelWindow.connEtoC1(actionEvent);
    }

    static Choice access$getDataMarkerChoice(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getDataMarkerChoice();
    }

    static JButton access$getLineColorButton(EclGraphModelWindow eclGraphModelWindow) {
        return eclGraphModelWindow.getLineColorButton();
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener,
    ItemListener {
        /* synthetic */ EclGraphModelWindow this$0;

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == EclGraphModelWindow.access$getLineColorButton(this.this$0)) {
                EclGraphModelWindow.access$connEtoC1(this.this$0, e);
            }
            if (e.getSource() == EclGraphModelWindow.access$getSaveButton(this.this$0)) {
                EclGraphModelWindow.access$connEtoC2(this.this$0, e);
            }
            if (e.getSource() == EclGraphModelWindow.access$getConnectPointsCheckBox(this.this$0)) {
                EclGraphModelWindow.access$connEtoC9(this.this$0, e);
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (e.getSource() == EclGraphModelWindow.access$getDatasetVariableTextField(this.this$0)) {
                EclGraphModelWindow.access$connEtoC3(this.this$0, e);
            }
            if (e.getSource() == EclGraphModelWindow.access$getXAxisTextField(this.this$0)) {
                EclGraphModelWindow.access$connEtoC4(this.this$0, e);
            }
            if (e.getSource() == EclGraphModelWindow.access$getYAxisTextField(this.this$0)) {
                EclGraphModelWindow.access$connEtoC5(this.this$0, e);
            }
            if (e.getSource() == EclGraphModelWindow.access$getPassFailTextField(this.this$0)) {
                EclGraphModelWindow.access$connEtoC6(this.this$0, e);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == EclGraphModelWindow.access$getDatasetChoice(this.this$0)) {
                EclGraphModelWindow.access$connEtoC8(this.this$0, e);
            }
            if (e.getSource() == EclGraphModelWindow.access$getDataMarkerChoice(this.this$0)) {
                EclGraphModelWindow.access$connEtoC7(this.this$0, e);
            }
        }

        IvjEventHandler(EclGraphModelWindow this$0) {
            this.this$0 = this$0;
        }
    }
}

