/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.graphs;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.EclGraph;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.graphs.ptplot.Plot;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class EclGraphView
extends Plot
implements EclipseView {
    private int[] dataMarkers = new int[0];
    private boolean[] connected = new boolean[0];
    private EclGraph controller = null;
    private boolean drawGrid = false;
    private boolean drawCursor = false;
    private boolean drawEOD = false;
    private float cursorLocation = 0.0f;
    private float endOfDataLocation = 0.0f;
    private boolean[] connectToLastPoint = null;
    private float xRangeMin = 0.0f;
    private float xRangeMax = 0.0f;
    private boolean xLog = false;
    private boolean xEng = false;
    private boolean xDrawMinorTicks = true;
    private float[] lastReceivedXValue = null;
    private float yRangeMin = 0.0f;
    private float yRangeMax = 0.0f;
    private boolean yLog = false;
    private boolean yEng = false;
    private boolean yDrawMinorTicks = true;
    private float[] lastReceivedYValue = null;

    public EclGraphView(EclGraph c) {
        this.controller = c;
        if (c == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": Constructor: Null controller in constructor!");
        }
        this.initialize();
    }

    protected synchronized void _drawPlotPoint(Graphics graphics, int dataset, int index) {
        this.setMarksStyle("various");
        super._drawPlotPoint(graphics, dataset, index);
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (!clip || ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            int xposi = (int)xpos;
            int yposi = (int)ypos;
            int mark = dataset < this.dataMarkers.length ? this.dataMarkers[dataset] : 0;
            switch (mark) {
                case 7: {
                    graphics.fillOval(xposi - 3, yposi - 3, 6, 6);
                    break;
                }
                case 5: {
                    graphics.drawLine(xposi - 3, yposi - 3, xposi + 3, yposi + 3);
                    graphics.drawLine(xposi + 3, yposi - 3, xposi - 3, yposi + 3);
                    break;
                }
                case 2: {
                    graphics.drawRect(xposi - 3, yposi - 3, 6, 6);
                    break;
                }
                case 9: {
                    int[] xpoints = new int[4];
                    int[] ypoints = new int[4];
                    xpoints[0] = xposi;
                    ypoints[0] = yposi - 3;
                    xpoints[1] = xposi + 3;
                    ypoints[1] = yposi + 3;
                    xpoints[2] = xposi - 3;
                    ypoints[2] = yposi + 3;
                    xpoints[3] = xposi;
                    ypoints[3] = yposi - 3;
                    graphics.fillPolygon(xpoints, ypoints, 4);
                    break;
                }
                case 4: {
                    int[] xpoints = new int[5];
                    int[] ypoints = new int[5];
                    xpoints[0] = xposi;
                    ypoints[0] = yposi - 3;
                    xpoints[1] = xposi + 3;
                    ypoints[1] = yposi;
                    xpoints[2] = xposi;
                    ypoints[2] = yposi + 3;
                    xpoints[3] = xposi - 3;
                    ypoints[3] = yposi;
                    xpoints[4] = xposi;
                    ypoints[4] = yposi - 3;
                    graphics.drawPolygon(xpoints, ypoints, 5);
                    break;
                }
                case 1: {
                    graphics.drawOval(xposi - 3, yposi - 3, 6, 6);
                    break;
                }
                case 6: {
                    graphics.drawLine(xposi, yposi - 3, xposi, yposi + 3);
                    graphics.drawLine(xposi - 3, yposi, xposi + 3, yposi);
                    break;
                }
                case 8: {
                    graphics.fillRect(xposi - 3, yposi - 3, 6, 6);
                    break;
                }
                case 3: {
                    int[] xpoints = new int[4];
                    int[] ypoints = new int[4];
                    xpoints[0] = xposi;
                    ypoints[0] = yposi - 3;
                    xpoints[1] = xposi + 3;
                    ypoints[1] = yposi + 3;
                    xpoints[2] = xposi - 3;
                    ypoints[2] = yposi + 3;
                    xpoints[3] = xposi;
                    ypoints[3] = yposi - 3;
                    graphics.drawPolygon(xpoints, ypoints, 4);
                    break;
                }
                case 10: {
                    int[] xpoints = new int[5];
                    int[] ypoints = new int[5];
                    xpoints[0] = xposi;
                    ypoints[0] = yposi - 3;
                    xpoints[1] = xposi + 3;
                    ypoints[1] = yposi;
                    xpoints[2] = xposi;
                    ypoints[2] = yposi + 3;
                    xpoints[3] = xposi - 3;
                    ypoints[3] = yposi;
                    xpoints[4] = xposi;
                    ypoints[4] = yposi - 3;
                    graphics.fillPolygon(xpoints, ypoints, 5);
                    break;
                }
            }
        }
    }

    private void drawCursor(Graphics g) {
        if (!((double)this.cursorLocation >= this._xMin) || !((double)this.cursorLocation <= this._xMax)) {
            EventLog.instance().log("ERROR: " + this.toString() + ": drawCursor: cursor is not on the graph.");
        } else {
            Color previousColor = g.getColor();
            g.setColor(new Color(4565791));
            int yp = this._uly + 1;
            int xp = this.translateD2P(this.cursorLocation);
            int cursorWidth = 3;
            if (xp == this._ulx) {
                g.fillRect(xp + 1, yp, cursorWidth - 1, this._lry - this._uly - 1);
            } else if (xp == this._lrx) {
                g.fillRect(xp - 2, yp, cursorWidth - 1, this._lry - this._uly - 1);
            } else {
                g.fillRect(xp - 1, yp, cursorWidth, this._lry - this._uly - 1);
            }
            g.setColor(previousColor);
        }
    }

    private void drawEndOfDataMarker(Graphics g) {
        if ((double)this.endOfDataLocation > this._xMin && (double)this.endOfDataLocation <= this._xMax) {
            Color previousColor = g.getColor();
            g.setColor(Color.black);
            int ypos = this._uly + 1;
            int xpos = this.translateD2P(this.endOfDataLocation);
            int endOfDataWidth = 5;
            if (xpos == 0) {
                g.fillRect(xpos + 1, ypos, endOfDataWidth - 1, this._lry - this._uly - 1);
            } else if (xpos + endOfDataWidth >= this._lrx) {
                int width = 1;
                if (endOfDataWidth > 1) {
                    width = endOfDataWidth - 1;
                }
                g.fillRect(this._lrx - width, ypos, width, this._lry - this._uly - 1);
            } else {
                g.fillRect(xpos + 1, ypos, endOfDataWidth, this._lry - this._uly - 1);
            }
            g.setColor(previousColor);
        }
    }

    public Color getBackground() {
        return this.controller.getBackground();
    }

    public Rectangle getBounds() {
        return this.controller.getBounds();
    }

    public Font getFont() {
        return this.controller.getFont();
    }

    public Color getForeground() {
        return this.controller.getForeground();
    }

    public Color getGraphAreaColor() {
        return this.controller.hasTrappedTransientError() ? GraphDefaults.transientErrorColour : super.getGraphAreaColor();
    }

    public Color getGridColor() {
        return this.controller.hasTrappedTransientError() ? GraphDefaults.transientErrorColour : super.getGridColor();
    }

    public float getLastReceivedXValue(int dataset) {
        return this.lastReceivedXValue[dataset];
    }

    public float getXRangeMax() {
        return this.xRangeMax;
    }

    private void initialize() {
        this.setBackground(GraphDefaults.background);
        this.setForeground(GraphDefaults.foreground);
        this.setGraphAreaColor(GraphDefaults.graphAreaColor);
        this._topPadding = 20;
        this._bottomPadding = 5;
        this._leftPadding = 60;
        this._rightPadding = 25;
        this.connectToLastPoint = new boolean[8];
        this.lastReceivedXValue = new float[8];
        this.lastReceivedYValue = new float[8];
    }

    public boolean isXLog() {
        return this.xLog;
    }

    public void notifyEclipseComponentChanged() {
    }

    public void paint(Graphics g) {
        if (this.controller.hasTrappedPermanentError()) {
            Rectangle bounds = this.getBounds();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, bounds.width, bounds.height);
        } else if (this.controller.hasTrappedTransientError()) {
            Rectangle bounds = this.getBounds();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, bounds.width, bounds.height);
            String s1 = "NO VALID GRAPH DATA AVAILABLE";
            int x = bounds.width / 2;
            int y = bounds.height / 2;
            g.setColor(Color.black);
            g.drawString(s1, x - s1.length() * 3 - 15, y);
        } else {
            super.paint(g);
            if (this.controller.isInitialized()) {
                if (this.drawCursor) {
                    this.drawCursor(g);
                }
                if (this.drawEOD) {
                    this.drawEndOfDataMarker(g);
                }
            }
        }
    }

    void plotData(int dataset, float[] x, float[] y, float[] z) {
        if (x.length != y.length || x.length != z.length) {
            EventLog.instance().log("ERROR: " + this.toString() + ": plotData: data arrays are of different lengths!");
            this.controller.trapTransientError(true);
            return;
        }
        if (dataset > 7) {
            EventLog.instance().log("ERROR: " + this.toString() + ": plotData: dataset " + dataset + " exceeds the maximum of " + 7);
            this.controller.trapTransientError(true);
            return;
        }
        int i = 0;
        while (i < x.length) {
            if (x[i] == this.lastReceivedXValue[dataset] && y[i] == this.lastReceivedYValue[dataset]) {
                if (this.controller.debug) {
                    System.err.println("DEBUG: " + this.toString() + ": plotData: dataset: " + dataset + ": Received duplicate point " + x[i] + ", " + y[i] + ". Discarding it. Note: This is an indicator that something has gone wrong with data communication.");
                }
            } else if (x[i] < this.lastReceivedXValue[dataset]) {
                if (this.controller.debug) {
                    System.err.println("DEBUG: " + this.toString() + ": plotData: dataset: " + dataset + ": x value, " + x[i] + ", is less than or equal to the last received x value, " + this.lastReceivedXValue[dataset] + ". Discarding it. Note: This is an indicator of possible inefficient data handling on the server side.");
                }
            } else {
                if (this.controller.debug && !this.connectToLastPoint[dataset]) {
                    EventLog.instance().log("DEBUG: " + this.toString() + ": plotData: connectToLastPoint = false");
                }
                boolean error = true;
                if (Math.round(z[i]) == 1) {
                    error = false;
                }
                this.addPoint(dataset, x[i], y[i], this.connectToLastPoint[dataset], error);
                this.lastReceivedXValue[dataset] = x[i];
                this.lastReceivedYValue[dataset] = y[i];
                this.connectToLastPoint[dataset] = this.connected[dataset];
            }
            ++i;
        }
        this.controller.trapTransientError(false, false);
        ((Component)((Object)this.controller)).repaint();
    }

    public void printGraphInfoParams() {
        EventLog.instance().log("DEBUG: " + this.toString() + ": Graph Info params: ");
        EventLog.instance().log("X range = (" + this.xRangeMin + "," + this.xRangeMax + "); Y range = (" + this.yRangeMin + "," + this.yRangeMax + "); X log = " + this.xLog + "; Y log = " + this.yLog + "; eod = " + this.endOfDataLocation + "; marker = " + this.cursorLocation);
    }

    void resetGraphParameters() {
        this.xRangeMin = 0.0f;
        this.xRangeMax = 0.0f;
        this.yRangeMin = 0.0f;
        this.yRangeMax = 0.0f;
        this.endOfDataLocation = 0.0f;
        this.cursorLocation = 0.0f;
        int i = 0;
        while (i < this.lastReceivedXValue.length) {
            this.lastReceivedXValue[i] = -999.0f;
            ++i;
        }
        i = 0;
        while (i < this.lastReceivedYValue.length) {
            this.lastReceivedYValue[i] = -999.0f;
            ++i;
        }
        i = 0;
        while (i < this.connectToLastPoint.length) {
            this.connectToLastPoint[i] = false;
            ++i;
        }
    }

    protected void resetPlot() {
        this.clear(true);
        this.setGrid(this.drawGrid);
        int i = 0;
        while (i < this.connectToLastPoint.length) {
            this.connectToLastPoint[i] = false;
            ++i;
        }
        this.setXLog(this.xLog);
        this.setXEngineeringMode(this.xEng);
        this.setXDrawMinorTicks(this.xDrawMinorTicks);
        this.setXRange(this.xRangeMin, this.xRangeMax);
        i = 0;
        while (i < this.lastReceivedXValue.length) {
            this.lastReceivedXValue[i] = this.xRangeMin - 1.0f;
            ++i;
        }
        this.setYLog(this.yLog);
        this.setYEngineeringMode(this.yEng);
        this.setYDrawMinorTicks(this.yDrawMinorTicks);
        this.setYRange(this.yRangeMin, this.yRangeMax);
        i = 0;
        while (i < this.lastReceivedYValue.length) {
            this.lastReceivedYValue[i] = -999.0f;
            ++i;
        }
        this.repaint();
    }

    public void setConnected(boolean[] c) {
        this.connected = c;
    }

    public void setCursorLocation(float newCursorLocation) {
        this.cursorLocation = newCursorLocation;
    }

    public void setDataMarkers(int[] markers) {
        this.dataMarkers = markers;
    }

    public void setDrawCursor(boolean newDrawCursor) {
        this.drawCursor = newDrawCursor;
    }

    public void setDrawEOD(boolean newDrawEOD) {
        this.drawEOD = newDrawEOD;
    }

    public void setDrawGrid(boolean newDrawGrid) {
        this.drawGrid = newDrawGrid;
    }

    public void setEndOfDataLocation(float newEndOfDataLocation) {
        this.endOfDataLocation = newEndOfDataLocation;
    }

    void setGraphInfoParameters(float xRangeMin, float xRangeMax, float yRangeMin, float yRangeMax, int commonFlags, int xFlags, int yFlags, float eodLocation, float cursorLocation) {
        this.xRangeMin = xRangeMin;
        this.xRangeMax = xRangeMax;
        this.yRangeMin = yRangeMin;
        this.yRangeMax = yRangeMax;
        this.xLog = (xFlags & 1) == 1;
        this.yLog = (yFlags & 1) == 1;
        this.xEng = (xFlags & 2) == 2;
        this.yEng = (yFlags & 2) == 2;
        this.xDrawMinorTicks = (xFlags & 4) == 4;
        this.yDrawMinorTicks = (yFlags & 4) == 4;
        this.endOfDataLocation = eodLocation;
        this.cursorLocation = cursorLocation;
        if (this.controller.debug) {
            this.printGraphInfoParams();
        }
        this.resetPlot();
    }

    public void setPlotColors(Color[] newColors) {
        int maxIndex = newColors.length < this._colors.length ? newColors.length : this._colors.length;
        int i = 0;
        while (i < maxIndex) {
            if (newColors[i] != null) {
                this._colors[i] = newColors[i];
            }
            ++i;
        }
    }

    public void setXRangeMax(float newXRangeMax) {
        this.xRangeMax = newXRangeMax;
    }

    public String toString() {
        return "EclGraphView";
    }

    private int translateD2P(float dataPoint) {
        double point = this.xLog ? Math.log(dataPoint) / Math.log(10.0) : (double)dataPoint;
        double min = this.xLog ? Math.log(this._xMin) / Math.log(10.0) : this._xMin;
        double max = this.xLog ? Math.log(this._xMax) / Math.log(10.0) : this._xMax;
        return (int)Math.round((double)this._ulx + (double)(this._lrx - this._ulx) * (point - min) / (max - min));
    }
}

