/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.graphs.ptplot;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.graphs.ptplot.CmdLineArgException;
import com.agilent.tntd.eclipse.graphs.ptplot.PlotBox;
import com.agilent.tntd.eclipse.graphs.ptplot.PlotPoint;
import java.awt.Cursor;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class Plot
extends PlotBox {
    protected int _pointsPersistence = 0;
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected Vector _prevx = new Vector();
    protected Vector _prevy = new Vector();
    protected int _marks;
    protected boolean _painted = false;
    private int _sweepsPersistence = 0;
    private boolean _bars = false;
    private double _barwidth = 0.5;
    private double _baroffset = 0.05;
    private boolean _connected = true;
    private boolean _impulses = false;
    private int _maxdataset = -1;
    private boolean _reusedatasets = false;
    private boolean _firstinset = true;
    private boolean _sawfirstdataset = false;
    private int _radius = 3;
    private int _diameter = 6;
    private boolean _pxgraphBlankLineMode = true;
    private static final int _NATIVE_ENDIAN = 0;
    private static final int _BIG_ENDIAN = 1;
    private static final int _LITTLE_ENDIAN = 2;
    private int _endian = 0;
    private static final int _ERRORBAR_LEG_LENGTH = 2;
    private static final int _MAX_MARKS = 10;
    private boolean _xyInvalid = false;
    private String _filename = null;
    private boolean _showing = false;
    private Vector _formats = new Vector();

    private boolean _addLegendIfNecessary(boolean connected) {
        if (!this._sawfirstdataset || this._currentdataset < 0) {
            this._sawfirstdataset = true;
            ++this._currentdataset;
        }
        if (this.getLegend(this._currentdataset) == null) {
            this._firstinset = true;
            this._sawfirstdataset = true;
            this.addLegend(this._currentdataset, new String("Set " + this._currentdataset));
        }
        if (this._firstinset) {
            connected = false;
            this._firstinset = false;
        }
        return connected;
    }

    private synchronized void _addPoint(int dataset, double x, double y, double yLowEB, double yHighEB, boolean connected, boolean errorBar, boolean inError) {
        this._checkDatasetIndex(dataset);
        if (x < this._xBottom) {
            this._xBottom = x;
        }
        if (x > this._xTop) {
            this._xTop = x;
        }
        if (y < this._yBottom) {
            this._yBottom = y;
        }
        if (y > this._yTop) {
            this._yTop = y;
        }
        PlotPoint pt = new PlotPoint();
        pt.x = x;
        pt.y = y;
        pt.connected = connected && this._connected;
        pt.inError = inError;
        if (errorBar) {
            if (yLowEB < this._yBottom) {
                this._yBottom = yLowEB;
            }
            if (yLowEB > this._yTop) {
                this._yTop = yLowEB;
            }
            if (yHighEB < this._yBottom) {
                this._yBottom = yHighEB;
            }
            if (yHighEB > this._yTop) {
                this._yTop = yHighEB;
            }
            pt.yLowEB = yLowEB;
            pt.yHighEB = yHighEB;
            pt.errorBar = true;
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        pts.addElement(pt);
        if (this._pointsPersistence > 0 && pts.size() > this._pointsPersistence) {
            this.erasePoint(dataset, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void _checkDatasetIndex(int dataset) {
        if (dataset >= 0) ** GOTO lbl7
        throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._formats.addElement(new Format(this));
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
lbl7:
            // 2 sources

            ** while (dataset >= this._points.size())
        }
lbl8:
        // 1 sources

    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long l, boolean clip) {
        long ypos;
        if (clip) {
            if (l < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int barlx = (int)((double)xpos - this._barwidth * this._xscale / 2.0 + (double)dataset * this._baroffset * this._xscale);
            int barrx = (int)((double)barlx + this._barwidth * this._xscale);
            if (barlx < this._ulx) {
                barlx = this._ulx;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx;
            }
            if (barlx >= barrx) {
                barrx = barlx + 1;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos, barrx - barlx, (int)(zeroypos - ypos));
            } else {
                graphics.fillRect(barlx, (int)zeroypos, barrx - barlx, (int)(ypos - zeroypos));
            }
        }
    }

    protected void _drawErrorBar(Graphics graphics, int dataset, long xpos, long yLowEBPos, long yHighEBPos, boolean clip) {
        this._drawLine(graphics, dataset, xpos - 2L, yHighEBPos, xpos + 2L, yHighEBPos, clip);
        this._drawLine(graphics, dataset, xpos, yLowEBPos, xpos, yHighEBPos, clip);
        this._drawLine(graphics, dataset, xpos - 2L, yLowEBPos, xpos + 2L, yLowEBPos, clip);
    }

    protected void _drawImpulse(Graphics graphics, long xpos, long l, boolean clip) {
        long ypos;
        if (clip) {
            if (l < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            double zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale);
            if ((double)this._lry < zeroypos) {
                zeroypos = this._lry;
            }
            if ((double)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            graphics.drawLine((int)xpos, (int)ypos, (int)xpos, (int)zeroypos);
        }
    }

    protected void _drawLine(Graphics graphics, int dataset, long l, long l2, long l3, long l4, boolean clip) {
        long startx;
        long starty;
        long endx;
        long endy;
        if (clip) {
            if (!(l3 <= (long)this._ulx && l <= (long)this._ulx || l3 >= (long)this._lrx && l >= (long)this._lrx || l4 <= (long)this._uly && l2 <= (long)this._uly || l4 >= (long)this._lry && l2 >= (long)this._lry)) {
                if (l != l3) {
                    if (l3 < (long)this._ulx) {
                        endy = (int)(l4 + (l2 - l4) * ((long)this._ulx - l3) / (l - l3));
                        endx = this._ulx;
                    } else if (endx > (long)this._lrx) {
                        endy = (int)(endy + (l2 - endy) * ((long)this._lrx - endx) / (l - endx));
                        endx = this._lrx;
                    }
                }
                if (l2 != endy) {
                    if (endy < (long)this._uly) {
                        endx = (int)(endx + (l - endx) * ((long)this._uly - endy) / (l2 - endy));
                        endy = this._uly;
                    } else if (endy > (long)this._lry) {
                        endx = (int)(endx + (l - endx) * ((long)this._lry - endy) / (l2 - endy));
                        endy = this._lry;
                    }
                }
                if (l != endx) {
                    if (l < (long)this._ulx) {
                        starty = (int)(l2 + (endy - l2) * ((long)this._ulx - l) / (endx - l));
                        startx = this._ulx;
                    } else if (startx > (long)this._lrx) {
                        starty = (int)(starty + (endy - starty) * ((long)this._lrx - startx) / (endx - startx));
                        startx = this._lrx;
                    }
                }
                if (starty != endy) {
                    if (starty < (long)this._uly) {
                        startx = (int)(startx + (endx - startx) * ((long)this._uly - starty) / (endy - starty));
                        starty = this._uly;
                    } else if (starty > (long)this._lry) {
                        startx = (int)(startx + (endx - startx) * ((long)this._lry - starty) / (endy - starty));
                        starty = this._lry;
                    }
                }
            }
            if (endx >= (long)this._ulx && endx <= (long)this._lrx && endy >= (long)this._uly && endy <= (long)this._lry && startx >= (long)this._ulx && startx <= (long)this._lrx && starty >= (long)this._uly && starty <= (long)this._lry) {
                graphics.drawLine((int)startx, (int)starty, (int)endx, (int)endy);
            }
        } else {
            graphics.drawLine((int)startx, (int)starty, (int)endx, (int)endy);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        super._drawPlot(graphics, clearfirst);
        this._showing = true;
        int dataset = this._points.size() - 1;
        while (dataset >= 0) {
            Vector data = (Vector)this._points.elementAt(dataset);
            int pointnum = 0;
            while (pointnum < data.size()) {
                this._drawPlotPoint(graphics, dataset, pointnum);
                ++pointnum;
            }
            --dataset;
        }
        this._painted = true;
        this.notifyAll();
    }

    protected synchronized void _drawPlotPoint(Graphics graphics, int dataset, int index) {
        if (this._pointsPersistence > 0) {
            graphics.setXORMode(this.getBackground());
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        PlotPoint pt = (PlotPoint)pts.elementAt(index);
        if (this._usecolor) {
            if (pt.inError) {
                graphics.setColor(GraphDefaults.errorColor);
            } else {
                int color = dataset % this._colors.length;
                graphics.setColor(this._colors[color]);
            }
        } else {
            graphics.setColor(this.getForeground());
        }
        long ypos = (long)this._lry - (long)((pt.y - this._yMin) * this._yscale);
        long xpos = (long)this._ulx + (long)((pt.x - this._xMin) * this._xscale);
        long prevx = (Long)this._prevx.elementAt(dataset);
        long prevy = (Long)this._prevy.elementAt(dataset);
        if (pt.connected) {
            this._drawLine(graphics, dataset, xpos, ypos, prevx, prevy, true);
        }
        this._prevx.setElementAt(new Long(xpos), dataset);
        this._prevy.setElementAt(new Long(ypos), dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (fmt.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, xpos, ypos, true);
            }
        } else if (fmt.impulses) {
            this._drawImpulse(graphics, xpos, ypos, true);
        }
        int marks = this._marks;
        if (!fmt.marksUseDefault) {
            marks = fmt.marks;
        }
        if (marks != 0) {
            this._drawPoint(graphics, dataset, xpos, ypos, true);
        }
        if (this._bars) {
            this._drawBar(graphics, dataset, xpos, ypos, true);
        }
        if (pt.errorBar) {
            this._drawErrorBar(graphics, dataset, xpos, (long)this._lry - (long)((pt.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((pt.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this.getForeground());
        if (this._pointsPersistence > 0) {
            graphics.setPaintMode();
        }
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (!clip || ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            int xposi = (int)xpos;
            int yposi = (int)ypos;
            Format fmt = (Format)this._formats.elementAt(dataset);
            int marks = this._marks;
            if (!fmt.marksUseDefault) {
                marks = fmt.marks;
            }
            switch (marks) {
                case 0: {
                    graphics.fillRect(xposi - 6, yposi - 6, 6, 6);
                    break;
                }
                case 1: {
                    graphics.fillOval(xposi - 1, yposi - 1, 3, 3);
                    break;
                }
                case 2: {
                    graphics.fillOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                    break;
                }
                case 3: {
                    int mark = dataset % 10;
                    switch (mark) {
                        case 0: {
                            graphics.fillOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                            break;
                        }
                        case 1: {
                            graphics.drawLine(xposi - this._radius, yposi - this._radius, xposi + this._radius, yposi + this._radius);
                            graphics.drawLine(xposi + this._radius, yposi - this._radius, xposi - this._radius, yposi + this._radius);
                            break;
                        }
                        case 2: {
                            graphics.drawRect(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                            break;
                        }
                        case 3: {
                            int[] xpoints = new int[4];
                            int[] ypoints = new int[4];
                            xpoints[0] = xposi;
                            ypoints[0] = yposi - this._radius;
                            xpoints[1] = xposi + this._radius;
                            ypoints[1] = yposi + this._radius;
                            xpoints[2] = xposi - this._radius;
                            ypoints[2] = yposi + this._radius;
                            xpoints[3] = xposi;
                            ypoints[3] = yposi - this._radius;
                            graphics.fillPolygon(xpoints, ypoints, 4);
                            break;
                        }
                        case 4: {
                            int[] xpoints = new int[5];
                            int[] ypoints = new int[5];
                            xpoints[0] = xposi;
                            ypoints[0] = yposi - this._radius;
                            xpoints[1] = xposi + this._radius;
                            ypoints[1] = yposi;
                            xpoints[2] = xposi;
                            ypoints[2] = yposi + this._radius;
                            xpoints[3] = xposi - this._radius;
                            ypoints[3] = yposi;
                            xpoints[4] = xposi;
                            ypoints[4] = yposi - this._radius;
                            graphics.drawPolygon(xpoints, ypoints, 5);
                            break;
                        }
                        case 5: {
                            graphics.drawOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                            break;
                        }
                        case 6: {
                            graphics.drawLine(xposi, yposi - this._radius, xposi, yposi + this._radius);
                            graphics.drawLine(xposi - this._radius, yposi, xposi + this._radius, yposi);
                            break;
                        }
                        case 7: {
                            graphics.fillRect(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                            break;
                        }
                        case 8: {
                            int[] xpoints = new int[4];
                            int[] ypoints = new int[4];
                            xpoints[0] = xposi;
                            ypoints[0] = yposi - this._radius;
                            xpoints[1] = xposi + this._radius;
                            ypoints[1] = yposi + this._radius;
                            xpoints[2] = xposi - this._radius;
                            ypoints[2] = yposi + this._radius;
                            xpoints[3] = xposi;
                            ypoints[3] = yposi - this._radius;
                            graphics.drawPolygon(xpoints, ypoints, 4);
                            break;
                        }
                        case 9: {
                            int[] xpoints = new int[5];
                            int[] ypoints = new int[5];
                            xpoints[0] = xposi;
                            ypoints[0] = yposi - this._radius;
                            xpoints[1] = xposi + this._radius;
                            ypoints[1] = yposi;
                            xpoints[2] = xposi;
                            ypoints[2] = yposi + this._radius;
                            xpoints[3] = xposi - this._radius;
                            ypoints[3] = yposi;
                            xpoints[4] = xposi;
                            ypoints[4] = yposi - this._radius;
                            graphics.fillPolygon(xpoints, ypoints, 5);
                        }
                    }
                    break;
                }
            }
        }
    }

    private synchronized void _erasePoint(Graphics graphics, int dataset, int index) {
        if (this._pointsPersistence > 0) {
            graphics.setXORMode(this.getBackground());
        }
        if (this._usecolor) {
            int color = dataset % this._colors.length;
            graphics.setColor(this._colors[color]);
        } else {
            graphics.setColor(this.getForeground());
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        PlotPoint pt = (PlotPoint)pts.elementAt(index);
        long ypos = (long)this._lry - (long)((pt.y - this._yMin) * this._yscale);
        long xpos = (long)this._ulx + (long)((pt.x - this._xMin) * this._xscale);
        if (index < pts.size() - 1) {
            PlotPoint nextp = (PlotPoint)pts.elementAt(index + 1);
            int nextx = this._ulx + (int)((nextp.x - this._xMin) * this._xscale);
            int nexty = this._lry - (int)((nextp.y - this._yMin) * this._yscale);
            if (nextp.connected) {
                this._drawLine(graphics, dataset, nextx, nexty, xpos, ypos, true);
            }
            nextp.connected = false;
        }
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (fmt.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, xpos, ypos, true);
            }
        } else if (fmt.impulses) {
            this._drawImpulse(graphics, xpos, ypos, true);
        }
        int marks = this._marks;
        if (!fmt.marksUseDefault) {
            marks = fmt.marks;
        }
        if (marks != 0) {
            this._drawPoint(graphics, dataset, xpos, ypos, true);
        }
        if (this._bars) {
            this._drawBar(graphics, dataset, xpos, ypos, true);
        }
        if (pt.errorBar) {
            this._drawErrorBar(graphics, dataset, xpos, (long)this._lry - (long)((pt.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((pt.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this.getForeground());
        if (this._pointsPersistence > 0) {
            graphics.setPaintMode();
        }
    }

    protected double _getLogarithmicValue(double value) throws IllegalArgumentException {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Cannot take the log of a value less than or equal to zero!");
        }
        return Math.log(value) * PlotBox._LOG10SCALE;
    }

    protected boolean _parseLine(String string) {
        String line;
        boolean connected = false;
        if (this._connected) {
            connected = true;
        }
        if (super._parseLine(string)) {
            this._pxgraphBlankLineMode = false;
            return true;
        }
        String lcLine = new String(string.toLowerCase());
        if (lcLine.startsWith("marks:")) {
            String style = string.substring(6).trim();
            if (this._sawfirstdataset) {
                this.setMarksStyle(style, this._currentdataset);
            } else {
                this.setMarksStyle(style);
            }
            this._pxgraphBlankLineMode = false;
            return true;
        }
        if (lcLine.startsWith("numsets:")) {
            this._pxgraphBlankLineMode = false;
            return true;
        }
        if (lcLine.startsWith("reusedatasets:")) {
            this._reusedatasets = lcLine.indexOf("off", 16) < 0;
            return true;
        }
        if (lcLine.startsWith("dataset:") || this._pxgraphBlankLineMode && lcLine.length() == 0) {
            if (this._reusedatasets && lcLine.length() > 0) {
                String tlegend = string.substring(8).trim();
                this._currentdataset = -1;
                int i = 0;
                while (i <= this._maxdataset) {
                    if (this.getLegend(i).compareTo(tlegend) == 0) {
                        this._currentdataset = i;
                    }
                    ++i;
                }
                if (this._currentdataset != -1) {
                    return true;
                }
                this._currentdataset = this._maxdataset;
            }
            this._firstinset = true;
            this._sawfirstdataset = true;
            ++this._currentdataset;
            if (lcLine.length() > 0) {
                String legend = string.substring(8).trim();
                if (legend != null && legend.length() > 0) {
                    this.addLegend(this._currentdataset, legend);
                }
                this._pxgraphBlankLineMode = false;
            }
            this._maxdataset = this._currentdataset;
            return true;
        }
        if (lcLine.startsWith("lines:")) {
            if (lcLine.indexOf("off", 6) >= 0) {
                this.setConnected(false);
            } else {
                this.setConnected(true);
            }
            this._pxgraphBlankLineMode = false;
            return true;
        }
        if (lcLine.startsWith("impulses:")) {
            if (this._sawfirstdataset) {
                if (lcLine.indexOf("off", 9) >= 0) {
                    this.setImpulses(false, this._currentdataset);
                } else {
                    this.setImpulses(true, this._currentdataset);
                }
            } else if (lcLine.indexOf("off", 9) >= 0) {
                this.setImpulses(false);
            } else {
                this.setImpulses(true);
            }
            this._pxgraphBlankLineMode = false;
            return true;
        }
        if (lcLine.startsWith("bars:")) {
            if (lcLine.indexOf("off", 5) >= 0) {
                this.setBars(false);
            } else {
                String barwidth;
                this.setBars(true);
                int comma = string.indexOf(",", 5);
                String baroffset = null;
                if (comma > 0) {
                    barwidth = string.substring(5, comma).trim();
                    baroffset = string.substring(comma + 1).trim();
                } else {
                    barwidth = string.substring(5).trim();
                }
                try {
                    Double bwidth = new Double(barwidth);
                    double boffset = this._baroffset;
                    if (baroffset != null) {
                        boffset = new Double(baroffset);
                    }
                    this.setBars(bwidth, boffset);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this._pxgraphBlankLineMode = false;
            return true;
        }
        if (string.startsWith("move:")) {
            connected = false;
            line = string.substring(5, string.length()).trim();
        } else if (line.startsWith("move")) {
            connected = false;
            line = line.substring(4, line.length()).trim();
        } else if (line.startsWith("draw:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("draw")) {
            line = line.substring(4, line.length()).trim();
        }
        line = line.trim();
        int fieldsplit = line.indexOf(",");
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf(" ");
        }
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf(" ");
        }
        if (fieldsplit > 0) {
            String x = line.substring(0, fieldsplit).trim();
            String y = line.substring(fieldsplit + 1).trim();
            int fieldsplit2 = y.indexOf(",");
            if (fieldsplit2 == -1) {
                fieldsplit2 = y.indexOf(" ");
            }
            if (fieldsplit2 == -1) {
                fieldsplit2 = y.indexOf(" ");
            }
            if (fieldsplit2 > 0) {
                line = y.substring(fieldsplit2 + 1).trim();
                y = y.substring(0, fieldsplit2).trim();
            }
            try {
                Double xpt = new Double(x);
                Double ypt = new Double(y);
                if (fieldsplit2 > 0) {
                    int fieldsplit3 = line.indexOf(",");
                    if (fieldsplit3 == -1) {
                        fieldsplit3 = line.indexOf(" ");
                    }
                    if (fieldsplit3 == -1) {
                        fieldsplit2 = line.indexOf(" ");
                    }
                    if (fieldsplit3 > 0) {
                        String yl = line.substring(0, fieldsplit3).trim();
                        String yh = line.substring(fieldsplit3 + 1).trim();
                        Double yLowEB = new Double(yl);
                        Double yHighEB = new Double(yh);
                        connected = this._addLegendIfNecessary(connected);
                        this.addPointWithErrorBars(this._currentdataset, xpt, ypt, yLowEB, yHighEB, connected);
                        return true;
                    }
                    connected = this._addLegendIfNecessary(connected);
                    this.addPoint(this._currentdataset, xpt, ypt, connected);
                    return true;
                }
                connected = this._addLegendIfNecessary(connected);
                this.addPoint(this._currentdataset, xpt, ypt, connected);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    protected void _write(PrintWriter output) {
        super._write(output);
        if (this._reusedatasets) {
            output.println("ReuseDatasets: on");
        }
        if (!this._connected) {
            output.println("Lines: off");
        }
        if (this._bars) {
            output.println("Bars: " + this._barwidth + ", " + this._baroffset);
        }
        if (this._impulses) {
            output.println("Impulses: on");
        }
        switch (this._marks) {
            case 1: {
                output.println("Marks: points");
            }
            case 2: {
                output.println("Marks: dots");
            }
            case 3: {
                output.println("Marks: various");
            }
        }
        int dataset = 0;
        while (dataset < this._points.size()) {
            String legend = this.getLegend(dataset);
            if (legend != null) {
                output.println("DataSet: " + this.getLegend(dataset));
            } else {
                output.println("DataSet:");
            }
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (!fmt.impulsesUseDefault) {
                if (fmt.impulses) {
                    output.println("Impulses: on");
                } else {
                    output.println("Impulses: off");
                }
            }
            if (!fmt.marksUseDefault) {
                switch (fmt.marks) {
                    case 0: {
                        output.println("Marks: none");
                    }
                    case 1: {
                        output.println("Marks: points");
                    }
                    case 2: {
                        output.println("Marks: dots");
                    }
                    case 3: {
                        output.println("Marks: various");
                    }
                }
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            int pointnum = 0;
            while (pointnum < pts.size()) {
                PlotPoint pt = (PlotPoint)pts.elementAt(pointnum);
                if (!pt.connected) {
                    output.print("move: ");
                }
                if (pt.errorBar) {
                    output.println(pt.x + ", " + pt.y + ", " + pt.yLowEB + ", " + pt.yHighEB);
                } else {
                    output.println(pt.x + ", " + pt.y);
                }
                ++pointnum;
            }
            ++dataset;
        }
    }

    public void addLegend(int dataset, String legend) {
        this._checkDatasetIndex(dataset);
        super.addLegend(dataset, legend);
    }

    public synchronized void addPoint(int dataset, double x, double y, boolean connected) {
        this.addPoint(dataset, x, y, connected, false);
    }

    public synchronized void addPoint(int dataset, double d, double d2, boolean connected, boolean inError) {
        double y;
        double x;
        if (this._xlog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d);
                return;
            }
            x = Math.log(d) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            try {
                y = this._getLogarithmicValue(d2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + y);
                return;
            }
        }
        this._addPoint(dataset, x, y, 0.0, 0.0, connected, false, inError);
    }

    public synchronized void addPointWithErrorBars(int dataset, double x, double y, double yLowEB, double yHighEB, boolean connected) {
        this.addPointWithErrorBars(dataset, x, y, yLowEB, yHighEB, connected, false);
    }

    public synchronized void addPointWithErrorBars(int dataset, double d, double d2, double d3, double d4, boolean connected, boolean inError) {
        double yHighEB;
        double yLowEB;
        double y;
        double x;
        if (this._xlog) {
            if (d <= 0.0) {
                EventLog.instance().log("ERROR: " + this.toString() + ": addPointWithErrorBars: Can't plot non-positive X values " + "when the logarithmic X axis value is specified: " + d);
                return;
            }
            x = Math.log(d) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (d2 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
                EventLog.instance().log("ERROR: " + this.toString() + ": addPointWithErrorBars: Can't plot non-positive Y values " + "when the logarithmic Y axis value is specified: " + d2);
                return;
            }
            y = Math.log(d2) * PlotBox._LOG10SCALE;
            yLowEB = Math.log(d3) * PlotBox._LOG10SCALE;
            yHighEB = Math.log(d4) * PlotBox._LOG10SCALE;
        }
        this._addPoint(dataset, x, y, yLowEB, yHighEB, connected, true, inError);
    }

    public synchronized void clear(boolean format) {
        super.clear(format);
        this._currentdataset = -1;
        this._points.size();
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._painted = false;
        this._maxdataset = -1;
        this._firstinset = true;
        this._sawfirstdataset = false;
        this._pxgraphBlankLineMode = true;
        this._endian = 0;
        this._xyInvalid = false;
        this._filename = null;
        this._showing = false;
        if (format) {
            this._formats = new Vector();
            this._marks = 0;
            this._pointsPersistence = 0;
            this._sweepsPersistence = 0;
            this._bars = false;
            this._barwidth = 0.5;
            this._baroffset = 0.05;
            this._connected = true;
            this._impulses = false;
            this._reusedatasets = false;
        }
    }

    public synchronized void erasePoint(int dataset, int index) {
        PlotPoint pt;
        Vector points;
        this._checkDatasetIndex(dataset);
        if (this.isShowing()) {
            this._erasePoint(this.getGraphics(), dataset, index);
        }
        if ((points = (Vector)this._points.elementAt(dataset)) != null && (pt = (PlotPoint)points.elementAt(index)) != null) {
            if (pt.x == this._xBottom || pt.x == this._xTop || pt.y == this._yBottom || pt.y == this._yTop) {
                this._xyInvalid = true;
            }
            points.removeElementAt(index);
        }
    }

    public synchronized void fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -Double.MIN_VALUE;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -Double.MIN_VALUE;
            int dataset = 0;
            while (dataset < this._points.size()) {
                Vector points = (Vector)this._points.elementAt(dataset);
                int index = 0;
                while (index < points.size()) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    if (pt.x < this._xBottom) {
                        this._xBottom = pt.x;
                    }
                    if (pt.x > this._xTop) {
                        this._xTop = pt.x;
                    }
                    if (pt.y < this._yBottom) {
                        this._yBottom = pt.y;
                    }
                    if (pt.y > this._yTop) {
                        this._yTop = pt.y;
                    }
                    ++index;
                }
                ++dataset;
            }
        }
        this._xyInvalid = false;
        if (this._bars) {
            if (this._yBottom > 0.0) {
                this._yBottom = 0.0;
            }
            if (this._yTop < 0.0) {
                this._yTop = 0.0;
            }
        }
        super.fillPlot();
    }

    public String getCmdLineFilename() {
        return this._filename;
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public void paint(Graphics graphics) {
        this._drawPlot(graphics, true);
    }

    public int parseArgs(String[] args) throws CmdLineArgException, FileNotFoundException, IOException {
        int i = 0;
        int argsread = 0;
        boolean sawbararg = false;
        boolean sawnlarg = false;
        int savedmarks = 0;
        boolean binary = false;
        String[] unsupportedOptions = new String[]{"-bd", "-brb", "-bw", "-gw", "-lw", "-zg", "-zw"};
        while (i < args.length && (args[i].startsWith("-") || args[i].startsWith("="))) {
            String arg;
            if ((arg = args[i++]).startsWith("-")) {
                boolean badarg = false;
                int j = 0;
                while (j < unsupportedOptions.length) {
                    if (arg.equals(unsupportedOptions[j])) {
                        EventLog.instance().log("ERROR: " + this.toString() + ": parseArgs: pxgraph: " + arg + " is not yet supported");
                        ++i;
                        badarg = true;
                    }
                    ++j;
                }
                if (badarg || arg.equals("-bb")) continue;
                if (arg.equals("-bg")) {
                    this.setBackground(PlotBox.getColorByName(args[i++]));
                    continue;
                }
                if (arg.equals("-brw")) {
                    if (!(arg.indexOf(",") == -1 ? !this._parseLine("Bars: " + args[i++] + ",0") : !this._parseLine("Bars: " + args[i++]))) continue;
                    throw new CmdLineArgException("Failed to parse `" + arg + "'");
                }
                if (arg.equals("-lf")) {
                    this.setLabelFont(args[i++]);
                    continue;
                }
                if (arg.equals("-lx")) {
                    if (this._parseLine("XRange: " + args[i++])) continue;
                    throw new CmdLineArgException("Failed to parse `" + arg + "'");
                }
                if (arg.equals("-ly")) {
                    if (this._parseLine("YRange: " + args[i++])) continue;
                    throw new CmdLineArgException("Failed to parse `" + arg + "'");
                }
                if (arg.equals("-t")) {
                    String title = args[i++];
                    this.setTitle(title);
                    continue;
                }
                if (arg.equals("-tf")) {
                    this.setTitleFont(args[i++]);
                    continue;
                }
                if (arg.equals("-x")) {
                    this.setXLabel(args[i++]);
                    continue;
                }
                if (arg.equals("-y")) {
                    this.setYLabel(args[i++]);
                    continue;
                }
                if (arg.equals("-bar")) {
                    sawbararg = true;
                    if (sawnlarg) {
                        this.setImpulses(true);
                    } else {
                        this.setBars(true);
                        savedmarks = this._marks;
                        this.setMarksStyle("none");
                    }
                    this.setConnected(false);
                    continue;
                }
                if (arg.equals("-binary")) {
                    binary = true;
                    this._endian = 0;
                    continue;
                }
                if (arg.equals("-bigendian")) {
                    binary = true;
                    this._endian = 1;
                    continue;
                }
                if (arg.equals("-littleendian")) {
                    binary = true;
                    this._endian = 2;
                    continue;
                }
                if (arg.equals("-db") || arg.equals("-debug")) continue;
                if (arg.equals("-fg")) {
                    this.setForeground(PlotBox.getColorByName(args[i++]));
                    continue;
                }
                if (arg.equals("-help")) continue;
                if (arg.equals("-impulses")) {
                    this.setImpulses(true);
                    this.setConnected(false);
                    continue;
                }
                if (arg.equals("-lnx")) {
                    this.setXLog(true);
                    continue;
                }
                if (arg.equals("-lny")) {
                    this.setYLog(true);
                    continue;
                }
                if (arg.equals("-m")) {
                    this.setMarksStyle("various");
                    continue;
                }
                if (arg.equals("-M")) {
                    this.setMarksStyle("various");
                    continue;
                }
                if (arg.equals("-nl")) {
                    sawnlarg = true;
                    if (sawbararg) {
                        this._marks = savedmarks;
                        this.setBars(false);
                        this.setImpulses(true);
                    }
                    this.setConnected(false);
                    continue;
                }
                if (arg.equals("-o")) {
                    ++i;
                    continue;
                }
                if (arg.equals("-p")) {
                    this.setMarksStyle("points");
                    continue;
                }
                if (arg.equals("-P")) {
                    this.setMarksStyle("dots");
                    continue;
                }
                if (arg.equals("-print")) continue;
                if (arg.equals("-rv")) {
                    this.setBackground(PlotBox.getColorByName("black"));
                    this.setForeground(PlotBox.getColorByName("white"));
                    continue;
                }
                if (arg.equals("-test")) continue;
                if (arg.equals("-tk")) {
                    this.setGrid(false);
                    continue;
                }
                if (arg.equals("-v") || arg.equals("-version")) continue;
                if (arg.length() > 1 && arg.charAt(0) == '-') {
                    try {
                        Integer datasetnumberint = new Integer(arg.substring(1));
                        int datasetnumber = datasetnumberint;
                        if (datasetnumber >= 0) {
                            this.addLegend(datasetnumber, args[i++]);
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            } else if (arg.startsWith("=")) {
                this._width = Integer.valueOf(arg.substring(1, arg.indexOf(120)));
                int plusIndex = arg.indexOf(43);
                int minusIndex = arg.indexOf(45);
                if (plusIndex != -1 || minusIndex != -1) {
                    if (plusIndex != -1 && minusIndex != -1) {
                        int index = minusIndex;
                        if (plusIndex < minusIndex) {
                            index = plusIndex;
                        }
                        this._height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, index));
                        continue;
                    }
                    if (plusIndex != -1) {
                        this._height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, plusIndex));
                        continue;
                    }
                    this._height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, minusIndex));
                    continue;
                }
                if (arg.length() <= arg.indexOf(120)) continue;
                this._height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, arg.length()));
                continue;
            }
            throw new CmdLineArgException("Failed to parse `" + arg + "'");
        }
        argsread = i++;
        this.setSize(this._width, this._height);
        i = argsread;
        while (i < args.length) {
            InputStream instream;
            try {
                URL inurl = new URL(this._documentBase, args[i]);
                instream = inurl.openStream();
            }
            catch (MalformedURLException malformedURLException) {
                instream = new FileInputStream(args[i]);
                this._filename = args[i];
            }
            if (binary) {
                this.readPxgraph(instream);
            } else {
                this.read(instream);
            }
            ++i;
        }
        return argsread;
    }

    public void parseFile(String filespec, URL documentBase) {
        this._firstinset = true;
        this._sawfirstdataset = false;
        super.parseFile(filespec, documentBase);
    }

    public int parsePxgraphargs(String pxgraphargs) throws CmdLineArgException, FileNotFoundException, IOException {
        Vector<String> argvector;
        block17: {
            argvector = new Vector<String>();
            boolean prependdash = false;
            StringReader pin = new StringReader(pxgraphargs);
            try {
                StreamTokenizer stoken = new StreamTokenizer(pin);
                stoken.resetSyntax();
                stoken.whitespaceChars(0, 32);
                stoken.wordChars(40, 126);
                stoken.quoteChar(34);
                stoken.quoteChar(39);
                String partialarg = null;
                while (true) {
                    int c = stoken.nextToken();
                    switch (stoken.ttype) {
                        case -1: {
                            break block17;
                        }
                        case -3: {
                            if (prependdash) {
                                prependdash = false;
                                if (partialarg == null) {
                                    argvector.addElement(new String("-" + stoken.sval));
                                } else {
                                    argvector.addElement(new String("-" + partialarg + stoken.sval));
                                }
                            } else if (partialarg == null) {
                                argvector.addElement(new String(stoken.sval));
                            } else {
                                argvector.addElement(new String(String.valueOf(partialarg) + stoken.sval));
                            }
                            partialarg = null;
                            break;
                        }
                        case 45: {
                            prependdash = true;
                            break;
                        }
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: {
                            partialarg = String.valueOf((String)argvector.lastElement()) + (char)c;
                            argvector.removeElementAt(argvector.size() - 1);
                            break;
                        }
                        case 34: 
                        case 39: {
                            argvector.addElement(new String(stoken.sval));
                            break;
                        }
                        default: {
                            throw new IOException("Failed to parse: '" + (char)c + "' in `" + pxgraphargs + "'");
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String[] args = new String[argvector.size()];
        int i = 0;
        while (i < argvector.size()) {
            args[i] = (String)argvector.elementAt(i);
            ++i;
        }
        return this.parseArgs(args);
    }

    public void read(InputStream in) throws IOException {
        super.read(in);
        this._firstinset = true;
        this._sawfirstdataset = false;
    }

    public void readPxgraph(InputStream inputstream) throws IOException {
        Cursor oldCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            this._firstinset = true;
            this._sawfirstdataset = false;
            DataInputStream in = new DataInputStream(new BufferedInputStream(inputstream));
            float x = 0.0f;
            float y = 0.0f;
            float pointCount = 0.0f;
            boolean byteSwapped = false;
            boolean connected = false;
            byte[] input = new byte[4];
            if (this._connected) {
                connected = true;
            }
            switch (this._endian) {
                case 0: {
                    try {
                        if (!System.getProperty("os.arch").equals("x86")) break;
                        byteSwapped = true;
                    }
                    catch (SecurityException securityException) {}
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    byteSwapped = true;
                    break;
                }
                default: {
                    throw new IOException("Internal Error: Don't know about '" + this._endian + "' style of endian");
                }
            }
            try {
                int c = in.readByte();
                if (c != 100) {
                    int bits = c;
                    bits <<= 8;
                    bits += in.readByte();
                    bits <<= 8;
                    bits += in.readByte();
                    bits <<= 8;
                    x = Float.intBitsToFloat(bits += in.readByte());
                    y = in.readFloat();
                    connected = this._addLegendIfNecessary(connected);
                    this.addPoint(this._currentdataset, x, y, connected);
                    if (this._connected) {
                        connected = true;
                    }
                    while (true) {
                        x = in.readFloat();
                        y = in.readFloat();
                        connected = this._addLegendIfNecessary(connected);
                        this.addPoint(this._currentdataset, x, y, connected);
                        if (!this._connected) continue;
                        connected = true;
                    }
                }
                while (true) {
                    switch (c) {
                        case 100: {
                            if (byteSwapped) {
                                in.readFully(input);
                                x = Float.intBitsToFloat((input[3] & 0xFF) << 24 | (input[2] & 0xFF) << 16 | (input[1] & 0xFF) << 8 | input[0] & 0xFF);
                                in.readFully(input);
                                y = Float.intBitsToFloat((input[3] & 0xFF) << 24 | (input[2] & 0xFF) << 16 | (input[1] & 0xFF) << 8 | input[0] & 0xFF);
                            } else {
                                x = in.readFloat();
                                y = in.readFloat();
                            }
                            pointCount += 1.0f;
                            connected = this._addLegendIfNecessary(connected);
                            this.addPoint(this._currentdataset, x, y, connected);
                            if (!this._connected) break;
                            connected = true;
                            break;
                        }
                        case 101: {
                            connected = false;
                            break;
                        }
                        case 110: {
                            StringBuffer datasetname = new StringBuffer();
                            this._firstinset = true;
                            this._sawfirstdataset = true;
                            ++this._currentdataset;
                            if (this._currentdataset >= 10) {
                                this._currentdataset = 0;
                            }
                            while (c != 10) {
                                datasetname.append(in.readChar());
                            }
                            this.addLegend(this._currentdataset, datasetname.toString());
                            this.setConnected(true);
                            break;
                        }
                        case 109: {
                            connected = false;
                            break;
                        }
                        default: {
                            throw new IOException("Don't understand `" + (char)c + "' character " + "(decimal value = " + c + ") in binary file.  Last point was (" + x + "," + y + ").\nProcessed " + pointCount + " points successfully");
                        }
                    }
                    c = in.readByte();
                }
            }
            catch (EOFException eOFException) {
            }
        }
        catch (Throwable throwable) {
            Object var3_14 = null;
            this.setCursor(oldCursor);
            throw throwable;
        }
        Object var3_15 = null;
        this.setCursor(oldCursor);
    }

    public void setBars(double width, double offset) {
        this._barwidth = width;
        this._baroffset = offset;
        this._bars = true;
    }

    public void setBars(boolean on) {
        this._bars = on;
    }

    public void setConnected(boolean on) {
        this._connected = on;
    }

    public void setImpulses(boolean on) {
        this._impulses = on;
    }

    public void setImpulses(boolean on, int dataset) {
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        fmt.impulses = on;
        fmt.impulsesUseDefault = false;
    }

    public void setMarksStyle(String style) {
        if (style.equalsIgnoreCase("none")) {
            this._marks = 0;
        } else if (style.equalsIgnoreCase("points")) {
            this._marks = 1;
        } else if (style.equalsIgnoreCase("dots")) {
            this._marks = 2;
        } else if (style.equalsIgnoreCase("various")) {
            this._marks = 3;
        }
    }

    public void setMarksStyle(String style, int dataset) {
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (style.equalsIgnoreCase("none")) {
            fmt.marks = 0;
        } else if (style.equalsIgnoreCase("points")) {
            fmt.marks = 1;
        } else if (style.equalsIgnoreCase("dots")) {
            fmt.marks = 2;
        } else if (style.equalsIgnoreCase("various")) {
            fmt.marks = 3;
        }
        fmt.marksUseDefault = false;
    }

    public void setNumSets(int numsets) {
        if (numsets < 1) {
            throw new IllegalArgumentException("Number of data sets (" + numsets + ") must be greater than 0.");
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._formats.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        int i = 0;
        while (i < numsets) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format(this));
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
            ++i;
        }
    }

    public void setPointsPersistence(int persistence) {
        this._pointsPersistence = persistence;
    }

    public void setSweepsPersistence(int persistence) {
        this._sweepsPersistence = persistence;
    }

    public String toString() {
        return "Plot";
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private class Format {
        /* synthetic */ Plot this$0;
        public boolean impulses;
        public boolean impulsesUseDefault = true;
        public int marks;
        public boolean marksUseDefault = true;

        Format(Plot this$0) {
            this.this$0 = this$0;
        }
    }
}

