/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.alarms;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.mrsgraphs.common.DatasetAttributes;
import com.agilent.tntd.eclipse.mrsgraphs.common.Epoch;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphComponent;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.agilent.tntd.eclipse.mrsgraphs.containers.GraphPane;
import com.agilent.tntd.eclipse.mrsgraphs.mouse.MouseActionEventHandler;
import com.agilent.tntd.eclipse.mrsgraphs.mouse.MouseEventReceiver;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class AlarmPlot
extends MRSGraphComponent
implements MouseEventReceiver {
    private boolean topGraph = false;
    private transient String alarmGroupTitle = "Alarms";
    private transient MouseActionEventHandler theMouseHandler = null;

    public AlarmPlot() {
        this.initialize();
    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long l, boolean clip) {
        long ypos;
        if (clip) {
            if (l < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int endpt;
            int barlx = (int)xpos - 1;
            int barrx = barlx + (this._lrx - this._ulx) / this.numDataPts + 3;
            if (barlx < this._ulx) {
                barlx = this._ulx + 1;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx - 1;
            }
            if (barlx >= barrx) {
                ++barrx;
            }
            if (barrx > (endpt = this.translateD2P(this.eodMarkerLocation))) {
                barrx = endpt + 3;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos + 1, barrx - barlx, (int)(zeroypos - ypos - 1L));
            } else {
                graphics.fillRect(barlx, (int)zeroypos + 1, barrx - barlx, (int)(ypos - zeroypos - 1L));
            }
        }
    }

    public void doLeftSingleClickAction(MouseEvent e) {
        super.doLeftSingleClickAction(e);
    }

    public void doRightSingleClickAction(MouseEvent e) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof GraphPane) break;
            parent = parent.getParent();
        }
        if (parent != null) {
            ((GraphPane)parent).doRightSingleClickAction(e);
        }
    }

    protected void drawCursorLocationValues(Graphics g) {
        if (this.topGraph) {
            super.drawCursorLocationValues(g);
        }
    }

    protected void drawGraphTitle(Graphics g) {
        String title = this.getGraphTitle();
        Font font = g.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        int xpos = this._ulx - fm.stringWidth(title) - 3;
        int ypos = this._topPadding + (this.getBounds().height - this._bottomPadding - this._topPadding) / 2 + 5;
        g.drawString(title, xpos, ypos);
        if (this.topGraph) {
            Font boldFont = new Font(font.getFamily(), 1, font.getSize());
            g.setFont(boldFont);
            g.setColor(this.getForeground());
            ypos = this._topPadding / 2 + 3;
            g.drawString(this.alarmGroupTitle, this._leftPadding, ypos);
        }
        g.setFont(font);
    }

    public void finishInitialise() {
        super.finishInitialise();
        this._topPadding = this.topGraph ? 20 : 0;
        this._bottomPadding = this.drawDates && this.drawTimes ? 35 : (this.drawDates || this.drawTimes ? 20 : 0);
        this.calculateGraphAreaBounds();
    }

    public String getAlarmGroupTitle() {
        return this.alarmGroupTitle;
    }

    protected void initialize() {
        super.initialize();
        this.enableEvents(28L);
        this.theMouseHandler = new MouseActionEventHandler();
        this._topPadding = 0;
        this._bottomPadding = 0;
        this.graph = "Alarms";
        this._colors[0] = GraphDefaults.errorColor;
    }

    public boolean isTopGraph() {
        return this.topGraph;
    }

    protected void plotData(int dataID, int dataset, long start, float[] data, boolean errorBars) {
        if (errorBars) {
            EventLog.instance().log("ERROR: " + this.toString() + ": plotData: Error bars specified. This makes no sense in an alarm graph.");
        }
        boolean connectToLastPoint = false;
        int length = data.length;
        String xvalues = "";
        String yvalues = "";
        int i = 0;
        while (i < length) {
            double x = start + (long)i * this.resolution;
            long endOfBucket = Math.round(x) + (this.resolution - 1L);
            if (this.debug && endOfBucket <= this.datasetAttributes[dataset].lastReceivedXValue) {
                EventLog.instance().log("ERROR: " + this.toString() + ": plotData: Already received data at time " + x);
            } else {
                this.addPoint(dataset, x, data[i], connectToLastPoint);
                xvalues = String.valueOf(xvalues) + "" + Math.round(x) + ", ";
                yvalues = String.valueOf(yvalues) + "" + data[i] + ", ";
                this.datasetAttributes[dataset].lastReceivedXValue = endOfBucket;
                this.eodMarkerLocation = Math.round(x);
                if (endOfBucket > this.maxXValueReceived) {
                    this.maxXValueReceived = endOfBucket;
                }
            }
            ++i;
        }
        if (this.debug) {
            EventLog.instance().log("*****");
            EventLog.instance().log("DEBUG: " + this.toString() + ": plotData: Data ID = " + dataID + "; Start = " + start + "; Size = " + length);
            EventLog.instance().log("X Values = " + xvalues);
            EventLog.instance().log("Y Values = " + yvalues);
            EventLog.instance().log("Last received x value = " + this.datasetAttributes[dataset].lastReceivedXValue);
        }
        this.setCursorLocation(this.cursorLocation);
        this.updateCursorLocationValues();
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getSource() == this) {
            this.theMouseHandler.processMouseEvent(e, this, true, this.isEnabled());
        }
    }

    protected void resetPlot() {
        this.clear(true);
        this.setGrid(false);
        this.maxXValueReceived = 0L;
        if (this.datasetAttributes != null) {
            int i = 0;
            while (i < this.datasetAttributes.length) {
                this.datasetAttributes[i].lastReceivedXValue = 0L;
                ++i;
            }
        }
        this.setXRange(this.rangeLeft, this.rangeRight);
        this.setBars(true);
        this.calculateXTickMarks();
        this.setYRange(0.0, 1.0);
        this.addYTick("", 0.0);
        this.addYTick("", 1.0);
    }

    public void setAlarmGroupTitle(String groupName) {
        this.alarmGroupTitle = groupName;
    }

    public void setGraphParameters(MRSGraphParameters params) {
        this.trapTransientError(true);
        this.resetGraphParameters();
        this.setAlarmGroupTitle(params.groupTitle);
        this.setDrawDates(params.drawDates);
        this.setDrawTimes(params.drawTimes);
        DatasetAttributes[] datasetAttributesArray = this.datasetAttributes = new DatasetAttributes[1];
        synchronized (this.datasetAttributes) {
            this.datasetAttributes[0] = new DatasetAttributes(params.graphNameOnServer, params.graphTitle, "y = xxxxx.xxx");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setTopGraph(boolean flag) {
        this.topGraph = flag;
    }

    public String toString() {
        return "AlarmPlot: " + super.toString();
    }

    protected boolean updateCursorLocationValues() {
        if (this.datasetAttributes == null || this.datasetAttributes.length < 1) {
            return false;
        }
        if (this.topGraph) {
            Epoch epoch = new Epoch(this.cursorLocation * 1000L);
            this.datasetAttributes[0].cursorValue = "t = " + epoch.getDateAndTime(true, true) + "    y = Alarm if red";
        }
        return true;
    }
}

