/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.common;

import com.agilent.tntd.eclipse.common.util.EventLog;
import java.util.GregorianCalendar;

public class Epoch
extends GregorianCalendar {
    public Epoch() {
    }

    public Epoch(int year, int month, int day, int hour, int min, int sec) {
        super(year, month - 1, day, hour, min, sec);
    }

    public Epoch(long epoch) {
        this.setTimeInMillis(epoch);
    }

    public String getDateAndTime(boolean yearFlag, boolean secondFlag) {
        String dateString = this.getDateOnly(yearFlag);
        String timeString = this.getTimeOnly(secondFlag);
        return String.valueOf(dateString) + " " + timeString;
    }

    public String getDateOnly(boolean yearFlag) {
        String dateString = "" + this.get(5);
        String month = "";
        switch (this.get(2)) {
            case 0: {
                month = "Jan";
                break;
            }
            case 1: {
                month = "Feb";
                break;
            }
            case 2: {
                month = "Mar";
                break;
            }
            case 3: {
                month = "Apr";
                break;
            }
            case 4: {
                month = "May";
                break;
            }
            case 5: {
                month = "Jun";
                break;
            }
            case 6: {
                month = "Jul";
                break;
            }
            case 7: {
                month = "Aug";
                break;
            }
            case 8: {
                month = "Sep";
                break;
            }
            case 9: {
                month = "Oct";
                break;
            }
            case 10: {
                month = "Nov";
                break;
            }
            case 11: {
                month = "Dec";
                break;
            }
            default: {
                EventLog.instance().log("ERROR: " + this.toString() + ": getDateOnly: Invalid month returned");
            }
        }
        dateString = String.valueOf(dateString) + " " + month;
        if (yearFlag) {
            dateString = String.valueOf(dateString) + " " + this.get(1);
        }
        return dateString;
    }

    public long getEpoch() {
        return this.getTimeInMillis();
    }

    public String getFullDateAndTime() {
        return this.getTime().toString();
    }

    public String getTimeOnly(boolean secondFlag) {
        String timeString = "" + this.get(11);
        int minute = this.get(12);
        String minuteString = "";
        if (minute < 10) {
            minuteString = String.valueOf(minuteString) + "0";
        }
        minuteString = String.valueOf(minuteString) + minute;
        timeString = String.valueOf(timeString) + ":" + minuteString;
        if (secondFlag) {
            int second = this.get(13);
            String secondString = "";
            if (second < 10) {
                secondString = String.valueOf(secondString) + "0";
            }
            secondString = String.valueOf(secondString) + second;
            timeString = String.valueOf(timeString) + ":" + secondString;
        }
        return timeString;
    }

    public void setEpoch(long epoch) {
        this.setTimeInMillis(epoch);
    }
}

