/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.common;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.graphs.ptplot.Plot;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.mrsgraphs.alarms.AlarmPlot;
import com.agilent.tntd.eclipse.mrsgraphs.common.DatasetAttributes;
import com.agilent.tntd.eclipse.mrsgraphs.common.Epoch;
import com.agilent.tntd.eclipse.mrsgraphs.common.LabelAndPosition;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphInfo;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphManager;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.agilent.tntd.eclipse.mrsgraphs.continuous.ContinuousPlot;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphPaneComponent;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphInfoDataReceiver;
import com.agilent.tntd.eclipse.mrsgraphs.multiline.MultipleLineGraphSupport;
import com.agilent.tntd.eclipse.mrsgraphs.step.StepPlot;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;

public abstract class MRSGraphComponent
extends Plot
implements CcConnectedComponent,
ApplicationGenericDataReceiver,
MRSGraphInfoDataReceiver,
GraphPaneComponent {
    protected String graph = "";
    protected String graphTitle = "";
    protected boolean drawDates = true;
    protected boolean drawTimes = true;
    protected String databaseVariableName = "MRS_GRAPH_DATA";
    protected final transient byte initialized = (byte)3;
    protected final transient int cursorWidth = 3;
    protected final transient int endOfDataWidth = 5;
    protected final transient String cursorValueInitString = "y = xxxxx.xxx";
    protected transient DatasetAttributes[] datasetAttributes = null;
    protected transient String session = "";
    protected transient long end = 0L;
    protected transient long eodMarkerLocation = 0L;
    protected transient long rangeLeft = 0L;
    protected transient long rangeRight = 0L;
    protected transient long cursorLocation = 0L;
    protected transient long resolution = 0L;
    protected transient int zoomFactor = -1;
    protected transient boolean live = false;
    protected transient int numDataPts = 60;
    protected transient long maxXValueReceived = 0L;
    protected transient LabelAndPosition[] dateLabels = null;
    protected transient ApplicationObject graphDataAO = null;
    protected transient boolean hasTrappedTransientError = false;
    protected transient boolean hasTrappedPermanentError = false;
    protected transient boolean graphManagerInError = false;
    protected transient boolean outOfContext = false;
    protected transient byte initializationState = 0;
    protected transient byte queryResponseState = 0;
    private transient MultipleLineGraphSupport theMultiLineGraphSupport = null;
    private static transient UnconsumedKeyHandler theMainKeyController = null;
    protected boolean debug = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
            return;
        }
        if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
            return;
        }
        if (aReport.getErrorStatus() == 0 && (this.initializationState == 0 || this.initializationState == 1)) {
            this.initializationState = (byte)(this.initializationState + 2);
        }
        this.graphDataAO = anAO;
        if (this.initializationState != 3) return;
        DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
        synchronized (this.datasetAttributes) {
            short i = 0;
            while (i < this.datasetAttributes.length) {
                ApplicationGenericMetaData meta = this.createMetaData((short)0, i, this.datasetAttributes[i].nameOnServer, this.rangeLeft, this.rangeRight);
                this.sendQuery((ApplicationMetaData)meta, this.graphDataAO);
                this.queryResponseState = (byte)(this.queryResponseState + 2);
                i = (short)(i + 1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void calculateGraphAreaBounds() {
        this._ulx = this._leftPadding;
        this._uly = this._topPadding;
        this._lrx = this.getBounds().width - this._rightPadding;
        this._lry = this.getBounds().height - this._bottomPadding - 1;
    }

    protected void calculateXTickMarks() {
        long left = Math.round(this._xMin);
        long right = Math.round(this._xMax);
        String tickLabel = "";
        Epoch epoch = new Epoch();
        this.dateLabels = null;
        switch (this.zoomFactor) {
            case 0: 
            case 1: {
                String leftDate = "";
                String rightDate = "";
                long range = right - left;
                long midpt = Math.round((double)range * 0.5) + left;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(true);
                    }
                    if (this.drawDates) {
                        leftDate = epoch.getDateOnly(false);
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                long tickMark = Math.round((double)range * 0.25) + left;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(true);
                }
                this.addXTick(tickLabel, tickMark);
                tickMark = midpt;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(true);
                }
                this.addXTick(tickLabel, tickMark);
                tickMark = Math.round((double)range * 0.75) + left;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(true);
                }
                this.addXTick(tickLabel, tickMark);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(true);
                    }
                    if (this.drawDates) {
                        rightDate = epoch.getDateOnly(false);
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                if (!this.drawDates) break;
                LabelAndPosition l = leftDate.equals(rightDate) ? new LabelAndPosition(leftDate, midpt) : new LabelAndPosition(String.valueOf(leftDate) + " - " + rightDate, midpt);
                this.dateLabels = new LabelAndPosition[1];
                this.dateLabels[0] = l;
                break;
            }
            case 2: 
            case 3: {
                String leftDate = "";
                String rightDate = "";
                long range = right - left;
                long midpt = Math.round((double)range * 0.5) + left;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        leftDate = epoch.getDateOnly(false);
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                long tickMark = Math.round((double)range * 0.25) + left;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(false);
                }
                this.addXTick(tickLabel, tickMark);
                tickMark = midpt;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(false);
                }
                this.addXTick(tickLabel, tickMark);
                tickMark = Math.round((double)range * 0.75) + left;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(false);
                }
                this.addXTick(tickLabel, tickMark);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        rightDate = epoch.getDateOnly(false);
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                if (!this.drawDates) break;
                LabelAndPosition l = leftDate.equals(rightDate) ? new LabelAndPosition(leftDate, midpt) : new LabelAndPosition(String.valueOf(leftDate) + " - " + rightDate, midpt);
                this.dateLabels = new LabelAndPosition[1];
                this.dateLabels[0] = l;
                break;
            }
            case 4: {
                LabelAndPosition l;
                String date;
                this.dateLabels = new LabelAndPosition[3];
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[0] = l = new LabelAndPosition(date, Math.round(this._xMin));
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                this.addXTick("", left + 21600L);
                long tickMark = left + 43200L;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(false);
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 21600L);
                tickMark = left + 86400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[1] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 21600L);
                tickMark += 43200L;
                if (this.drawTimes) {
                    epoch.setEpoch(tickMark * 1000L);
                    tickLabel = epoch.getTimeOnly(false);
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 21600L);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.getFontMetrics(this.getFont());
                        this.dateLabels[2] = l = new LabelAndPosition(date, Math.round(this._xMax));
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                break;
            }
            case 5: {
                LabelAndPosition l;
                String date;
                this.dateLabels = new LabelAndPosition[4];
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[0] = l = new LabelAndPosition(date, Math.round(this._xMin));
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                this.addXTick("", left + 43200L);
                long tickMark = left + 86400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[1] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 172800L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[2] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[3] = l = new LabelAndPosition(date, Math.round(this._xMax));
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                break;
            }
            case 6: {
                LabelAndPosition l;
                String date;
                this.dateLabels = new LabelAndPosition[5];
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[0] = l = new LabelAndPosition(date, Math.round(this._xMin));
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                this.addXTick("", left + 43200L);
                long tickMark = left + 86400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[1] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 172800L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[2] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 259200L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[3] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[4] = l = new LabelAndPosition(date, Math.round(this._xMax));
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                break;
            }
            case 7: {
                LabelAndPosition l;
                String date;
                this.dateLabels = new LabelAndPosition[6];
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[0] = l = new LabelAndPosition(date, Math.round(this._xMin));
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                this.addXTick("", left + 43200L);
                long tickMark = left + 86400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[1] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 172800L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[2] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 259200L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[3] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 345600L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[4] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[5] = l = new LabelAndPosition(date, Math.round(this._xMax));
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                break;
            }
            case 8: {
                LabelAndPosition l;
                String date;
                this.dateLabels = new LabelAndPosition[7];
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[0] = l = new LabelAndPosition(date, Math.round(this._xMin));
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                this.addXTick("", left + 43200L);
                long tickMark = left + 86400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[1] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 172800L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[2] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 259200L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[3] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 345600L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[4] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 432000L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[5] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[6] = l = new LabelAndPosition(date, Math.round(this._xMax));
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                break;
            }
            case 9: {
                LabelAndPosition l;
                String date;
                this.dateLabels = new LabelAndPosition[8];
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(left * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[0] = l = new LabelAndPosition(date, Math.round(this._xMin));
                    }
                }
                this.addXTick(tickLabel, this._xMin);
                this.addXTick("", left + 43200L);
                long tickMark = left + 86400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[1] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 172800L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[2] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 259200L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[3] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 345600L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[4] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 432000L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[5] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                tickMark = left + 518400L;
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(tickMark * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[6] = l = new LabelAndPosition(date, tickMark);
                    }
                }
                this.addXTick(tickLabel, tickMark);
                this.addXTick("", tickMark + 43200L);
                if (this.drawTimes || this.drawDates) {
                    epoch.setEpoch(right * 1000L);
                    if (this.drawTimes) {
                        tickLabel = epoch.getTimeOnly(false);
                    }
                    if (this.drawDates) {
                        date = epoch.getDateOnly(false);
                        this.dateLabels[7] = l = new LabelAndPosition(date, Math.round(this._xMax));
                    }
                }
                this.addXTick(tickLabel, this._xMax);
                break;
            }
            default: {
                EventLog.instance().log("ERROR: " + this.toString() + ": calculateTickMarks: Zoom factor is unknown");
            }
        }
    }

    protected ApplicationGenericMetaData createMetaData(short dataID, short dataset, String name, long left, long right) {
        ApplicationGenericMetaData meta = null;
        if (left < 970000000L) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: min x-range is too small: " + left);
        }
        try {
            meta = new ApplicationGenericMetaData();
            PrimitiveTypesWriter writer = meta.getPrimitiveTypesWriter();
            writer.write(dataID);
            writer.write(dataset);
            writer.write(this.session);
            writer.write(name);
            writer.write(left);
            writer.write(right);
            writer.write(this.resolution);
            meta.completedMetaDataInitialisation();
        }
        catch (IOException iOException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Creation of meta data failed!");
        }
        return meta;
    }

    public void doLeftSingleClickAction(MouseEvent e) {
        if (this.outOfContext || this.graphManagerInError || this.hasTrappedTransientError || this.hasTrappedPermanentError) {
            return;
        }
        Point p = e.getPoint();
        if (p.y >= this._uly && p.y <= this._lry && p.x >= this._ulx && p.x <= this._lrx) {
            if (p.x + 2 <= this._lrx) {
                p.x += 2;
            }
            long dataValue = this.translateP2D(p.x);
            MRSGraphManager.getInstance().moveCursor(dataValue);
        }
    }

    protected void drawCursor(Graphics g) {
        if ((double)this.cursorLocation >= this._xMin && (double)this.cursorLocation <= this._xMax) {
            Color previousColor = g.getColor();
            g.setColor(new Color(4565791));
            int yp = this._uly + 1;
            int xp = this.translateD2P(this.cursorLocation);
            if (xp == this._ulx) {
                g.fillRect(xp + 1, yp, 2, this._lry - this._uly - 1);
            } else if (xp == this._lrx) {
                g.fillRect(xp - 2, yp, 2, this._lry - this._uly - 1);
            } else {
                g.fillRect(xp - 1, yp, 3, this._lry - this._uly - 1);
            }
            g.setColor(previousColor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drawCursorLocationValues(Graphics g) {
        if (this.datasetAttributes == null) return;
        DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
        synchronized (this.datasetAttributes) {
            if (this.theMultiLineGraphSupport == null) {
                int xpos = this.getBounds().width / 2 + 65;
                int ypos = this._topPadding / 2 + 3;
                g.drawString(this.datasetAttributes[0].cursorValue, xpos, ypos);
            } else {
                int length = this.datasetAttributes.length;
                String[] s = new String[length];
                int i = 0;
                while (i < length) {
                    DatasetAttributes d = this.datasetAttributes[i];
                    int index = d.cursorValue.indexOf("y =");
                    s[i] = d.cursorValue.substring(index);
                    ++i;
                }
                this.theMultiLineGraphSupport.updateDatasetCursorValues(s);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void drawDates(Graphics g) {
        if (this.dateLabels != null) {
            g.setColor(this.getForeground());
            int yOffset = 15;
            if (this.drawTimes) {
                yOffset = 30;
            }
            int length = this.dateLabels.length;
            int i = 0;
            while (i < length) {
                int ypos = this._lry + yOffset;
                int xpos = this.translateD2P(this.dateLabels[i].position);
                String string = this.dateLabels[i].label;
                FontMetrics fm = this.getFontMetrics(g.getFont());
                int w = fm.stringWidth(string);
                if (xpos == this._lrx) {
                    g.drawString(string, xpos - w + this._rightPadding - 5, ypos);
                } else {
                    g.drawString(string, xpos - w / 2, ypos);
                }
                ++i;
            }
        }
    }

    protected void drawEndOfDataMarker(Graphics g) {
        if ((double)this.end > this._xMin && (double)this.end <= this._xMax) {
            Color previousColor = g.getColor();
            g.setColor(Color.black);
            int ypos = this._uly + 1;
            int xpos = this.translateD2P(this.eodMarkerLocation);
            if (xpos == 0) {
                g.fillRect(xpos + 1, ypos, 4, this._lry - this._uly - 1);
            } else if (xpos + 5 >= this._lrx) {
                int width = xpos + 5 - this._lrx - 1;
                g.fillRect(this._lrx - width, ypos, width, this._lry - this._uly - 1);
            } else {
                g.fillRect(xpos + 1, ypos, 5, this._lry - this._uly - 1);
            }
            g.setColor(previousColor);
        }
    }

    protected void drawGraphTitle(Graphics g) {
        if (this.datasetAttributes == null || this.datasetAttributes.length != 1) {
            return;
        }
        DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
        synchronized (this.datasetAttributes) {
            Font f = g.getFont();
            Font boldFont = new Font(f.getFamily(), 1, f.getSize());
            g.setFont(boldFont);
            int ypos = this._topPadding / 2 + 3;
            g.drawString(this.datasetAttributes[0].title, this._leftPadding, ypos);
            g.setFont(f);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void drawXTickMarks(Graphics graphics) {
        if (this._xticks == null || this._xticklabels == null) {
            return;
        }
        Enumeration nt = this._xticks.elements();
        Enumeration nl = this._xticklabels.elements();
        while (nl.hasMoreElements()) {
            String label = (String)nl.nextElement();
            double x = (Double)nt.nextElement();
            if (x > this._xMax || x < this._xMin) continue;
            int xpos = this.translateD2P(Math.round(x));
            FontMetrics fm = this.getFontMetrics(graphics.getFont());
            int labxpos = !nl.hasMoreElements() ? xpos - fm.stringWidth(label) + this._rightPadding - 5 : xpos - fm.stringWidth(label) / 2;
            graphics.drawString(label, labxpos, this._lry + fm.getHeight());
        }
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.setGraphManagerInError(false);
        String debugProperty = System.getProperty("graph.debug");
        if (debugProperty != null && debugProperty.equals("1")) {
            this.debug = true;
        }
        this._bottomPadding = this.drawDates && this.drawTimes ? 35 : (this.drawDates || this.drawTimes ? 20 : 5);
        this.calculateGraphAreaBounds();
        if (this.datasetAttributes == null) {
            this.datasetAttributes = new DatasetAttributes[1];
            this.datasetAttributes[0] = new DatasetAttributes(this.getGraph(), this.getGraphTitle(), "y = xxxxx.xxx");
        }
        if (!MRSGraphManager.getInstance().register(this)) {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: Registration with the Graph Manager failed!");
            this.permanentError();
        } else {
            ApplicationManager.instance().request("ISS", 0, this.databaseVariableName, (ApplicationObjectObserver)this);
        }
    }

    protected String formatDoubleToString(double value, int numDecimalPlaces) {
        String string = String.valueOf(value);
        int index = string.indexOf(".");
        if (index >= 0) {
            String exponentialString = "";
            String beforeDecimalString = "";
            String afterDecimalString = "";
            beforeDecimalString = string.substring(0, index);
            afterDecimalString = string.substring(index + 1);
            if ((index = afterDecimalString.indexOf("E")) >= 0) {
                exponentialString = afterDecimalString.substring(index);
                afterDecimalString = afterDecimalString.substring(0, index);
            }
            if (afterDecimalString.length() > numDecimalPlaces) {
                String firstUnwantedNumberString = afterDecimalString.substring(numDecimalPlaces, numDecimalPlaces + 1);
                afterDecimalString = afterDecimalString.substring(0, numDecimalPlaces);
                int firstUnwantedNum = Integer.valueOf(firstUnwantedNumberString);
                if (firstUnwantedNum > 4) {
                    char[] afterDecimalArray = afterDecimalString.toCharArray();
                    int i = afterDecimalArray.length - 1;
                    while (i >= 0) {
                        afterDecimalArray[i] = (char)(afterDecimalArray[i] + '\u0001');
                        if (afterDecimalArray[i] != ':') break;
                        afterDecimalArray[i] = 48;
                        --i;
                    }
                    afterDecimalString = String.valueOf(afterDecimalArray);
                    if (i < 0 && afterDecimalArray[0] == '0') {
                        int beforeDecimalNumber = Integer.valueOf(beforeDecimalString);
                        beforeDecimalString = String.valueOf(++beforeDecimalNumber);
                    }
                }
            }
            return String.valueOf(beforeDecimalString) + "." + afterDecimalString + " " + exponentialString;
        }
        return string;
    }

    public Component getComponent() {
        return this;
    }

    public String getDatabaseVariableName() {
        return this.databaseVariableName;
    }

    public boolean getDrawDates() {
        return this.drawDates;
    }

    public boolean getDrawTimes() {
        return this.drawTimes;
    }

    public String getGraph() {
        return this.datasetAttributes == null || this.datasetAttributes.length < 1 || this.datasetAttributes[0] == null ? this.graph : this.datasetAttributes[0].nameOnServer;
    }

    public String getGraphTitle() {
        return this.datasetAttributes == null || this.datasetAttributes.length < 1 || this.datasetAttributes[0] == null ? this.graphTitle : this.datasetAttributes[0].title;
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (MRSGraphComponent.theMainKeyController != null) break block2;
            c = this.getParent();
            if (c != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                c = c.getParent();
lbl6:
                // 2 sources

                ** while (c.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(c instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + c.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            MRSGraphComponent.theMainKeyController = (UnconsumedKeyHandler)c;
        }
        return MRSGraphComponent.theMainKeyController;
    }

    public Color getTransientErrorColor() {
        if (GraphDefaults.transientErrorColour == null) {
            return this.getBackground();
        }
        return GraphDefaults.transientErrorColour;
    }

    protected void initialize() {
        this.setBackground(GraphDefaults.background);
        this.setForeground(GraphDefaults.foreground);
        this.setGraphAreaColor(GraphDefaults.graphAreaColor);
        this.setFont(GraphDefaults.font);
        this._leftPadding = 75;
        this._rightPadding = 10;
        this._topPadding = 20;
        this._bottomPadding = 5;
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        if (this.hasTrappedPermanentError) {
            Rectangle bounds = this.getBounds();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, bounds.width, bounds.height);
        } else if (this.hasTrappedTransientError || this.graphManagerInError) {
            int width = this._lrx - this._ulx;
            int height = this._lry - this._uly;
            g.setColor(this.getGraphAreaColor());
            g.fillRect(this._ulx, this._uly, width, height);
            g.setColor(this.getForeground());
            g.drawRect(this._ulx, this._uly, width, height);
            String s1 = "No Data Available";
            FontMetrics fm = this.getFontMetrics(g.getFont());
            int w = fm.stringWidth(s1);
            int h = fm.getHeight();
            int x = width / 2 + this._ulx - w / 2;
            int y = height / 2 + this._uly + h / 2 - 1;
            g.setColor(Color.black);
            g.drawString(s1, x, y);
            g.setColor(this.getForeground());
            this.drawGraphTitle(g);
            if (this.drawTimes) {
                this.drawXTickMarks(g);
            }
            if (this.drawDates) {
                this.drawDates(g);
            }
        } else if (this.outOfContext) {
            int width = this._lrx - this._ulx;
            int height = this._lry - this._uly;
            g.setColor(this.getGraphAreaColor());
            g.fillRect(this._ulx, this._uly, width, height);
            g.setColor(this.getForeground());
            g.drawRect(this._ulx, this._uly, width, height);
            String s1 = "Out of Context";
            FontMetrics fm = this.getFontMetrics(g.getFont());
            int w = fm.stringWidth(s1);
            int h = fm.getHeight();
            int x = width / 2 + this._ulx - w / 2;
            int y = height / 2 + this._uly + h / 2 - 1;
            g.setColor(this.getGraphAreaColor().darker());
            g.drawString(s1, x, y);
            if (this.initializationState == 3) {
                if (this instanceof AlarmPlot) {
                    g.setColor(this.getBackground().darker());
                } else {
                    g.setColor(this.getForeground());
                }
                this.drawGraphTitle(g);
                g.setColor(this.getForeground());
                if (this.drawTimes) {
                    this.drawXTickMarks(g);
                }
                if (this.drawDates) {
                    this.drawDates(g);
                }
            }
        } else {
            super.paint(g);
            if (this.initializationState == 3) {
                this.drawEndOfDataMarker(g);
                this.drawCursor(g);
                g.setColor(this.getForeground());
                this.drawGraphTitle(g);
                this.drawCursorLocationValues(g);
                if (this.drawDates) {
                    this.drawDates(g);
                }
            }
        }
    }

    public void permanentError() {
        this.setBackground(GraphDefaults.permanentErrorColour);
        this.setForeground(GraphDefaults.permanentErrorColour);
        this.setGraphAreaColor(GraphDefaults.permanentErrorColour);
        this.setGridColor(GraphDefaults.permanentErrorColour);
        this.hasTrappedPermanentError = true;
        this.hasTrappedTransientError = false;
        this.setVisible(true);
        this.unregister();
    }

    protected abstract void plotData(int var1, int var2, long var3, float[] var5, boolean var6);

    public void processCursorUpdate(MRSGraphInfo info) {
        if (this.cursorLocation != info.cursorLocation) {
            this.setCursorLocation(info.cursorLocation);
            this.updateCursorLocationValues();
            this.repaint();
        }
    }

    public void processLiveUpdate(MRSGraphInfo info) {
        this.end = info.endOfData;
        if (this.end <= this.rangeRight && this.initializationState == 3 && this.maxXValueReceived > 0L) {
            if (this.end < this.maxXValueReceived + this.resolution) {
                this.processCursorUpdate(info);
            } else if (this.queryResponseState == 0) {
                if (this.end < this.maxXValueReceived + this.resolution || this.end - (this.maxXValueReceived + 1L) < 0L) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": processLiveUpdate: Invalid query parameters sent to server! min = " + (this.maxXValueReceived + 1L) + "; max = " + this.end + "; resolution = " + this.resolution);
                }
                this.setCursorLocation(info.cursorLocation);
                if (this.datasetAttributes != null) {
                    DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
                    synchronized (this.datasetAttributes) {
                        short i = 0;
                        while (i < this.datasetAttributes.length) {
                            ApplicationGenericMetaData meta = this.createMetaData((short)1, i, this.datasetAttributes[i].nameOnServer, this.maxXValueReceived + 1L, this.end);
                            this.sendQuery((ApplicationMetaData)meta, this.graphDataAO);
                            this.queryResponseState = (byte)(this.queryResponseState + 1);
                            i = (short)(i + 1);
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": processLiveUpdate: datasetAttributes is NULL!");
                }
            } else {
                this.processCursorUpdate(info);
            }
        }
    }

    public void processMajorGraphInfoChange(MRSGraphInfo info) {
        this.session = info.sessionName;
        this.rangeLeft = info.left;
        this.rangeRight = info.right;
        this.cursorLocation = info.cursorLocation;
        this.resolution = info.resolution;
        this.end = info.endOfData;
        this.zoomFactor = info.zoomFactor;
        this.live = info.live;
        if (this.session == null) {
            this.trapTransientError(true);
        } else {
            if (this.initializationState == 0 || this.initializationState == 2) {
                this.initializationState = (byte)(this.initializationState + 1);
            }
            if (this.initializationState == 3) {
                if (this.datasetAttributes != null) {
                    DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
                    synchronized (this.datasetAttributes) {
                        short i = 0;
                        while (i < this.datasetAttributes.length) {
                            ApplicationGenericMetaData meta = this.createMetaData((short)0, i, this.datasetAttributes[i].nameOnServer, this.rangeLeft, this.rangeRight);
                            this.sendQuery((ApplicationMetaData)meta, this.graphDataAO);
                            this.queryResponseState = (byte)(this.queryResponseState + 2);
                            i = (short)(i + 1);
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": processMajorGraphInfoChange: datasetAttributes is NULL!");
                }
            }
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData v, ApplicationDataSender s) {
        if (s == this.graphDataAO) {
            PrimitiveTypesReader reader = v.getPrimitiveTypesReader();
            if (reader == null) {
                this.trapTransientError(true);
            } else {
                try {
                    short dataID = reader.readShort();
                    short dataset = reader.readShort();
                    long start = reader.readLong();
                    int size = reader.readInt();
                    if (this.debug) {
                        EventLog.instance().log("*****");
                        EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: Data ID = " + dataID + "; Size = " + size);
                    }
                    if (dataID == 0 && dataset == 0) {
                        this.resetPlot();
                    }
                    if (size > 0) {
                        boolean errorBars = reader.readBoolean();
                        float[] data = new float[size];
                        int i = 0;
                        while (i < size) {
                            data[i] = reader.readFloat();
                            ++i;
                        }
                        this.plotData(dataID, dataset, start, data, errorBars);
                        this.trapTransientError(false);
                        this.outOfContext = false;
                    } else if (size == -1) {
                        this.outOfContext = true;
                        this.trapTransientError(false);
                    } else {
                        this.trapTransientError(true);
                        this.outOfContext = false;
                    }
                    if (dataID == 0) {
                        this.queryResponseState = (byte)(this.queryResponseState - 2);
                    } else if (dataID == 1) {
                        this.queryResponseState = (byte)(this.queryResponseState - 1);
                    }
                    if (this.debug) {
                        EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: Query response state = " + this.queryResponseState);
                    }
                    this.repaint();
                }
                catch (IOException iOException) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Received meaningless data for graphs");
                    this.trapTransientError(true);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetGraphParameters() {
        this.session = "";
        this.end = 0L;
        this.rangeLeft = 0L;
        this.rangeRight = 0L;
        this.cursorLocation = 0L;
        this.resolution = 0L;
        this.maxXValueReceived = 0L;
        this.zoomFactor = -1;
        this.live = false;
        this.initializationState = 0;
        this.queryResponseState = 0;
        this.outOfContext = false;
        if (this.datasetAttributes == null) return;
        DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
        synchronized (this.datasetAttributes) {
            int i = 0;
            while (i < this.datasetAttributes.length) {
                this.datasetAttributes[i].lastReceivedXValue = 0L;
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void resetPlot();

    protected void sendQuery(ApplicationMetaData meta, ApplicationObject AO) {
        if (meta != null && !this.graphManagerInError && this.initializationState == 3) {
            AO.asyncQuery(meta, (ApplicationObjectObserver)this);
        } else {
            this.trapTransientError(true);
        }
    }

    protected void setCursorLocation(long location) {
        this.cursorLocation = location;
        if (this.cursorLocation > this.eodMarkerLocation) {
            this.cursorLocation = this.eodMarkerLocation;
        }
    }

    public void setDatabaseVariableName(String name) {
        this.databaseVariableName = name;
    }

    public void setDrawDates(boolean flag) {
        this.drawDates = flag;
    }

    public void setDrawTimes(boolean flag) {
        this.drawTimes = flag;
    }

    public void setGraph(String g) {
        this.graph = g;
    }

    public void setGraphManagerInError(boolean inError) {
        if (this.graphManagerInError != inError) {
            this.graphManagerInError = inError;
            if (this.graphManagerInError && !this.isVisible()) {
                this.setVisible(true);
                this.repaint();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setGraphParameters(MRSGraphParameters[] params) {
        this.trapTransientError(true);
        if (params.length < 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": setParameters: Invalid parameters received");
            return;
        }
        this.resetGraphParameters();
        DatasetAttributes[] datasetAttributesArray = this.datasetAttributes = new DatasetAttributes[params.length];
        synchronized (this.datasetAttributes) {
            int i = 0;
            while (i < params.length) {
                DatasetAttributes d;
                this.datasetAttributes[i] = d = new DatasetAttributes(params[i].graphNameOnServer, params[i].graphTitle, "y = xxxxx.xxx");
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.setDrawDates(params[0].drawDates);
            this.setDrawTimes(params[0].drawTimes);
            if (this.theMultiLineGraphSupport == null) return;
            this.theMultiLineGraphSupport.setDatasetAttributes(this.datasetAttributes);
            return;
        }
    }

    public void setGraphTitle(String title) {
        this.graphTitle = title;
    }

    public void setMultiLineGraphSupport(MultipleLineGraphSupport newMultiLineGraphSupport) {
        if (this instanceof ContinuousPlot || this instanceof StepPlot) {
            this.theMultiLineGraphSupport = newMultiLineGraphSupport;
        }
    }

    public void switchToErrorMode(ApplicationObject anAppObj) {
    }

    public String toString() {
        if (this.datasetAttributes == null || this.datasetAttributes.length < 1) {
            return "Title = " + this.graphTitle + "; Name on server = " + this.graph + "; Parent = " + this.getParent().toString();
        }
        try {
            DatasetAttributes[] datasetAttributesArray = this.datasetAttributes;
            synchronized (this.datasetAttributes) {
                String title = "Title = " + this.datasetAttributes[0].title;
                String name = "Name on server = " + this.datasetAttributes[0].nameOnServer;
                int i = 1;
                while (i < this.datasetAttributes.length) {
                    title = String.valueOf(title) + "/" + this.datasetAttributes[i].title;
                    name = String.valueOf(name) + "/" + this.datasetAttributes[i].nameOnServer;
                    ++i;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return String.valueOf(title) + "; " + name + "; Parent = " + this.getParent().toString();
            }
        }
        catch (Exception e) {
            System.out.println("MRSGraphComponent: toString: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    protected int translateD2P(long dataPoint) {
        return (int)((long)this._ulx + (long)(this._lrx - this._ulx) * (dataPoint - Math.round(this._xMin)) / Math.round(this._xMax - this._xMin));
    }

    protected long translateP2D(int x) {
        return Math.round(this._xMin) + (long)(x - this._ulx) * Math.round(this._xMax - this._xMin) / (long)(this._lrx - this._ulx);
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            if (this.debug) {
                EventLog.instance().log("INFO: " + this.toString() + ": trapTransientError: Transient error = " + this.hasTrappedTransientError);
            }
            this.hasTrappedTransientError = isInError;
            this.repaint();
        }
    }

    public void unregister() {
        if (this.graphDataAO != null) {
            this.graphDataAO.unregister((ApplicationObjectObserver)this);
            this.graphDataAO = null;
        }
        MRSGraphManager.getInstance().unregister(this);
        this.resetGraphParameters();
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update: Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        }
    }

    public void update(MRSGraphInfo info) {
        if (this.initializationState != 3 || this.session != info.sessionName || this.rangeLeft != info.left || this.rangeRight != info.right || this.resolution != info.resolution || this.zoomFactor != info.zoomFactor || this.live != info.live) {
            this.processMajorGraphInfoChange(info);
        } else if (this.end != info.endOfData) {
            this.processLiveUpdate(info);
        } else if (this.cursorLocation != info.cursorLocation) {
            this.processCursorUpdate(info);
        } else if (this.debug) {
            EventLog.instance().log("DEBUG: " + this.toString() + ": update(GraphInfo): Received data from MRS Graph Manager identical to the last");
        }
    }

    protected abstract boolean updateCursorLocationValues();
}

