/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.common;

import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphManager;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import java.awt.Component;
import java.awt.event.KeyEvent;

public class MRSGraphEventHandler
extends ModalWindowHandler
implements UnconsumedKeyHandler {
    private MRSGraphWindow myGraphWindow = null;

    public void processUnconsumedKeyEvents(KeyEvent e, Component receiverComponent) {
        if (e.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)e)) {
                case 37: {
                    MRSGraphManager.getInstance().moveCursorLeft();
                    e.consume();
                    break;
                }
                case 39: {
                    MRSGraphManager.getInstance().moveCursorRight();
                    e.consume();
                    break;
                }
                case 2010: {
                    MRSGraphManager.getInstance().pageLeft();
                    e.consume();
                    break;
                }
                case 2013: {
                    MRSGraphManager.getInstance().pageRight();
                    e.consume();
                    break;
                }
                case 107: {
                    if (this.myGraphWindow != null) {
                        this.myGraphWindow.processMenuKey(e);
                    }
                    e.consume();
                    break;
                }
                case 27: {
                    this.removeModalWindow();
                    e.consume();
                    break;
                }
                case 10: 
                case 113: 
                case 119: {
                    e.consume();
                }
            }
        }
    }

    public void setWindow(InternalWindow w) {
        super.setWindow(w);
        if (w instanceof MRSGraphWindow) {
            this.myGraphWindow = (MRSGraphWindow)w;
        }
    }

    public String toString() {
        return "GraphEventHandler";
    }
}

