/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.common;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.mrsgraphs.common.Epoch;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphInfo;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSLatestSessionState;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphInfoDataReceiver;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.ZoomFactor;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.ListIterator;
import java.io.IOException;

public class MRSGraphManager
implements ZoomFactor,
CcConnectedComponent,
ApplicationGenericDataReceiver,
KnownLengthStringDataReceiver,
MaskedIntegerDataReceiver {
    private static MRSGraphManager instance = null;
    private List registeredReceivers = null;
    private MRSGraphInfo graphInfo = null;
    private final long uninitializedCursorValue = -99999L;
    private final int numDataPts = 60;
    private final String defaultSession = "LATEST";
    private final String sessionNameVariableName = "MRS_SESSION_SELECTED_NAME";
    private final String sessionInfoVariableName = "MRS_SESSION_INFO";
    private final String sessionEndTimeVariableName = "MRS_SESSION_END_TIME";
    private final String latestStateDBVariableName = "MRS_SESSION_LATEST_STATE";
    private ApplicationObject theSessionNameAO = null;
    private ApplicationObject theSessionInfoAO = null;
    private ApplicationObject theSessionEndTimeAO = null;
    private ApplicationObject theLatestStateAO = null;
    private transient MRSLatestSessionState latestSessionState = new MRSLatestSessionState();
    private boolean hasTrappedTransientError = false;
    private boolean hasTrappedPermanentError = false;
    private String session = null;
    private boolean live = false;
    private long start = 0L;
    private long end = 0L;
    private long rangeLeft = 0L;
    private long rangeRight = 0L;
    private long cursorLocation = -99999L;
    private long resolution = 0L;
    private int zoomFactor = -1;
    private boolean initialized = false;
    private boolean sessionNameAOIsInitialized = false;
    private boolean sessionNameReceived = false;
    private boolean sessionInfoAOIsInitialized = false;
    private boolean sessionInfoReceived = false;
    private boolean sessionEndTimeAOIsInitialized = false;
    private boolean sessionEndTimeReceived = false;
    private boolean latestStateAOIsInitialized = false;
    private boolean latestStateReceived = false;
    private boolean debug = false;

    private MRSGraphManager() {
        this.finishInitialise();
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals("MRS_SESSION_INFO")) {
            this.theSessionInfoAO = anAO;
            if (aReport.getErrorStatus() == 0) {
                this.sessionInfoAOIsInitialized = true;
            }
        } else if (anAO.getName().equals("MRS_SESSION_END_TIME")) {
            this.theSessionEndTimeAO = anAO;
            if (aReport.getErrorStatus() == 0) {
                this.sessionEndTimeAOIsInitialized = true;
            }
        } else if (anAO.getName().equals("MRS_SESSION_SELECTED_NAME")) {
            this.theSessionNameAO = anAO;
            if (aReport.getErrorStatus() == 0) {
                this.sessionNameAOIsInitialized = true;
            }
        } else if (anAO.getName().equals("MRS_SESSION_LATEST_STATE")) {
            this.theLatestStateAO = anAO;
            if (aReport.getErrorStatus() == 0) {
                this.latestStateAOIsInitialized = true;
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + anAO.toString());
        }
    }

    private void calculateResolution() {
        this.resolution = (this.rangeRight - this.rangeLeft) / 60L;
    }

    private void calculateZoom() {
        long zoomRange;
        long range = this.rangeRight - this.rangeLeft;
        if (range <= 60L) {
            this.zoomFactor = 0;
            zoomRange = 60L;
        } else if (range <= 3600L) {
            this.zoomFactor = 1;
            zoomRange = 3600L;
        } else if (range <= 43200L) {
            this.zoomFactor = 2;
            zoomRange = 43200L;
        } else if (range <= 86400L) {
            this.zoomFactor = 3;
            zoomRange = 86400L;
        } else if (range <= 172800L) {
            this.zoomFactor = 4;
            zoomRange = 172800L;
        } else if (range <= 259200L) {
            this.zoomFactor = 5;
            zoomRange = 259200L;
        } else if (range <= 345600L) {
            this.zoomFactor = 6;
            zoomRange = 345600L;
        } else if (range <= 432000L) {
            this.zoomFactor = 7;
            zoomRange = 432000L;
        } else if (range <= 518400L) {
            this.zoomFactor = 8;
            zoomRange = 518400L;
        } else if (range <= 604800L) {
            this.zoomFactor = 9;
            zoomRange = 604800L;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": calculateZoom: Given range is greater than 7 days (6048*10^5 seconds): " + range + " Defaulting to 7 days.");
            this.zoomFactor = 9;
            zoomRange = 604800L;
        }
        this.rangeRight = this.rangeLeft + zoomRange;
    }

    protected ApplicationGenericMetaData createMetaData() {
        ApplicationGenericMetaData meta = null;
        try {
            if (this.session != null) {
                meta = new ApplicationGenericMetaData();
                PrimitiveTypesWriter writer = meta.getPrimitiveTypesWriter();
                writer.write(this.session);
                meta.completedMetaDataInitialisation();
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Cannot create meta data with a null session!");
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Creation of meta data failed!");
        }
        return meta;
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        String debugProperty = System.getProperty("graph.debug");
        if (debugProperty != null && debugProperty.equals("1")) {
            this.debug = true;
        }
        ApplicationManager.instance().request("LOCAL", 0, "MRS_SESSION_SELECTED_NAME", (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, "MRS_SESSION_LATEST_STATE", (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, "MRS_SESSION_INFO", (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, "MRS_SESSION_END_TIME", (ApplicationObjectObserver)this);
    }

    public MRSGraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    public static synchronized MRSGraphManager getInstance() {
        if (instance == null) {
            instance = new MRSGraphManager();
            SingletonRegistry.instance().add((Object)instance);
        }
        return instance;
    }

    public long getRangeLeft() {
        return this.rangeLeft;
    }

    public long getRangeRight() {
        return this.rangeRight;
    }

    public String getSession() {
        return this.session;
    }

    public void getStoredParameters() {
    }

    public void gotoEnd() {
        long range = this.rangeRight - this.rangeLeft;
        if (this.rangeRight < this.end && this.rangeRight - range >= this.start) {
            this.rangeRight = this.end;
            this.rangeLeft = this.rangeRight - range;
            this.cursorLocation = this.rangeLeft + range / 2L;
            if (this.cursorLocation > this.end) {
                this.cursorLocation = this.start;
            }
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    public void gotoStart() {
        if (this.rangeLeft > this.start) {
            long range = this.rangeRight - this.rangeLeft;
            this.rangeLeft = this.start;
            this.rangeRight = this.rangeLeft + range;
            this.cursorLocation = this.rangeLeft + range / 2L;
            if (this.cursorLocation > this.end) {
                this.cursorLocation = this.start;
            }
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    public void moveCursor(long dataValue) {
        if (dataValue >= this.start && dataValue <= this.end && this.cursorLocation != dataValue) {
            this.cursorLocation = dataValue;
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    public void moveCursorLeft() {
        long temp = this.cursorLocation;
        this.cursorLocation -= this.resolution;
        if (this.cursorLocation < this.start) {
            this.cursorLocation = this.start;
        }
        if (this.cursorLocation != temp) {
            if (this.cursorLocation < this.rangeLeft) {
                this.shiftRangeLeft();
            }
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    public void moveCursorRight() {
        long temp = this.cursorLocation;
        this.cursorLocation += this.resolution;
        if (this.cursorLocation > this.end) {
            this.cursorLocation = this.end;
        }
        if (this.cursorLocation != temp) {
            if (this.cursorLocation > this.rangeRight) {
                this.shiftRangeRight();
            }
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    private void notifyRegisteredReceivers() {
        if (this.registeredReceivers != null && this.registeredReceivers.size() > 0) {
            List list = this.registeredReceivers;
            synchronized (list) {
                ListIterator list2 = this.registeredReceivers.listIterator();
                while (list2.hasNext()) {
                    ((MRSGraphInfoDataReceiver)list2.next()).update(this.graphInfo);
                }
            }
        }
    }

    public void pageLeft() {
        long temp = this.cursorLocation;
        this.cursorLocation -= this.resolution * 60L;
        if (this.cursorLocation < this.start) {
            this.cursorLocation = this.start;
        }
        if (this.cursorLocation != temp) {
            long range = this.rangeRight - this.rangeLeft;
            long min = Math.round((double)this.cursorLocation - (double)range / 2.0);
            this.rangeLeft = min < this.start ? this.start : min;
            this.rangeRight = this.rangeLeft + range;
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    public void pageRight() {
        long temp = this.cursorLocation;
        this.cursorLocation += this.resolution * 60L;
        if (this.cursorLocation > this.end) {
            this.cursorLocation = this.end;
        }
        if (this.cursorLocation != temp) {
            long range = this.rangeRight - this.rangeLeft;
            long max = Math.round((double)this.cursorLocation + (double)range / 2.0);
            this.rangeRight = max > this.end ? this.end : max;
            this.rangeLeft = this.rangeRight - range;
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    private void permanentError() {
        EventLog.instance().log("ERROR: GraphManager: permanentError: Permanent error occured, graphs will be unusable");
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = true;
        this.unregister();
        if (this.registeredReceivers != null && this.registeredReceivers.size() > 0) {
            List list = this.registeredReceivers;
            synchronized (list) {
                ArrayList list2 = new ArrayList((Collection)this.registeredReceivers);
                ListIterator i = list2.listIterator();
                while (i.hasNext()) {
                    ((MRSGraphInfoDataReceiver)i.next()).permanentError();
                }
            }
        }
    }

    public void printRegisteredReceivers() {
        String time = new Epoch(System.currentTimeMillis()).getDateAndTime(true, true);
        System.out.println("\n" + time + " " + this.toString() + " registered graph list:");
        if (this.registeredReceivers != null && this.registeredReceivers.size() > 0) {
            List list = this.registeredReceivers;
            synchronized (list) {
                ListIterator list2 = this.registeredReceivers.listIterator();
                while (list2.hasNext()) {
                    System.out.println(list2.next().toString());
                }
            }
        }
    }

    private void recalculateCursorLocation() {
        if (this.resolution < 1L) {
            EventLog.instance().log("ERROR:" + this.toString() + ": recalculateCursorLocation: Resolution is less than 1!");
            return;
        }
        if (this.cursorLocation < this.rangeLeft || this.cursorLocation > this.rangeRight) {
            this.cursorLocation = (long)Math.round((this.rangeRight - this.rangeLeft) / 2L) + this.rangeLeft;
            if (this.cursorLocation > this.end) {
                this.cursorLocation = this.end;
            }
        }
        long x = this.rangeLeft;
        while (x <= this.cursorLocation) {
            x += this.resolution;
        }
        this.cursorLocation = this.cursorLocation - (x - this.resolution) < x - this.cursorLocation ? x - this.resolution : x;
        if (this.cursorLocation < this.rangeLeft) {
            this.cursorLocation = this.rangeLeft;
        }
        if (this.cursorLocation > this.rangeRight) {
            this.cursorLocation = this.rangeRight;
        }
        if (this.cursorLocation < this.start) {
            this.cursorLocation = this.start;
        }
        if (this.cursorLocation > this.end) {
            this.cursorLocation = this.end;
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData v, ApplicationDataSender s) {
        PrimitiveTypesReader reader = v.getPrimitiveTypesReader();
        if (reader == null) {
            this.trapTransientError(true);
        } else {
            long sessionEnd;
            block28: {
                sessionEnd = 0L;
                if (s == this.theSessionEndTimeAO) {
                    try {
                        String sessionName = reader.readString();
                        if (!sessionName.equals(this.session)) break block28;
                        sessionEnd = reader.readLong();
                        if (sessionEnd == 0L) {
                            EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Session " + this.session + " is currently invalid.");
                            this.trapTransientError(true);
                            if (this.registeredReceivers != null && this.registeredReceivers.size() > 0) {
                                List list = this.registeredReceivers;
                                synchronized (list) {
                                    ArrayList list2 = new ArrayList((Collection)this.registeredReceivers);
                                    ListIterator i = list2.listIterator();
                                    while (i.hasNext()) {
                                        ((MRSGraphInfoDataReceiver)i.next()).setGraphManagerInError(true);
                                    }
                                }
                            }
                            return;
                        }
                        this.sessionEndTimeReceived = true;
                        if (this.debug) {
                            EventLog.instance().log("*****");
                            EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: session end time successfully received");
                            EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: session = " + this.session + "; end time = " + sessionEnd);
                        }
                    }
                    catch (IOException iOException) {
                        EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Received meaningless data from " + s.toString());
                        this.trapTransientError(true);
                        this.sessionEndTimeReceived = false;
                    }
                } else if (s == this.theSessionInfoAO) {
                    try {
                        String sessionName = reader.readString();
                        if (!sessionName.equals(this.session)) break block28;
                        this.live = reader.readBoolean();
                        long sessionStart = reader.readLong();
                        sessionEnd = reader.readLong();
                        if (sessionStart == 0L && sessionEnd == 0L) {
                            EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Session " + this.session + " is currently invalid.");
                            this.trapTransientError(true);
                            if (this.registeredReceivers != null && this.registeredReceivers.size() > 0) {
                                List list = this.registeredReceivers;
                                synchronized (list) {
                                    ArrayList list3 = new ArrayList((Collection)this.registeredReceivers);
                                    ListIterator i = list3.listIterator();
                                    while (i.hasNext()) {
                                        ((MRSGraphInfoDataReceiver)i.next()).setGraphManagerInError(true);
                                    }
                                }
                            }
                            return;
                        }
                        if (this.start != sessionStart) {
                            this.start = sessionStart;
                            this.initialized = false;
                        }
                        this.sessionInfoReceived = true;
                        this.sessionEndTimeReceived = true;
                        if (this.debug) {
                            EventLog.instance().log("*****");
                            EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: session info successfully received");
                            EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: session = " + this.session + "; live = " + this.live + "; start time = " + sessionStart + "; end time = " + sessionEnd);
                        }
                    }
                    catch (IOException iOException) {
                        EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Received meaningless data from " + s.toString());
                        this.trapTransientError(true);
                        this.sessionInfoReceived = false;
                    }
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Unhandled data received from " + s.toString());
                }
            }
            if (this.end != sessionEnd) {
                if (this.initialized && this.live && sessionEnd > this.rangeRight && this.end >= this.rangeLeft && this.end <= this.rangeRight) {
                    this.shiftRangeRight();
                    this.cursorLocation = sessionEnd;
                    this.recalculateCursorLocation();
                }
                this.end = sessionEnd;
            }
            if (this.debug) {
                EventLog.instance().log("DEBUG: " + this.toString() + ": receiveApplicationGenericData: calling update()");
            }
            this.update();
        }
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue v, ApplicationDataSender s) {
        if (s == this.theSessionNameAO) {
            if (v != null) {
                String name;
                if (this.debug) {
                    EventLog.instance().log("INFO: " + this.toString() + ": receiveKnownLengthStringData: received value = " + v.getValue());
                }
                if ((name = v.getValue()) != null) {
                    if (!name.equals(this.session)) {
                        this.resetParameters();
                        this.trapTransientError(true);
                        this.session = name;
                        this.sessionNameReceived = true;
                        if (this.sessionInfoAOIsInitialized) {
                            if (this.debug) {
                                EventLog.instance().log("*****");
                                EventLog.instance().log("DEBUG: " + this.toString() + ": receiveKnownLengthStringData: sending query for session info.");
                            }
                            this.sendQuery(this.theSessionInfoAO);
                        }
                    }
                } else if (this.latestSessionState.getState() != -1 && this.latestSessionState.getState() != -2) {
                    EventLog.instance().log("INFO: " + this.toString() + ": receiveKnownLengthStringData: No session selected. Defaulting to the latest session.");
                    this.setSession("LATEST");
                } else if (this.latestStateReceived) {
                    this.resetParameters();
                    this.trapTransientError(true);
                    this.initialized = true;
                    this.sessionNameReceived = true;
                    this.update();
                    EventLog.instance().log("WARNING: " + this.toString() + ": receiveKnownLengthStringData: No session selected and LATEST session does not exist or its state is unknown. Graphs will be unviewable.");
                }
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": receiveKnownLengthStringData: The impossible happened: null data was received.");
                this.permanentError();
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveKnownLengthStringData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (s == this.theLatestStateAO) {
            int value = v.getValue();
            if (value != this.latestSessionState.getState()) {
                if (value >= -1 && value <= 1) {
                    this.latestSessionState.setState(value);
                    switch (value) {
                        case 0: {
                            if (this.theSessionNameAO.change((ApplicationData)new KnownLengthStringValue(new String("LATEST")))) break;
                            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Server refused to set the selected session to the default session");
                            break;
                        }
                        case -1: {
                            if (this.session == null || !this.session.equals("LATEST")) break;
                            this.setSession(null);
                            break;
                        }
                        case 1: {
                            if (this.session != null) break;
                            this.setSession("LATEST");
                            break;
                        }
                        default: {
                            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Unhandled value of " + value + " received; Check FIRST and LAST in MRSLatestSessionState class.");
                        }
                    }
                    if (this.debug) {
                        EventLog.instance().log("DEBUG: " + this.toString() + ": receiveMaskedIntegerData: received latest state; value = " + this.latestSessionState.getState());
                    }
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Invalid data received for the latest session state.");
                }
            }
            this.latestStateReceived = true;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public boolean register(MRSGraphInfoDataReceiver receiver) {
        if (this.hasTrappedPermanentError) {
            return false;
        }
        if (this.registeredReceivers == null) {
            this.registeredReceivers = Collections.synchronizedList((List)new ArrayList());
        }
        List list = this.registeredReceivers;
        synchronized (list) {
            this.registeredReceivers.add((Object)receiver);
        }
        if (this.initialized) {
            receiver.update(this.graphInfo);
        }
        return true;
    }

    private void resetGraphInfo(boolean calculateResolution) {
        if (this.live) {
            this.rangeRight = this.end + 30L;
            this.rangeLeft = this.rangeRight - 60L;
            if (this.rangeLeft < this.start) {
                this.rangeLeft = this.start;
                this.rangeRight = this.rangeLeft + 60L;
            }
        } else {
            this.rangeLeft = this.start;
            this.rangeRight = this.end;
        }
        this.calculateZoom();
        if (calculateResolution) {
            this.calculateResolution();
        }
        this.recalculateCursorLocation();
        this.updateGraphInfo();
        this.initialized = true;
    }

    private void resetParameters() {
        this.initialized = false;
        this.sessionInfoReceived = false;
        this.sessionEndTimeReceived = false;
        this.session = null;
        this.live = false;
        this.start = 0L;
        this.end = 0L;
        this.rangeLeft = 0L;
        this.rangeRight = 0L;
        this.cursorLocation = -99999L;
        this.resolution = 0L;
        this.zoomFactor = -1;
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = false;
    }

    private void sendQuery(ApplicationObject AO) {
        ApplicationGenericMetaData meta = this.createMetaData();
        if (meta != null) {
            AO.asyncQuery((ApplicationMetaData)meta, (ApplicationObjectObserver)this);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": sendQuery: Unable to create meta data! Query for AO " + AO.toString() + " failed.");
        }
    }

    private boolean setSession(String newSession) {
        boolean changeRequestStatus = false;
        if (newSession != null && newSession.equals(this.session)) {
            changeRequestStatus = true;
        } else {
            changeRequestStatus = this.theSessionNameAO.change((ApplicationData)new KnownLengthStringValue(newSession));
            if (!changeRequestStatus) {
                EventLog.instance().log("ERROR: " + this.toString() + ": setSession: Server refused to set the selected session to " + newSession);
            }
        }
        return changeRequestStatus;
    }

    private void shiftRangeLeft() {
        long range = this.rangeRight - this.rangeLeft;
        long min = Math.round((double)this.rangeLeft - (double)range / 2.0);
        this.rangeLeft = min < this.start ? this.start : min;
        this.rangeRight = this.rangeLeft + range;
    }

    private void shiftRangeRight() {
        long range = this.rangeRight - this.rangeLeft;
        long max = Math.round((double)this.rangeRight + (double)range / 2.0);
        this.rangeRight = !this.live && max > this.end ? this.end : max;
        this.rangeLeft = this.rangeRight - range;
    }

    public String toString() {
        return "MRSGraphManager";
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            if (this.debug) {
                EventLog.instance().log("INFO: " + this.toString() + ": trapTransientError: Transient error = " + this.hasTrappedTransientError);
            }
            this.hasTrappedTransientError = isInError;
            if (!this.hasTrappedTransientError && this.registeredReceivers != null && this.registeredReceivers.size() > 0) {
                List list = this.registeredReceivers;
                synchronized (list) {
                    ArrayList list2 = new ArrayList((Collection)this.registeredReceivers);
                    ListIterator i = list2.listIterator();
                    while (i.hasNext()) {
                        ((MRSGraphInfoDataReceiver)i.next()).setGraphManagerInError(false);
                    }
                }
            }
        }
    }

    public void unregister() {
    }

    public void unregister(MRSGraphInfoDataReceiver receiver) {
        if (this.registeredReceivers == null) {
            return;
        }
        List list = this.registeredReceivers;
        synchronized (list) {
            this.registeredReceivers.remove((Object)receiver);
        }
    }

    private void update() {
        if (this.sessionInfoReceived && this.sessionEndTimeReceived && this.sessionNameReceived && this.latestStateReceived) {
            this.trapTransientError(false);
        }
        if (!this.hasTrappedTransientError) {
            if (!this.initialized) {
                if (this.debug) {
                    EventLog.instance().log("DEBUG: " + this.toString() + ": update(): resetting graph info");
                }
                this.resetGraphInfo(true);
            } else {
                if (this.debug) {
                    EventLog.instance().log("DEBUG: " + this.toString() + ": update(): updating graph info");
                }
                this.updateGraphInfo();
            }
        }
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update(v,o): Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        } else if (o == this.theSessionEndTimeAO) {
            if (this.debug) {
                EventLog.instance().log("*****");
                EventLog.instance().log("DEBUG: " + this.toString() + ": update(v,o): anonymous update for theSessionEndTimeAO");
            }
            if (this.sessionEndTimeAOIsInitialized && this.sessionNameReceived) {
                if (this.debug) {
                    EventLog.instance().log("DEBUG: " + this.toString() + ": update(v,o): sending query for session end time.");
                }
                this.sendQuery(this.theSessionEndTimeAO);
            }
        } else if (o == this.theSessionInfoAO) {
            if (this.debug) {
                EventLog.instance().log("*****");
                EventLog.instance().log("DEBUG: " + this.toString() + ": update(v,o): anonymous update for theSessionInfoAO");
            }
            if (this.sessionInfoAOIsInitialized && this.sessionNameReceived) {
                if (this.debug) {
                    EventLog.instance().log("DEBUG: " + this.toString() + ": update(v,o): sending query for session info.");
                }
                this.sendQuery(this.theSessionInfoAO);
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": update(v,o): Unknown AO: " + o.toString());
        }
    }

    private void updateGraphInfo() {
        this.graphInfo = new MRSGraphInfo(this.start, this.end, this.rangeLeft, this.rangeRight, this.cursorLocation, this.resolution, this.zoomFactor, this.session, this.live);
        this.notifyRegisteredReceivers();
    }

    public void zoom(int factor) {
        long range = 0L;
        switch (factor) {
            case 0: {
                range = 60L;
                break;
            }
            case 1: {
                range = 3600L;
                break;
            }
            case 2: {
                range = 43200L;
                break;
            }
            case 3: {
                range = 86400L;
                break;
            }
            case 4: {
                range = 172800L;
                break;
            }
            case 5: {
                range = 259200L;
                break;
            }
            case 6: {
                range = 345600L;
                break;
            }
            case 7: {
                range = 432000L;
                break;
            }
            case 8: {
                range = 518400L;
                break;
            }
            case 9: {
                range = 604800L;
                break;
            }
            default: {
                EventLog.instance().log("ERROR: " + this.toString() + ": zoom: Unmatched zoom factor");
                return;
            }
        }
        this.zoomFactor = factor;
        this.rangeLeft = this.cursorLocation - range / 2L;
        this.rangeRight = this.cursorLocation + range / 2L;
        if (this.rangeLeft < this.start) {
            this.rangeLeft = this.start;
            this.rangeRight = this.rangeLeft + range;
        } else if (!this.live && this.rangeRight > this.end) {
            this.rangeRight = this.end;
            this.rangeLeft = this.rangeRight - range;
            if (this.rangeLeft < this.start) {
                this.rangeLeft = this.start;
                this.rangeRight = this.rangeLeft + range;
            }
        }
        this.calculateResolution();
        this.recalculateCursorLocation();
        this.updateGraphInfo();
    }

    public void zoomIn() {
        if (this.zoomFactor > 0) {
            --this.zoomFactor;
            long range = 0L;
            switch (this.zoomFactor) {
                case 0: {
                    range = 60L;
                    break;
                }
                case 1: {
                    range = 3600L;
                    break;
                }
                case 2: {
                    range = 43200L;
                    break;
                }
                case 3: {
                    range = 86400L;
                    break;
                }
                case 4: {
                    range = 172800L;
                    break;
                }
                case 5: {
                    range = 259200L;
                    break;
                }
                case 6: {
                    range = 345600L;
                    break;
                }
                case 7: {
                    range = 432000L;
                    break;
                }
                case 8: {
                    range = 518400L;
                    break;
                }
                case 9: {
                    EventLog.instance().log("ERROR? " + this.toString() + ": zoomIn: Zooming in changed the zoom factor to 7 days");
                    range = 604800L;
                    break;
                }
                default: {
                    EventLog.instance().log("ERROR: " + this.toString() + ": zoomIn: Unmatched zoom factor");
                }
            }
            this.rangeLeft = this.cursorLocation - range / 2L;
            this.rangeRight = this.cursorLocation + range / 2L;
            if (this.rangeLeft < this.start) {
                this.rangeLeft = this.start;
                this.rangeRight = this.rangeLeft + range;
            } else if (!this.live && this.rangeRight > this.end) {
                this.rangeRight = this.end;
                this.rangeLeft = this.rangeRight - range;
                if (this.rangeLeft < this.start) {
                    this.rangeLeft = this.start;
                    this.rangeRight = this.rangeLeft + range;
                }
            }
            this.calculateResolution();
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }

    public void zoomOut() {
        if (this.zoomFactor < 9) {
            ++this.zoomFactor;
            long range = 0L;
            switch (this.zoomFactor) {
                case 0: {
                    EventLog.instance().log("ERROR? " + this.toString() + ": zoomOut: Zooming out changed the zoom factor to 1 minute");
                    range = 60L;
                    break;
                }
                case 1: {
                    range = 3600L;
                    break;
                }
                case 2: {
                    range = 43200L;
                    break;
                }
                case 3: {
                    range = 86400L;
                    break;
                }
                case 4: {
                    range = 172800L;
                    break;
                }
                case 5: {
                    range = 259200L;
                    break;
                }
                case 6: {
                    range = 345600L;
                    break;
                }
                case 7: {
                    range = 432000L;
                    break;
                }
                case 8: {
                    range = 518400L;
                    break;
                }
                case 9: {
                    range = 604800L;
                    break;
                }
                default: {
                    EventLog.instance().log("ERROR: " + this.toString() + ": zoomOut: Unmatched zoom factor");
                }
            }
            this.rangeLeft = this.cursorLocation - range / 2L;
            this.rangeRight = this.cursorLocation + range / 2L;
            if (this.rangeLeft < this.start) {
                this.rangeLeft = this.start;
                this.rangeRight = this.rangeLeft + range;
            } else if (!this.live && this.rangeRight > this.end) {
                this.rangeRight = this.end;
                this.rangeLeft = this.rangeRight - range;
                if (this.rangeLeft < this.start) {
                    this.rangeLeft = this.start;
                    this.rangeRight = this.rangeLeft + range;
                }
            }
            this.calculateResolution();
            this.recalculateCursorLocation();
            this.updateGraphInfo();
        }
    }
}

