/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.common;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSLatestSessionState;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButton;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTable;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionEvent;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionListener;

public class MRSSessionWindowManager
implements MaskedIntegerDataReceiver,
KnownLengthStringDataReceiver,
CcConnectedComponent,
RowSelectionListener {
    private final String defaultSession = "LATEST";
    private final transient String agentDBVariableName = "MRS_SESSION_AGENT";
    private transient ApplicationObject agentAO = null;
    private final transient String selectedSessionDBVariableName = "MRS_SESSION_SELECTED_NAME";
    private transient ApplicationObject selectedSessionAO = null;
    private transient KnownLengthStringValue selectedSession = null;
    private transient EclButton renameStoredSessionButton = null;
    private transient EclButton deleteStoredSessionButton = null;
    private transient EclButton viewInfoStoredSessionButton = null;
    private transient EclButton viewStoredSessionButton = null;
    private transient EclTable storedSessionTable = null;
    private transient int selectedIndex = -1;
    private final transient String latestStateDBVariableName = "MRS_SESSION_LATEST_STATE";
    private transient ApplicationObject latestStateAO = null;
    private transient MRSLatestSessionState latestSessionState = new MRSLatestSessionState();
    private transient EclButton storeLatestSessionButton = null;
    private transient EclButton viewLatestSessionButton = null;
    private transient boolean hasTrappedTransientError = false;
    private transient boolean hasTrappedPermanentError = false;
    private transient boolean debug = false;

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals("MRS_SESSION_AGENT")) {
            this.agentAO = anAO;
        } else if (anAO.getName().equals("MRS_SESSION_SELECTED_NAME")) {
            this.selectedSessionAO = anAO;
        } else if (anAO.getName().equals("MRS_SESSION_LATEST_STATE")) {
            this.latestStateAO = anAO;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + anAO.toString());
        }
    }

    public void finishInitialise() {
        String debugProperty = System.getProperty("graph.debug");
        if (debugProperty != null && debugProperty.equals("1")) {
            this.debug = true;
        }
        if (this.storedSessionTable != null) {
            this.storedSessionTable.addRowSelectionListener((RowSelectionListener)this);
        }
        ApplicationManager.instance().request("ISS", 0, "MRS_SESSION_AGENT", (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, "MRS_SESSION_LATEST_STATE", (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("LOCAL", 0, "MRS_SESSION_SELECTED_NAME", (ApplicationObjectObserver)this);
        this.updateStoredSessionButtons();
    }

    public ApplicationObject getAgentAO() {
        if (this.agentAO.getInitialisationState() == 2) {
            return this.agentAO;
        }
        return null;
    }

    public boolean isInError() {
        return this.hasTrappedPermanentError;
    }

    private void permanentError() {
        EventLog.instance().log("ERROR: " + this.toString() + ": permanentError: Permanent error occured, dialogs will be unusable");
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = true;
        this.unregister();
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue v, ApplicationDataSender s) {
        if (s == this.selectedSessionAO) {
            if (this.debug) {
                EventLog.instance().log("INFO: " + this.toString() + ": receiveKnownLengthStringData: received value = " + v.getValue());
            }
            if (!v.equals(this.selectedSession)) {
                this.selectedSession = v;
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveKnownLengthStringData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (s == this.latestStateAO) {
            int value = v.getValue();
            if (value != this.latestSessionState.getState()) {
                if (value >= -1 && value <= 1) {
                    this.latestSessionState.setState(value);
                    switch (value) {
                        case -1: {
                            if (this.storeLatestSessionButton != null) {
                                this.storeLatestSessionButton.setGreying(true, true);
                            }
                            if (this.viewLatestSessionButton != null) {
                                this.viewLatestSessionButton.setGreying(true, true);
                            }
                            this.updateStoredSessionButtons();
                            break;
                        }
                        case 0: {
                            if (this.storeLatestSessionButton != null) {
                                this.storeLatestSessionButton.setGreying(true, true);
                            }
                            if (this.viewLatestSessionButton != null) {
                                this.viewLatestSessionButton.setGreying(false, true);
                            }
                            this.updateStoredSessionButtons();
                            break;
                        }
                        case 1: {
                            if (this.storeLatestSessionButton != null) {
                                this.storeLatestSessionButton.setGreying(false, true);
                            }
                            if (this.viewLatestSessionButton != null) {
                                this.viewLatestSessionButton.setGreying(false, true);
                            }
                            this.updateStoredSessionButtons();
                            break;
                        }
                        default: {
                            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Unhandled value of " + value + " received; Check FIRST and LAST in MRSLatestSessionState class.");
                            break;
                        }
                    }
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Invalid data received for the latest session state.");
                }
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void selectRow(RowSelectionEvent e) {
        int index = this.storedSessionTable.getSelectedIndex();
        if (this.selectedIndex != index) {
            this.selectedIndex = index;
            this.updateStoredSessionButtons();
        }
    }

    public boolean sendApplicationGenericData(ApplicationData data) {
        boolean valueChanged = false;
        if (data != null) {
            if (this.agentAO.change(data)) {
                valueChanged = true;
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": sendApplicationGenericData: Server refused change request for session agent AO");
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": sendApplicationGenericData: Received null data! Change request NOT sent.");
        }
        return valueChanged;
    }

    public boolean sendKnownLengthStringData(ApplicationData data) {
        boolean valueChanged = false;
        if (this.selectedSessionAO.change(data)) {
            valueChanged = true;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": sendKnownLengthStringData: Server refused change request for selected session AO");
        }
        return valueChanged;
    }

    public void setDeleteStoredSessionButton(EclButton b) {
        this.deleteStoredSessionButton = b;
    }

    public void setRenameStoredSessionButton(EclButton b) {
        this.renameStoredSessionButton = b;
    }

    public void setStoredSessionTable(EclTable t) {
        this.storedSessionTable = t;
    }

    public void setStoreLatestSessionButton(EclButton b) {
        this.storeLatestSessionButton = b;
    }

    public void setViewInfoStoredSessionButton(EclButton b) {
        this.viewInfoStoredSessionButton = b;
    }

    public void setViewLatestSessionButton(EclButton b) {
        this.viewLatestSessionButton = b;
    }

    public void setViewStoredSessionButton(EclButton b) {
        this.viewStoredSessionButton = b;
    }

    public String toString() {
        return "MRSSessionWindowManager";
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            this.hasTrappedTransientError = isInError;
        }
    }

    public void unregister() {
        if (this.agentAO != null) {
            this.agentAO.unregister((ApplicationObjectObserver)this);
            this.agentAO = null;
        }
        if (this.latestStateAO != null) {
            this.latestStateAO.unregister((ApplicationObjectObserver)this);
            this.latestStateAO = null;
        }
        if (this.selectedSessionAO != null) {
            this.selectedSessionAO.unregister((ApplicationObjectObserver)this);
            this.selectedSessionAO = null;
        }
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (o != this.agentAO) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update(v,o): Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        }
    }

    public void updateStoredSessionButtons() {
        if (this.latestSessionState.getState() == 0) {
            if (this.renameStoredSessionButton != null) {
                this.renameStoredSessionButton.setGreying(true, true);
            }
            if (this.viewInfoStoredSessionButton != null) {
                this.viewInfoStoredSessionButton.setGreying(true, true);
            }
            if (this.viewStoredSessionButton != null) {
                this.viewStoredSessionButton.setGreying(true, true);
            }
            if (this.deleteStoredSessionButton != null) {
                this.deleteStoredSessionButton.setGreying(true, true);
            }
        } else if (this.selectedIndex < 0) {
            if (this.renameStoredSessionButton != null) {
                this.renameStoredSessionButton.setGreying(true, true);
            }
            if (this.viewInfoStoredSessionButton != null) {
                this.viewInfoStoredSessionButton.setGreying(true, true);
            }
            if (this.viewStoredSessionButton != null) {
                this.viewStoredSessionButton.setGreying(true, true);
            }
            if (this.latestSessionState.getState() == -1) {
                if (this.deleteStoredSessionButton != null) {
                    this.deleteStoredSessionButton.setGreying(true, true);
                }
            } else if (this.deleteStoredSessionButton != null) {
                this.deleteStoredSessionButton.setGreying(false, true);
            }
        } else {
            if (this.deleteStoredSessionButton != null) {
                this.deleteStoredSessionButton.setGreying(false, true);
            }
            if (this.renameStoredSessionButton != null) {
                this.renameStoredSessionButton.setGreying(false, true);
            }
            if (this.viewInfoStoredSessionButton != null) {
                this.viewInfoStoredSessionButton.setGreying(false, true);
            }
            if (this.viewStoredSessionButton != null) {
                this.viewStoredSessionButton.setGreying(false, true);
            }
        }
    }
}

