/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.common;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSLatestSessionState;
import com.sun.java.util.collections.ArrayList;

public class MRSStateMonitor
implements CcConnectedComponent,
MaskedIntegerDataReceiver {
    private MRSLatestSessionState latestSessionState = new MRSLatestSessionState();
    private ApplicationObject theLatestStateAO = null;
    private ArrayList latestStateDataReceivers = null;
    public static final int DOUBLE_VIEW_MODE = 0;
    public static final int SINGLE_VIEW_MODE = 1;
    private final String graphViewModeVariableName = "MRS_GUI_GRAPH_MODE";
    private ApplicationObject theGraphViewModeAO = null;
    private int currentGraphViewMode = -1;
    private ArrayList graphViewModeDataReceivers = null;
    private boolean hasTrappedTransientError = false;
    private boolean hasTrappedPermanentError = false;

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals("MRS_SESSION_LATEST_STATE")) {
            this.theLatestStateAO = anAO;
        } else if (anAO.getName().equals("MRS_GUI_GRAPH_MODE")) {
            this.theGraphViewModeAO = anAO;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + anAO.toString());
        }
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        ApplicationManager.instance().request("ISS", 0, "MRS_SESSION_LATEST_STATE", (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, "MRS_GUI_GRAPH_MODE", (ApplicationObjectObserver)this);
    }

    public ApplicationObject getGraphViewModeAO() {
        return this.theGraphViewModeAO;
    }

    public ApplicationObject getLatestStateAO() {
        return this.theLatestStateAO;
    }

    private void permanentError() {
        EventLog.instance().log("ERROR: " + this.toString() + ": permanentError: Permanent error occured!");
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = true;
        this.unregister();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        int value;
        if (s == this.theLatestStateAO) {
            int value2 = v.getValue();
            if (value2 != this.latestSessionState.getState() && value2 >= -1 && value2 <= 1) {
                this.latestSessionState.setState(value2);
                int i = 0;
                while (i < this.latestStateDataReceivers.size()) {
                    ((MaskedIntegerDataReceiver)this.latestStateDataReceivers.get(i)).receiveMaskedIntegerData(v, s);
                    ++i;
                }
            }
        } else if (s == this.theGraphViewModeAO && (value = v.getValue()) != this.currentGraphViewMode) {
            this.currentGraphViewMode = value;
            int i = 0;
            while (i < this.graphViewModeDataReceivers.size()) {
                ((MaskedIntegerDataReceiver)this.graphViewModeDataReceivers.get(i)).receiveMaskedIntegerData(v, s);
                ++i;
            }
        }
        this.trapTransientError(false);
    }

    public void registerForGraphViewMode(MaskedIntegerDataReceiver receiver) {
        if (this.graphViewModeDataReceivers == null) {
            this.graphViewModeDataReceivers = new ArrayList();
        }
        this.graphViewModeDataReceivers.add((Object)receiver);
        if (this.theGraphViewModeAO != null && this.theGraphViewModeAO.getInitialisationState() == 2) {
            MaskedIntegerValue miv = new MaskedIntegerValue(this.currentGraphViewMode);
            receiver.receiveMaskedIntegerData(miv, (ApplicationDataSender)this.theGraphViewModeAO);
        }
    }

    public void registerForLatestStateData(MaskedIntegerDataReceiver receiver) {
        if (this.latestStateDataReceivers == null) {
            this.latestStateDataReceivers = new ArrayList();
        }
        this.latestStateDataReceivers.add((Object)receiver);
        if (this.theLatestStateAO != null && this.theLatestStateAO.getInitialisationState() == 2) {
            MaskedIntegerValue miv = new MaskedIntegerValue(this.latestSessionState.getState());
            receiver.receiveMaskedIntegerData(miv, (ApplicationDataSender)this.theLatestStateAO);
        }
    }

    public boolean setGraphViewMode(int value) {
        return this.theGraphViewModeAO.change((ApplicationData)new MaskedIntegerValue(value));
    }

    public String toString() {
        return "MRSStateMonitor";
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            this.hasTrappedTransientError = isInError;
        }
    }

    public void unregister() {
        if (this.theLatestStateAO != null) {
            this.theLatestStateAO.unregister((ApplicationObjectObserver)this);
            this.theLatestStateAO = null;
        }
        this.latestStateDataReceivers = null;
        if (this.theGraphViewModeAO != null) {
            this.theGraphViewModeAO.unregister((ApplicationObjectObserver)this);
            this.theGraphViewModeAO = null;
        }
        this.graphViewModeDataReceivers = null;
    }

    public void unregisterForGraphViewMode(MaskedIntegerDataReceiver receiver) {
        if (this.graphViewModeDataReceivers != null) {
            this.graphViewModeDataReceivers.remove((Object)receiver);
        }
    }

    public void unregisterForLatestStateData(MaskedIntegerDataReceiver receiver) {
        if (this.latestStateDataReceivers != null) {
            this.latestStateDataReceivers.remove((Object)receiver);
        }
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update: Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        }
    }
}

