/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.components;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceButtonListView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceController;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclStringListDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class SimpleListComponent
extends EclipseComponent
implements SingleSelectableChoiceController {
    private SingleSelectableChoiceButtonListView theView = null;
    private boolean hasFocus = false;
    private GreyableString[] theList = null;
    private int theSelectedIndex = 0;
    private GreyableString theSelectedString = null;
    private static transient MouseActionnedComponentHandler theMouseHandler = null;

    public SimpleListComponent() {
        this.initialize();
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        ((Component)((Object)this)).enableEvents(16L);
    }

    protected EclipseView getEclipseView() {
        return this.theView;
    }

    public int getListSize() {
        int size = 0;
        if (this.theList != null) {
            size = this.theList.length;
        }
        return size;
    }

    public int getSelectedIndex() {
        return this.theSelectedIndex;
    }

    public String getSelectedString() {
        return this.theSelectedString.getValue();
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
    }

    protected void initialize() {
        ((Component)((Object)this)).setSize(70, 20);
        if (this.getBackground() == null) {
            this.setBackground(EclStringListDefaults.background);
        }
        if (this.getForeground() == null) {
            this.setForeground(EclStringListDefaults.foreground);
        }
        if (this.getFont() == null) {
            this.setFont(EclStringListDefaults.font);
        }
        ((Component)((Object)this)).enableEvents(12L);
        this.createMouseHandler();
        this.theView = new SingleSelectableChoiceButtonListView((SingleSelectableChoiceController)this);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        switch (e.getID()) {
            case 1004: {
                if (!((Component)((Object)this)).isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible((Component)((Object)this));
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        ((Component)((Object)this)).repaint();
    }

    protected void processKeyEvent(KeyEvent e) {
        this.theView.processKeyEvent(e);
    }

    protected void processMouseEvent(MouseEvent e) {
        theMouseHandler.processMouseEvent(e, this.theView.getMouseActionnedComponent(), this.hasFocus, ((Component)((Object)this)).isEnabled());
    }

    public void setList(GreyableString[] list) {
        this.theList = list;
        this.theView.initialiseView(list);
        if (list == null || this.theSelectedIndex >= list.length) {
            this.theSelectedIndex = 0;
        }
        this.theView.setSelectedIndex(this.theSelectedIndex, false);
        ((Component)((Object)this)).repaint();
    }

    public void setList(String[] list) {
        int length = 0;
        GreyableString[] greyableList = null;
        if (list != null) {
            length = list.length;
            greyableList = new GreyableString[length];
        }
        int i = 0;
        while (i < length) {
            greyableList[i] = new GreyableString(list[i], true);
            ++i;
        }
        this.setList(greyableList);
    }

    public void setSelectedIndex(int index) {
        this.theSelectedIndex = index;
    }

    public void setSelectedString(GreyableString string) {
        this.theSelectedString = string;
    }

    public String toString() {
        String thisName = ((Component)((Object)this)).getName();
        return thisName == null || thisName.length() == 0 ? "SimpleListComponent" : thisName;
    }
}

