/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.containers;

import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.mrsgraphs.alarms.AlarmGroupPanePage;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.agilent.tntd.eclipse.mrsgraphs.containers.ErrorPanePage;
import com.agilent.tntd.eclipse.mrsgraphs.continuous.ContinuousPlot;
import com.agilent.tntd.eclipse.mrsgraphs.histogram.HistogramPlot;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphPaneComponent;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphTypeHandler;
import com.agilent.tntd.eclipse.mrsgraphs.mouse.MouseActionEventHandler;
import com.agilent.tntd.eclipse.mrsgraphs.mouse.MouseEventReceiver;
import com.agilent.tntd.eclipse.mrsgraphs.multiline.MultipleLineGraphSupport;
import com.agilent.tntd.eclipse.mrsgraphs.step.StepPlot;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpController;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.GlobalDefaults;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class GraphPane
extends Container
implements GraphTypeHandler,
CcComponent,
MouseEventReceiver {
    private transient CardLayout theLayoutManager = new CardLayout();
    private transient int currentType = 0;
    private transient boolean hasFocus = false;
    private transient UnconsumedKeyHandler theMainKeyController = null;
    private transient MouseActionEventHandler theMouseHandler = null;
    private transient MultipleLineGraphSupport multiLineGraphSupport = null;
    private transient ContextHelpController contextHelpController = null;
    private transient GraphPaneComponentInfo[] myChildren = new GraphPaneComponentInfo[5];
    private boolean drawDates = false;
    private boolean drawTimes = false;

    public GraphPane() {
        this.initialize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String childrenToString() {
        String string = String.valueOf(this.toString()) + " children:";
        if (this.myChildren == null) return string;
        GraphPaneComponentInfo[] graphPaneComponentInfoArray = this.myChildren;
        synchronized (this.myChildren) {
            int i = 0;
            while (i < this.myChildren.length) {
                if (this.myChildren[i] != null) {
                    string = String.valueOf(string) + "\n\t" + this.myChildren[i].component.toString();
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return string;
        }
    }

    private GraphPaneComponentInfo createGraphPaneComponent(int type) {
        GraphPaneComponent component = null;
        String typeString = null;
        switch (type) {
            case 1: {
                component = new StepPlot();
                typeString = "Step";
                break;
            }
            case 2: {
                component = new ContinuousPlot();
                typeString = "Continuous";
                break;
            }
            case 3: {
                component = new HistogramPlot();
                typeString = "Histogram";
                break;
            }
            case 4: {
                component = new AlarmGroupPanePage();
                typeString = "AlarmGroup";
                break;
            }
            default: {
                component = new ErrorPanePage();
                typeString = "ErrorPage";
            }
        }
        component.getComponent().setVisible(false);
        Dimension size = this.getSize();
        component.getComponent().setBounds(0, 0, size.width, size.height);
        this.add((Component)((Object)component), typeString);
        GraphPaneComponentInfo info = new GraphPaneComponentInfo(this, typeString, component);
        GraphPaneComponentInfo[] graphPaneComponentInfoArray = this.myChildren;
        synchronized (this.myChildren) {
            this.myChildren[type] = info;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return info;
        }
    }

    public void doLeftSingleClickAction(MouseEvent e) {
        this.myChildren[this.currentType].component.doLeftSingleClickAction(e);
    }

    public void doRightSingleClickAction(MouseEvent e) {
        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent((Component)this), (Component)this);
    }

    public void finishInitialise() {
        int type = 0;
        MRSGraphParameters[] params = null;
        GraphPaneStoredInfo info = this.getStoredInfo();
        if (info != null) {
            type = info.type;
            params = info.parameters;
        }
        this.updateGraphType(type, params);
    }

    private ContextHelpController getContextHelpController() {
        if (this.contextHelpController == null) {
            Container c = this.getParent();
            while (c != null) {
                if (c instanceof ContextHelpController) {
                    this.contextHelpController = (ContextHelpController)c;
                    break;
                }
                c = c.getParent();
            }
        }
        return this.contextHelpController;
    }

    public boolean getDrawDates() {
        return this.drawDates;
    }

    public boolean getDrawTimes() {
        return this.drawTimes;
    }

    private GraphPaneComponentInfo getGraphPaneComponentInfo(int n, MRSGraphParameters[] parameters) {
        int type;
        GraphPaneComponentInfo info = null;
        if (n < 0 || n >= 5) {
            EventLog.instance().log("ERROR: " + this.toString() + ": getGraphPaneComponentInfo: Type is out of bounds!");
            type = 0;
        }
        info = this.myChildren[type] == null ? this.createGraphPaneComponent(type) : this.myChildren[type];
        if (type == 2 || type == 1) {
            info.component.setMultiLineGraphSupport(this.multiLineGraphSupport);
        } else if (this.multiLineGraphSupport != null) {
            this.multiLineGraphSupport.hideAllComponents();
        }
        info.component.setGraphParameters(parameters);
        info.component.finishInitialise();
        info.component.getComponent().setVisible(true);
        return info;
    }

    public MRSGraphParameters[] getGraphParameters() {
        if (this.myChildren[this.currentType] != null) {
            return this.myChildren[this.currentType].getGraphParameters();
        }
        return null;
    }

    private String getHashMapKey() {
        return "GraphPane." + this.toString();
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (this.theMainKeyController != null) break block2;
            c = this.getParent();
            if (c != null) ** GOTO lbl6
            throw new NullPointerException("ERROR: " + this.toString() + ": getMainKeyController: Cannot find this object's parent");
lbl-1000:
            // 1 sources

            {
                c = c.getParent();
lbl6:
                // 2 sources

                ** while (c.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(c instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("ERROR: " + this.toString() + ": getMainKeyController: The root parent doesn't implement UnconsumedKeyHandler");
            }
            this.theMainKeyController = (UnconsumedKeyHandler)c;
        }
        return this.theMainKeyController;
    }

    private GraphPaneStoredInfo getStoredInfo() {
        return (GraphPaneStoredInfo)EclipseSystem.instance().getPlatformMap().get((Object)this.getHashMapKey());
    }

    public int getType() {
        return this.currentType;
    }

    public Color getVisibleBackground() {
        Color background = this.getBackground();
        if (background != null) {
            return background;
        }
        Container c = this.getParent();
        while (c != null) {
            if (c.getBackground() != null) {
                return c.getBackground();
            }
            c = c.getParent();
        }
        return Color.lightGray;
    }

    private void initialize() {
        this.setLayout(this.theLayoutManager);
        this.enableEvents(28L);
        this.theMouseHandler = new MouseActionEventHandler();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setFont(GlobalDefaults.font);
        if (this.getComponentCount() < 1) {
            g.setColor(this.getVisibleBackground());
            g.fillRect(0, 0, bounds.width, bounds.height);
            FontMetrics fm = this.getFontMetrics(g.getFont());
            String s1 = "No graph selected. Press the Menu key or click on";
            String s2 = "the right mouse button to display the graph menu.";
            int w1 = fm.stringWidth(s1);
            int h1 = fm.getHeight();
            int x1 = bounds.width / 2 - w1 / 2;
            int y1 = bounds.height / 2 - h1;
            int w2 = fm.stringWidth(s2);
            int x2 = bounds.width / 2 - w2 / 2;
            int y2 = y1 + h1 + 2;
            g.setColor(Color.black);
            g.drawString(s1, x1, y1);
            g.drawString(s2, x2, y2);
        } else {
            super.paint(g);
        }
        Color base = this.hasFocus ? GraphDefaults.focusColor : this.getVisibleBackground();
        Color highlight = base.brighter();
        Color shadow = base.darker();
        int left = 0;
        int right = bounds.width - 1;
        int top = 0;
        int bottom = bounds.height - 1;
        g.setColor(shadow);
        g.drawLine(left, top, right, top);
        g.drawLine(left + 1, bottom - 1, right - 1, bottom - 1);
        g.drawLine(left, top, left, bottom);
        g.drawLine(right - 1, top + 1, right - 1, bottom - 1);
        g.setColor(highlight);
        g.drawLine(left + 1, top + 1, right - 1, top + 1);
        g.drawLine(left, bottom, right, bottom);
        g.drawLine(left + 1, top + 1, left + 1, bottom - 2);
        g.drawLine(right, top + 1, right, bottom);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        int id = e.getID();
        switch (id) {
            case 1004: {
                this.hasFocus = true;
                this.getContextHelpController().displayContextHelp("GraphPaneHelpId");
                break;
            }
            case 1005: {
                this.hasFocus = false;
                this.getContextHelpController().removeContextHelp("GraphPaneHelpId");
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent e) {
        this.getMainKeyController().processUnconsumedKeyEvents(e, (Component)this);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getSource() == this) {
            this.theMouseHandler.processMouseEvent(e, this, this.hasFocus, this.isEnabled());
        }
    }

    public final void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent(this, 1005));
        }
    }

    public void requestFocus() {
        if (this.isFocusTraversable() && EclipseFocusManager.getInstance().canRequestFocus((Component)this)) {
            super.requestFocus();
        }
    }

    public void setDrawDates(boolean newDrawDates) {
        this.drawDates = newDrawDates;
    }

    public void setDrawTimes(boolean newDrawTimes) {
        this.drawTimes = newDrawTimes;
    }

    public void setMultiLineGraphSupport(MultipleLineGraphSupport newMultiLineGraphSupport) {
        this.multiLineGraphSupport = newMultiLineGraphSupport;
    }

    private void setStoredInfo(int type, MRSGraphParameters[] parameters) {
        GraphPaneStoredInfo info = new GraphPaneStoredInfo(this, type, parameters);
        EclipseSystem.instance().getPlatformMap().put((Object)this.getHashMapKey(), (Object)info);
    }

    public String toString() {
        String thisName = this.getName();
        return thisName == null || thisName.length() == 0 ? "GraphPane" : thisName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void unregister() {
        if (this.myChildren != null) {
            GraphPaneComponentInfo[] graphPaneComponentInfoArray = this.myChildren;
            // MONITORENTER : this.myChildren
            if (this.myChildren[this.currentType] != null) {
                this.setStoredInfo(this.currentType, this.getGraphParameters());
            }
            int i = 0;
            while (true) {
                if (i >= this.myChildren.length) {
                    // MONITOREXIT : graphPaneComponentInfoArray
                    break;
                }
                if (this.myChildren[i] != null) {
                    this.myChildren[i].component.unregister();
                    this.myChildren[i].component.setMultiLineGraphSupport(null);
                }
                ++i;
            }
        }
        if (!this.hasFocus) return;
        EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible((Component)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void updateGraphType(int type, MRSGraphParameters[] parameters) {
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                parameters[i].drawDates = this.drawDates;
                parameters[i].drawTimes = this.drawTimes;
                ++i;
            }
        }
        if (this.myChildren[this.currentType] != null && type == this.currentType) {
            GraphPaneComponentInfo[] i = this.myChildren;
            // MONITORENTER : this.myChildren
            this.myChildren[this.currentType].component.getComponent().setVisible(false);
            this.myChildren[this.currentType].component.unregister();
            // MONITOREXIT : i
        }
        GraphPaneComponentInfo info = this.getGraphPaneComponentInfo(type, parameters);
        info.setGraphParameters(parameters);
        this.theLayoutManager.show(this, info.typeString);
        if (this.myChildren[this.currentType] != null && type != this.currentType) {
            GraphPaneComponentInfo[] graphPaneComponentInfoArray = this.myChildren;
            // MONITORENTER : this.myChildren
            this.myChildren[this.currentType].component.getComponent().setVisible(false);
            this.myChildren[this.currentType].component.unregister();
            // MONITOREXIT : graphPaneComponentInfoArray
        }
        this.currentType = type;
        this.repaint();
    }

    private class GraphPaneComponentInfo {
        /* synthetic */ GraphPane this$0;
        final String typeString;
        final GraphPaneComponent component;
        private MRSGraphParameters[] parameters = null;

        GraphPaneComponentInfo(GraphPane this$0, String typeString, GraphPaneComponent c) {
            this.this$0 = this$0;
            this.typeString = typeString;
            this.component = c;
        }

        MRSGraphParameters[] getGraphParameters() {
            return this.parameters;
        }

        void setGraphParameters(MRSGraphParameters[] p) {
            this.parameters = p;
        }
    }

    private class GraphPaneStoredInfo {
        /* synthetic */ GraphPane this$0;
        public final int type;
        public final MRSGraphParameters[] parameters;

        GraphPaneStoredInfo(GraphPane this$0, int type, MRSGraphParameters[] parameters) {
            this.this$0 = this$0;
            this.type = type;
            this.parameters = parameters;
        }
    }
}

